local E, L, DF = unpack(select(2, ...)); --Engine
local CH = E:GetModule('Chat')

E.Options.args.chat = {
	type = "group",
	name = L["Chat"],
	get = function(info) return E.db.chat[ info[#info] ] end,
	set = function(info, value) E.db.chat[ info[#info] ] = value end,
	args = {
		intro = {
			order = 1,
			type = "description",
			name = L["CHAT_DESC"],
		},		
		enable = {
			order = 2,
			type = "toggle",
			name = L["Enable"],
			get = function(info) return E.db.chat.enable end,
			set = function(info, value) E.db.chat.enable = value; StaticPopup_Show("CONFIG_RL") end
		},
		panelBackdrop = {
			order = 3,
			type = 'select',
			name = L['Panel Backdrop'],
			desc = L['Toggle showing of the left and right chat panels.'],
			get = function(info) return E.db.core.panelBackdrop end,
			set = function(info, value) E.db.core.panelBackdrop = value; E:GetModule('Layout'):ToggleChatPanels() end,
			values = {
				['HIDEBOTH'] = L['Hide Both'],
				['SHOWBOTH'] = L['Show Both'],
				['LEFT'] = L['Left Only'],
				['RIGHT'] = L['Right Only'],
			},
		},		
		general = {
			order = 3,
			type = "group",
			name = L["General"],
			guiInline = true,
			args = {	
				url = {
					order = 1,
					type = 'toggle',
					name = L['URL Links'],
					desc = L['Attempt to create URL links inside the chat.'],
				},
				shortChannels = {
					order = 2,
					type = 'toggle',
					name = L['Short Channels'],
					desc = L['Shorten the channel names in chat.'],
				},		
				embedright = {
					order = 3,
					type = 'select',
					name = L["embedright"],
					desc = L["embedright_desc"],
					set = function(info, value) E.db.chat.embedright = value; StaticPopup_Show("CONFIG_RL") end,
					values = {
						["Skada"] = "Skada",
						["Recount"] = "Recount",
						["Omen"] = "Omen",
						["OmenRecount"] = "Omen+Recount",
						["None"] = "None",
					},
				},
				embedcombat = {
					order = 4,
					type = "toggle",
					name = L["embedcombat"],
					desc = L["embedcombat_desc"],
					set = function(info, value) E.db.chat.embedcombat = value; StaticPopup_Show("CONFIG_RL") end,
				},					
			},
		},
		panel = {
			order = 4,
			type = "group",
			name = L['Panels'],
			guiInline = true,
			args = {
				leftpanelWidth = {
					order = 1,
					type = 'range',
					name = L["LEFT"].. L['Panel Width'],
					desc = L['PANEL_DESC'],
					set = function(info, value) E.db.chat.leftpanelWidth = value; E:GetModule('Chat'):PositionChat(true); local bags = E:GetModule('Bags'); bags:Layout(); bags:Layout(true); end,
					min = 150, max = 700, step = 1,
				},
				leftpanelHeight = {
					order = 2,
					type = 'range',
					name = L["LEFT"].. L['Panel Height'],
					desc = L['PANEL_DESC'],
					set = function(info, value) E.db.chat.leftpanelHeight = value; E:GetModule('Chat'):PositionChat(true) end,
					min = 150, max = 600, step = 1,
				},
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 3,
				},
				rightpanelWidth = {
					order = 4,
					type = 'range',
					name = L["RIGHT"].. L['Panel Width'],
					desc = L['PANEL_DESC'],
					set = function(info, value) E.db.chat.rightpanelWidth = value; E:GetModule('Chat'):PositionChat(true); local bags = E:GetModule('Bags'); bags:Layout(); bags:Layout(true); if E.db.chat.embedright ~= 'None' then StaticPopup_Show("CONFIG_RL") end; end,
					min = 150, max = 700, step = 1,
				},
				rightpanelHeight = {
					order = 5,
					type = 'range',
					name = L["RIGHT"].. L['Panel Height'],
					desc = L['PANEL_DESC'],
					set = function(info, value) E.db.chat.rightpanelHeight = value; E:GetModule('Chat'):PositionChat(true); if E.db.chat.embedright ~= 'None' then StaticPopup_Show("CONFIG_RL") end; end,
					min = 150, max = 600, step = 1,
				},
			},
		},
	},
}