-- Auther: ljxx.net
local E, L, DF = unpack(select(2, ...)); --Engine
local FILTER = E:NewModule('Filter', 'AceTimer-3.0', 'AceEvent-3.0')

local class = select(2, UnitClass("player"));
local classcolor = RAID_CLASS_COLORS[class];
local active, bars = {}, {};

local MyUnits = {
    player = true,
    vehicle = true,
    pet = true,
}

local time, Update;

local function OnUpdate(self, elapsed)
	time = self.filter == "CD" and self.expirationTime+self.duration-GetTime() or self.expirationTime-GetTime();
	if ( self:GetParent().Mode == "BAR" ) then
		self.statusbar:SetValue(time);
		self.time:SetFormattedText(SecondsToTimeAbbrev(time));
	end
	if ( time < 0 and self.filter == "CD" ) then
		local id = self:GetParent().Id;
		for index, value in ipairs(active[id]) do
			local spn;
			if value.data.filter == "CD" then
				spn = value.data.slotID;
			else
				spn = GetSpellInfo( value.data.spellID);
			end
		--	local spn = GetSpellInfo( value.data.spellID or value.data.slotID )
			if ( self.spellName == spn) then
				tremove(active[id], index);
				break;
			end
		end
		self:SetScript("OnUpdate", nil);
		FILTER:Update(self:GetParent());
	end
end


local function OnEvent(self, event, ...)
	local unit = ...
	if ((unit == "target" or unit == "player" or unit == "pet" or unit == "focus") or event == "PLAYER_TARGET_CHANGED" or event == "PLAYER_ENTERING_WORLD" or event == "SPELL_UPDATE_COOLDOWN") then
		local id = self.Id
		for i=1, #Filger_Spells[class][id], 1 do
			local data, name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable, start, enabled, slotLink, spn
			data = Filger_Spells[class][id][i]
			if (data.filter == "BUFF") then
				spn = GetSpellInfo(data.spellID)
				name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable = UnitBuff(data.unitId or "player", spn or "6603")
			elseif (data.filter == "DEBUFF") then
				spn = GetSpellInfo(data.spellID)
				name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable = UnitDebuff(data.unitId or "player", spn or "6603")
			else
				if (data.spellID) then
					spn = GetSpellInfo(data.spellID)
					start, duration, enabled = GetSpellCooldown(data.spellID)
					_, _, icon = GetSpellInfo(data.spellID)
				else
					name, _, _, _, _, _, _, _, _, icon = GetItemInfo(data.slotID)
					data.spellName = name
					start, duration, enabled = GetItemCooldown(data.slotID)
				end
				count = 0
				caster = "all"
			end
			if (not data.spellName) then
				data.spellName = spn
			end
			if (not active[id]) then
				active[id] = {}
			end
			for index, value in ipairs(active[id]) do
				if (data.spellName == value.data.spellName) then
					tremove(active[id], index)
					break
				end
			end
			if ((name and (data.caster ~= 1 and (caster == data.caster or data.caster == "all") or MyUnits[caster])) or ((enabled or 0) > 0 and (duration or 0) > 1.5)) then
				table.insert(active[id], { data = data, icon = icon, count = count, duration = duration, expirationTime = expirationTime or start })
			end
		end
		FILTER:Update(self)
	end
end

function FILTER:Update(self)
	local id = self.Id;
	if ( not bars[id] ) then
		bars[id] = {};
	end
	for index, value in ipairs(bars[id]) do
		value:Hide();
	end
	local bar;
	for index, value in ipairs(active[id]) do
		bar = bars[id][index];
		if ( not bar ) then
			bar = CreateFrame("Frame", "EuiFilter"..id.."Frame"..index, self);
			bar:SetWidth(value.data.size);
			bar:SetHeight(value.data.size);
			
			bar.bg = CreateFrame("Frame", nil, bar)
			bar.bg:SetPoint("TOPLEFT", -2, 2)
			bar.bg:SetPoint("BOTTOMRIGHT", 2, -2)
			bar.bg:SetTemplate("Default")
			bar.bg:CreateShadow("Default")
			bar.bg:SetFrameLevel(bar:GetFrameLevel()-1)
			
			bar.icon = bar:CreateTexture(nil, "BACKGROUND")
			bar.icon:SetAllPoints(bar)
			bar.icon:SetTexCoord(.08, .92, .08, .92)
			
			if ( index == 1 ) then
				bar:SetAllPoints(_G["EuiFilter"..id])
			else
				if ( self.Direction == "UP" ) then
					bar:SetPoint("BOTTOM", bars[id][index-1], "TOP", 0, self.Interval);
				elseif ( self.Direction == "RIGHT" ) then
					bar:SetPoint("LEFT", bars[id][index-1], "RIGHT", self.Mode == "ICON" and self.Interval or value.data.barWidth+self.Interval, 0);
				elseif ( self.Direction == "LEFT" ) then
					bar:SetPoint("RIGHT", bars[id][index-1], "LEFT", self.Mode == "ICON" and -self.Interval or -(value.data.barWidth+self.Interval), 0);
				else
					bar:SetPoint("TOP", bars[id][index-1], "BOTTOM", 0, -self.Interval);
				end
			end
			if ( self.Mode == "ICON" ) then
				bar.count = bar:CreateFontString(nil, "ARTWORK");
				bar.count:SetFont(E["media"].normFont, 12, "OUTLINE");
				bar.count:SetPoint("BOTTOMRIGHT",0,1);
				bar.count:SetJustifyH("RIGHT");

				bar.cooldown = CreateFrame("Cooldown", nil, bar);
				bar.cooldown:SetPoint("TOPLEFT", bar, 0, 0)
				bar.cooldown:SetPoint("BOTTOMRIGHT", bar, 0, 0)
				bar.cooldown:SetReverse();
				bar.cooldown.onlyfilter = true;

			else
				bar.statusbar = CreateFrame("StatusBar", nil, bar);
				bar.statusbar:SetWidth(value.data.barWidth - value.data.size -5);
				bar.statusbar:SetHeight(value.data.size);
				bar.statusbar:SetStatusBarTexture(E["media"].normTex);
				if E.db["filter"].classcolor == true then
					bar.statusbar:SetStatusBarColor(classcolor.r, classcolor.g, classcolor.b, 0.8);
				else
					bar.statusbar:SetStatusBarColor(unpack(E["media"].backdropcolor));
				end
				bar.statusbar:SetPoint("TOPLEFT", bar, "TOPRIGHT", 5, 0);
				bar.statusbar:SetMinMaxValues(0, 1);
				bar.statusbar:SetValue(0);
				
				bar.statusbar.bg = CreateFrame("Frame", nil, bar.statusbar)
				bar.statusbar.bg:SetPoint("TOPLEFT", bar.statusbar, -2, 2)
				bar.statusbar.bg:SetPoint("BOTTOMRIGHT", bar.statusbar, 2, -2)
				bar.statusbar.bg:SetTemplate("Default")
				bar.statusbar.bg:CreateShadow("Default")
				bar.statusbar.bg:SetFrameLevel(bar.statusbar:GetFrameLevel()-1)
					
				bar.time = bar.statusbar:CreateFontString(nil, "ARTWORK");
				bar.time:SetFont(E["media"].normFont, 10, "OUTLINE");
				bar.time:SetPoint("RIGHT", bar.statusbar, -2, 1);
				
				bar.spellname = bar.statusbar:CreateFontString(nil, "ARTWORK");
				bar.spellname:SetFont(E["media"].normFont, 11, "OUTLINE");
				bar.spellname:SetPoint("LEFT", bar.statusbar, 5, 0);
				bar.spellname:SetPoint("RIGHT", bar.time, "LEFT");
				bar.spellname:SetJustifyH("LEFT");
				
				bar.count = bar.statusbar:CreateFontString(nil, "ARTWORK");
				bar.count:SetFont(E["media"].normFont, 10, "OUTLINE");
				bar.count:SetPoint("RIGHT", bar.statusbar, -40, 1);
				bar.count:SetJustifyH("RIGHT");
			end
			
			tinsert(bars[id], bar);
		end
		
		bar.icon:SetTexture(value.icon)
		bar.count:SetText(value.count > 1 and value.count or "")
		if value.data.filter == "CD" then
			bar.spellName = value.data.slotID
		else
			bar.spellName = GetSpellInfo(value.data.spellID)
		end
	--	bar.spellName = GetSpellInfo( value.data.spellID or value.data.slotID );
		
		
	--	print(bar.spellName.."?");
		if ( self.Mode == "BAR" ) then
			bar.spellname:SetText(value.data.displayName or GetSpellInfo( value.data.spellID ));
		end
		if ( value.duration > 0 ) then
			if ( self.Mode == "ICON" ) then
				CooldownFrame_SetTimer(bar.cooldown, value.data.filter == "CD" and value.expirationTime or value.expirationTime-value.duration, value.duration, 1);
				if ( value.data.filter == "CD" ) then
					bar.expirationTime = value.expirationTime;
					bar.duration = value.duration;
					bar.filter = value.data.filter;
					bar:SetScript("OnUpdate", OnUpdate);
				end
			else
				bar.statusbar:SetMinMaxValues(0, value.duration);
				bar.expirationTime = value.expirationTime;
				bar.duration = value.duration;
				bar.filter = value.data.filter;
				bar:SetScript("OnUpdate", OnUpdate);
			end
		else
			if ( self.Mode == "ICON" ) then
				bar.cooldown:Hide();
			else
				bar.statusbar:SetMinMaxValues(0, 1);
				bar.statusbar:SetValue(1);
				bar.time:SetText("");
				bar:SetScript("OnUpdate", nil);
			end
		end
		
		bar:Show();
	end
end

function FILTER:Initialize()
	if E.db["filter"].enable ~= true then return end
	-- write config spell list
	local kid
	for k, v  in pairs(E.db["filter"].pbuffbarlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.pbuffbar_group.args.pbuffbarlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].pbufficonlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.pbufficon_group.args.pbufficonlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].pdebufficonlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.pdebufficon_group.args.pdebufficonlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].pcdiconlist) do
		kid = string.sub(k, string.find(k, '-')+1)
		if kid == 'spell' then
			E.Options.args.filter.args.pcdicon_group.args.pcdiconlist.values[k] = GetSpellInfo(string.sub(k, 1, string.find(k, '-')-1)).." "..string.sub(k, 1, string.find(k, '-')-1).."-"..kid
		elseif kid == 'item' then
			E.Options.args.filter.args.pcdicon_group.args.pcdiconlist.values[k] = "|cffC495DD"..GetItemInfo(string.sub(k, 1, string.find(k, '-')-1)).." "..string.sub(k, 1, string.find(k, '-')-1).."-"..kid.."|r"
		end			
	end
	for k, v  in pairs(E.db["filter"].tbufficonlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.tbufficon_group.args.tbufficonlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].tdebufficonlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.tdebufficon_group.args.tdebufficonlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].tdebuffbarlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.tdebuffbar_group.args.tdebuffbarlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].fbufficonlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.fbufficon_group.args.fbufficonlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end
	for k, v  in pairs(E.db["filter"].fdebufficonlist) do
		kid = string.sub(k, 1, string.find(k, '-')-1)
		if GetSpellInfo(kid) then E.Options.args.filter.args.fdebufficon_group.args.fdebufficonlist.values[k] = GetSpellInfo(kid).." ("..kid..") "..L[string.sub(k, string.find(k, '-')+1)] end
	end		
	kid = nil;
	
	local class = select(2, UnitClass("player"))
	local playerframe, targetframe, focusframe, portrait
	portrait = 0
	playerframe = ElvUF_Player or UIParent
	targetframe = ElvUF_Target or UIParent
	focusframe = ElvUF_Focus or UIParent

	local playBuffBarHeight = 6
	if E.myclass == 'SHAMAN' or E.myclass == 'DEATHKNIGHT' or E.myclass == 'DRUID' or E.myclass == 'PALADIN' or E.myclass == 'WARLOCK' then
		playBuffBarHeight = 20
	else
		playBuffBarHeight = 16
	end	
	local playBuffIconHeight = 235
	local playCDIconHeight = 150
	local cdsize
	if E.db["filter"].cdsize < 1 then cdsize = 30 else cdsize = E.db["filter"].cdsize end
		
	Filger_Spells = {
		["ROGUE"] = {},
		["DRUID"] = {},
		["HUNTER"] = {},
		["MAGE"] = {},
		["WARRIOR"] = {},
		["SHAMAN"] = {},
		["PALADIN"] = {},
		["PRIEST"] = {},
		["WARLOCK"] = {},
		["DEATHKNIGHT"] = {},
	}

	local CreateSpellEntry = function( id, castByAnyone, color, unitType, castSpellId )
		return { enabled = true, id = id, castByAnyone = castByAnyone, color = color, unitType = unitType or 0, castSpellId = castSpellId };
	end	

	local function Findit(name)
		local result
		for k, v in pairs(Filger_Spells[class]) do
			if Filger_Spells[class][k].Name == name then
				result = k
				break
			end
		end
		return result
	end
	
	--启用玩家BUFF计时条
	if E.db["filter"].pbuffbar == true then
	table.insert(Filger_Spells[class],
		{
			Name = "playerbuffbar",
			Direction = E.db["filter"].pbuffbardirection,
			Interval = E.db["filter"].pbuffbarinterval,
			Mode = "BAR",
			setPoint = { "BOTTOMLEFT", playerframe, "TOPLEFT", 0, playBuffBarHeight },


			{ spellID = 6603, size = E.db["filter"].barheight, barWidth = E.db["filter"].pbarwidth, unitId = "player", caster = "player", filter = "BUFF" },
		})
		for k, v in pairs(E.db["filter"].pbuffbarlist) do --读取玩家BUFF計時條
			if v == true then
				table.insert(Filger_Spells[class][Findit("playerbuffbar")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].barheight,
					barWidth = E.db["filter"].pbarwidth,
					unitId = "player",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "BUFF"
				})
			end
		end
	end
	--启用玩家BUFF图标提示
	if E.db["filter"].pbufficon == true then
	table.insert(Filger_Spells[class],
		{
			Name = "playerbufficon",
			Direction = E.db["filter"].pbufficondirection,
			Interval = E.db["filter"].pbufficoninterval,
			Mode = "ICON",
			setPoint = { "BOTTOMLEFT", playerframe, "TOPLEFT", 0, playBuffIconHeight },
			
			{ spellID = 6603, size = E.db["filter"].piconsize, unitId = "player", caster = "player", filter = "BUFF" },
		})
		for k, v in pairs(E.db["filter"].pbufficonlist) do --读取玩家BUFF圖標
			if v == true then
				table.insert(Filger_Spells[class][Findit("playerbufficon")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].piconsize,
					unitId = "player",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "BUFF"
				})
			end
		end		
	end	
	
	--启用玩家DEBUFF图标提示
	if E.db["filter"].pdebufficon == true then
	table.insert(Filger_Spells[class],
		{
			Name = "playerdebufficon",
			Direction = E.db["filter"].pdebufficondirection,
			Interval = E.db["filter"].pdebufficoninterval,
			Mode = "ICON",
			setPoint = { "BOTTOMLEFT", playerframe, "TOPLEFT", 0, 190 },
			
			{ spellID = 6603, size = E.db["filter"].piconsize, unitId = "player", caster = "player", filter = "DEBUFF" },
		})
		for k, v in pairs(E.db["filter"].pdebufficonlist) do --读取玩家DEBUFF圖標
			if v == true then
				table.insert(Filger_Spells[class][Findit("playerdebufficon")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].piconsize,
					unitId = "player",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "DEBUFF"
				})
			end
		end		
	end
		
	--启用玩家冷却图标提示
	if E.db["filter"].pcdicon == true then
		table.insert(Filger_Spells[class],
		{
			Name = "playercdicon",
			Direction = E.db["filter"].pcdicondirection,
			Interval = E.db["filter"].pcdiconinterval,
			Mode = "ICON",
			setPoint = { "BOTTOMLEFT", playerframe, "TOPLEFT", 0, playCDIconHeight },
			
			{ spellID = 6603, size = cdsize, filter = "CD" },
		})
		for k, v in pairs(E.db["filter"].pcdiconlist) do --读取玩家CD圖標
			if v == true then
				if not string.find(k, '-') then k = k.."-spell" end  -- 兼容旧版本未区分spell,item的设置
				if string.sub(k, string.find(k, '-')+1) == "spell" then
					table.insert(Filger_Spells[class][Findit("playercdicon")],{
						spellID = string.sub(k, 1, string.find(k, '-')-1),
						size = E.db["filter"].piconsize,
						filter = "CD"
					})
				elseif string.sub(k, string.find(k, '-')+1) == "item" then
					table.insert(Filger_Spells[class][Findit("playercdicon")],{
						slotID = string.sub(k, 1, string.find(k, '-')-1),
						size = E.db["filter"].piconsize,
						filter = "CD"
					})				
				end
			end
		end			
	end

	--启用目标BUFF图标
	if E.db["filter"].tbufficon == true then
	table.insert(Filger_Spells[class],
		{
			Name = "targetbufficon",
			Direction = E.db["filter"].tbufficondirection,
			Interval = E.db["filter"].tbufficoninterval,
			Mode = "ICON",
			setPoint = { "BOTTOMRIGHT", targetframe, "TOPRIGHT", 0, 162 },

			{ spellID = 6603, size = E.db["filter"].ticonsize, unitId = "target", caster = "player", filter = "BUFF" },

		})
		for k, v in pairs(E.db["filter"].tbufficonlist) do --读取目标BUFF圖標
			if v == true then
				table.insert(Filger_Spells[class][Findit("targetbufficon")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].ticonsize,
					unitId = "target",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "BUFF"
				})
			end
		end			
	end		
	--启用目标DEBUFF图标
	if E.db["filter"].tdebufficon == true then
	table.insert(Filger_Spells[class],
		{
			Name = "targetdebufficon",
			Direction = E.db["filter"].tdebufficondirection,
			Interval = E.db["filter"].tdebufficoninterval,
			Mode = "ICON",
			setPoint = { "BOTTOMRIGHT", targetframe, "TOPRIGHT", 0, 202 },

			{ spellID = 6603, size = E.db["filter"].ticonsize, unitId = "target", caster = "player", filter = "DEBUFF" },

		})
		for k, v in pairs(E.db["filter"].tdebufficonlist) do --读取目标DEBUFF圖標
			if v == true then
				table.insert(Filger_Spells[class][Findit("targetdebufficon")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].ticonsize,
					unitId = "target",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "DEBUFF"
				})
			end
		end			
	end		

	--启用目标DEBUFF计时条
	if E.db["filter"].tdebuffbar == true then
	table.insert(Filger_Spells[class],
		{
			Name = "targetdebuffbar",
			Direction = E.db["filter"].tdebuffbardirection,
			Interval = E.db["filter"].tdebuffbarinterval,
			Mode = "BAR",
			setPoint = { "BOTTOMLEFT", targetframe, "BOTTOMRIGHT", 5, 0+portrait },
			
			{ spellID = 6603, size = E.db["filter"].barheight, barWidth = E.db["filter"].tbarwidth, unitId = "target", caster = "player", filter = "DEBUFF" },

		})
		for k, v in pairs(E.db["filter"].tdebuffbarlist) do --读取目标DEBUFF计时条
			if v == true then
				table.insert(Filger_Spells[class][Findit("targetdebuffbar")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].barheight, 
					barWidth = E.db["filter"].tbarwidth,
					unitId = "target",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "DEBUFF"
				})
			end
		end			
	end
	
	--启用焦点BUFF图标提示
	if E.db["filter"].fbufficon == true then
	table.insert(Filger_Spells[class],
		{
			Name = "focusbufficon",
			Direction = E.db["filter"].fbufficondirection,
			Interval = E.db["filter"].fbufficoninterval,
			Mode = "ICON",
			setPoint = { "TOPLEFT", focusframe, "BOTTOMLEFT", 0, -10 },
			
			{ spellID = 6603, size = E.db["filter"].ficonsize, unitId = "focus", caster = "player", filter = "BUFF" },
		})
		for k, v in pairs(E.db["filter"].fbufficonlist) do --读取焦点BUFF圖標
			if v == true then
				table.insert(Filger_Spells[class][Findit("focusbufficon")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].ficonsize,
					unitId = "focus",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "BUFF"
				})
			end
		end			
	end

	--启用焦点DEBUFF图标提示
	if E.db["filter"].fdebufficon == true then
	table.insert(Filger_Spells[class],
		{
			Name = "focusdebufficon",
			Direction = E.db["filter"].fdebufficondirection,
			Interval = E.db["filter"].fdebufficoninterval,
			Mode = "ICON",
			setPoint = { "BOTTOMLEFT", focusframe, "BOTTOMLEFT", -70, 0 },
			
			{ spellID = 6603, size = E.db["filter"].ficonsize, unitId = "focus", caster = "player", filter = "DEBUFF" },
		})
		for k, v in pairs(E.db["filter"].fdebufficonlist) do --读取焦点DEBUFF圖標
			if v == true then
				table.insert(Filger_Spells[class][Findit("focusdebufficon")],{
					spellID = string.sub(k, 1, string.find(k, '-')-1),
					size = E.db["filter"].ficonsize,
					unitId = "focus",
					caster = string.sub(k, string.find(k, '-')+1),
					filter = "DEBUFF"
				})
			end
		end			
	end	

	if ( Filger_Spells and Filger_Spells[class] ) then
		for index in pairs(Filger_Spells) do
			if ( index ~= class ) then
				Filger_Spells[index] = nil;
			end
		end
		local data, frame;
		for i=1, #Filger_Spells[class], 1 do
			data = Filger_Spells[class][i];
			frame = CreateFrame("Frame", "EuiFilter"..i, UIParent);
			frame.Id = i;
			frame.Name = data.Name;
			frame.Direction = data.Direction or "DOWN";
			frame.Interval = data.Interval+4 or 4;
			frame.Mode = data.Mode or "ICON";
			frame.setPoint = data.setPoint or "CENTER";
			frame:SetWidth(Filger_Spells[class][i][1] and Filger_Spells[class][i][1].size or 100);
			frame:SetHeight(Filger_Spells[class][i][1] and Filger_Spells[class][i][1].size or 20);
			frame:SetPoint(unpack(data.setPoint));

			E:CreateMover(frame, frame.Name, L.FILTER[frame.Name])
			
			for j=1, #Filger_Spells[class][i], 1 do
				data = Filger_Spells[class][i][j];
				if ( data.filter == "CD" ) then
					frame:RegisterEvent("SPELL_UPDATE_COOLDOWN");
					break;
				end
			end
			frame:RegisterEvent('ADDON_LOADED')
			frame:RegisterEvent("UNIT_AURA");
			frame:RegisterEvent("PLAYER_TARGET_CHANGED");
			frame:RegisterEvent("PLAYER_ENTERING_WORLD");
			frame:SetScript("OnEvent", OnEvent);
		end
	end	
end

E:RegisterModule(FILTER:GetName())