local E, L, DF = unpack(select(2, ...)); --Engine
local FILTER = E:GetModule('Filter')

local function Findit(name)
	local result
	for k, v in pairs(Filger_Spells[E.myclass]) do
		if Filger_Spells[E.myclass][k].Name == name then
			result = k
			break
		end
	end
	return result
end	

E.Options.args.filter = {
	type = "group",
	name = L["filter"],
	desc = L["filter_desc"],
	childGroups = "select",
	get = function(info) return E.db.filter[ info[#info] ] end,
	set = function(info, value) E.db.filter[ info[#info] ] = value end,
	args = {
		intro = {
			order = 1,
			type = "description",
			name = L["filter_desc"],
		},	
		ResetFilterDB = {
			order = 2,
			type = "execute",
			name = L["ResetFilterDB"],
			func = function() E.db.filter = DF["filter"]; StaticPopup_Show("CONFIG_RL") end,
		},
		filter_general = {
			order = 3,
			type = "group",
			name = L["filter_general"],
			get = function(info) return E.db.filter[ info[#info] ] end,
			set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,
			args = {
				enable = {
					order = 1,
					type = "toggle",
					name = L["filter_enable"],
					desc = L["filter_desc"],
					set = function(info, value)
						E.db.filter.enable = value;
						if value == true and E.db.filter.defaultlistloaded ~= true then
							local DF = E.DF["profile"]["classtimer"]
							if DF['spells_filter'] then
								for k, v in pairs(DF['spells_filter'][E.myclass].player) do
									if GetSpellInfo(v.id) then
										E.db["filter"].pbufficonlist[v.id.."-player"] = true
										E.db["filter"].pbuffbarlist[v.id.."-player"] = false
									end
								end
								for k, v in pairs(DF['spells_filter'][E.myclass].target) do
									if GetSpellInfo(v.id) then
										E.db["filter"].tdebufficonlist[v.id.."-target"] = true
										E.db["filter"].tdebuffbarlist[v.id.."-target"] = false
									end
								end
								for k, v in pairs(DF['spells_filter'][E.myclass].procs) do
									if GetSpellInfo(v.id) then
										E.db["filter"].pbufficonlist[v.id.."-player"] = true
										E.db["filter"].pbuffbarlist[v.id.."-player"] = false
									end
								end
								E.db.filter.defaultlistloaded = true
							end;
						end;
						StaticPopup_Show("CONFIG_RL");
					end,
				},						
				classcolor = {
					order = 2,
					name = L["filter_classcolor"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "toggle",
				},
				barheight = {
					order = 3,
					name = L["filter_barheight"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 1, max = 100, step = 1,
				},
				pbarwidth = {
					order = 3,
					name = L["filter_pbarwidth"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 50, max = 500, step = 1,
				},
				tbarwidth = {
					order = 3,
					name = L["filter_tbarwidth"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 50, max = 500, step = 1,
				},							
				cdsize = {
					order = 4,
					name = L["filter_cdsize"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 1, max = 100, step = 1,
				},
				piconsize = {
					order = 4,
					name = L["filter_piconsize"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 1, max = 100, step = 1,
				},
				ticonsize = {
					order = 4,
					name = L["filter_ticonsize"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 1, max = 100, step = 1,
				},
				ficonsize = {
					order = 4,
					name = L["filter_ficonsize"],
					disabled = function(info) return not E.db.filter.enable end,
					type = "range",
					min = 1, max = 100, step = 1,
				},	
			},
		},		
		pbuffbar_group = {
			order = 4,
			type = "group",
			name = L["pbuffbar_group"],
			disabled = function(info) return not E.db.filter.enable end,
			args = {
				pbuffbar = {
					order = 1,
					name = L["filter_pbuffbar"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				pbuffbardirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["UP"] = L["UP"],
						["DOWN"] = L["DOWN"],
					},
				},
				pbuffbarinterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end							
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.pbuffbarlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.pbuffbar_group.args.pbuffbarlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].pbuffbarlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.pbuffbarlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.pbuffbarlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.pbuffbar_group.args.pbuffbarlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].pbuffbarlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},						
				pbuffbarlist = {
					type = "multiselect",	
					order = 8,
					name = L["pbuffbarlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.pbuffbar end,
					get = function(info, k) return E.db.filter.pbuffbarlist[k] end,
					set = function(info, k, v)
						E.db.filter.pbuffbarlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("playerbuffbar")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].barheight,
								barWidth = E.db["filter"].pbarwidth,
								unitId = "player",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "BUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("playerbuffbar")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("playerbuffbar")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		pbufficon_group = {
			order = 5,
			type = "group",
			name = L["pbufficon_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				pbufficon = {
					order = 1,
					name = L["filter_pbufficon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				pbufficondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				pbufficoninterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},							
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.pbufficonlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.pbufficon_group.args.pbufficonlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].pbufficonlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.pbufficonlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.pbufficonlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.pbufficon_group.args.pbufficonlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].pbufficonlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},
				pbufficonlist = {
					type = "multiselect",	
					order = 8,
					name = L["pbufficonlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.pbufficon end,
					get = function(info, k) return E.db.filter.pbufficonlist[k] end,
					set = function(info, k, v)
						E.db.filter.pbufficonlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("playerbufficon")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].piconsize,
								unitId = "player",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "BUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("playerbufficon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("playerbufficon")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		pdebufficon_group = {
			order = 6,
			type = "group",
			name = L["pdebufficon_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				pdebufficon = {
					order = 1,
					name = L["filter_pdebufficon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				pdebufficondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				pdebufficoninterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},							
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.pdebufficonlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.pdebufficon_group.args.pdebufficonlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].pdebufficonlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.pdebufficonlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.pdebufficonlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.pdebufficon_group.args.pdebufficonlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].pdebufficonlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},						
				pdebufficonlist = {
					type = "multiselect",	
					order = 8,
					name = L["pdebufficonlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.pdebufficon end,
					get = function(info, k) return E.db.filter.pdebufficonlist[k] end,
					set = function(info, k, v)
						E.db.filter.pdebufficonlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("playerdebufficon")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].ticonsize,
								unitId = "player",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "DEBUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("playerdebufficon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("playerdebufficon")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		pcdicon_group = {
			order = 7,
			type = "group",
			name = L["pcdicon_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				pcdicon = {
					order = 1,
					name = L["filter_pcdicon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				pcdicondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				pcdiconinterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},						
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 5,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						E.db.filter.pcdiconlist[value.."-spell"] = false
						E.Options.args.filter.args.pcdicon_group.args.pcdiconlist.values[value.."-spell"] = GetSpellInfo(value).." "..value.."-spell"
						E.db["filter"].pcdiconlist[value.."-spell"] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.pcdiconlist[value.."-spell"] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.pcdiconlist[value.."-spell"] = nil
						E.Options.args.filter.args.pcdicon_group.args.pcdiconlist.values[value.."-spell"] = nil
						E.db["filter"].pcdiconlist[value.."-spell"] = nil
						E.db.filter.castby = ""
					end,
				},
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 7,
				},							
				NewItemName = {
					type = "input",
					name = "|cffC495DD"..L["filter_newitemname"].."|r",
					desc = L["filter_newitemname_desc"],
					order = 8,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetItemInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						E.db.filter.pcdiconlist[value.."-item"] = false
						E.Options.args.filter.args.pcdicon_group.args.pcdiconlist.values[value.."-item"] = "|cffC495DD"..GetItemInfo(value).." "..value.."-spell|r"
						E.db["filter"].pcdiconlist[value.."-item"] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteItemName = {
					type = 'input',
					name = "|cffC495DD"..L['filter_deleteitemname'].."|r",
					desc = L["filter_deleteitemname_desc"],
					order = 9,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.pcdiconlist[value.."-item"] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.pcdiconlist[value.."-item"] = nil
						E.Options.args.filter.args.pcdicon_group.args.pcdiconlist.values[value.."-item"] = nil
						E.db["filter"].pcdiconlist[value.."-item"] = nil
						E.db.filter.castby = ""
					end,
				},				
				pcdiconlist = {
					type = "multiselect",	
					order = 10,
					name = L["pcdiconlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.pcdicon end,
					get = function(info, k) return E.db.filter.pcdiconlist[k] end,
					set = function(info, k, v)
						E.db.filter.pcdiconlist[k] = v
						if v then
							--ü
							if string.sub(k, string.find(k, '-')+1) == "spell" then
								table.insert(Filger_Spells[E.myclass][Findit("playercdicon")],{
									spellID = string.sub(k, 1, string.find(k, '-')-1),
									size = E.db["filter"].cdsize,
									filter = "CD"
								})
							elseif string.sub(k, string.find(k, '-')+1) == "item" then
								table.insert(Filger_Spells[E.myclass][Findit("playercdicon")],{
									slotID = string.sub(k, 1, string.find(k, '-')-1),
									size = E.db["filter"].cdsize,
									filter = "CD"
								})						
							end	
						else
							for key, value in pairs(Filger_Spells[E.myclass][Findit("playercdicon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) or value.slotID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("playercdicon")], key)
									break
								end
							end
							StaticPopup_Show("CONFIG_RL")
						end
					end,
					values = {							
					},
				},
			},
		},
		tbufficon_group = {
			order = 8,
			type = "group",
			name = L["tbufficon_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				tbufficon = {
					order = 1,
					name = L["filter_tbufficon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				tbufficondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				tbufficoninterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.tbufficonlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.tbufficon_group.args.tbufficonlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].tbufficonlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.tbufficonlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.tbufficonlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.tbufficon_group.args.tbufficonlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].tbufficonlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},						
				tbufficonlist = {
					type = "multiselect",	
					order = 8,
					name = L["tbufficonlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.tbufficon end,
					get = function(info, k) return E.db.filter.tbufficonlist[k] end,
					set = function(info, k, v)
						E.db.filter.tbufficonlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("targetbufficon")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].ticonsize,
								unitId = "target",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "BUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("targetbufficon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("targetbufficon")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		tdebufficon_group = {
			order = 9,
			type = "group",
			name = L["tdebufficon_group"],
			disabled = function() return not E.db.filter.enable end,						
			args = {
				tdebufficon = {
					order = 1,
					name = L["filter_tdebufficon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				tdebufficondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				tdebufficoninterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},							
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.tdebufficonlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.tdebufficon_group.args.tdebufficonlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].tdebufficonlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.tdebufficonlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.tdebufficonlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.tdebufficon_group.args.tdebufficonlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].tdebufficonlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},						
				tdebufficonlist = {
					type = "multiselect",	
					order = 8,
					name = L["tdebufficonlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.tdebufficon end,
					get = function(info, k) return E.db.filter.tdebufficonlist[k] end,
					set = function(info, k, v)
						E.db.filter.tdebufficonlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("targetdebufficon")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].ticonsize,
								unitId = "target",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "DEBUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("targetdebufficon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("targetdebufficon")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		tdebuffbar_group = {
			order = 10,
			type = "group",
			name = L["tdebuffbar_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				tdebuffbar = {
					order = 1,
					name = L["filter_tdebuffbar"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				tdebuffbardirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["UP"] = L["UP"],
						["DOWNT"] = L["DOWN"],
					},
				},
				tdebuffbarinterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.tdebuffbarlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.tdebuffbar_group.args.tdebuffbarlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].tdebuffbarlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.tdebuffbarlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.tdebuffbarlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.tdebuffbar_group.args.tdebuffbarlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].tdebuffbarlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},							
				tdebuffbarlist = {
					type = "multiselect",	
					order = 8,
					name = L["tdebuffbarlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.tdebuffbar end,
					get = function(info, k) return E.db.filter.tdebuffbarlist[k] end,
					set = function(info, k, v)
						E.db.filter.tdebuffbarlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("targetdebuffbar")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].barheight,
								barWidth = E.db["filter"].tbarwidth,
								unitId = "target",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "DEBUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("targetdebuffbar")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("targetdebuffbar")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		fbufficon_group = {
			order = 11,
			type = "group",
			name = L["fbufficon_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				fbufficon = {
					order = 1,
					name = L["filter_fbufficon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				fbufficondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				fbufficoninterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.fbufficonlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.fbufficon_group.args.fbufficonlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].fbufficonlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.fbufficonlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.fbufficonlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.fbufficon_group.args.fbufficonlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].fbufficonlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},						
				fbufficonlist = {
					type = "multiselect",	
					order = 8,
					name = L["fbufficonlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.fbufficon end,
					get = function(info, k) return E.db.filter.fbufficonlist[k] end,
					set = function(info, k, v)
						E.db.filter.fbufficonlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("focusbufficon")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].ficonsize,
								unitId = "focus",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "BUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("focusbufficon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("focusbufficon")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
		fdebufficon_group = {
			order = 12,
			type = "group",
			name = L["fdebufficon_group"],
			disabled = function() return not E.db.filter.enable end,
			args = {
				fdebufficon = {
					order = 2,
					name = L["filter_fdebufficon"],
					type = "toggle",
					get = function(info) return E.db.filter[ info[#info] ] end,
					set = function(info, value) E.db.filter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,				
				},
				fdebufficondirection = {
					order = 2,
					name = L["filter_direction"],
					type = "select",
					values = {
						["LEFT"] = L["LEFT"],
						["RIGHT"] = L["RIGHT"],
					},
				},
				fdebufficoninterval = {
					order = 3,
					name = L["filter_interval"],
					type = "range",
					min = 2, max = 20, step = 1,
				},							
				spacer = {
					type = 'description',
					name = '',
					desc = '',
					order = 4,
				},				
				castby = {
					order = 5,
					name = L["castby"],
					type = "select",
					values = {
						["player"] = L["player"],
						["target"] = L["target"],
						["focus"] = L["focus"],
						["all"] = L["all"],
					},
				},
				NewName = {
					type = "input",
					name = L["filter_newname"],
					desc = L["filter_newname_desc"],
					order = 6,
					get = function(info) return "" end,
					set = function(info, value)
						if not GetSpellInfo(value) then
							print(L["filter_newname_err1"])
							return
						end
						if E.db.filter.castby ~= "player" and E.db.filter.castby ~= "target" and E.db.filter.castby ~= "focus" and E.db.filter.castby ~= "all" then
							print(L["filter_newname_err2"])
							return
						end
						E.db.filter.fdebufficonlist[value.."-"..E.db.filter.castby] = false
						E.Options.args.filter.args.fdebufficon_group.args.fdebufficonlist.values[value.."-"..E.db.filter.castby] = GetSpellInfo(value).." ("..value..") "..L[E.db.filter.castby]
						E.db["filter"].fdebufficonlist[value.."-"..E.db.filter.castby] = false
						E.db.filter.castby = ""
					end,
				},
				DeleteName = {
					type = 'input',
					name = L['filter_deletename'],
					desc = L["filter_deletename_desc"],
					order = 7,
					get = function(info) return "" end,
					set = function(info, value)
						if E.db.filter.fdebufficonlist[value.."-"..E.db.filter.castby] == nil then
							print(L["filter_deletename_err"])
							return
						end
						E.db.filter.fdebufficonlist[value.."-"..E.db.filter.castby] = nil
						E.Options.args.filter.args.fdebufficon_group.args.fdebufficonlist.values[value.."-"..E.db.filter.castby] = nil
						E.db["filter"].fdebufficonlist[value.."-"..E.db.filter.castby] = nil
						E.db.filter.castby = ""
					end,
				},					
				fdebufficonlist = {
					type = "multiselect",	
					order = 8,
					name = L["fdebufficonlist"],
					desc = L["filter_list_desc"],
					disabled = function(info) return not E.db.filter.fdebufficon end,
					get = function(info, k) return E.db.filter.fdebufficonlist[k] end,
					set = function(info, k, v)
						E.db.filter.fdebufficonlist[k] = v
						if v then
							--ü
							table.insert(Filger_Spells[E.myclass][Findit("focusdebufficon")],{
								spellID = string.sub(k, 1, string.find(k, '-')-1),
								size = E.db["filter"].ficonsize,
								unitId = "focus",
								caster = string.sub(k, string.find(k, '-')+1),
								filter = "DEBUFF"
							})
						else
							--ɾ
							for key, value in pairs(Filger_Spells[E.myclass][Findit("focusdebufficon")]) do
								if type(value) == "table" and value.spellID == string.sub(k, 1, string.find(k, '-')-1) then
									tremove(Filger_Spells[E.myclass][Findit("focusdebufficon")], key)
									break
								end
							end
						end
					end,
					values = {							
					},
				},
			},
		},
	},
}

