local E, _, DF = unpack(select(2, ...)) -- Import Functions/Constants, Config, Locales
local RC = E:NewModule('RaidCheck');



local join = string.join
local find = string.find
local format = string.format
local sort = table.sort
local floor = math.floor
local MaxGroup = 5

local EuiSetTooltip = function(f,title,L1,R1,L2,R2,L3,R3,L4,R4)
	f:SetScript("OnEnter", function()
		if not InCombatLockdown() then
			GameTooltip:SetOwner(f, "ANCHOR_BOTTOMRIGHT")
			GameTooltip:ClearLines()
			GameTooltip:SetText(title or " ")
			if title then GameTooltip:AddLine(" ") end
			if L1 and R1 then GameTooltip:AddDoubleLine(L1,R1,16/255,226/255,5/255,1,1,1) end
			if L2 and R2 then GameTooltip:AddLine(" "); GameTooltip:AddDoubleLine(L2,R2,16/255,226/255,5/255,1,1,1) end
			if L3 and R3 then GameTooltip:AddLine(" "); GameTooltip:AddDoubleLine(L3,R3,16/255,226/255,5/255,1,1,1) end
			if L4 and R4 then GameTooltip:AddLine(" "); GameTooltip:AddDoubleLine(L4,R4,16/255,226/255,5/255,1,1,1) end
			GameTooltip:Show()
		end
	end)

	f:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)

end

local L = {}
if (GetLocale() == "zhCN") then
	L.RaidCheckMsgOUTRAID = "你不在一个团队中"
	L.RaidCheckMsgFullBuff = "EUI Buff检查：常规Buff已齐全！"
	L.RaidCheckMsgNoBuff = "EUI Buff检查：缺少如下！"
		
	L.RaidCheckMsgPosition = "到位检查"
	L.RaidCheckMsgAllInPlace = "%s人全部到位"
	L.RaidCheckMsgInPlace = "已到位%s人"
	L.RaidCheckMsgDead = "%s人死亡"
	L.RaidCheckMsgOffline = "%s人离线"
	L.RaidCheckMsgUnVisible = "%s人过远"
	L.RaidCheckMsgETC = "等."

	L.RaidCheckFlaskData = {
			"合剂",
		}
	L.RaidCheckMsgFlask = "合剂检查"
	L.RaidCheckMsgAllNoFlask = "所有人均无合剂效果"
	L.RaidCheckMsgAllHasFlask = "所有人均已有合剂效果"
	L.RaidCheckMsgNoFlask = "%s人无合剂效果"
	L.RaidCheckMsgHasFlask = "%s人已有合剂效果"

	L.RaidCheckTipLeftButtonOnLeftInfo = "检查团队成员到位情况"
	L.RaidCheckTipRightButtonOnLeftInfo = "发起团队就位确认"
	L.RaidCheckTipLeftButtonOnRightInfo = "检查团队BUFF"
	L.RaidCheckTipRightButtonOnRightInfo = "检查合剂效果"
	L.RAIDCHECK_RAIDTOOL = "打开团队工具面板"

	L.MouseLeftButton = "鼠标左键"
	L.MouseRightButton = "鼠标右键"
	L.MouseClick = "鼠标点击"
	L.BottomPanelRaidCheck = "EUI团队检查工具"
	L.GameSetting = "打开EUI设置界面"

elseif (GetLocale() == "zhTW") then
	L.RaidCheckMsgOUTRAID = "你不在一個團隊中"
	L.RaidCheckMsgFullBuff = "EUI Buff檢查：常規Buff已齊全！"
	L.RaidCheckMsgNoBuff = "EUI Buff檢查: 缺少如下！"
		
	L.RaidCheckMsgPosition = "到位檢查"
	L.RaidCheckMsgAllInPlace = "%s人全部到位"
	L.RaidCheckMsgInPlace = "已到位%s人"
	L.RaidCheckMsgDead = "%s人死亡"
	L.RaidCheckMsgOffline = "%s人離線"
	L.RaidCheckMsgUnVisible = "%s人過遠"
	L.RaidCheckMsgETC = "等."

	L.RaidCheckFlaskData = {
			"藥劑",
		}
	L.RaidCheckMsgFlask = "合劑檢查"
	L.RaidCheckMsgAllNoFlask = "所有人均無藥劑效果"
	L.RaidCheckMsgAllHasFlask = "所有人均已有藥劑效果"
	L.RaidCheckMsgNoFlask = "%s人無藥劑效果"
	L.RaidCheckMsgHasFlask = "%s人已有藥劑效果"

	L.RaidCheckTipLeftButtonOnLeftInfo = "檢查團隊成員到位情況"
	L.RaidCheckTipRightButtonOnLeftInfo = "發起團隊就位確認"
	L.RaidCheckTipLeftButtonOnRightInfo = "檢查團隊BUFF"
	L.RaidCheckTipRightButtonOnRightInfo = "檢查藥劑效果"
	L.RAIDCHECK_RAIDTOOL = "打開團隊工具面板"

	L.MouseLeftButton = "鼠標左鍵"
	L.MouseRightButton = "鼠標右鍵"
	L.MouseClick = "鼠標點擊"
	L.BottomPanelRaidCheck = "EUI團隊檢查工具"
	L.GameSetting = "打開EUI設置界面"
end

L.RaidCheckBuffMS = GetSpellInfo(21562)
L.RaidCheckBuffFS = GetSpellInfo(79058)
L.RaidCheckBuffQS1 = GetSpellInfo(20217)
L.RaidCheckBuffQS2 = GetSpellInfo(19740)
L.RaidCheckBuffXD = GetSpellInfo(1126)
L.RaidCheckBuffFOOD = GetSpellInfo(87564)

-------------------------------------------------------------------------------------------------------------------
--	团队Buff检查
-------------------------------------------------------------------------------------------------------------------
function RC:CheckRaidBuff()
	local HasClass = {
		ms = false,
		qs = false,
		xd = false,
		fs = false,
	}

	local NoMSBuffName
	local NoFSBuffName
	local NoQS1BuffName
	local NoQS2BuffName
	local NoXDBuffName
	local NoFOODBuffName
	local HasBuffMS = false
	local HasBuffFS = false
	local HasBuffQS1 = false
	local HasBuffQS2 = false
	local HasBuffXD = false
	local HasBuffFOOD = false
	
	for i = 1, GetNumRaidMembers() do
		local _, _, _, _, _, class, _, online = GetRaidRosterInfo(i)
		if online then
			if class == 'PRIEST' then HasClass.ms = true end
			if class == 'PALADIN' then HasClass.qs = true end
			if class == 'MAGE' then HasClass.fs = true end
			if class == 'DRUID' then HasClass.xd = true end
		end
	end

	for i = 1, GetNumRaidMembers() do
		local name, _, subgroup = GetRaidRosterInfo(i)
		if subgroup <= MaxGroup then
			local unit = "raid"..i
			local j = 1
			while UnitBuff(unit, j) do
				local BuffTEXT = UnitBuff(unit, j)
				if find(BuffTEXT, L.RaidCheckBuffMS) then HasBuffMS = true end
				if find(BuffTEXT, L.RaidCheckBuffFS) then HasBuffFS = true end
				if find(BuffTEXT, L.RaidCheckBuffQS1) then HasBuffQS1 = true end --王者
				if find(BuffTEXT, L.RaidCheckBuffQS2) then HasBuffQS2 = true end --力量
				if find(BuffTEXT, L.RaidCheckBuffXD) then HasBuffXD = true end
				if find(BuffTEXT, L.RaidCheckBuffFOOD) then HasBuffFOOD = true end
				j = j + 1
			end
			if HasClass.ms and HasBuffMS == false then if NoMSBuffName == nil then NoMSBuffName = {} end; table.insert(NoMSBuffName, name) end
			if HasClass.fs and HasBuffFS == false then if NoFSBuffName == nil then NoFSBuffName = {} end; table.insert(NoFSBuffName, name) end
			if HasClass.qs and HasBuffQS1 == false and HasBuffXD == false then if NoQS1BuffName == nil then NoQS1BuffName = {} end; table.insert(NoQS1BuffName, name) end
			if HasClass.qs and HasBuffQS2 == false then if NoQS2BuffName == nil then NoQS2BuffName = {} end; table.insert(NoQS2BuffName, name) end
			if HasClass.xd and HasBuffXD == false and HasBuffQS1 == false then if NoXDBuffName == nil then NoXDBuffName = {} end; table.insert(NoXDBuffName, name) end
			if HasBuffFOOD == false then if NoFOODBuffName == nil then NoFOODBuffName = {} end; table.insert(NoFOODBuffName, name) end
		end
	end
	
	if NoMSBuffName == nil and NoFSBuffName == nil and NoQS1BuffName == nil and NoQS2BuffName == nil and NoXDBuffName == nil and NoFOODBuffName == nil then
		SendChatMessage(L.RaidCheckMsgFullBuff, "RAID")
	else
		SendChatMessage(L.RaidCheckMsgNoBuff, "RAID")
		if NoMSBuffName then SendChatMessage(L.RaidCheckBuffMS.. ": ".. table.concat(NoMSBuffName, ","), "RAID") end
		if NoFSBuffName then SendChatMessage(L.RaidCheckBuffFS.. ": ".. table.concat(NoFSBuffName, ","), "RAID") end
		if NoQS1BuffName then SendChatMessage(L.RaidCheckBuffQS1.. ": ".. table.concat(NoQS1BuffName, ","), "RAID") end
		if NoQS2BuffName then SendChatMessage(L.RaidCheckBuffQS2.. ": ".. table.concat(NoQS2BuffName, ","), "RAID") end
		if NoXDBuffName then SendChatMessage(L.RaidCheckBuffXD.. ": ".. table.concat(NoXDBuffName, ","), "RAID") end
		if NoFOODBuffName then SendChatMessage(L.RaidCheckBuffFOOD.. ": ".. table.concat(NoFOODBuffName, ","), "RAID") end
	end
end

-------------------------------------------------------------------------------------------------------------------
--	团队成员到位检查
-------------------------------------------------------------------------------------------------------------------
function RC:CheckPosition()

	local UnVisiblePlayer = ""
	local DeadPlayer = ""
	local OfflinePlayer = ""
	local UnVisiblePlayerCount = 0
	local DeadPlayerCount = 0
	local OfflinePlayerCount = 0
	local msg = "["..L.RaidCheckMsgPosition.."]"
	local RaidNum = GetNumRaidMembers()

	for i = 1, RaidNum do
		_, _, subgroup = GetRaidRosterInfo(i)
		if subgroup <= MaxGroup then
			local unit = "raid"..i
			if UnitIsConnected(unit) then
				if not UnitIsDeadOrGhost(unit) then
					if not UnitIsVisible(unit) then
						UnVisiblePlayerCount = UnVisiblePlayerCount + 1
						if UnVisiblePlayerCount > 0 and UnVisiblePlayerCount < 20 then
							UnVisiblePlayer = UnVisiblePlayer..UnitName(unit).."."
						end
						if UnVisiblePlayerCount == 20 then
							UnVisiblePlayer = UnVisiblePlayer.." "..L.RaidCheckMsgETC
						end
					end
				else
					DeadPlayerCount = DeadPlayerCount + 1
					if DeadPlayerCount > 0 and DeadPlayerCount < 10 then
						DeadPlayer = DeadPlayer..UnitName(unit).."."
					end
					if DeadPlayerCount == 10 then
						DeadPlayer = DeadPlayer.." "..L.RaidCheckMsgETC
					end
				end
			else
				OfflinePlayerCount = OfflinePlayerCount + 1
				if OfflinePlayerCount > 0 and OfflinePlayerCount < 10 then
					OfflinePlayer = OfflinePlayer..UnitName(unit).."."
				end
				if OfflinePlayerCount == 10 then
					OfflinePlayer = OfflinePlayer.." "..L.RaidCheckMsgETC
				end
			end
		end
	end

	if UnVisiblePlayerCount == 0 and DeadPlayerCount == 0 and OfflinePlayerCount == 0 then
		msg = msg..format(L.RaidCheckMsgAllInPlace, RaidNum)
	else
		msg = msg..format(L.RaidCheckMsgInPlace, (RaidNum - OfflinePlayerCount - DeadPlayerCount - UnVisiblePlayerCount)).."."
		if UnVisiblePlayerCount > 0 then
			msg = msg..format(L.RaidCheckMsgUnVisible, UnVisiblePlayerCount)..":"..UnVisiblePlayer
		end
		if DeadPlayerCount > 0 then
			msg = msg..format(L.RaidCheckMsgDead, DeadPlayerCount)..":"..DeadPlayer
		end
		if OfflinePlayerCount > 0 then
			msg = msg..format(L.RaidCheckMsgOffline, OfflinePlayerCount)..":"..OfflinePlayer
		end
	end
	
	SendChatMessage(msg, "RAID")
end

-------------------------------------------------------------------------------------------------------------------
--	团队成员合剂检查
-------------------------------------------------------------------------------------------------------------------
function RC:CheckRaidFlask()

	local FlaskText = RAL_TEXT_CHECK_12
	local FlaskDATA = L.RaidCheckFlaskData
	local FlaskPlayer, NoFlaskPlayer = "", ""
	local FlaskPlayerCount, NoFlaskPlayerCount = 0, 0
	local msg = "["..L.RaidCheckMsgFlask.."]"

	for i = 1,GetNumRaidMembers() do
		_, _, subgroup = GetRaidRosterInfo(i)
		if subgroup <= MaxGroup then
			local unit = "raid"..i
			local j = 1
			local has = 0
			while UnitBuff(unit, j) and has == 0 and UnitIsConnected(unit) do
				for k, v in pairs(FlaskDATA) do
					if find(UnitBuff(unit, j), v) then
						has = 1
						FlaskPlayerCount = FlaskPlayerCount + 1
						FlaskPlayer = FlaskPlayer..UnitName(unit).."."
						break
					end
				end
				j = j + 1
				if not UnitBuff(unit, j) and has == 0 then
					NoFlaskPlayerCount = NoFlaskPlayerCount + 1
					NoFlaskPlayer = NoFlaskPlayer..UnitName(unit).."."
				end
			end
		end
	end

	if FlaskPlayerCount == 0 then
		msg = msg..L.RaidCheckMsgAllNoFlask
	elseif NoFlaskPlayerCount == 0 then
		msg = msg..L.RaidCheckMsgAllHasFlask
	elseif FlaskPlayerCount >= NoFlaskPlayerCount then
		msg = msg..format(L.RaidCheckMsgNoFlask, NoFlaskPlayerCount)..": "..NoFlaskPlayer
	else
		msg = msg..format(L.RaidCheckMsgHasFlask, FlaskPlayerCount)..": "..FlaskPlayer
	end
	SendChatMessage(msg, "RAID")
end

-------------------------------------------------------------------------------------------------------------------
--	创建团队状态检测按钮
-------------------------------------------------------------------------------------------------------------------
function RC:CheckRaidStatus()
	local inInstance, instanceType = IsInInstance()
	if ((GetNumPartyMembers() > 0 and not UnitInRaid("player")) or IsRaidLeader() or IsRaidOfficer()) and not (inInstance and (instanceType == "pvp" or instanceType == "arena")) then
		return true
	else
		return false
	end
end

function RC:Initialize()
	if E.db["euiscript"].raidcheck ~= true then return end
	
	local RaidCheckFrameLeft = CreateFrame("Button", "RaidCheckFrameLeft", UIParent)
	RaidCheckFrameLeft:SetAllPoints(ElvuiLocX)
	EuiSetTooltip(RaidCheckFrameLeft, L.BottomPanelRaidCheck, L.MouseLeftButton, RaidUtilityPanel and L.RAIDCHECK_RAIDTOOL or L.RaidCheckTipLeftButtonOnLeftInfo, L.MouseRightButton, L.RaidCheckTipRightButtonOnLeftInfo)

	RaidCheckFrameLeft:SetScript("OnMouseDown", function(self, btn)
		if InCombatLockdown() then return end
		if btn == "LeftButton" then
			if RaidUtilityPanel and RC:CheckRaidStatus() then RaidUtilityPanel:Show() else RC:CheckPosition() end
		elseif btn == "RightButton" then
			DoReadyCheck()
		end
	end)


	local RaidCheckFrameRight = CreateFrame("Button", "RaidCheckFrameRight", UIParent)
	RaidCheckFrameRight:SetAllPoints(ElvuiLocY)
	EuiSetTooltip(RaidCheckFrameRight, L.BottomPanelRaidCheck, L.MouseLeftButton, L.RaidCheckTipLeftButtonOnRightInfo, L.MouseRightButton, L.RaidCheckTipRightButtonOnRightInfo)
	
	RaidCheckFrameRight:SetScript("OnMouseDown", function(self, btn)
		if InCombatLockdown() then return end
		if btn == "LeftButton" then
			RC:CheckRaidBuff()
		elseif btn == "RightButton" then
			RC:CheckRaidFlask()
		end
	end)	
end

E:RegisterModule(RC:GetName())