local E, L, DF = unpack(select(2, ...)); --Engine
local M = E:GetModule('Misc');
-- Very simple threat bar for ElvUI. modify by ljxx.net.

local aggroColors = {
	[1] = {0, 1, 0},
	[2] = {1, 1, 0},
	[3] = {0, 1, 0},
}
local unitframes_ouf_threattext = ''

if GetLocale() == 'zhCN' then
	unitframes_ouf_threattext = "当前目标仇恨:"
elseif GetLocale() == 'zhTW' then
	unitframes_ouf_threattext = "當前目標仇恨:"
elseif GetLocale() == 'enUS' then
	unitframes_ouf_threattext = "Threat on current target:"
end


-- event func
function M:PLAYER_ENTERING_WORLD(self, event, ...)
	local party = GetNumPartyMembers()
	local raid = GetNumRaidMembers()
	local pet = select(1, HasPetUI())	

	if (InCombatLockdown()) and (party > 0 or raid > 0 or pet == 1) then
		ElvuiThreatBar:Show()
	else
		ElvuiThreatBar:Hide()
	end
end

function M:PLAYER_REGEN_ENABLED(self, event, ...)
	ElvuiThreatBar:Hide()
	UIErrorsFrame:RegisterEvent('UI_ERROR_MESSAGE')
end

function M:PLAYER_REGEN_DISABLED(self, event, ...)
	local party = GetNumPartyMembers()
	local raid = GetNumRaidMembers()
	local pet = select(1, HasPetUI())
	
	if party > 0 or raid > 0 or pet == 1 then
		ElvuiThreatBar:Show()
	else
		ElvuiThreatBar:Hide()
	end
	UIErrorsFrame:UnregisterEvent('UI_ERROR_MESSAGE')
end

-- update status bar func
local function OnUpdate(self, event, unit)
	if UnitAffectingCombat(self.unit) then
		local _, _, threatpct, rawthreatpct, _ = UnitDetailedThreatSituation(self.unit, self.tar)
		local threatval = threatpct or 0
		
		self:SetValue(threatval)
		self.text:SetFormattedText("%s "..E.ValColor.."%3.1f%%|r", unitframes_ouf_threattext, threatval)
		
		if E.Role ~= "Tank" then
			if( threatval < 30 ) then
				self:SetStatusBarColor(unpack(self.Colors[1]))
			elseif( threatval >= 30 and threatval < 70 ) then
				self:SetStatusBarColor(unpack(self.Colors[2]))
			else
				self:SetStatusBarColor(unpack(self.Colors[3]))
			end
		else
			if( threatval < 30 ) then
				self:SetStatusBarColor(unpack(self.Colors[3]))
			elseif( threatval >= 30 and threatval < 70 ) then
				self:SetStatusBarColor(unpack(self.Colors[2]))
			else
				self:SetStatusBarColor(unpack(self.Colors[1]))
			end		
		end
				
		if threatval > 0 then
			self:SetAlpha(1)
		else
			self:SetAlpha(0)
		end		
	end
end

function M:LoadThreat()	
	-- cannot work without Info Right DataText Panel.
	if not RightChatDataPanel then return end

	-- create the bar
	local ElvuiThreatBar = CreateFrame("StatusBar", "ElvuiThreatBar", RightChatDataPanel)
	ElvuiThreatBar:Point("TOPLEFT", 2, -2)
	ElvuiThreatBar:Point("BOTTOMRIGHT", -2, 2)
	ElvuiThreatBar:SetFrameLevel(RightChatDataPanel:GetFrameLevel()+2)

	ElvuiThreatBar:SetStatusBarTexture(E["media"].normTex)
	ElvuiThreatBar:GetStatusBarTexture():SetHorizTile(false)
	ElvuiThreatBar:SetTemplate('Default', true)
	ElvuiThreatBar:SetBackdropBorderColor(0, 0, 0, 0)
	ElvuiThreatBar:SetMinMaxValues(0, 100)

	ElvuiThreatBar.text = ElvuiThreatBar:CreateFontString(nil, 'OVERLAY')
	ElvuiThreatBar.text:FontTemplate(nil, nil, "THICKOUTLINE")
	ElvuiThreatBar.text:SetPoint("CENTER")
	ElvuiThreatBar.text:SetShadowOffset(E.mult, -E.mult)
	ElvuiThreatBar.text:SetShadowColor(0, 0, 0, 0.4)

	ElvuiThreatBar.bg = ElvuiThreatBar:CreateTexture(nil, 'BORDER')
	ElvuiThreatBar.bg:SetAllPoints(ElvuiThreatBar)
	
	-- event handling
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	ElvuiThreatBar:SetScript("OnUpdate", OnUpdate)
	
	ElvuiThreatBar.unit = "player"
	ElvuiThreatBar.tar = ElvuiThreatBar.unit.."target"
	ElvuiThreatBar.Colors = aggroColors
	ElvuiThreatBar:SetAlpha(0)
end
