local E, L, DF = unpack(select(2, ...)); --Engine
local S = E:GetModule('Skins')

local borderWidth = 2

local function LoadSkin()
	if E.db.skins.omen.enable ~= true then return end
	
	-- Skin Bar Texture
	Omen.UpdateBarTextureSettings_ = Omen.UpdateBarTextureSettings
	Omen.UpdateBarTextureSettings = function(self)
		for i, v in ipairs(self.Bars) do
			v.texture:SetTexture(E["media"].normTex)
		end
	end

	-- Skin Bar fonts
	Omen.UpdateBarLabelSettings_ = Omen.UpdateBarLabelSettings
	Omen.UpdateBarLabelSettings = function(self)
		self:UpdateBarLabelSettings_()
		for i, v in ipairs(self.Bars) do
			v.Text1:FontTemplate(nil, self.db.profile.Bar.FontSize)
			v.Text2:FontTemplate(nil, self.db.profile.Bar.FontSize)
			v.Text3:FontTemplate(nil, self.db.profile.Bar.FontSize)
		end
	end

	-- Skin Title Bar
	Omen.UpdateTitleBar_ = Omen.UpdateTitleBar
	Omen.UpdateTitleBar = function(self)
		Omen.db.profile.Scale = 1
		Omen.db.profile.Background.EdgeSize = 1
		Omen.db.profile.Background.BarInset = borderWidth
		Omen.db.profile.TitleBar.UseSameBG = true
		self:UpdateTitleBar_()
		self.TitleText:FontTemplate(nil, self.db.profile.TitleBar.FontSize)
		self.BarList:SetPoint("TOPLEFT", self.Title, "BOTTOMLEFT", 0, -1)
	end

	--Skin Title/Bars backgrounds
	Omen.UpdateBackdrop_ = Omen.UpdateBackdrop
	Omen.UpdateBackdrop = function(self)
		Omen.db.profile.Scale = 1
		Omen.db.profile.Background.EdgeSize = 1
		Omen.db.profile.Background.BarInset = borderWidth
		self:UpdateBackdrop_()
		self.BarList:SetTemplate("Transparent")
		self.Title:SetTemplate("Transparent")
		self.BarList:SetPoint("TOPLEFT", self.Title, "BOTTOMLEFT", 0, -1)
	end

	-- Hook bar creation to apply settings
	local omen_mt = getmetatable(Omen.Bars)
	local oldidx = omen_mt.__index
	omen_mt.__index = function(self, barID)
		local bar = oldidx(self, barID)
		Omen:UpdateBarTextureSettings()
		Omen:UpdateBarLabelSettings()
		return bar
	end

	-- Option Overrides
	Omen.db.profile.Bar.Spacing = 1
	Omen.db.profile.Bar.Texture = "ElvUI Norm"
	Omen.db.profile.Bar.Font = "ElvUI Font"
	Omen.db.profile.Bar.Height = 18
	Omen.db.profile.TitleBar.Font = "ElvUI Font"
	Omen.db.profile.Background.Texture = "ElvUI Blank"
	Omen.db.profile.ShowWith.Alone = true
--	Omen.db.profile.ShowWith.UseShowWith = false
	
	-- Force updates
	Omen:UpdateBarTextureSettings()
	Omen:UpdateBarLabelSettings()
	Omen:UpdateTitleBar()
	Omen:UpdateBackdrop()
	Omen:ReAnchorBars()
	Omen:ResizeBars()
	
	if E.db["chat"].embedright == "Omen" then
		local Omen_Skin = CreateFrame("Frame")
		Omen_Skin:RegisterEvent("PLAYER_ENTERING_WORLD")
		Omen_Skin:SetScript("OnEvent", function(self)
			self:UnregisterAllEvents()
			self = nil
			
			Omen.UpdateTitleBar = function() end
			OmenTitle:Kill()
			OmenBarList:ClearAllPoints()
			OmenBarList:SetSize(E.db.chat.rightpanelWidth - 11, (E.db.chat.rightpanelHeight - 60))
			OmenBarList:SetPoint("BOTTOMLEFT", RightChatDataPanel, "TOPLEFT", 1, 3)
			Omen.db.profile.FrameStrata = "3-MEDIUM"

		end)
		
		if RightChatTab then
			local button = CreateFrame('Button', 'SkadaToggleSwitch', RightChatTab)
			button:Width(RightChatTab:GetHeight())
			button:Height(RightChatTab:GetHeight() - 4)
			button:Point("RIGHT", RightChatTab, "RIGHT", -2, 0)
			
			button.tex = button:CreateTexture(nil, 'OVERLAY')
			button.tex:SetTexture([[Interface\AddOns\ElvUI\media\textures\vehicleexit.tga]])
			button.tex:Point('TOPRIGHT', -2, -2)
			button.tex:Height(button:GetHeight() - 4)
			button.tex:Width(16)

			if E.db['chat'].embedcombat then
				button.tex:SetVertexColor(23/255, 132/255, 209/255)
				button:RegisterEvent("PLAYER_REGEN_DISABLED")
				button:RegisterEvent("PLAYER_REGEN_ENABLED")
				button:SetScript("OnEvent", function(self, event)
					if event == "PLAYER_REGEN_ENABLED" then
						if OmenBarList:IsShown() then OmenBarList:Hide() end
					elseif event == "PLAYER_REGEN_DISABLED" then
						if not OmenBarList:IsShown() then OmenBarList:Show() end
					end
				end)
			end
			
			button:SetScript('OnClick', function(self) ToggleFrame(OmenBarList) end)
		end
	end
	if E.db["chat"].embedright == "OmenRecount" and IsAddOnLoaded("Recount") then
		local Omen_Skin = CreateFrame("Frame")
		Omen_Skin:RegisterEvent("PLAYER_ENTERING_WORLD")
		Omen_Skin:SetScript("OnEvent", function(self)
			self:UnregisterAllEvents()
			self = nil
			
			Omen.UpdateTitleBar = function() end
			OmenTitle:Kill()
			OmenBarList:ClearAllPoints()
			OmenBarList:SetSize((E.db.chat.rightpanelWidth - 11)/2 - 2, (E.db.chat.rightpanelHeight - 60))
			OmenBarList:SetPoint("BOTTOMLEFT", RightChatDataPanel, "TOPLEFT", 1, 3)
			Omen.db.profile.FrameStrata = "3-MEDIUM"
		end)
		
		if RightChatTab then
			local button = CreateFrame('Button', 'SkadaToggleSwitch', RightChatTab)
			button:Width(RightChatTab:GetHeight())
			button:Height(RightChatTab:GetHeight() - 4)
			button:Point("RIGHT", RightChatTab, "RIGHT", -2, 0)
			
			button.tex = button:CreateTexture(nil, 'OVERLAY')
			button.tex:SetTexture([[Interface\AddOns\ElvUI\media\textures\vehicleexit.tga]])
			button.tex:Point('TOPRIGHT', -2, -2)
			button.tex:Height(button:GetHeight() - 4)
			button.tex:Width(16)

			if E.db['chat'].embedcombat then
				button.tex:SetVertexColor(23/255, 132/255, 209/255)
				button:RegisterEvent("PLAYER_REGEN_ENABLED")
				button:RegisterEvent("PLAYER_REGEN_DISABLED")
				button:SetScript("OnEvent", function(self, event)
					if event == "PLAYER_REGEN_DISABLED" then
						if not OmenBarList:IsShown() then OmenBarList:Show() end
						if not Recount_MainWindow:IsShown() then Recount_MainWindow:Show() end
					elseif event == "PLAYER_REGEN_ENABLED" then
						if OmenBarList:IsShown() then OmenBarList:Hide() end
						if Recount_MainWindow:IsShown() then Recount_MainWindow:Hide() end						
					end
				end)
			end
			
			button:SetScript('OnClick', function(self) ToggleFrame(OmenBarList); ToggleFrame(Recount_MainWindow) end)
		end
	end		
end

S:RegisterSkin('Omen', LoadSkin)