﻿local E, L, DF = unpack(ElvUI)
local LSM = LibStub("LibSharedMedia-3.0")
if E.db["euiscript"].raidcd ~= true then return end

----------------------------------------------------------------------------------------
--	Raid cooldowns(alRaidCD by Allez)
--  Modify by Ljxx.net at 2011.10.7
----------------------------------------------------------------------------------------
local show = {
	raid = true,
	party = true,
	arena = true,
}

local raid_spells = {
	[20484] = 600,	-- 复生
	[61999] = 600,	-- 复活盟友
	[20707] = 900,	-- 灵魂石复活
	[6346] = 180,	-- 防护恐惧结界
	[29166] = 180,	-- 激活
	[32182] = 300,	-- 英勇
	[2825] = 300,	-- 嗜血
	[80353] = 300,	-- 时间扭曲
	[90355] = 300,	-- 远古狂乱

	--团队免伤技能	
	[97462] = 180,  -- 集结呐喊
	[98008] = 180,  -- 灵魂链接图腾
	[62618] = 180,  -- 真言术: 障
	[51052] = 120,  -- 反魔法领域
	[70940] = 180,  -- 神圣守卫(FQ)
	[31821] = 120,  -- 光环掌握(NQ)
	[64843] = 180,  -- 神圣赞美诗 *
	[740]   = 180,  -- 宁静(ND) *
	
}

local filter = COMBATLOG_OBJECT_AFFILIATION_RAID + COMBATLOG_OBJECT_AFFILIATION_PARTY + COMBATLOG_OBJECT_AFFILIATION_MINE
local band = bit.band
local sformat = string.format
local floor = math.floor
local timer = 0
local bars = {}

local RaidCDAnchor = CreateFrame("Frame", "RaidCDAnchor", UIParent)
RaidCDAnchor:Point("TOPLEFT", Minimap, "BOTTOMLEFT", 0, -28)
RaidCDAnchor:SetSize(E.db["euiscript"].raidcd_width, E.db["euiscript"].raidcd_height)

E:CreateMover(RaidCDAnchor, "RaidCDAnchorMover", L["raidcd"])

local FormatTime = function(time)
	if time >= 60 then
		return sformat("%.2d:%.2d", floor(time / 60), time % 60)
	else
		return sformat("%.2d", time)
	end
end

local CreateFS = function(frame, fsize, fstyle)
	local fstring = frame:CreateFontString(nil, "OVERLAY")
	fstring:SetFont(LSM:Fetch("font", E.db["core"].font), E.db.core.fontsize, "OUTLINE")
	return fstring
end

local UpdatePositions = function()
	for i = 1, #bars do
		bars[i]:ClearAllPoints()
		if i == 1 then
			bars[i]:Point("TOPLEFT", RaidCDAnchor, "TOPLEFT", 26, 0)
		else
			if E.db["euiscript"].raidcd_direction == "up" then
				bars[i]:Point("BOTTOMLEFT", bars[i-1], "TOPLEFT", 0, 5)
			else
				bars[i]:Point("TOPLEFT", bars[i-1], "BOTTOMLEFT", 0, -5)
			end
		end
		bars[i].id = i
	end
end

local StopTimer = function(bar)
	bar:SetScript("OnUpdate", nil)
	bar:Hide()
	tremove(bars, bar.id)
	UpdatePositions()
end

local BarUpdate = function(self, elapsed)
	local curTime = GetTime()
	if self.endTime < curTime then
		StopTimer(self)
		return
	end
	self:SetValue(100 - (curTime - self.startTime) / (self.endTime - self.startTime) * 100)
	self.right:SetText(FormatTime(self.endTime - curTime))
end

local OnEnter = function(self)
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
	GameTooltip:AddDoubleLine(self.spell, self.right:GetText())
	GameTooltip:SetClampedToScreen(true)
	GameTooltip:Show()
end

local OnLeave = function(self)
	GameTooltip:Hide()
end

local OnMouseDown = function(self, button)
	if button == "LeftButton" then
		if GetRealNumRaidMembers() > 0 then
			SendChatMessage(sformat("EUI_RaidCD".." %s: %s", self.left:GetText(), self.right:GetText()), "RAID")
		elseif GetRealNumPartyMembers() > 0 and not UnitInRaid("player") then
			SendChatMessage(sformat("EUI_RaidCD".." %s: %s", self.left:GetText(), self.right:GetText()), "PARTY")
		else
			SendChatMessage(sformat("EUI_RaidCD".." %s: %s", self.left:GetText(), self.right:GetText()), "SAY")
		end
	elseif button == "RightButton" then
		StopTimer(self)
	end
end

local CreateBar = function()
	local bar = CreateFrame("Statusbar", nil, UIParent)
	bar:SetFrameStrata("LOW")
	bar:Size(E.db["euiscript"].raidcd_width - E.db["euiscript"].raidcd_height - 6, E.db["euiscript"].raidcd_height)
	bar:SetStatusBarTexture(E["media"].normTex)
	bar:SetMinMaxValues(0, 100)

	bar.backdrop = CreateFrame("Frame", nil, bar)
	bar.backdrop:Point("TOPLEFT", -2, 2)
	bar.backdrop:Point("BOTTOMRIGHT", 2, -2)
	bar.backdrop:SetTemplate("Default")
	bar.backdrop:SetFrameStrata("BACKGROUND")

	bar.bg = bar:CreateTexture(nil, "BACKGROUND")
	bar.bg:SetAllPoints(bar)
	bar.bg:SetTexture(E["media"].glossTex)

	bar.left = CreateFS(bar)
	bar.left:Point("LEFT", 2, 0)
	bar.left:SetJustifyH("LEFT")
	bar.left:Size(E.db["euiscript"].raidcd_width - E.db["euiscript"].raidcd_height, E.db["euiscript"].raidcd_height)

	bar.right = CreateFS(bar)
	bar.right:Point("RIGHT", 1, 0)
	bar.right:SetJustifyH("RIGHT")

	bar.icon = CreateFrame("Button", nil, bar)
	bar.icon:Size(E.db["euiscript"].raidcd_height)
	bar.icon:Point("BOTTOMRIGHT", bar, "BOTTOMLEFT", -6, 0)

	bar.icon.backdrop = CreateFrame("Frame", nil, bar.icon)
	bar.icon.backdrop:Point("TOPLEFT", -2, 2)
	bar.icon.backdrop:Point("BOTTOMRIGHT", 2, -2)
	bar.icon.backdrop:SetTemplate("Default")
	bar.icon.backdrop:SetFrameStrata("BACKGROUND")

	return bar
end

local StartTimer = function(name, spellId)
	local bar = CreateBar()
	local spell, rank, icon = GetSpellInfo(spellId)
	bar.endTime = GetTime() + raid_spells[spellId]
	bar.startTime = GetTime()
	bar.left:SetText(name.." - "..spell)
	bar.right:SetText(FormatTime(raid_spells[spellId]))
	bar.icon:SetNormalTexture(icon)
	bar.icon:GetNormalTexture():SetTexCoord(0.1, 0.9, 0.1, 0.9)
	bar.spell = spell
	bar:Show()
	local color = RAID_CLASS_COLORS[select(2, UnitClass(name))]
	if color then
		bar:SetStatusBarColor(color.r, color.g, color.b)
		bar.bg:SetVertexColor(color.r, color.g, color.b, 0.25)
	else
		bar:SetStatusBarColor(0.3, 0.7, 0.3)
		bar.bg:SetVertexColor(0.3, 0.7, 0.3, 0.25)
	end
	bar:SetScript("OnUpdate", BarUpdate)
	bar:EnableMouse(true)
	bar:SetScript("OnEnter", OnEnter)
	bar:SetScript("OnLeave", OnLeave)
	bar:SetScript("OnMouseDown", OnMouseDown)
	tinsert(bars, bar)
	UpdatePositions()
end

local OnEvent = function(self, event, ...)
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local _, eventType, _, _, sourceName, sourceFlags = ...

		if band(sourceFlags, filter) == 0 then return end
		local spellId = select(12, ...)
		if raid_spells[spellId] and show[select(2, IsInInstance())] then
			if eventType == "SPELL_RESURRECT" and not spellId == 61999 then
				if spellId == 95750 then spellId = 6203 end
				StartTimer(sourceName, spellId)
			elseif eventType == "SPELL_AURA_APPLIED" then
				if spellId == 20707 then
					local _, class = UnitClass(sourceName)
					if class == "WARLOCK" then
						StartTimer(sourceName, spellId)
					end
				end
			elseif eventType == "SPELL_CAST_SUCCESS" then
				StartTimer(sourceName, spellId)
			end
			if eventType == "SPELL_RESURRECT" and spellId == 20484 then StartTimer(sourceName, spellId) end
		end
	elseif event == "ZONE_CHANGED_NEW_AREA" and select(2, IsInInstance()) == "arena" then
		for k, v in pairs(bars) do
			StopTimer(v)
		end
	end
end

local addon = CreateFrame("Frame")
addon:SetScript("OnEvent", OnEvent)
addon:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
addon:RegisterEvent("ZONE_CHANGED_NEW_AREA")

SlashCmdList.RaidCD = function(msg)
	StartTimer(UnitName("player"), 20484)	-- Rebirth
	StartTimer(UnitName("player"), 20707)	-- Soulstone
	StartTimer(UnitName("player"), 6346)	-- Fear Ward
	StartTimer(UnitName("player"), 29166)	-- Innervate
	StartTimer(UnitName("player"), 32182)	-- Heroism
	StartTimer(UnitName("player"), 2825)	-- Bloodlust
end
SLASH_RaidCD1 = "/raidcd"