-- Wild Mushroom Tracker Addon By Smelly
-- Credits to Hydra for code inspiration :D
-- Modify by Ljxx.net
-- 20111007: add Frame move, add spell icon, modify statusbar is classcolor, fix spellname and time postion.
local E, L, DF = unpack(ElvUI)
local LSM = LibStub("LibSharedMedia-3.0")
if E.db["euiscript"].wildmushroom ~= true then return end

if E.myclass ~= "DRUID" then return end
local spellname, _,icontexture = GetSpellInfo(88747)
local tMushroom = {}
local anchor = {"TOPLEFT", Minimap, "BOTTOMLEFT", 0, LeftMiniPanel and -28 or -4}

local f = CreateFrame("Frame", "Mushroom", E.UIParent)
f:Size(E.db["euiscript"].wildmushroom_width, E.db["euiscript"].wildmushroom_height * 3 + 6)
f:Point(unpack(anchor))

E:CreateMover(f, "MushroomMover", spellname)

for i = 1, 3 do
	tMushroom[i] = CreateFrame("Frame", "tMushroom"..i, UIParent)
	tMushroom[i]:Size(E.db["euiscript"].wildmushroom_width, E.db["euiscript"].wildmushroom_height)
	tMushroom[i]:SetTemplate("Default", true)
	if i == 1 then
		tMushroom[i]:ClearAllPoints()
		tMushroom[i]:Point("TOPLEFT", f, "TOPLEFT", 0, 0)
	else
		if E.db["euiscript"].wildmushroom_direction == "down" then
			tMushroom[i]:Point("TOP", tMushroom[i-1], "BOTTOM", 0, -3)
		else
			tMushroom[i]:Point("BOTTOM", tMushroom[i-1], "TOP", 0, 3)
		end
	end	
	tMushroom[i].icon = tMushroom[i]:CreateTexture(nil, "OVERLAY")
	tMushroom[i].icon:Point("TOPLEFT", tMushroom[i], "TOPLEFT", 2, -2)
	tMushroom[i].icon:Point("BOTTOMRIGHT", tMushroom[i], "BOTTOMLEFT", 20, 2)
	tMushroom[i].icon:SetTexCoord(.08, .92, .08, .92)
	tMushroom[i].icon:SetTexture(icontexture)
	tMushroom[i].status = CreateFrame("StatusBar", "status"..i, tMushroom[i])
	tMushroom[i].status:SetStatusBarTexture(E["media"].normTex)
	tMushroom[i].status:SetFrameLevel(6)
	tMushroom[i].status:SetStatusBarColor(RAID_CLASS_COLORS[E.myclass].r, RAID_CLASS_COLORS[E.myclass].g, RAID_CLASS_COLORS[E.myclass].b )
	tMushroom[i].status:Point("TOPLEFT", tMushroom[i].icon, "TOPRIGHT", 2, 0)
	tMushroom[i].status:Point("BOTTOMRIGHT", tMushroom[i], "BOTTOMRIGHT", -2, 2)
	tMushroom[i].text = tMushroom[i].status:CreateFontString(nil, "OVERLAY")
	tMushroom[i].text:SetPoint("RIGHT", tMushroom[i].status, "RIGHT", -3, -1)
	tMushroom[i].text:SetFont(LSM:Fetch("font", E.db["core"].font), E.db.core.fontsize, "OUTLINE")
	tMushroom[i].name = tMushroom[i].status:CreateFontString(nil, "OVERLAY")
	tMushroom[i].name:SetPoint("LEFT", tMushroom[i].status, "LEFT", 3, -1)
	tMushroom[i].name:SetFont(LSM:Fetch("font", E.db["core"].font), E.db.core.fontsize, "OUTLINE")
end

local function FormatTime(s)
	local day, hour, minute = 86400, 3600, 60
	if s >= day then
		return format("%dd", ceil(s / day))
	elseif s >= hour then
		return format("%dh", ceil(s / hour))
	elseif s >= minute then
		return format("%dm", ceil(s / minute))
	elseif s >= minute / 12 then
		return floor(s)
	end
	return format("%.1f", s)
end

local function MushroomUpdate(self)
	for i = 1, 3 do
		local haveTotem, totemName, start, duration = GetTotemInfo(i)
		if haveTotem then
			tMushroom[i]:Show()
			local timeLeft = (start+duration) - GetTime()
			tMushroom[i].status:SetMinMaxValues(0, 300)
			tMushroom[i].status:SetValue(timeLeft)
			local tTime = FormatTime(timeLeft)
			tMushroom[i].text:SetText(tTime)
			tMushroom[i].name:SetText(totemName)
		else
			tMushroom[i]:Hide()
		end
	end 	
	
end

local UpdateMushroom = CreateFrame("Frame")
UpdateMushroom:SetScript("OnUpdate", MushroomUpdate)