local E = unpack(ElvUI) -- Import Functions/Constants, Config, Locales
if E.db["euiscript"].bossnotes ~= true then return end

--BOSS数据来源于大脚
local BossData = {
	["灵魂洪炉"]	= {
		{name = "布隆亚姆", raiders = "P1被点名远离BOSS,DPS集火紫色灵魂球,球吃控制；P2靠近BOSS,被恐惧进入风暴者迅速返回中心,治疗加好被恐惧者。"},
		{name = "噬魂者", raiders = "男人脸注意打断\"魅影冲击\"技能,红色连线出现时立即停止攻击；胖子脸远离鬼魂；女人脸躲开正面\"哀嚎之魂\"技能的扫射范围。"},
	},
	["萨隆矿坑"]	= {
		{name = "熔炉领主加费斯特", raiders = "BOSS\"投掷萨钢\"时躲开地上阴影；在萨钢石后面可以卡视角消除\"极寒冰霜\"DEBUFF,DEBUFF也可以驱散,切勿超过10层。"},
		{name = "依克和科瑞克", raiders = "\"毒气新星\"时远离BOSS；被点名\"失序追击\"人员头上有箭头速度远离BOSS；\"爆裂弹幕\"时躲开紫色爆炸范围；绿水有毒不要站。"},
		{name = "天灾领主泰兰努斯", raiders = "点名\"白霜\"远离人群；点名\"霸主的烙纹\"有红色连线,立即停止攻击；BOSS变大后伤害增加,坦克开技能或风筝BOSS在冰面。"},
	},
	["映像大厅"]	= {
		{name = "小怪", raiders = "战斗前站在墙角卡小怪视野,等坦克建立好仇恨再分散；尽量控制法师或者猎人怪单点击杀；及时驱散队友魔法和诅咒。"},
		{name = "法瑞克", raiders = "优先驱散队友DEBUFF,BOSS释放恐惧前保证队友高血量,坦克中\"颤栗打击\"后注意开技能保命,\"颤栗打击\"也可驱散。"},
		{name = "玛维恩", raiders = "所有人远离黑水；治疗加好中\"苦难共享\"技能的队友,但不要驱散该DEBUFF；\"血肉腐化\"技能期间注意自保。"},
		{name = "逃离巫妖王", raiders = "远离巫妖王,靠近冰墙进行战斗；坦克拉憎恶怪背对人群；优先击杀法系怪,注意打断其施法,及时驱散队友诅咒。"},
	},
	["冠军的试炼"]	= {
		{name = "阵营勇士", raiders = "P1,使用\"冲锋\"和\"戳刺\"配合\"破盾\"击杀敌人,BOSS落马起身及时踩踏；P2,躲好DZ的\"毒药瓶\"ZS的\"旋风斩\",打断萨满治疗术,法师急速BUFF及时偷取或驱散。"},
		{name = "银色神官帕尔崔丝", raiders = "\"忏悔\"之后转火召唤的回忆幻象,打断或驱散\"神圣之火\",偷取或驱散BOSS与回忆幻象身上的\"恢复\"。"},
		{name = "纯洁者耶德瑞克", raiders = "当使用\"光辉\"技能时背对BOSS防止致盲,BOSS使用\"正义之锤\"时及时驱散BOSS目标身上的\"制裁之锤\"。"},
		{name = "黑骑士", raiders = "驱散T的疾病,加好\"缓刑\",躲好食尸鬼爆炸；P2,驱散T的疾病,跑开\"亵渎\"范围,躲好食尸鬼爆炸；P3,加好\"死亡印记\"目标,保持全队满血。"},
	},
	["乌特加德城堡"]	= {
		{name = "凯雷塞斯王子", raiders = "BOSS\"召唤骷髅\"出现时T拉好A掉,治疗加好中了\"冰之坟墓\"的人,DPS第一时间转火\"冰之坟墓\",闪现、冰箱、无敌、徽章可解除。"},
		{name = "建筑师斯卡瓦尔德&控制者达尔隆", raiders = "拉好控制者召唤的小怪,建筑师施放\"激怒\"时注意保命,加好被\"冲锋\"的人血,BOSS死后会复活但无法杀死,成功击杀另外一个以后获胜。"},
		{name = "劫掠者因格瓦尔", raiders = "BOSS释放\"恐怖咆哮\"的时候不要施法,T拉BOSS背对人群防止\"顺劈斩\"和\"黑暗打击\",P2阶段注意跑开暗影战斧的\"旋风斩\"范围。"},
	},
	["魔枢"]	= {
		{name = "阵营指挥官", raiders = "躲好BOSS的\"旋风斩\",加好被\"冲锋\"的目标,拉离其他未引到的小怪,防止BOSS\"群体恐惧\"冲进怪堆。"},
		{name = "大魔导师泰蕾丝塔", raiders = "远离中\"火焰炸弹\"的目标,BOSS施放\"重力之井\"用瞬发治疗和DPS,BOSS血量66%和33%会使用\"分身\",躲好冰分身的\"暴风雪\",驱散奥分身\"变羊术\"。"},
		{name = "阿诺玛鲁斯", raiders = "BOSS血量降低到50%会\"裂隙充能\"并召唤\"混乱裂隙\",转火\"混乱裂隙\",注意加好中\"奥术吸引\"的目标以及全队的血。"},
		{name = "塑树者奥莫洛克", raiders = "BOSS施放\"法术反射\"所有法系停手,跑好\"水晶尖刺\",秒掉BOSS召唤的\"小花\"防止被定身,BOSS血量20%会\"激怒\",T开技能保命。"},
		{name = "克莉斯塔萨", raiders = "DPS不要站龙头和龙尾防止\"扫尾\"和\"水晶喷吐\",\"极度寒冷\"DEBUFF会无限叠加通过跳跃和移动人物来及时解除,\"冻结\"后及时驱散,血量20%以下\"激怒\"所有人开技能保命。"},
	},
	["艾卓-尼鲁布"]	= {
		{name = "看门者克里克希尔", raiders = "3位守护者,优先击杀法系怪,BOSS战加好当前T的血,驱散\"疲劳诅咒\",BOSS召唤小虫治疗尽量向T靠拢方便群拉,10%血BOSS\"激怒\"开技能自保。"},
		{name = "哈多诺克斯", raiders = "及时跑开\"毒云\",第一时间驱散\"吸血毒药\"并且在DEBUFF持续期间别死人,BOSS使用\"穿刺护甲\"治疗注意加好T,T开技能保命。"},
		{name = "阿努巴拉克", raiders = "\"虫群风暴\"期间加好全队和T血,别站BOSS面前防止被\"猛击\"秒,BOSS每减少25%血会下地,T注意拉好精英小怪,小心地面突起的白刺,可以提前躲开。"},
	},
	["安卡赫特：古代王国"]	= {
		{name = "纳多克斯长老", raiders = "驱散\"巢穴热疫\"疾病,T群拉好BOSS召唤的小虫,BOSS每减少25%血量召唤\"安卡哈尔守护者\",迅速转火守护者,治疗自己保命。"},
		{name = "塔达拉姆王子", raiders = "召唤\"火焰之球\"所有人尽量站分散减少治疗压力,BOSS每减少25%血量会对某一玩家使用\"吸血鬼拥抱\",无法治疗但可以套盾,所有人打BOSS4W血以后停止。"},
		{name = "埃曼尼塔(英雄模式)", raiders = "T靠墙拉BOSS以防被击飞,注意解毒、解魔法,BOSS施放\"迷你\"所有人靠近健康的蘑菇并打掉以解DEBUFF,所有人禁止释放AOE技能。"},
		{name = "耶戈达·觅影者", raiders = "近战注意躲避\"飓风打击\",迅速跑开\"雷霆震击\"范围,BOSS每减少25%血量会升空召唤\"暮光志愿者\",转火志愿者,若没杀掉T注意开技能。"},
		{name = "传令官沃拉兹", raiders = "加好\"暗影箭雨\"造成的伤害,BOSS每减少33%血会使用\"疯狂\",所有人优先击杀治疗者化身,输出低的注意保命等别人帮杀,打断职业注意打断鞭笞。"},
	},
	["达克萨隆要塞"]	= {
		{name = "托尔戈", raiders = "分散站位,小怪死了T把BOSS拉开以防尸爆,注意及时驱散\"感染之伤\"。"},
		{name = "召唤者诺沃斯", raiders = "迅速清理小怪,优先击杀法系怪,解除\"痛苦之怒\"诅咒效果,及时躲开\"暴风雪\"范围。打断寒冰箭,治疗注意团血。"},
		{name = "暴龙之王爵德", raiders = "尽量驱散\"低吼咆哮\",T中了\"穿刺猛击\"注意开技能保命,治疗给中\"悲惨撕咬\"的人抬满血,BOSS召唤小龙T注意拉住不让小龙打治疗,看见提示\"爵德阴险的举起爪子\"时T注意保命。"},
		{name = "先知萨隆亚", raiders = "驱散\"生命诅咒\"效果,及时躲开\"毒云\",骷髅阶段T用\"嘲讽\"+\"白骨护盾\"技能(2、3技能),其他人用\"杀戮打击\"+\"生命之触\"技能(1、4技能)输出。"},
	},
	["紫罗兰监狱"]	= {
		{name = "埃雷克姆", raiders = "驱散或偷取\"嗜血\"和\"闪电护盾\",打断\"治疗链\",优先击杀BOSS不需要杀随从。"},
		{name = "拉文索尔", raiders = "离开\"熔岩灼烧\"范围,请勿站BOSS正面防止被\"火焰吐息\"造成伤害,全力击杀BOSS防止\"灼热之焰\"堆叠太高。"},
		{name = "湮灭者祖拉玛特", raiders = "中了\"虚空变换\"的人优先寻找\"虚空斥候\"击杀,其他人全力击杀BOSS防止\"黑暗之影\"堆叠太高。"},
		{name = "谢沃兹", raiders = "所有人远离\"虚灵之球\"防止被传送并增加BOSS伤害,T也需要拉BOSS远离\"虚灵之球\",驱散\"奥术易伤\"DEBUFF。"},
		{name = "艾库隆", raiders = "迅速打破\"水之护盾\",快速击杀\"艾库隆水滴\"或开启墙上的红色水晶防御结界击杀,防止水滴与BOSS融合。"},
		{name = "摩拉格", raiders = "\"腐蚀粘液\"堆叠太多层T开保命技能,治疗加好中\"注视之光\"的人。"},
		{name = "塞安妮苟萨", raiders = "除T以外所有人不要站龙头和龙尾防止\"无法控制的能量\"和\"扫尾\",驱散\"无法控制的能量\"的DOT和\"魔法破坏\"DEBUFF,跑开\"暴风雪\"范围,\"奥术真空\"后DPS等T上仇恨再输出。"},
	},
	["古达克"]	= {
		{name = "斯拉德兰", raiders = "T中了\"强力撕咬\"注意开保命技能,近战注意躲开\"剧毒新星\"15码AOE范围,BOSS召唤小蛇迅速击杀。"},
		{name = "达卡莱巨像", raiders = "BOSS血量下降50%会分裂成为\"达卡莱元素\",注意躲开元素的\"粘液堆\"范围,BOSS合体时施放\"涌动\"的时候躲开正面冲锋路径。"},
		{name = "莫拉比", raiders = "BOSS释放\"地震\"时注意治疗,在\"震耳咆哮\"技能时,治疗注意预读T,BOSS施放\"变身\"尽量打断。"},
		{name = "凶残的伊克(英雄模式)", raiders = "所有人不要站BOSS正面防止被\"喷吐\",BOSS跳跃以后所有人停手等T建立仇恨,全力输出防止90秒后BOSS\"狂暴\"。"},
		{name = "迦尔达拉", raiders = "注意躲开\"旋风斩\"AOE范围,BOSS变身犀牛后加好被\"穿刺\"的人,\"雷霆一击\"和\"犀牛冲撞\"技能时注意自保和治疗。"},
	},
	["岩石大厅"]	= {
		{name = "克莱斯塔卢斯", raiders = "治疗加好\"践踏\",BOSS\"大地碎裂\"击飞后施放\"碎裂\"时所有人保持距离15码防止距离过近被误伤秒杀。"},
		{name = "悲伤圣女", raiders = "驱散\"悲伤之柱\"DOT,所有人躲开\"悲伤风暴\"的范围,BOSS施放\"心碎\"时治疗先给T加满HOT防止被忏悔后治疗真空,T注意开保命技能。"},
		{name = "远古法庭", raiders = "全程T拉好小怪,P2阶段驱散职业注意驱散中了黑球DEBUFF的人,P3阶段注意跑开\"凝视光线\"AOE范围。"},
		{name = "塑铁者斯约尼尔", raiders = "中了\"静电充能\"的人要远离队友,BOSS施放\"闪电之环\"的时候所有人跑开防止DEBUFF叠的过多被秒,BOSS30%血量后施放\"狂乱\"治疗加好T,T注意开保命技能。"},
	},
	["净化斯坦索姆"]	= {
		{name = "肉钩", raiders = "法系与治疗尽量远离BOSS避免被\"疾病驱逐\"沉默,治疗加好中了\"收缩之链\"的人,如治疗中则T开保命技能。"},
		{name = "塑血者沙尔拉姆", raiders = "解除\"扭曲血肉诅咒\"DEBUFF,第一时间击杀召唤的\"食尸鬼\"防止\"食尸鬼爆炸\"造成AOE伤害。"},
		{name = "时光领主埃博克", raiders = "解除\"消耗诅咒\"DEBUFF,所有人靠近BOSS输出防止BOSS\"时间扭曲\"后随机冲锋秒人。"},
		{name = "永恒腐蚀者(英雄模式)", raiders = "治疗全力加好\"腐蚀瘟疫\"的目标掉血每3秒8%的血量,T拉BOSS背对人群防止\"虚空打击\"对队友造成伤害。"},
		{name = "玛尔加尼斯", raiders = "驱散BOSS自己的\"吸血鬼之触\"BUFF,驱散中\"睡眠\"DEBUFF的人,T拉BOSS背对人群,队友分散站开防止\"腐臭蜂群\"造成AOE伤害。"},
	},
	["黑石岩窟"]	= {
		{name = "摧骨者罗姆欧格", raiders = "开boss前清光附近小怪,否则附近的小怪会被boss喊过来add,被\"苦痛之链\"锁住后第一时间打掉锁链,所有人远离boss避免旋风斩,Boss召唤出的小怪由T拉住让boss自己旋风斩劈死即可。"},
		{name = "柯尔拉，暮光之兆", raiders = "分三个人挡三道光线,身上的debuff叠到70~80层时离开光线(暗影斗篷、无敌、披风可解除),debuff一消失继续去挡,一定要打断BOSS的恐惧技能。"},
		{name = "卡尔什·断钢", raiders = "让boss靠近中间的火,boss每获得一层debuff,受到的伤害增加,同时也会释放一次AOE。掌握好时间及层数,最好保持boss身上debuff不要断。"},
		{name = "如花", raiders = "注意及时解除恐惧,普通模式小狗和boss仇恨不连接,可以先杀小狗再BOSS,不用全杀(小狗全死后BOSS会狂暴)。"},
		{name = "升腾者领主奥西迪斯", raiders = "T只拉BOSS,其他一人风筝小怪,每隔一段时间BOSS会和影子换位并清空仇恨,注意第一时间控制好目标仇恨。"},
	},
	["旋云之巅"]	= {
		{name = "大宰相埃尔坦", raiders = "开战后外围会出现旋风,站在旋风和boss之间输出,当旋风向BOSS聚拢时近战离开,全程注意保持和旋风的距离,碰到旋风攻击速度会减少很多。"},
		{name = "阿尔泰鲁斯", raiders = "看场上风向,处在逆风位置时穿过BOSS一下,尽量保持顺风,躲好Boss释放的龙息及地上的旋风。"},
		{name = "阿萨德", raiders = "平时分散站位,避免闪电链穿多人,第一时间驱散\"静滞之握\"(跳跃也可闪开),boss召唤法阵后全都站在法阵内，不然会被A死。"},
	},
	["潮汐王座"]	= {
		{name = "纳兹夏尔女士", raiders = "分散站位,避免致命孢子影响队友,躲好脚下的喷泉,第一时间打断\"震爆\",小怪阶段控制2个法系怪,杀近战,躲好旋风。"},
		{name = "指挥官乌尔索克", raiders = "T拉着BOSS绕屋子走,躲开BOSS砸地,不要待在黑圈里,加好被抓住的人,狂怒时注意T血。"},
		{name = "蛊心魔古厄夏", raiders = "p1阶段T把boss背对人群,尽量打断施法读条并注意躲开地刺,p2阶段注意躲开绿色迷雾输出,出保护罩后法系dps停手(可偷,可驱散),黑色连线时治疗注意团血。"},
		{name = "厄祖玛特", raiders = "p1阶段近战注意恐兽跳起后远离并躲开黑水,p2阶段t风筝血肉DPS击杀工兵,不要长时间站在黑水里,p3阶段全力输出BOSS。"},
	},
	["巨石之核"]	= {
		{name = "克伯鲁斯", raiders = "地上阶段远离地上的红水晶并第一时间打掉,地下阶段t拉住小怪,所有人第一时间躲开地上的烟雾。"},
		{name = "岩皮", raiders = "躲好地上的岩浆圈,Boss在地面全屏Aoe躲在柱子后面卡视角,近战注意,不能找boss红圈内的石柱躲,否则照样挨打,空中阶段不要被落下来的石柱砸到。"},
		{name = "欧泽鲁克", raiders = "T拉好BOSS背离人群,BOSS抬腿放地刺的瞬间往BOSS背后跑。BOSS放昏迷前所有人用技能打一下BOSS获得流血DOT来解除昏迷,当提示“感受大地之力”时,迅速远离BOSS。"},
		{name = "高阶女祭司艾苏尔", raiders = "地上出什么躲什么(出烟不躲瞬死),及时打断BOSS的\"原力之握\",将跑过来得信徒都引入重力之井会直接秒杀。"},
	},
	["格瑞姆巴托"]	= {
		{name = "乌比斯将军", raiders = "T把BOSS拉至背对人群,治疗注意刷掉坦克身上的流血效果。小怪杀掉,注意英雄模式紫色小怪控制好不要杀。BOSS盯人冲锋时要及时避开。"},
		{name = "铸炉之主索乌格斯", raiders = "三种随机形态:盾形态时全体站BOSS身后输出,注意及时调整位置；剑形态时治疗加好,原地输出(可缴械)；锤形态时风筝BOSS,躲开地上的火焰。"},
		{name = "达加·燃影者", raiders = "被火元素连线的人迅速远离火元素,同时所有DPS集火秒掉火元素。龙下来后,提前跑到BOSS的背后,不要被火喷到,不要站光圈里。"},
		{name = "埃鲁达克", raiders = "BOSS对人放黑影时立即跑开,门口刷小怪时,分配好减速人员,必须在小怪跑进来开蛋之前击杀两个小怪。BOSS放暗影强风时,所有人躲到漩涡中间。"},
	},
	["托维尔失落之城"]	= {
		{name = "胡辛姆将军", raiders = "坦克尽量把BOSS往一边拉,保证有地方没地雷。躲地雷,躲光圈,记得躲远一些,地雷爆炸范围大约8码。"},
		{name = "锁喉", raiders = "近战站鳄鱼侧面输出,杀完鳄鱼速度恢复。躲好旋风斩,能AOE的帮忙AOE小鳄鱼,中标记的注意自保,驱散好毒。"},
		{name = "高阶预言者巴林姆", raiders = "P1躲开光柱,风筝火凤凰,治疗驱散瘟疫。P2速度Rush黑凤凰,灵魂碎片出现后,坦克将黑暗凤凰拉开,避免融合,灵魂碎片可以减速。"},
		{name = "希亚玛特", raiders = "P1杀好小怪,优先打远程小怪,躲开地上的云；P2技能全开狠打。"},
	},
	["死亡矿井"]	= {
		{name = "格拉布托克", raiders = "p1无脑输出,注意boss有时会清仇恨注意嘲讽,p2阶段躲好火墙,坦克拉小怪,其他人全力打BOSS。"},
		{name = "赫利克斯·破甲", raiders = "中间的轨道不要站人,中炸弹的远离人群,躲开地上的炸弹。"},
		{name = "死神5000", raiders = "一个近战去下面开伐木机,用技能杀死火炉中出的火元素,千万不要让火元素上来。其他人在上面通道打BOSS,躲开BOSS的旋转爪子挠人,不躲必死！"},
		{name = "撕心狼将军", raiders = "出小怪优先杀小怪,最后一次出三个小怪的时候可直接rush boss。"},
		{name = "\"队长\"曲奇", raiders = "BOSS无仇恨,点地上的食物,躲开绿全力输出,坏食物的debuff可以用好食物消除。"},
		{name = "梵妮莎·范克里夫", raiders = "闯关阶段：躲好地上的火,天上的冰,死了释放跑本。BOSS战：打好小怪,BOSS烧船时,点船旁边的绳子逃避爆炸。"},
	},
	["影牙城堡"]	= {
		{name = "灰葬男爵", raiders = "p1分配一人打断痛苦与折磨,窒息术所有人空血后,注意要让BOSS的死亡缓刑爆1到2下再打断,p2黑暗大天使时全力输出。"},
		{name = "席瓦莱恩男爵", raiders = "坦克拉好,集火杀BOSS召唤的狼人,治疗注意驱散诅咒。"},
		{name = "指挥官斯普林瓦尔", raiders = "优先击杀小怪,躲好Boss喷火,不要站在绿圈里,小怪的邪恶活化尽量打断。"},
		{name = "瓦尔登勋爵", raiders = "分散站位,地上出什么躲什么,boss喷绿毒时要保持移动或原地跳,喷红色毒的时候不能移动并全力输出。"},
		{name = "高弗雷勋爵", raiders = "远程治疗站在台子上面,近战和坦克在台子下面攻击,boss召唤食尸鬼时坦克注意拉住,中debuff的即时解,否则必死,漫天弹幕坦克近战注意跑向boss背面输出。"},
	},
	["起源大厅"]	= {
		{name = "神殿守护者安努尔", raiders = "地上出什么躲什么,BOSS无敌时,双人下台阶,一人引蛇一人开机关,注意脚底下的蓝火。"},
		{name = "地怒者塔赫", raiders = "坦克拉BOSS背对人群,其他人不要站正面,躲开地上的土圈,远程上骆驼可以移动施法,但宠物会消失。"},
		{name = "安拉斐特", raiders = "第一时间躲开boss施放到地上的黑圈,全力输出,英雄模式下黑圈会一直存在,T注意把boss拉到没有黑圈的地方。"},
		{name = "伊希斯特", raiders = "出小怪近战帮助打一下,boss放闪光弹注意背对,boss分身只需集火打掉一个即可。"},
		{name = "阿穆纳伊", raiders = "驱散好\"枯萎\",出小怪打小怪,无脑输出。"},
		{name = "塞特斯", raiders = "boss无仇恨,普通模式不用管小怪,无脑输出boss,英雄模式注意第一时间打掉传送门,坦克风筝小怪,dps输出boss和传送门,第三个传送门后可以全力rush boss。"},
		{name = "拉夏", raiders = "注意打断,boss所有技能读条都可以打断,地上出什么躲什么,太阳祝福时所有技能全开rush Boss。"},
	},
    ["巴拉丁监狱"]	= {
        {name = "阿尔加洛斯", raiders = "1队左，2队右，吃DEBUFF换T，驱散吞噬魔法，放火全团跑动."},--来源于我们可爱的猫猫.
    },
	["祖尔格拉布"]	= {
		{name = "小怪攻略", raiders = "冰锅:下一次攻击冰冻并减少目标80%生命值(Boss无效);火锅:山寨版自焚;毒锅:减免自然伤害90%。"},
		{name = "高阶祭司温诺西斯", raiders = "打断\"赫希斯的低语\",连线玩家速度相互跑开,全程躲开地面绿线和毒圈,75%变身后躲开BOSS正面,50%上台,躲好绿线追踪。"},
		{name = "血领主曼多基尔", raiders = "第一时间急火奥根,冲锋必死(大天使点掉)等NPC救即可,注意脚下扇形AOE伤害技能。"},
		{name = "格里雷克", raiders = "被追逐玩家风筝BOSS,躲开脚下地动波。"},
		{name = "哈萨拉", raiders = "打断\"愤怒\",远离房间边缘,出梦魇时没定身玩家速秒小怪解救4位队员。"},
		{name = "乌舒雷", raiders = "BOSS背对人群,躲开闪电云,注意分散躲避闪电棒。"},
		{name = "雷纳塔基", raiders = "加好被伏击的玩家,躲开旋风斩路线。"},
		{name = "高阶祭司基尔娜拉", raiders = "带着BOSS清掉小豹子再输出BOSS,注意打断引导技能,躲好风墙。"},
		{name = "赞吉尔", raiders = "躲开BOSS正面火线,BOSS召唤大个,被点的跑;DPS(远程吃冰锅)急火;召唤僵尸,坦克吃火,DPS打掉,全屏毒伤,全员吃绿锅。"},
		{name = "碎神者金度", raiders = "清两侧小怪再开BOSS,将BOSS拉出绿罩,哈卡阴影时全员进绿罩,p2阶段出现三条锁链,T拉台下大个,被大个点名站在紫色圈附近就能打破紫圈,然后跑开集急火锁链,3条都清;注意脚下火圈并清掉灵魂。"},
	},
	["祖阿曼"]	= {
		{name = "埃基尔松", raiders = "当白鸟抓住玩家时速度打掉白鸟,当boss释放闪电技能时所有人集中在boss脚下,木桩boss。"},
		{name = "纳洛拉克", raiders = "P1人形时所有人不要远离BOSS超过10码,木桩BOSS,p2变熊时木桩BOSS。"},
		{name = "加亚莱", raiders = "当boss喷火时躲到其身后输出,当出巨魔小怪的时候速度全部杀掉,尽量不让其召唤龙鹰,当boss释放炸弹技能时迅速躲开。"},
		{name = "哈尔拉兹", raiders = "P1时BOSS会释放治疗图腾,坦第一时间拉出绿圈即可,留下少量图腾可以恢复玩家生命;P2时治疗加好被豹子急火的目标,闪电图腾第一时间打掉,反复几次即可。"},
		{name = "妖术领主玛拉卡斯", raiders = "优先杀掉小怪,BOSS会随机指定一名玩家释放灵魂虹吸,期间可以使用该职业的技能,技能可打断,结束后boss会释放AOE技能,治疗注意群补。"},
		{name = "达卡拉", raiders = "P1:躲旋风斩,加好重伤;p2随机2种形态,熊:冲锋最远目标,除T外轮流吃,优先驱散T麻痹;山鹰:施法会受伤害,优先打图腾,躲好风;龙鹰:躲好火圈和火柱;猫:被点名开技能自保T可嘲讽,全力大招rush。"},
	},
	["时光之末"] = {
		{name = "贝恩的残影", raiders = "别在岩浆里面站着.驱散熔岩武器,拿图腾砸BOSS."},
		{name = "吉安娜的残影", raiders = "躲好动感光波,会从泰兰德脚下放出,到水塘边会分成三股."},
		{name = "希尔瓦娜斯的残影", raiders = "集火打掉一个食尸鬼,然后从缺口走出去.地上有什么躲什么."},
		{name = "姆诺兹多", raiders = "所有技能全开,沙漏重置所有cd,死人也复生~直到站不下或死人了或打掉了1/6血了再点沙漏."},
	},
	["永恒之井"] = {
		{name = "佩罗萨恩", raiders = "地上什么躲什么,白送."},
		{name = "艾萨拉女王", raiders = "打掉控制单个人的手,打断女王的群控读条,小怪放的技能地上有什么躲什么."},
		{name = "玛诺洛斯", raiders = "躲好玛洛诺斯放的暗影火,可以往远处跑.两次火之后瓦罗森应该基本上死了,点他的配剑.泰兰德应该不行了,去白光那救泰兰德(打死恐惧魔王).然后猛抽玛洛诺斯,T拉好小怪,躲好暗影火.各种自保免伤坚持直到伊利丹读完萨格拉斯之赐."},
	},
	["暮光审判"] = {
		{name = "萨奎里恩", raiders = "治疗驱散定身.20%以下开团队免伤/大技能轰掉."},
		{name = "埃希拉", raiders = "别站在血雾里,多用dot/hot,白送."},
		{name = "大主教本尼迪塔斯", raiders = "P1躲在萨尔的罩子里,P2跑动输出避开暗影球,看好方向避开暮光浪潮. "},
	},
	["巨龙之魂"] = {
		{name = "莫卓克", raiders = "人群靠近王的脚，红球出现往那儿跑。黑水石柱后藏好，反复三次王就倒。"},
		{name = "督军佐诺兹", raiders = "这里如果你是坦克可以你自己处理坏灭虚无（光球），一个人撞。这样就当木桩打了。人群分边撞球忙（分成近战远程两组相互撞球），七层以后踹给王。王开AE集中站，反复三次王就挂。"},
		{name = "不眠的约萨希", raiders = "紫绿红蓝依次打（软泥优先击杀顺序），绿色集合不用怕。红色集中脚下刷，招啥打啥王就趴。"},
		{name = "缚风者哈格拉", raiders = "集中攻击坦克跑，冰阶段地上躲好（躲外圈顺时针移动的冰浪）。雷阶段集中站，顺时跟着团乱窜（从一个水晶传电到下一个水晶）。"},
		{name = "奥卓克希昂", raiders = "主坦DEBUFF副坦嘲，DEBUFF4秒再去消（点屏幕中央按钮消DEBUFF）。暮光之时点中间，看清时间别乱点（暮光之时读条过一半再点按钮）。"},
		{name = "战斗大师黑角", raiders = "小怪要处理好，飞龙优先怪拉牢（远程优先打飞龙，坦克拉好近战怪，背对人群）。黑圈冒烟要躲掉（地上黑圈要躲开），越打越痛技能交。"},
		{name = "死亡之翼的背脊", raiders = "DPS看标打，触手杀一就行啦（看标记打一个触手就行）。大怪血少停手下，九层靠近装甲杀（大怪DEBUFF叠到9层拉到BOSS护甲边击杀）。肌腱出现用力打（肌键露出后全力轰），打掉三块看动画。"},
		{name = "疯狂的死亡之翼", raiders = "红绿黄蓝的台子（击杀顺序）；杀触手再打爪子；刺穿2次才开技能的样子；小怪拉到黄圈内杀要A快点；源质箭最快集火单点；换台子别换错要换快点；P2去绿色的台子，清掉一波触手大怪全力RUSH."},
	},
}

SLASH_BOSS1 = "/boss"
SLASH_BOSS2 = "/BOSS"
SlashCmdList["BOSS"] = function(input)
	local bossname = UnitName("target")
	if bossname == nil then
		DEFAULT_CHAT_FRAME:AddMessage("请选中BOSS为你的目标",1,0,0)
		return
	end
	for k, v in pairs(BossData) do
		for i, info in ipairs(v) do
			if(type(info.raiders)=="string") then
				if bossname == info.name then
					if UnitInRaid("player") then
						SendChatMessage(info.raiders, "RAID");
					else
						SendChatMessage(info.raiders, "PARTY");
					end
					return;
				end
			end
		end
	end
	DEFAULT_CHAT_FRAME:AddMessage("无此BOSS数据",1,0,0);
end

SLASH_IN1 = "/in"
SlashCmdList["IN"] = function(msg)
	local seconds, command, rest = msg:match("^([^%s]+)%s+(/[^%s]+)(.*)$")
	if not seconds or not command or not rest then return end
	seconds = tonumber(seconds)
	local f = f or CreateFrame("frame")
	local T = T or 0
	local i = seconds
	local order = {
		["/s"] = "SAY",
		["/e"] = "EMOTE",
		["/y"] = "YELL",
		["/p"] = "PARTY",
		["/g"] = "GUILD",
		["/o"] = "OFFICER",
		["/raid"] = "RAID",
		["/rw"] = "RAID_WARNING",
		["/bg"] = "BATTLEGROUND",
		["/w"] = "WHISPER",
	}
	local function OnUpdate()
		local t = GetTime()
		if t - T > 1 then
			if i == 0 then
				SendChatMessage(rest, order[command]);
				f:SetScript("OnUpdate", nil);
			else
				i = i - 1;
				T = t;
			end
		end
	end
	f:SetScript("OnUpdate", OnUpdate)
end