local E, L, DF = unpack(ElvUI); --Engine

E.Options.args.euiscript = {
	type = "group",
	name = L["euiscript"],
	desc = L["euiscript_desc"],
	childGroups = "select",
	get = function(info) return E.db.euiscript[ info[#info] ] end,
	set = function(info, value) E.db.euiscript[ info[#info] ] = value end,
	args = {
		euiscript_general = {
			order = 1,
			type = "group",
			name = L["euiscript_general"],
			get = function(info) return E.db.euiscript[ info[#info] ] end,
			set = function(info, value) E.db.euiscript[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,
			args = {
				chatbar = {
					order = 1,
					type = "toggle",
					name = L["chatbar"],
				},
				statreport = {
					order = 2,
					type = "toggle",
					name = L["statreport"],
				},
				drag = {
					order = 3,
					type = "toggle",
					name = L["drag"],
				},
				castby = {
					order = 4,
					type = "toggle",
					name = L["castby"],
				},
				chatmod = {
					order = 5,
					type = "toggle",
					name = L["chatmod"],
				},
				ilevel = {
					order = 6,
					type = "toggle",
					name = L["ilevel"],
				},
				mapmove = {
					order = 7,
					type = "toggle",
					name = L["mapmove"],
				},
				talent = {
					order = 8,
					type = "toggle",
					name = L["talent"],
				},
				tradetabs = {
					order = 9,
					type = "toggle",
					name = L["tradetabs"],
				},
				combatnoti = {
					order = 10,
					type = "toggle",
					name = L["combatnoti"],
				},
				combatnoti_leaving = {
					order = 11,
					type = "input",
					disabled = function(info) return not E.db.euiscript.combatnoti end,
					set = function(info, value) E.db.euiscript[ info[#info] ] = value; end,
					name = L["combatnoti_leaving"],
				},
				combatnoti_entering = {
					order = 12,
					type = "input",
					disabled = function(info) return not E.db.euiscript.combatnoti end,
					set = function(info, value) E.db.euiscript[ info[#info] ] = value; end,
					name = L["combatnoti_entering"],
				},
				wgtimenoti = {
					order = 13,
					type = "toggle",
					name = L["wgtimenoti"],
				},
				sr = {
					order = 14,
					type = "toggle",
					name = L["sr"],
				},
				idq = {
					order = 15,
					type = "toggle",
					name = L["idQuestAutomation"],
					desc = L["idQuestAutomation_desc"],
				},
				recipients = {
					order = 16,
					type = "toggle",
					name = L["recipients"],
				},
				dispel = {
					order = 17,
					type = "toggle",
					name = L["dispel"],
				},
				chatemote = {
					order = 18,
					type = "toggle",
					name = L["chatemote"],
				},
				mapfull = {
					order = 19,
					type = "toggle",
					name = L["mapfull"],
				},
				bossnotes = {
					order = 20,
					type = "toggle",
					name = L["bossnotes"],
				},
				hovertip = {
					order = 21,
					type = "toggle",
					name = L["hovertip"],
					desc = L["HOVERTIP_DESC"],
				},
				openall = {
					order = 22,
					type = "toggle",
					name = L["openall"],
				},
				autogreed = {
					order = 23,
					type = "toggle",
					name = L["autogreed"],
				},
				buffreminder = {
					order = 24,
					type = "toggle",
					name = L["buffreminder"],
				},
				autoacceptinv = {
					order = 25,
					type = "toggle",
					name = L["autoacceptinv"],
				},
				autoinvenable = {
					order = 26,
					type = "toggle",
					name = L["autoinvenable"],
				},
				ainvkeyword = {
					order = 27,
					type = "input",
					disabled = function(info) return not E.db.euiscript.autoinvenable end,
					set = function(info, value) E.db.euiscript.ainvkeyword = value; end,					
					name = L["ainvkeyword"],
				},
				errorenable = {
					order = 28,
					type = "toggle",
					name = L["errorenable"],
				},
			},
		},
		euiscript_raidcd = {
			order = 2,
			type = "group",
			name = L["raidcd"],
			get = function(info) return E.db.euiscript[ info[#info] ] end,
			set = function(info, value) E.db.euiscript[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,
			args = {
				raidcd = {
					order = 1,
					type = "toggle",
					name = L["raidcd"],
					desc = L["raidcd_desc"],
				},
				raidcd_width = {
					order = 2,
					type = "range",
					name = L["raidcd_width"],
					min = 10, max = 200, step = 1,
				},
				raidcd_height = {
					order = 3,
					type = "range",
					name = L["raidcd_height"],
					min = 1, max = 100, step = 1,
				},
				raidcd_maxbars = {
					order = 4,
					type = "range",
					name = L["raidcd_maxbars"],
					min = 1, max = 40, step = 1,
				},
				raidcd_direction = {
					order = 5,
					type = "select",
					name = L["raidcd_direction"],
					values = {
						["up"] = L["up"],
						["down"] = L["down"],
					},
				},
			},
		},
		euiscript_classcd = {
			order = 3,
			type = "group",
			name = L["classcd"],
			get = function(info) return E.db.euiscript[ info[#info] ] end,
			set = function(info, value) E.db.euiscript[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,
			args = {
				classcd = {
					order = 1,
					type = "toggle",
					name = L["classcd"],
					desc = L["classcd_desc"],
				},
				classcd_width = {
					order = 2,
					type = "range",
					name = L["classcd_width"],
					min = 10, max = 200, step = 1,
				},
				classcd_height = {
					order = 3,
					type = "range",
					name = L["classcd_height"],
					min = 1, max = 100, step = 1,
				},
				classcd_maxbars = {
					order = 4,
					type = "range",
					name = L["classcd_maxbars"],
					min = 1, max = 40, step = 1,
				},
				classcd_direction = {
					order = 5,
					type = "select",
					name = L["classcd_direction"],
					values = {
						["up"] = L["up"],
						["down"] = L["down"],
					},
				},
			},
		},		
		euiscript_wildmushroom = {
			order = 4,
			type = "group",
			name = L["wildmushroom"],
			get = function(info) return E.db.euiscript[ info[#info] ] end,
			set = function(info, value) E.db.euiscript[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,
			args = {
				wildmushroom = {
					order = 1,
					type = "toggle",
					name = L["wildmushroom"],
					desc = L["wildmushroom_desc"],
				},
				wildmushroom_width = {
					order = 2,
					type = "range",
					name = L["wildmushroom_width"],
					min = 10, max = 200, step = 1,
				},
				wildmushroom_height = {
					order = 3,
					type = "range",
					name = L["wildmushroom_height"],
					min = 1, max = 100, step = 1,
				},
				wildmushroom_direction = {
					order = 4,
					type = "select",
					name = L["wildmushroom_direction"],
					values = {
						["up"] = L["up"],
						["down"] = L["down"],
					},
				},
			},
		},
	},
}

E.Options.args.chatfilter = {
	type = "group",
	name = L["chatfilter"],
	get = function(info) return E.db.chatfilter[ info[#info] ] end,
	set = function(info, value) E.db.chatfilter[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,
	args = {
		Enabled = {
			order = 0,
			type = "toggle",
			name = L["Enabled"],
		},
		chatfilter_general = {
			order = 1,
			type = "group",
			name = L["General"],
			guiInline = true,
			disabled = function() return not E.db.chatfilter.Enabled end,
			args = {
				ScanOurself = {
					order = 1,
					type = "toggle",
					name = L["Scan ourself"],
				},
				ScanFriend = {
					order = 2,
					type = "toggle",
					name = L["Scan friends"],
				},
				ScanTeam = {
					order = 3,
					type = "toggle",
					name = L["Scan raid/party members"],
				},
				ScanGuild = {
					order = 4,
					type = "toggle",
					name = L["Scan guildies"],
				},
				noprofanityFilter = {
					order = 5,
					type = "toggle",
					name = L["Disable the profanityFilter"],
				},
				nojoinleaveChannel = {
					order = 5,
					type = "toggle",
					name = L["Disable the alert joinleaveChannel"],
				},
				MergeTalentSpec = {
					order = 6,
					type = "toggle",
					name = L["Merge the messages:'You have learned/unlearned...'"],
				},
				FilterPetTalentSpec = {
					order = 7,
					type = "toggle",
					name = L["Filter the messages:'Your pet has learned/unlearned...'"],
				},
				MergeAchievement = {
					order = 8,
					type = "toggle",
					name = L["Merge the messages:'...has earned the achievement...'"],
				},
				MergeManufacturing = {
					order = 9,
					type = "toggle",
					name = L["Merge the messages:'You has created...'"],
				},
				FilterAuctionMSG = {
					order = 10,
					type = "toggle",
					name = L["Filter the messages:'Auction created/cancelled'"],
				},
				FilterDuelMSG = {
					order = 11,
					type = "toggle",
					name = L["Filter the messages:'... has defeated/fled from ... in a duel'"],
				},
				FilterAdvertising = {
					order = 12,
					type = "toggle",
					name = L["Filter the advertising messages"],
				},
				AllowMatchs = {
					order = 13,
					type = "range",
					min = 1, max = 10, step = 1,
					name = L["How many words can be allowd to use"],
				},
				FilterMultiLine = {
					order = 14,
					type = "toggle",
					name = L["Filter the multiple messages"],
				},
				AllowLines = {
					order = 15,
					type = "range",
					min = 1, max = 10, step = 1,
					name = L["How many lines can be allowd"],
				},
				FilterRepeat = {
					order = 16,
					type = "toggle",
					name = L["Filter the repeat messages"],
				},
				RepeatAlike = {
					order = 17,
					type = "range",
					min = 1, max = 100, step = 1,
					name = L["Set the similarity between the messages"],
				},
				RepeatInterval = {
					order = 18,
					type = "range",
					min = 1, max = 300, step = 5,
					name = L["Set the interval between the messages"],
				},
				RepeatMaxCache = {
					order = 19,
					type = "range",
					min = 1, max = 1000, step = 5,
					name = L["Set the max cache from the messages"],
				},
			},
		},
	},
}	