-- stAddonManager
-- Version: v1.0.4-9aef575
-- Author: Safturento
-- Modify by ljxx.net at 20111028

local E, _, DF = unpack(ElvUI)
local LSM = LibStub("LibSharedMedia-3.0")
local S = E:GetModule('Skins')

local function SkinButton(f, strip)
	if f:GetName() then
		local l = _G[f:GetName().."Left"]
		local m = _G[f:GetName().."Middle"]
		local r = _G[f:GetName().."Right"]
		
		
		if l then l:SetAlpha(0) end
		if m then m:SetAlpha(0) end
		if r then r:SetAlpha(0) end
	end

	if f.SetNormalTexture then f:SetNormalTexture("") end
	
--	if f.SetHighlightTexture then f:SetHighlightTexture(C["media"].glossTex) end
	
	if f.SetPushedTexture then f:SetPushedTexture("") end
	
	if f.SetDisabledTexture then f:SetDisabledTexture("") end
	
	if strip then f:StripTextures() end
	
	f:SetTemplate("Default")

end

local L = {}
if GetLocale() == "zhCN" then
	L.title = "插件管理"
	L.search = "搜索"
	L.reloadui = "重载"
elseif GetLocale() == "zhTW" then
	L.title = "插件管理"
	L.search = "搜索"
	L.reloadui = "重載"	
else
	L.title = "stAddonManager"
	L.search = "Search"
	L.reloadui = "ReloadUI"	
end

local function WorldStateAlwaysUpFrame_Update()   
   _G["WorldStateAlwaysUpFrame"]:ClearAllPoints()
   _G["WorldStateAlwaysUpFrame"].ClearAllPoints = E.noop
   _G["WorldStateAlwaysUpFrame"]:SetPoint("TOP", UIParent, "TOP", -40, -70)
   _G["WorldStateAlwaysUpFrame"].SetPoint = E.noop
end

hooksecurefunc("WorldStateAlwaysUpFrame_Update", WorldStateAlwaysUpFrame_Update)
	
------------------------------------------------------
-- INITIAL FRAME CREATION ----------------------------
------------------------------------------------------
stAddonManager = CreateFrame("Frame", "stAddonManager", UIParent)
stAddonManager:SetFrameStrata("HIGH")
stAddonManager.header = CreateFrame("Frame", "stAddonmanager_Header", stAddonManager)

stAddonManager.header:SetPoint("CENTER", UIParent, "CENTER", 0, 50)
stAddonManager:SetPoint("TOP", stAddonManager.header, "TOP", 0, 0)

------------------------------------------------------
-- FUNCTIONS -----------------------------------------
------------------------------------------------------

function stAddonManager:UpdateAddonList(queryString)
	local addons = {}
	for i=1, GetNumAddOns() do
		local name, title, notes, enabled, loadable, reason, security = GetAddOnInfo(i)
		local lwrTitle, lwrName = strlower(title), strlower(name)
		if (queryString and (strfind(lwrTitle,strlower(queryString)) or strfind(lwrName,strlower(queryString)))) or (not queryString) then
			addons[i] = {}
			addons[i].name = name
			addons[i].title = title
			addons[i].notes = notes
			addons[i].enabled = enabled
		end
	end
	return addons
end

local function LoadWindow()
	if not stAddonManager.Loaded then
		local window = stAddonManager
		local header = window.header
		
		tinsert(UISpecialFrames,window:GetName());
		
		window:SetSize(300,300)
		header:SetSize(300,20)

		window:SetTemplate("Transparent")
		
		header:EnableMouse(true)
		header:SetMovable(true)
		header:SetScript("OnMouseDown", function(self) self:StartMoving() end)
		header:SetScript("OnMouseUp", function(self) self:StopMovingOrSizing() end)
		
		header.title = header:CreateFontString(nil, 'OVERLAY')
		header.title:FontTemplate(nil, nil, "THICKOUTLINE")
		header.title:SetPoint("CENTER", 0, -2)
		header.title:SetText(L.title)

		local close = CreateFrame("Button", nil, header)
		close:SetPoint("RIGHT", header, "RIGHT", 0, 0)
		close:SetFrameLevel(header:GetFrameLevel()+2)
		close:SetSize(20, 20)
		close:SetScript("OnEnter", function(self) self.text:SetTextColor(0/255, 170/255, 255/255) end)
		close:SetScript("OnLeave", function(self) self.text:SetTextColor(255/255, 255/255, 255/255) end)		
		close:SetScript("OnClick", function() window:Hide() end)
		header.close = close
		S:HandleCloseButton(close)
		
		addonListBG = CreateFrame("Frame", window:GetName().."_ScrollBackground", window)
		addonListBG:SetPoint("TOPLEFT", header, "TOPLEFT", 10, -50)
		addonListBG:SetWidth(window:GetWidth()-20)
		addonListBG:SetHeight(window:GetHeight()-60)
		addonListBG:SetTemplate("Transparent")
		
		--Create scroll frame (God damn these things are a pain)
		local scrollFrame = CreateFrame("ScrollFrame", window:GetName().."_ScrollFrame", window, "UIPanelScrollFrameTemplate")
		scrollFrame:SetPoint("TOPLEFT", addonListBG, "TOPLEFT", 0, -2)
		scrollFrame:SetWidth(addonListBG:GetWidth()-25)
		scrollFrame:SetHeight(addonListBG:GetHeight()-5)
		S:HandleScrollBar(_G[window:GetName().."_ScrollFrameScrollBar"])
		scrollFrame:SetFrameLevel(window:GetFrameLevel()+1)
		
		scrollFrame.Anchor = CreateFrame("Frame", window:GetName().."_ScrollAnchor", scrollFrame)
		scrollFrame.Anchor:SetPoint("TOPLEFT", scrollFrame, "TOPLEFT", 0, -3)
		scrollFrame.Anchor:SetWidth(window:GetWidth()-40)
		scrollFrame.Anchor:SetHeight(scrollFrame:GetHeight())
		scrollFrame.Anchor:SetFrameLevel(scrollFrame:GetFrameLevel()+1)
		scrollFrame:SetScrollChild(scrollFrame.Anchor)
	
		--Load up addon information
		stAddonManager.AllAddons = stAddonManager:UpdateAddonList()
		stAddonManager.FilteredAddons = stAddonManager:UpdateAddonList()
		stAddonManager.showEnabled = true
		stAddonManager.showDisabled = true
		
		stAddonManager.Buttons = {}
		
		--Create initial list
		for i, addon in pairs(stAddonManager.AllAddons) do
			local button = CreateFrame("Frame", nil, scrollFrame.Anchor)
			button:SetFrameLevel(scrollFrame.Anchor:GetFrameLevel() + 1)
			button:SetSize(16, 16)
			SkinButton(button)
			if addon.enabled then
				button:SetBackdropColor(0/255, 170/255, 255/255)
			end
			
			if i == 1 then
				button:SetPoint("TOPLEFT", scrollFrame.Anchor, "TOPLEFT", 5, -5)
			else
				button:SetPoint("TOP", stAddonManager.Buttons[i-1], "BOTTOM", 0, -5)
			end
			button.text = button:CreateFontString(nil, 'OVERLAY')
			button.text:FontTemplate(nil, nil, "THINOUTLINE")
			button.text:SetJustifyH("LEFT")
			button.text:SetPoint("LEFT", button, "RIGHT", 8, 0)
			button.text:SetPoint("RIGHT", scrollFrame.Anchor, "RIGHT", 0, 0)
			button.text:SetText(addon.title)
			
			button:SetScript("OnEnter", function(self)
				--tooltip stuff
			end)
			
			button:SetScript("OnMouseDown", function(self)
				if addon.enabled then
					self:SetBackdropColor(unpack(E["media"].backdropfadecolor))
					DisableAddOn(addon.name)
					addon.enabled = false
				else
					self:SetBackdropColor(0/255, 170/255, 255/255)
					EnableAddOn(addon.name)
					addon.enabled = true
				end
			end)
			
			stAddonManager.Buttons[i] = button
		end
		
		local function UpdateList(AddonsTable)
			--Start off by hiding all of the buttons
			for _, b in pairs(stAddonManager.Buttons) do b:Hide() end
			
			local bIndex = 1
			for i, addon in pairs(AddonsTable) do
				local button = stAddonManager.Buttons[bIndex]
				button:Show()
				if addon.enabled then
					button:SetBackdropColor(0/255, 170/255, 255/255)
				else
					button:SetBackdropColor(unpack(E["media"].backdropfadecolor))
				end
				
				button:SetScript("OnMouseDown", function(self)
					if addon.enabled then
						self:SetBackdropColor(unpack(E["media"].backdropfadecolor))
						DisableAddOn(addon.name)
						addon.enabled = false
					else
						self:SetBackdropColor(0/255, 170/255, 255/255)
						EnableAddOn(addon.name)
						addon.enabled = true
					end
				end)
				
				button.text:SetText(addon.title)
				bIndex = bIndex+1
			end
		end
		
		--Search Bar
		local searchBar = CreateFrame("EditBox", window:GetName().."_SearchBar", window)
		searchBar:SetFrameLevel(window:GetFrameLevel()+1)
		searchBar:SetPoint("TOPLEFT", header, "BOTTOMLEFT", 12, -7)
		searchBar:SetWidth(196)
		searchBar:SetHeight(16)
		S:HandleEditBox(searchBar)
		searchBar:SetFont(LSM:Fetch("font", E.db["core"].font), E.db.core.fontsize, "THINOUTLINE")
		searchBar:SetText(L.search)
		searchBar:SetAutoFocus(false)
		searchBar:SetTextInsets(3, 0, 0 ,0)
		searchBar:SetScript("OnEnterPressed", function(self) self:ClearFocus() end)
		searchBar:SetScript("OnEscapePressed", function(self) searchBar:SetText(L.search) UpdateList(stAddonManager.AllAddons) searchBar:ClearFocus() end)
		searchBar:SetScript("OnEditFocusGained", function(self) self:HighlightText() end)
		searchBar:SetScript("OnTextChanged", function(self, input)
			if input then
				stAddonManager.FilteredAddons = stAddonManager:UpdateAddonList(self:GetText())
				UpdateList(stAddonManager.FilteredAddons)
			end
		end)
		
		local sbClear = CreateFrame("Button", nil, searchBar)
		sbClear:SetPoint("RIGHT", searchBar, "RIGHT", 0, 0)
		sbClear:SetFrameLevel(searchBar:GetFrameLevel()+2)
		sbClear:SetSize(20, 20)
		sbClear:SetScript("OnEnter", function(self) self.text:SetTextColor(0/255, 170/255, 255/255) end)
		sbClear:SetScript("OnLeave", function(self) self.text:SetTextColor(255/255, 255/255, 255/255) end)
		sbClear:SetScript("OnClick", function(self) searchBar:SetText(L.search) UpdateList(stAddonManager.AllAddons) searchBar:ClearFocus() end)
		searchBar.clear = sbClear
		S:HandleCloseButton(sbClear)

		local reloadButton = CreateFrame("Button", window:GetName().."_ReloadUIButton", window)
		reloadButton:SetPoint("LEFT", searchBar, "RIGHT", 5, 0)
		reloadButton:SetWidth(window:GetWidth()-27-searchBar:GetWidth())
		reloadButton:SetHeight(20)
		reloadButton.text = reloadButton:CreateFontString(nil, 'OVERLAY')
		reloadButton.text:FontTemplate(nil, nil, "THINOUTLINE")
		reloadButton.text:SetPoint("CENTER")
		reloadButton.text:SetText(L.reloadui)
		reloadButton:SetScript("OnEnter", function(self) self.text:SetTextColor(0/255, 170/255, 255/255) end)
		reloadButton:SetScript("OnLeave", function(self) self.text:SetTextColor(255/255, 255/255, 255/255) end)
		reloadButton:SetScript("OnClick", function(self)
			if InCombatLockdown() then return end
			ReloadUI()
		end)
		S:HandleButton(reloadButton)
		
		stAddonManager.Loaded = true
	else
		stAddonManager:Show()
	end
end

SLASH_STADDONMANAGER1, SLASH_STADDONMANAGER2, SLASH_STADDONMANAGER3 = "/staddonmanager", "/stam", "/staddon"
SlashCmdList["STADDONMANAGER"] = LoadWindow

local gmbAddOns = CreateFrame("Button", "GameMenuButtonAddOns", GameMenuFrame, "GameMenuButtonTemplate")
gmbAddOns:SetSize(GameMenuButtonMacros:GetWidth(), GameMenuButtonMacros:GetHeight())
GameMenuFrame:SetHeight(GameMenuFrame:GetHeight()+GameMenuButtonMacros:GetHeight());
GameMenuButtonLogout:SetPoint("TOP", gmbAddOns, "BOTTOM", 0, -1)
gmbAddOns:SetPoint("TOP", GameMenuButtonMacros, "BOTTOM", 0, -1)
gmbAddOns:SetText(L.title)
gmbAddOns:SetScript("OnClick", function()
	HideUIPanel(GameMenuFrame);
	LoadWindow()
end)
S:HandleButton(gmbAddOns)