-- Part of ReforgeLite by d07.RiV (Iroared)
-- All rights reserved

local L = {}
local gameLocale = GetLocale()
if gameLocale == "enGB" then
  gameLocale = "enUS"
end
local L_enUS = {}
L_enUS["SpiritLong"] = "Spirit"
L_enUS["DodgeLong"] = "Dodge"
L_enUS["ParryLong"] = "Parry"
L_enUS["HitLong"] = "Hit"
L_enUS["CritLong"] = "Crit"
L_enUS["HasteLong"] = "Haste"
L_enUS["ExpLong"] = "Expertise"
L_enUS["MasteryLong"] = "Mastery"
L_enUS["Compute"] = "Calculate"
L_enUS["2H Weapon"] = "2H Weapon"
L_enUS["Active window color"] = "Active window color"
L_enUS["Add cap"] = "Add cap"
L_enUS["All Stats"] = "All Stats"
L_enUS["At least"] = "At least"
L_enUS["At most"] = "At most"
L_enUS["Bear"] = "Bear"
L_enUS["Best result"] = "Best result"
L_enUS["Block chance"] = "Block chance"
L_enUS["Cancel"] = "Cancel"
L_enUS["Cap value"] = "Cap value"
L_enUS["Cat"] = "Cat"
L_enUS["Clear"] = "Clear"
L_enUS["Click an item to lock it"] = "Click an item to lock it"
L_enUS["Compute"] = "Calculate"
L_enUS["Crit"] = "Crit"
L_enUS["Crit block"] = "Crit block"
L_enUS["CritLong"] = "Crit"
L_enUS["Debug"] = "Debug"
L_enUS["Delete"] = "Delete"
L_enUS["Dodge"] = "Dodge"
L_enUS["Dodge chance"] = "Dodge chance"
L_enUS["DodgeLong"] = "Dodge"
L_enUS["Dual Wielding"] = "Dual Wielding"
L_enUS["Enter pawn string"] = "Enter pawn string"
L_enUS["Enter the preset name"] = "Enter the preset name"
L_enUS["Exp"] = "Exp"
L_enUS["ExpLong"] = "Expertise"
L_enUS["Expertise hard cap"] = "Expertise hard cap"
L_enUS["Expertise soft cap"] = "Expertise soft cap"
L_enUS["Fury secondary hit cap"] = "Fury secondary hit cap"
L_enUS["Haste"] = "Haste"
L_enUS["HasteLong"] = "Haste"
L_enUS["Hit"] = "Hit"
L_enUS["HitLong"] = "Hit"
L_enUS["Import Pawn"] = "Import Pawn"
L_enUS["Inactive window color"] = "Inactive window color"
L_enUS["Item level"] = "Item level"
L_enUS["Manual"] = "Manual"
L_enUS["Mastery"] = "Mastery"
L_enUS["MasteryLong"] = "Mastery"
L_enUS["Melee DW hit cap"] = "Melee DW hit cap"
L_enUS["Melee hit cap"] = "Melee hit cap"
L_enUS["No reforge"] = "No reforge"
L_enUS["None"] = "None"
L_enUS["Only one cap allowed with spirit-to-hit conversion"] = "Only one cap allowed with spirit-to-hit conversion"
L_enUS["Open window when reforging"] = "Open window when reforging"
L_enUS["Other/No flask"] = "Other/No flask"
L_enUS["Other/No food"] = "Other/No food"
L_enUS["Parry"] = "Parry"
L_enUS["Parry chance"] = "Parry chance"
L_enUS["ParryLong"] = "Parry"
L_enUS["Pawn scales"] = "Pawn scales"
L_enUS["Presets"] = "Presets"
L_enUS["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"
L_enUS["Reforging window must be open"] = "Reforging window must be open"
L_enUS["Remove cap"] = "Remove cap"
L_enUS["Reset"] = "Reset"
L_enUS["Restore"] = "Restore"
L_enUS["Result"] = "Result"
L_enUS["Save"] = "Save"
L_enUS["Score"] = "Score"
L_enUS["Settings"] = "Settings"
L_enUS["Show"] = "Show"
L_enUS["Show reforged stats in item tooltips"] = "Show reforged stats in item tooltips"
L_enUS["Single-Minded Fury"] = "Single-Minded Fury"
L_enUS["Speed"] = "Speed"
L_enUS["Spell hit cap"] = "Spell hit cap"
L_enUS["Spirit"] = "Spirit"
L_enUS["Spirit to hit"] = "Spirit to hit"
L_enUS["SpiritLong"] = "Spirit"
L_enUS["Stat weights"] = "Stat weights"
L_enUS["Strength/Agility"] = "Strength/Agility"
L_enUS["Sum"] = "Sum"
L_enUS["Tanking model"] = "Tanking model"
L_enUS["Target level"] = "Target level"
L_enUS["Titan's Grip"] = "Titan's Grip"
L_enUS["Total"] = "Total"
L_enUS["Weight after cap"] = "Weight after cap"


if gameLocale == "frFR" then
  L["2H Weapon"] = "Arme 2M"
  L["Active window color"] = "Couleur de la fenêtre active"
  L["Add cap"] = "Ajouter un plafond"
--   L["All Stats"] = ""
  L["At least"] = "Au moins"
  L["At most"] = "Au plus"
  L["Bear"] = "Ours"
  L["Best result"] = "Meilleur résultat"
  L["Block chance"] = "Chances de bloquer"
  L["Cancel"] = "Annuler"
  L["Cap value"] = "Valeur du plafond"
  L["Cat"] = "Chat"
  L["Clear"] = "Effacer"
  L["Click an item to lock it"] = "Cliquez sur un objet pour le verrouiller"
  L["Compute"] = "Calculer"
  L["Crit"] = "Crit"
  L["Crit block"] = "Blocage crit"
  L["CritLong"] = "Critique"
--   L["Debug"] = ""
  L["Delete"] = "Supprimer"
  L["Dodge"] = "Esqu"
  L["Dodge chance"] = "Chances d'esquiver"
  L["DodgeLong"] = "Esquive"
  L["Dual Wielding"] = "Ambidextrie"
  L["Enter pawn string"] = "Entrez le string de Pawn"
  L["Enter the preset name"] = "Entrez le nom du pré-établis"
  L["Exp"] = "Exp"
  L["ExpLong"] = "Expertise"
  L["Expertise hard cap"] = "Plafond d'expertise (hard)"
  L["Expertise soft cap"] = "Plafond d'expertise (soft)"
  L["Fury secondary hit cap"] = "Plafond secondaire de toucher en Furie"
  L["Haste"] = "Hâte"
  L["HasteLong"] = "Hâte"
  L["Hit"] = "Touch"
  L["HitLong"] = "Toucher"
  L["Import Pawn"] = "Importer Pawn"
  L["Inactive window color"] = "Couleur de la fenêtre inactive"
  L["Item level"] = "Niveau d'objet"
  L["Manual"] = "Manuel"
  L["Mastery"] = "Maît"
  L["MasteryLong"] = "Maîtrise"
  L["Melee DW hit cap"] = "Plafond de toucher en ambi"
  L["Melee hit cap"] = "Plafond de toucher en mêlée"
  L["No reforge"] = "Pas de retouche"
  L["None"] = "Aucun"
  L["Only one cap allowed with spirit-to-hit conversion"] = "Un seul plafond est autorisé avec la conversion esprit-en-toucher"
  L["Open window when reforging"] = "Ouvrir la fenêtre lors de la retouche"
--   L["Other/No flask"] = ""
--   L["Other/No food"] = ""
  L["Parry"] = "Parade"
  L["Parry chance"] = "Chances de parer"
  L["ParryLong"] = "Parade"
--   L["Pawn scales"] = ""
  L["Presets"] = "Pré-établis"
  L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite n'a pas réussi à calculer votre retouche optimale. Essayez d'augmenter la vitesse en déplaçant le curseur de vitesse.\\nMessage d'erreur : %s"
  L["Reforging window must be open"] = "La fenêtre de retouche doit être ouverte"
  L["Remove cap"] = "Enlever ce plafond"
--   L["Reset"] = ""
  L["Restore"] = "Restaurer"
  L["Result"] = "Résultat"
  L["Save"] = "Sauver"
  L["Score"] = "Score "
  L["Settings"] = "Paramètres"
  L["Show"] = "Afficher"
  L["Show reforged stats in item tooltips"] = "Afficher les stats retouchées dans les bulles d'aide des objets"
  L["Single-Minded Fury"] = "Fureur obsessionnelle"
  L["Speed"] = "Vitesse"
  L["Spell hit cap"] = "Plafond de toucher par l'esprit"
  L["Spirit"] = "Esprit"
  L["Spirit to hit"] = "Esprit en toucher"
  L["SpiritLong"] = "Esprit"
  L["Stat weights"] = "Pondérations des stats"
--   L["Strength/Agility"] = ""
  L["Sum"] = "Résu"
  L["Tanking model"] = "Modèle de tanking"
  L["Target level"] = "Niveau de la cible"
  L["Titan's Grip"] = "Poigne du Titan"
  L["Total"] = "Total"
  L["Weight after cap"] = "Pondération après plafond"

elseif gameLocale == "deDE" then
  L["2H Weapon"] = "2H-Waffe"
  L["Active window color"] = "Aktive Fensterfarbe"
  L["Add cap"] = "Neues Cap"
--   L["All Stats"] = ""
  L["At least"] = "mindestens"
  L["At most"] = "Maximal"
  L["Bear"] = "Bär"
  L["Best result"] = "Bestes Resultat"
  L["Block chance"] = "Blocken"
  L["Cancel"] = "Abbrechen"
  L["Cap value"] = "Capwert tooltip" -- Needs review
  L["Cat"] = "Katze"
  L["Clear"] = "Löschen"
  L["Click an item to lock it"] = "Klicken um einen Gegenstand zu sperren" -- Needs review
  L["Compute"] = "Berechnen"
  L["Crit"] = "Crit"
  L["Crit block"] = "Kritischer Block"
  L["CritLong"] = "Kritische Trefferwertung"
--   L["Debug"] = ""
  L["Delete"] = "Löschen"
  L["Dodge"] = "Ausweichen"
  L["Dodge chance"] = "Ausweichchance"
  L["DodgeLong"] = "Ausweichen"
--   L["Dual Wielding"] = ""
--   L["Enter pawn string"] = ""
--   L["Enter the preset name"] = ""
  L["Exp"] = "Waffenkunde"
  L["ExpLong"] = "Waffenkunde"
  L["Expertise hard cap"] = "Waffenkunde Hardcap"
  L["Expertise soft cap"] = "Waffenkunde Softcap"
  L["Fury secondary hit cap"] = "Zweite Trefferwertungsschwelle für Furor Krieger (10%)"
  L["Haste"] = "Tempo"
  L["HasteLong"] = "Tempowertung"
  L["Hit"] = "Hit"
  L["HitLong"] = "Trefferwertung"
  L["Import Pawn"] = "Pawn importieren"
  L["Inactive window color"] = "inaktive Fensterfarbe"
  L["Item level"] = "Gegenstandsstufe"
  L["Manual"] = "Manuell das Cap einstellen"
  L["Mastery"] = "Meisterschaft"
  L["MasteryLong"] = "Meisterschaft"
  L["Melee DW hit cap"] = "Nahkampf mit zwei Einhandwaffen Treffercap"
  L["Melee hit cap"] = "Nahkampf Hit Cap einstellen"
  L["No reforge"] = "Kein Umschieden"
  L["None"] = "Nichts"
--   L["Only one cap allowed with spirit-to-hit conversion"] = ""
  L["Open window when reforging"] = "Fenster öffnen zum Umschmieden"
--   L["Other/No flask"] = ""
--   L["Other/No food"] = ""
  L["Parry"] = "Parieren"
  L["Parry chance"] = "Parrierchance"
  L["ParryLong"] = "Parieren"
--   L["Pawn scales"] = ""
--   L["Presets"] = ""
  L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite konnte dein optimales Umschmieden nicht berechnen. Versuche es erneut nachdem du den Geschwindigkeitswert mit dem Regler erhöht hast." -- Needs review
  L["Reforging window must be open"] = "Umschmieden Fenster muss geöffnet sein"
  L["Remove cap"] = "Entferne Cap"
--   L["Reset"] = ""
  L["Restore"] = "Wiederherstellen"
  L["Result"] = "Resultat"
  L["Save"] = "Speichern"
  L["Score"] = "Punkte"
  L["Settings"] = "Einstellungen"
  L["Show"] = "(an)zeigen"
  L["Show reforged stats in item tooltips"] = "Zeige umgeschmiedete Werte im Gegenstandstooltip"
  L["Single-Minded Fury"] = "Einhandwaffen Furor"
  L["Speed"] = "Geschwindigkeit"
  L["Spell hit cap"] = "Zaubertrefferwertungscap"
  L["Spirit"] = "Wille"
  L["Spirit to hit"] = "Willenskraft in Trefferwertung"
  L["SpiritLong"] = "Willenskraft"
  L["Stat weights"] = "Gewichtung"
--   L["Strength/Agility"] = ""
  L["Sum"] = "Summe"
--   L["Tanking model"] = ""
  L["Target level"] = "Ziel Level"
  L["Titan's Grip"] = "Titanengriff"
  L["Total"] = "Gesamt"
  L["Weight after cap"] = "Gewichtung über Cap"

elseif gameLocale == "koKR" then
  L["2H Weapon"] = "양손 무기" -- Needs review
  L["Active window color"] = "활성화된 창 색상" -- Needs review
  L["Add cap"] = "조건 추가" -- Needs review
--   L["All Stats"] = ""
  L["At least"] = "최소" -- Needs review
  L["At most"] = "최대" -- Needs review
  L["Bear"] = "곰" -- Needs review
  L["Best result"] = "최고 결과" -- Needs review
  L["Block chance"] = "방패 막기 확률" -- Needs review
  L["Cancel"] = "취소" -- Needs review
  L["Cap value"] = "조건 값" -- Needs review
  L["Cat"] = "살쾡이" -- Needs review
  L["Clear"] = "초기화" -- Needs review
  L["Click an item to lock it"] = "재연마하지 않을 아이템은 클릭하세요" -- Needs review
  L["Compute"] = "계산" -- Needs review
  L["Crit"] = "치명" -- Needs review
  L["Crit block"] = "결정적 방어" -- Needs review
  L["CritLong"] = "치명타" -- Needs review
  L["Debug"] = "디버그" -- Needs review
  L["Delete"] = "삭제" -- Needs review
  L["Dodge"] = "회피" -- Needs review
  L["Dodge chance"] = "회피율" -- Needs review
  L["DodgeLong"] = "회피 숙련도" -- Needs review
  L["Dual Wielding"] = "쌍수 무기" -- Needs review
  L["Enter pawn string"] = "Pawn 문자열을 입력하세요" -- Needs review
  L["Enter the preset name"] = "프리셋 이름을 입력하세요" -- Needs review
  L["Exp"] = "숙련" -- Needs review
  L["ExpLong"] = "숙련도" -- Needs review
  L["Expertise hard cap"] = "숙련 하드 캡" -- Needs review
  L["Expertise soft cap"] = "숙련 소프트 캡" -- Needs review
  L["Fury secondary hit cap"] = "분노 보조 만적중" -- Needs review
  L["Haste"] = "가속" -- Needs review
  L["HasteLong"] = "가속도" -- Needs review
  L["Hit"] = "적중" -- Needs review
  L["HitLong"] = "적중도" -- Needs review
  L["Import Pawn"] = "Pawn 가져오기" -- Needs review
  L["Inactive window color"] = "비활성화된 창 색상" -- Needs review
  L["Item level"] = "아이템 레벨" -- Needs review
  L["Manual"] = "직접 입력" -- Needs review
  L["Mastery"] = "특화" -- Needs review
  L["MasteryLong"] = "특화도" -- Needs review
  L["Melee DW hit cap"] = "쌍수 만적중" -- Needs review
  L["Melee hit cap"] = "근접 만적중" -- Needs review
  L["No reforge"] = "재연마 하지 않음" -- Needs review
  L["None"] = "없음" -- Needs review
--   L["Only one cap allowed with spirit-to-hit conversion"] = ""
  L["Open window when reforging"] = "재연마 시 창 열기" -- Needs review
--   L["Other/No flask"] = ""
--   L["Other/No food"] = ""
  L["Parry"] = "무막" -- Needs review
  L["Parry chance"] = "무기 막기 확률" -- Needs review
  L["ParryLong"] = "무기 막기 숙련도" -- Needs review
--   L["Pawn scales"] = ""
  L["Presets"] = "프리셋" -- Needs review
  L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite가 최적 재연마 결과를 계산에 실패했습니다. 속도 막대를 움직여 속도를 높여보세요.\\n오류 메시지: %s" -- Needs review
  L["Reforging window must be open"] = "재연마 창이 열려 있어야 합니다" -- Needs review
  L["Remove cap"] = "조건 삭제" -- Needs review
  L["Reset"] = "리셋" -- Needs review
  L["Restore"] = "복원" -- Needs review
  L["Result"] = "결과" -- Needs review
  L["Save"] = "저장" -- Needs review
  L["Score"] = "점수" -- Needs review
  L["Settings"] = "설정" -- Needs review
  L["Show"] = "보기" -- Needs review
  L["Show reforged stats in item tooltips"] = "아이템 툴팁에 재연마된 능력치 표시" -- Needs review
  L["Single-Minded Fury"] = "하나된 분노" -- Needs review
  L["Speed"] = "속도" -- Needs review
  L["Spell hit cap"] = "주문 만적중" -- Needs review
  L["Spirit"] = "정신" -- Needs review
  L["Spirit to hit"] = "정신력으로 인한 적중도" -- Needs review
  L["SpiritLong"] = "정신력" -- Needs review
  L["Stat weights"] = "스탯 가중치" -- Needs review
  L["Strength/Agility"] = "힘/민첩" -- Needs review
  L["Sum"] = "합계" -- Needs review
  L["Tanking model"] = "탱킹 모델" -- Needs review
  L["Target level"] = "대상과의 레벨 차이" -- Needs review
  L["Titan's Grip"] = "티탄의 손아귀" -- Needs review
  L["Total"] = "합계" -- Needs review
  L["Weight after cap"] = "조건 값 이후 가중치" -- Needs review

elseif gameLocale == "esMX" then
--   L["2H Weapon"] = ""
--   L["Active window color"] = ""
  L["Add cap"] = "Añadir cap" -- Needs review
--   L["All Stats"] = ""
  L["At least"] = "Al menos" -- Needs review
  L["At most"] = "Como máximo" -- Needs review
--   L["Bear"] = ""
  L["Best result"] = "Mejor resultado" -- Needs review
--   L["Block chance"] = ""
  L["Cancel"] = "Cancelar" -- Needs review
  L["Cap value"] = "Valor del cap" -- Needs review
--   L["Cat"] = ""
  L["Clear"] = "Despejar" -- Needs review
--   L["Click an item to lock it"] = ""
  L["Compute"] = "Calcular" -- Needs review
  L["Crit"] = "Crit" -- Needs review
--   L["Crit block"] = ""
  L["CritLong"] = "Crit" -- Needs review
--   L["Debug"] = ""
--   L["Delete"] = ""
  L["Dodge"] = "Esquivar" -- Needs review
--   L["Dodge chance"] = ""
  L["DodgeLong"] = "Esquivar" -- Needs review
--   L["Dual Wielding"] = ""
--   L["Enter pawn string"] = ""
--   L["Enter the preset name"] = ""
  L["Exp"] = "Pericia" -- Needs review
  L["ExpLong"] = "Pericia" -- Needs review
--   L["Expertise hard cap"] = ""
--   L["Expertise soft cap"] = ""
--   L["Fury secondary hit cap"] = ""
  L["Haste"] = "Celeridad" -- Needs review
  L["HasteLong"] = "Celeridad" -- Needs review
  L["Hit"] = "Golpe" -- Needs review
  L["HitLong"] = "Golpe" -- Needs review
--   L["Import Pawn"] = ""
--   L["Inactive window color"] = ""
--   L["Item level"] = ""
  L["Manual"] = "Manual" -- Needs review
  L["Mastery"] = "Maestría" -- Needs review
  L["MasteryLong"] = "Maestria" -- Needs review
--   L["Melee DW hit cap"] = ""
  L["Melee hit cap"] = "Cap de golpe cuerpo a cuepo" -- Needs review
  L["No reforge"] = "No reforjar" -- Needs review
  L["None"] = "Nada" -- Needs review
--   L["Only one cap allowed with spirit-to-hit conversion"] = ""
--   L["Open window when reforging"] = ""
--   L["Other/No flask"] = ""
--   L["Other/No food"] = ""
  L["Parry"] = "Parada" -- Needs review
--   L["Parry chance"] = ""
  L["ParryLong"] = "Parada" -- Needs review
--   L["Pawn scales"] = ""
--   L["Presets"] = ""
--   L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = ""
  L["Reforging window must be open"] = "La ventana de Reforjar tiene que estar abierta" -- Needs review
  L["Remove cap"] = "Remover cap" -- Needs review
--   L["Reset"] = ""
  L["Restore"] = "Restaurar" -- Needs review
  L["Result"] = "Resultado" -- Needs review
--   L["Save"] = ""
  L["Score"] = "Puntuacion" -- Needs review
--   L["Settings"] = ""
  L["Show"] = "Enseñar" -- Needs review
--   L["Show reforged stats in item tooltips"] = ""
--   L["Single-Minded Fury"] = ""
  L["Speed"] = "Velocidad" -- Needs review
  L["Spell hit cap"] = "Cap de golpe de hechizos" -- Needs review
  L["Spirit"] = "Espíritu" -- Needs review
  L["Spirit to hit"] = "Espíritu a Golpe" -- Needs review
  L["SpiritLong"] = "Espiritu" -- Needs review
  L["Stat weights"] = "Peso de Atributos" -- Needs review
--   L["Strength/Agility"] = ""
  L["Sum"] = "Sum" -- Needs review
--   L["Tanking model"] = ""
--   L["Target level"] = ""
--   L["Titan's Grip"] = ""
--   L["Total"] = ""
  L["Weight after cap"] = "Valor después del cap" -- Needs review

elseif gameLocale == "ruRU" then
  L["2H Weapon"] = "Двуручное оружие"
  L["Active window color"] = "Цвет активного окна"
  L["Add cap"] = "Добавить пороговое значение"
  L["All Stats"] = "Все характеристики"
  L["At least"] = "Не ниже"
  L["At most"] = "Не выше"
  L["Bear"] = "Медведь"
  L["Best result"] = "Лучший результат"
  L["Block chance"] = "Шанс блока"
  L["Cancel"] = "Отмена"
  L["Cap value"] = "Пороговое значение"
  L["Cat"] = "Кот"
  L["Clear"] = "Очистить"
  L["Click an item to lock it"] = "Нажмите на предмет, чтобы его заблокировать"
  L["Compute"] = "Посчитать"
  L["Crit"] = "Крит"
  L["Crit block"] = "Крит блок"
  L["CritLong"] = "Крит"
  L["Debug"] = "Отладка"
  L["Delete"] = "Удалить"
  L["Dodge"] = "Уклон"
  L["Dodge chance"] = "Шанс уклонения"
  L["DodgeLong"] = "Уклонение"
  L["Dual Wielding"] = "Одноручные оружия"
  L["Enter pawn string"] = "Введите строку Pawn"
  L["Enter the preset name"] = "Введите имя шаблона"
  L["Exp"] = "Маст"
  L["ExpLong"] = "Мастерство"
  L["Expertise hard cap"] = "Мастерство (парирование)"
  L["Expertise soft cap"] = "Мастерство (уклонение)"
  L["Fury secondary hit cap"] = "Меткость - Неистовство"
  L["Haste"] = "Скор"
  L["HasteLong"] = "Скорость"
  L["Hit"] = "Метк"
  L["HitLong"] = "Меткость"
  L["Import Pawn"] = "Импорт Pawn"
  L["Inactive window color"] = "Цвет неактивного окна"
  L["Item level"] = "Уровень предметов"
  L["Manual"] = "Вручную"
  L["Mastery"] = "Искус"
  L["MasteryLong"] = "Искусность"
  L["Melee DW hit cap"] = "Ближний бой, 2 оружия - меткость"
  L["Melee hit cap"] = "Ближний бой - меткость"
  L["No reforge"] = "Без перековки"
  L["None"] = "Нет"
  L["Only one cap allowed with spirit-to-hit conversion"] = "При преобразовании духа в меткость можно использовать только одно пороговое значение."
  L["Open window when reforging"] = "Открыть окно при перековке"
  L["Other/No flask"] = "Другое/нет настоя"
  L["Other/No food"] = "Другое/нет еды"
  L["Parry"] = "Пар"
  L["Parry chance"] = "Шанс парирования"
  L["ParryLong"] = "Парирование"
  L["Pawn scales"] = "Веса Pawn"
  L["Presets"] = "Шаблоны"
  L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite не смог посчитать оптимальную перековку. Попробуйте увеличить скорость.\\nОшибка: %s"
  L["Reforging window must be open"] = "Необходимо открыть окно перековки"
  L["Remove cap"] = "Удалить пороговое значение"
  L["Reset"] = "Сброс"
  L["Restore"] = "Восстановить"
  L["Result"] = "Результат"
  L["Save"] = "Сохранить"
  L["Score"] = "Вес"
  L["Settings"] = "Настройки"
  L["Show"] = "Показать"
  L["Show reforged stats in item tooltips"] = "Показывать перекованные статы в подсказках"
  L["Single-Minded Fury"] = "Единство намерений"
  L["Speed"] = "Скорость"
  L["Spell hit cap"] = "Заклинания - меткость"
  L["Spirit"] = "Дух"
  L["Spirit to hit"] = "Дух в меткость"
  L["SpiritLong"] = "Дух"
  L["Stat weights"] = "Веса"
  L["Strength/Agility"] = "Сила/ловкость"
  L["Sum"] = "Сум"
  L["Tanking model"] = "Режим танка"
  L["Target level"] = "Уровень цели"
  L["Titan's Grip"] = "Хватка титана"
  L["Total"] = "Сумма"
  L["Weight after cap"] = "Вес после порога"

elseif gameLocale == "zhCN" then
  L["2H Weapon"] = "双手武器"
  L["Active window color"] = "激活窗口的颜色"
  L["Add cap"] = "添加上限"
--   L["All Stats"] = ""
  L["At least"] = "至少"
  L["At most"] = "最多"
  L["Bear"] = "熊"
  L["Best result"] = "最佳成果"
  L["Block chance"] = "格挡机率"
  L["Cancel"] = "取消"
  L["Cap value"] = "上限值"
  L["Cat"] = "猫"
  L["Clear"] = "清除"
  L["Click an item to lock it"] = "点击以锁定该物品"
  L["Compute"] = "计算"
  L["Crit"] = "爆击"
  L["Crit block"] = "精确格挡"
  L["CritLong"] = "爆击等级"
--   L["Debug"] = ""
  L["Delete"] = "删除"
  L["Dodge"] = "躲闪"
  L["Dodge chance"] = "躲闪机率"
  L["DodgeLong"] = "躲闪等级"
  L["Dual Wielding"] = "双持武器"
  L["Enter pawn string"] = "输入Pawn字符"
  L["Enter the preset name"] = "输入预设名称"
  L["Exp"] = "精准"
  L["ExpLong"] = "精准等级"
  L["Expertise hard cap"] = "精准硬上限"
  L["Expertise soft cap"] = "精准软上限"
  L["Fury secondary hit cap"] = "狂战副手命中上限"
  L["Haste"] = "急速"
  L["HasteLong"] = "急速等级"
  L["Hit"] = "命中"
  L["HitLong"] = "命中等级"
  L["Import Pawn"] = "导入Pawn"
  L["Inactive window color"] = "未激活窗口的颜色"
  L["Item level"] = "物品等级"
  L["Manual"] = "手动"
  L["Mastery"] = "精通"
  L["MasteryLong"] = "精通等级"
  L["Melee DW hit cap"] = "双持近战命中上限"
  L["Melee hit cap"] = "近战命中上限"
  L["No reforge"] = "未能重铸"
  L["None"] = "无"
  L["Only one cap allowed with spirit-to-hit conversion"] = "精神转命中只允许一个上限"
  L["Open window when reforging"] = "重铸时打开窗口"
--   L["Other/No flask"] = ""
--   L["Other/No food"] = ""
  L["Parry"] = "招架"
  L["Parry chance"] = "招架机率"
  L["ParryLong"] = "招架等级"
  L["Pawn scales"] = "Pawn尺度"
  L["Presets"] = "预设"
  L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite无法计算你的最优重铸.请尝试调整速度滑块.\\n错误信息: %s"
  L["Reforging window must be open"] = "必须打开重铸窗口"
  L["Remove cap"] = "移除上限"
--   L["Reset"] = ""
  L["Restore"] = "还原"
  L["Result"] = "成果"
  L["Save"] = "保存"
  L["Score"] = "得分"
  L["Settings"] = "设定"
  L["Show"] = "显示结果"
  L["Show reforged stats in item tooltips"] = "在鼠标提示中显示重铸后的属性"
  L["Single-Minded Fury"] = "鲁莽怒火"
  L["Speed"] = "速度"
  L["Spell hit cap"] = "法术命中上限"
  L["Spirit"] = "精神"
  L["Spirit to hit"] = "精神转命中"
  L["SpiritLong"] = "精神"
  L["Stat weights"] = "属性权重"
--   L["Strength/Agility"] = ""
  L["Sum"] = "总计"
  L["Tanking model"] = "坦克模式"
  L["Target level"] = "目标等级"
  L["Titan's Grip"] = "泰坦之握"
  L["Total"] = "总计"
  L["Weight after cap"] = "超过上限后权重"

elseif gameLocale == "esES" then
  L["2H Weapon"] = "2 Manos"
  L["Active window color"] = "Color de ventana activa"
  L["Add cap"] = "Agregar cap"
--   L["All Stats"] = ""
  L["At least"] = "Al menos"
  L["At most"] = "Como maximo"
  L["Bear"] = "Oso"
  L["Best result"] = "Mejor resultado"
  L["Block chance"] = "Block chance" -- Needs review
  L["Cancel"] = "Cancelar"
  L["Cap value"] = "Valor de cap"
  L["Cat"] = "Gato"
  L["Clear"] = "Borrar"
  L["Click an item to lock it"] = "Click an item to lock it" -- Needs review
  L["Compute"] = "Calcular"
  L["Crit"] = "Crit"
  L["Crit block"] = "Crit block" -- Needs review
  L["CritLong"] = "Critico"
--   L["Debug"] = ""
  L["Delete"] = "Borrar"
  L["Dodge"] = "Esqv"
  L["Dodge chance"] = "Dodge chance" -- Needs review
  L["DodgeLong"] = "Esquiva"
  L["Dual Wielding"] = "2 Armas"
  L["Enter pawn string"] = "Introduzca cadena peon"
  L["Enter the preset name"] = "Introduzca el nombre del ajuste"
  L["Exp"] = "Peri"
  L["ExpLong"] = "Pericia"
  L["Expertise hard cap"] = "Cap maximo Pericia"
  L["Expertise soft cap"] = "Cap minimo Pericia"
  L["Fury secondary hit cap"] = "Cap secundario en Furia"
  L["Haste"] = "Cele"
  L["HasteLong"] = "Celeridad"
  L["Hit"] = "Golpe"
  L["HitLong"] = "Probabilidad de Golpe"
  L["Import Pawn"] = "Importar Peon"
  L["Inactive window color"] = "Color de ventana inactiva"
  L["Item level"] = "Item level" -- Needs review
  L["Manual"] = "Manual"
  L["Mastery"] = "Maest"
  L["MasteryLong"] = "Maestria"
  L["Melee DW hit cap"] = "Cap Melee 2 armas"
  L["Melee hit cap"] = "Cap de golpe Melee"
  L["No reforge"] = "Sin reforja"
  L["None"] = "Ninguno"
  L["Only one cap allowed with spirit-to-hit conversion"] = "Solo un Cap permitido cuando se usa conversion Espiritu a Golpe"
  L["Open window when reforging"] = "Abrir ventana cuando reforje"
--   L["Other/No flask"] = ""
--   L["Other/No food"] = ""
  L["Parry"] = "Par"
  L["Parry chance"] = "Parry chance" -- Needs review
  L["ParryLong"] = "Parada"
  L["Pawn scales"] = "Pawn scales" -- Needs review
  L["Presets"] = "Ajustes pre-establecidos"
--   L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = ""
  L["Reforging window must be open"] = "Ventana de reforje tiene que estar abierta"
  L["Remove cap"] = "Quitar cap"
--   L["Reset"] = ""
  L["Restore"] = "Restaurar"
  L["Result"] = "Resultado"
  L["Save"] = "Guardar"
  L["Score"] = "Puntuacion"
  L["Settings"] = "Ajustes"
  L["Show"] = "Mostrar"
--   L["Show reforged stats in item tooltips"] = ""
  L["Single-Minded Fury"] = "Furia un solo proposito"
  L["Speed"] = "Velocidad"
  L["Spell hit cap"] = "Cap de golpe con hechizos"
  L["Spirit"] = "Espr"
  L["Spirit to hit"] = "Espiritu a Golpe"
  L["SpiritLong"] = "Espiritu"
  L["Stat weights"] = "Peso de estadisticas"
--   L["Strength/Agility"] = ""
  L["Sum"] = "Tot"
  L["Tanking model"] = "Tanking model" -- Needs review
  L["Target level"] = "Nivel de objetivo"
  L["Titan's Grip"] = "Empuñadura de Titan"
  L["Total"] = "Total" -- Needs review
  L["Weight after cap"] = "Peso despues del cap"

elseif gameLocale == "zhTW" then
  L["2H Weapon"] = "雙手武器"
  L["Active window color"] = "活動窗口的顏色"
  L["Add cap"] = "增加上限"
  L["All Stats"] = [=[所有屬性
+5%所有屬性增益]=] -- Needs review
  L["At least"] = "至少(可超過)" -- Needs review
  L["At most"] = "最多(低於上限)"
  L["Bear"] = "熊"
  L["Best result"] = "最好的結果"
  L["Block chance"] = "格檔機率(%)"
  L["Cancel"] = "取消"
  L["Cap value"] = "上限數值"
  L["Cat"] = "貓"
  L["Clear"] = "清除"
  L["Click an item to lock it"] = "點擊物品鎖定"
  L["Compute"] = "計算"
  L["Crit"] = "致命"
  L["Crit block"] = "致命格檔"
  L["CritLong"] = "致命"
  L["Debug"] = "偵錯"
  L["Delete"] = "刪除"
  L["Dodge"] = "閃躲"
  L["Dodge chance"] = "閃躲機率(%)"
  L["DodgeLong"] = "閃躲"
  L["Dual Wielding"] = "雙持武器"
  L["Enter pawn string"] = "輸入pawn字符"
  L["Enter the preset name"] = "輸入預設的名稱"
  L["Exp"] = "熟練"
  L["ExpLong"] = "熟練"
  L["Expertise hard cap"] = "熟練硬上限"
  L["Expertise soft cap"] = "熟練軟上限"
  L["Fury secondary hit cap"] = "狂戰第二命中上限"
  L["Haste"] = "加速"
  L["HasteLong"] = "加速"
  L["Hit"] = "命中"
  L["HitLong"] = "命中"
  L["Import Pawn"] = "匯入Pawn"
  L["Inactive window color"] = "非活動窗口的顏色"
  L["Item level"] = "物品等級"
  L["Manual"] = "自訂"
  L["Mastery"] = "精通"
  L["MasteryLong"] = "精通"
  L["Melee DW hit cap"] = "進戰雙持命中上限"
  L["Melee hit cap"] = "進戰命中上限"
  L["No reforge"] = "未重鑄"
  L["None"] = "無"
  L["Only one cap allowed with spirit-to-hit conversion"] = "精神到命中的轉換只允許一個上限"
  L["Open window when reforging"] = "當重鑄時開啟視窗"
  L["Other/No flask"] = "其他/無精鍊"
  L["Other/No food"] = "其他/無食物"
  L["Parry"] = "招架"
  L["Parry chance"] = "招架機率(%)"
  L["ParryLong"] = "招架"
  L["Pawn scales"] = "Pawn尺度"
  L["Presets"] = "預設"
  L["ReforgeLite failed to compute your optimal reforge. Try increasing the speed by moving the speed slider.\\nError message: %s"] = "ReforgeLite計算你的最理想重鑄失敗。藉由移動速度條來嘗試提高速度。\\n錯誤訊息：%s"
  L["Reforging window must be open"] = "重鑄視窗必須開啟"
  L["Remove cap"] = "移除上限"
  L["Reset"] = "重置"
  L["Restore"] = "恢復"
  L["Result"] = "結果"
  L["Save"] = "儲存"
  L["Score"] = "分數"
  L["Settings"] = "設定"
  L["Show"] = "顯示"
  L["Show reforged stats in item tooltips"] = "提示上顯示物品重鑄狀態"
  L["Single-Minded Fury"] = "一心狂怒狂戰"
  L["Speed"] = "速度"
  L["Spell hit cap"] = "法術命中上限"
  L["Spirit"] = "精神"
  L["Spirit to hit"] = "精神轉命中"
  L["SpiritLong"] = "精神"
  L["Stat weights"] = "屬性比重"
  L["Strength/Agility"] = [=[力量/敏捷
+力量/敏捷 增益]=] -- Needs review
  L["Sum"] = "總計"
  L["Tanking model"] = "坦克模式"
  L["Target level"] = "目標等級"
  L["Titan's Grip"] = "泰坦之握"
  L["Total"] = "總共"
  L["Weight after cap"] = "超過上限後比重"

end

setmetatable (L_enUS, {__index = function (self, key)
  rawset (self, key, key)
  return key
end})
if gameLocale == "enUS" then
  L = L_enUS
else
  setmetatable (L, {__index = function (self, key)
    rawset (self, key, L_enUS[key])
    return L_enUS[key]
  end})
end

for k, v in pairs (LOCALIZED_CLASS_NAMES_MALE) do
  L[k] = v
end

-- Following borrowed from LibBabble-TalentTree
if gameLocale == "frFR" then
  L["Affliction"] = "Affliction"
  L["Arcane"] = "Arcane"
  L["Arms"] = "Armes"
  L["Assassination"] = "Assassinat"
  L["Balance"] = "Equilibre"
  L["Beast Mastery"] = "Maîtrise des bêtes"
  L["Blood"] = "Sang"
  L["Combat"] = "Combat"
  L["Demonology"] = "Démonologie"
  L["Destruction"] = "Destruction"
  L["Discipline"] = "Discipline"
  L["Elemental"] = "Elémentaire"
  L["Enhancement"] = "Amélioration"
  L["Feral Combat"] = "Combat farouche"
  L["Fire"] = "Feu"
  L["Frost"] = "Givre"
  L["Fury"] = "Fureur"
  L["Holy"] = "Sacré"
  L["Marksmanship"] = "Précision"
  L["Protection"] = "Protection"
  L["Restoration"] = "Restauration"
  L["Retribution"] = "Vindicte"
  L["Shadow"] = "Ombre"
  L["Subtlety"] = "Finesse"
  L["Survival"] = "Survie"
  L["Unholy"] = "Impie"
elseif gameLocale == "deDE" then
  L["Affliction"] = "Gebrechen"
  L["Arcane"] = "Arkan"
  L["Arms"] = "Waffen"
  L["Assassination"] = "Meucheln"
  L["Balance"] = "Gleichgewicht"
  L["Beast Mastery"] = "Tierherrschaft"
  L["Blood"] = "Blut"
  L["Combat"] = "Kampf"
  L["Demonology"] = "Dämonologie"
  L["Destruction"] = "Zerstörung"
  L["Discipline"] = "Disziplin"
  L["Elemental"] = "Elementar"
  L["Enhancement"] = "Verstärkung"
  L["Feral Combat"] = "Wilder Kampf"
  L["Fire"] = "Feuer"
  L["Frost"] = "Frost"
  L["Fury"] = "Furor"
  L["Holy"] = "Heilig"
  L["Marksmanship"] = "Treffsicherheit"
  L["Protection"] = "Schutz"
  L["Restoration"] = "Wiederherstellung"
  L["Retribution"] = "Vergeltung"
  L["Shadow"] = "Schatten"
  L["Subtlety"] = "Täuschung"
  L["Survival"] = "Überleben"
  L["Unholy"] = "Unheilig"
elseif gameLocale == "koKR" then
  L["Affliction"] = "고통"
  L["Arcane"] = "비전"
  L["Arms"] = "무기"
  L["Assassination"] = "암살"
  L["Balance"] = "조화"
  L["Beast Mastery"] = "야수"
  L["Blood"] = "혈기"
  L["Combat"] = "전투"
  L["Demonology"] = "악마"
  L["Destruction"] = "파괴"
  L["Discipline"] = "수양"
  L["Elemental"] = "정기"
  L["Enhancement"] = "고양"
  L["Feral Combat"] = "야성"
  L["Fire"] = "화염"
  L["Frost"] = "냉기"
  L["Fury"] = "분노"
  L["Holy"] = "신성"
  L["Marksmanship"] = "사격"
  L["Protection"] = "방어"
  L["Restoration"] = "복원"
  L["Retribution"] = "징벌"
  L["Shadow"] = "암흑"
  L["Subtlety"] = "잠행"
  L["Survival"] = "생존"
  L["Unholy"] = "부정"
elseif gameLocale == "esMX" then
  L["Affliction"] = "Aflicción"
  L["Arcane"] = "Arcano"
  L["Arms"] = "Armas"
  L["Assassination"] = "Asesinato"
  L["Balance"] = "Balance"
  L["Beast Mastery"] = "Bestias"
  L["Blood"] = "Sangre"
  L["Combat"] = "Combate"
  L["Demonology"] = "Demonología"
  L["Destruction"] = "Destrucción"
  L["Discipline"] = "Disciplina"
  L["Elemental"] = "Elemental"
  L["Enhancement"] = "Mejora"
  L["Feral Combat"] = "Combate feral"
  L["Fire"] = "Fuego"
  L["Frost"] = "Escarcha"
  L["Fury"] = "Furia"
  L["Holy"] = "Sagrado"
  L["Marksmanship"] = "Puntería"
  L["Protection"] = "Protección"
  L["Restoration"] = "Restauración"
  L["Retribution"] = "Reprensión"
  L["Shadow"] = "Sombra"
  L["Subtlety"] = "Sutileza"
  L["Survival"] = "Supervivencia"
  L["Unholy"] = "Profano"
elseif gameLocale == "ruRU" then
  L["Affliction"] = "Колдовство"
  L["Arcane"] = "Тайная магия"
  L["Arms"] = "Оружие"
  L["Assassination"] = "Ликвидация"
  L["Balance"] = "Баланс"
  L["Beast Mastery"] = "Повелитель зверей"
  L["Blood"] = "Кровь"
  L["Combat"] = "Бой"
  L["Demonology"] = "Демонология"
  L["Destruction"] = "Разрушение"
  L["Discipline"] = "Послушание"
  L["Elemental"] = "Стихии"
  L["Enhancement"] = "Совершенствование"
  L["Feral Combat"] = "Сила зверя"
  L["Fire"] = "Огонь"
  L["Frost"] = "Лед"
  L["Fury"] = "Неистовство"
  L["Holy"] = "Свет"
  L["Marksmanship"] = "Стрельба"
  L["Protection"] = "Защита"
  L["Restoration"] = "Исцеление"
  L["Retribution"] = "Воздаяние"
  L["Shadow"] = "Тьма"
  L["Subtlety"] = "Скрытность"
  L["Survival"] = "Выживание"
  L["Unholy"] = "Нечестивость"
elseif gameLocale == "zhCN" then
  L["Affliction"] = "痛苦"
  L["Arcane"] = "奥术"
  L["Arms"] = "武器"
  L["Assassination"] = "刺杀"
  L["Balance"] = "平衡"
  L["Beast Mastery"] = "野兽控制"
  L["Blood"] = "鲜血"
  L["Combat"] = "战斗"
  L["Demonology"] = "恶魔学识"
  L["Destruction"] = "毁灭"
  L["Discipline"] = "戒律"
  L["Elemental"] = "元素战斗"
  L["Enhancement"] = "增强"
  L["Feral Combat"] = "野性战斗"
  L["Fire"] = "火焰"
  L["Frost"] = "冰霜"
  L["Fury"] = "狂怒"
  L["Holy"] = "神圣"
  L["Marksmanship"] = "射击"
  L["Protection"] = "防护"
  L["Restoration"] = "恢复"
  L["Retribution"] = "惩戒"
  L["Shadow"] = "暗影魔法"
  L["Subtlety"] = "敏锐"
  L["Survival"] = "生存技能"
  L["Unholy"] = "邪恶"
elseif gameLocale == "esES" then
  L["Affliction"] = "Aflicción"
  L["Arcane"] = "Arcano"
  L["Arms"] = "Armas"
  L["Assassination"] = "Asesinato"
  L["Balance"] = "Equilibrio"
  L["Beast Mastery"] = "Dominio de bestias"
  L["Blood"] = "Sangre"
  L["Combat"] = "Combate"
  L["Demonology"] = "Demonología"
  L["Destruction"] = "Destrucción"
  L["Discipline"] = "Disciplina"
  L["Elemental"] = "Elemental"
  L["Enhancement"] = "Mejora"
  L["Feral Combat"] = "Combate Feral"
  L["Fire"] = "Fuego"
  L["Frost"] = "Escarcha"
  L["Fury"] = "Furia"
  L["Holy"] = "Sagrado"
  L["Marksmanship"] = "Puntería"
  L["Protection"] = "Protección"
  L["Restoration"] = "Restauración"
  L["Retribution"] = "Reprensión"
  L["Shadow"] = "Sombras"
  L["Subtlety"] = "Sutileza"
  L["Survival"] = "Supervivencia"
  L["Unholy"] = "Profano"
elseif gameLocale == "zhTW" then
  L["Affliction"] = "痛苦"
  L["Arcane"] = "秘法"
  L["Arms"] = "武器"
  L["Assassination"] = "刺殺"
  L["Balance"] = "平衡"
  L["Beast Mastery"] = "野獸控制"
  L["Blood"] = "血魄"
  L["Combat"] = "戰鬥"
  L["Demonology"] = "惡魔學識"
  L["Destruction"] = "毀滅"
  L["Discipline"] = "戒律"
  L["Elemental"] = "元素"
  L["Enhancement"] = "增強"
  L["Feral Combat"] = "野性戰鬥"
  L["Fire"] = "火焰"
  L["Frost"] = "冰霜"
  L["Fury"] = "狂怒"
  L["Holy"] = "神聖"
  L["Marksmanship"] = "射擊"
  L["Protection"] = "防護"
  L["Restoration"] = "恢復"
  L["Retribution"] = "懲戒"
  L["Shadow"] = "暗影"
  L["Subtlety"] = "敏銳"
  L["Survival"] = "生存"
  L["Unholy"] = "穢邪"
end

ReforgeLiteLocale = L
