--[[
Copyright 2009, 2010, 2011 João Cardoso
Callbicas is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Callbicas.

Callbicas is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Callbicas is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Callbicas. If not, see <http://www.gnu.org/licenses/>.
--]]

local lib, old = LibStub:NewLibrary('Callbicas-1.0', 1)
if not lib then
	return
elseif not old then
	lib.methods = {
		'RegisterCallback',
		'FireCallback',
		'GetCallback',
		'IterateCallbacks',
		'UnregisterCallback',
		'UnregisterAllCallbacks',
	}
	lib.table = {}
end

local unpack, pairs, type, next, select = unpack, pairs, type, next, select -- speed up!
local methods, table, registry, index, data = lib.methods , lib.table


--[[ User API ]]--

function lib:Embed(target, name, ...)
	local registry = {}
	
	for i,method in pairs(methods) do
		local custom = select(i, ...)
	
		if custom ~= false then
			target[custom or name and method:gsub('Callback', name) or method] = function(...)
				return lib[method](registry, ...)
			end
		end
	end
end


--[[ Embedded API ]]--

function lib:RegisterCallback(target, event, method, ...)
	self[target] = self[target] or {}
	self[target][event] = {method = method or event, ...}
end

function lib:UnregisterCallback(target, event)
	if self[target] then
		self[target][event] = nil
		
		local i = 0
		for _ in pairs(self[target]) do
			i = i + 1
		end
		if i == 0 then -- can we clean the table?
			self[target] = nil
		end
	end
end

function lib:UnregisterAllCallbacks(target)
	if self[target] then
		for event in pairs(self[target]) do
			self[target][event] = nil
		end
		self[target] = nil
	end
end

function lib:GetCallback(target, event)
	target = self[target]
	if target then
		event = target[event]
		if event then
			return event.method, unpack(event)
		end
	end
end

function lib:IterateCallbacks(target)
	registry = self[target]
	if registry then
		index = nil
		return lib.Iterate
	end
end

function lib:FireCallback(target, event, ...)
	for target, events in pairs(self) do
		local data = events[event]
		if data then
			local method = data.method
		
			if type(method) == 'function' then
				return method(lib.Unpack(data, ...))
			elseif type(target) == 'table' and type(target[method]) == 'function' then
				return target[method](target, lib.Unpack(data, ...))
			end
		end
	end
end


--[[ Internal API ]]--

function lib:Iterate()
	index, data = next(registry, index)
	if index then
		return index, data.method, unpack(data)
	end
end

function lib:Unpack(...)
	if #self == 0 then
		return ...
	elseif not ... then
		return unpack(self)
	else
		wipe(table)
		for i,v in pairs(self) do
			if i ~= 'method' then
				tinsert(table, v)
			end
		end
		for i = 1, select('#', ...) do
			i = select(i, ...)
			tinsert(table, i)
		end
		return unpack(table)
	end
end