--[[
Copyright 2008, 2009, 2010, 2011 João Cardoso
ClassHandler is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of ClassHandler.

ClassHandler is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ClassHandler is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ClassHandler. If not, see <http://www.gnu.org/licenses/>.
--]]

local lib, old = LibStub:NewLibrary('ClassHandler-1.0', 2)
if not lib then
	return
end

LibStub('EmbedHandler-1.0'):Embed(lib)
lib.classes = {}
lib.empty = {}

local error, pairs = error, pairs --speed up!
local empty, classes, class = lib.empty, lib.classes


--[[ API ]]--

function lib:NewClass(id, class)
	class = class or {}
	lib:Embed(class)
	
	classes[self] = classes[self] or {}
	classes[self][id] = class
	return class
end

function lib:GetClass(id, silent)
	class = self and classes[self]
	return class and id and class[id] or not silent and error(format('Cannot find a class instance of %q.', tostring(id)), 2)
end

function lib:IterateClasses()
	return pairs(classes[self] or empty)
end