--[[
Copyright 2009, 2010, 2011 João Cardoso
Sake is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Sake.

Sake is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Sake is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sake. If not, see <http://www.gnu.org/licenses/>.
--]]

LibStub('Sake-1.0'):RegisterLayout('List', 1,
	function(parent, data, children)
		local anchor = data.anchor or parent
	 	local offset = 0
	 	
		for child, data in children do
			local top, bottom, left = data.top or 0, data.bottom or 0, data.left or 0
			local height = (data.height or child:GetHeight()) + bottom + top
		
			child:SetPoint('TOPLEFT', anchor, 'TOPLEFT', left, - offset - top)
			
			offset = offset + height
		end
		return nil, offset
	end
)