--[[
Copyright 2009, 2010, 2011 João Cardoso
Sake is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Sake.

Sake is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Sake is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sake. If not, see <http://www.gnu.org/licenses/>.
--]]

local lib = LibStub:NewLibrary('Sake-1.0', 2)
if not lib then
	return
end

LibStub('EmbedHandler-1.0'):Embed(lib)
lib.childrenOrder = {}
lib.children = {}

lib.layoutVersions = {}
lib.layouts = {}

lib.count = 0
lib.empty = {}
lib.meta = {}
lib.temp = {}

local layouts, layoutVersions = lib.layouts, lib.layoutVersions
local children, childrenOrder = lib.children, lib.childrenOrder
local meta, empty, t, i, child = lib.meta, lib.empty, lib.temp, 0

meta.__call = function(children)
	i = i + 1
	child = t[i]
	if child then
		return child, children[child]
	else
		i = 0
	end
end


--[[ Children ]]--

function lib:RegisterLayoutChild(child, data)
	children[self] = children[self] or setmetatable({}, meta)
	children[self][child] = data or empty
	
	childrenOrder[self] = childrenOrder[self] or {}
	childrenOrder[self][child] = lib.count
	lib.count = lib.count + 1
end

function lib:UnregisterLayoutChild(child)
	if lib.IsLayoutChild(self, child) then
		childrenOrder[self][child] = nil
		children[self][child] = nil
	end
end

function lib:UnregisterLayoutChildren()
	for child in lib.IterateLayoutChildren(self) do
		lib.UnregisterLayoutChild(self, child)
	end
end

function lib:IsLayoutChild(child)
	return children[self] and children[self][child]
end

function lib:IterateLayoutChildren()
	return pairs(children[self] or wipe(t))
end


--[[ Performing ]]--

function lib:PerformLayout(layout, data)
	local children, childrenOrder = children[self], childrenOrder[self]
	
	if children and childrenOrder then
		wipe(t)
		for child, data in lib.IterateLayoutChildren(self) do
			tinsert(t, child)
		end
		
		sort(t, function(A, B)
			if not A then
				return true
			elseif not B or A == B then
				return nil
			end
			
			return childrenOrder[A] <= childrenOrder[B]
		end)
		
		return lib:GetLayout(layout, nil, 3)(self, data or {}, children, #t)
	end
end


--[[ Layouts ]]--

function lib:RegisterLayout(name, version, func)
	local old = layoutVersions[name]
	if not old or version > old then
		layoutVersions[name] = version
		layouts[name] = func
	end
end

function lib:GetLayout(name, silent, off)
	return layouts[name] or not silent and error(format('Cannot find a layout instance of %q.', tostring(name)), off or 2), layoutVersions[name]
end

function lib:IterateLayouts()
	return pairs(layouts)
end