--[[
Copyright 2008, 2009, 2010, 2011 João Cardoso
Sushi is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Sushi.

Sushi is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Sushi is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushi. If not, see <http://www.gnu.org/licenses/>.
--]]

local Sushi = LibStub:NewLibrary('Sushi-2.0', 2)
local Callbicas = LibStub('Callbicas-1.0')
if not Sushi then
	return
end

local function safecall(target, key, ...)
	if type(target[key]) == 'function' then
		return target[key](target, ...)
	end
end


--[[ Classes ]]--

function Sushi:NewWidgetClass(name, data)
	local class = self:GetClass(name, true) or self:NewClass(name, UIFrameCache:New(data.frameType, 'Sushi-2.0_' .. name, UIParent, data.template))
	local new, old = data.version, class.version
	
	if not old or new and new > old then
		for k,v in pairs(data) do
			class[k] = v
		end
		return class, version
	end
end


--[[ Widgets ]]--

function Sushi:CreateWidget(name, parent)
	local class = Sushi:GetClass(name)
	local new = not class.frames[1]
	
	local frame = class:GetFrame()
	frame:SetParent(parent)
	
	if new then
		Callbicas:Embed(frame)
		class:Embed(frame)
		
		frame.Release = Sushi.ReleaseWidget
		safecall(frame, 'OnCreate')
	else
		frame:Show()
	end
	
	safecall(frame, 'OnAcquire')
	return frame
end

function Sushi:ReleaseWidget()
	self.frameCache:ReleaseFrame(self)
	self:UnregisterAllCallbacks()
	self:ClearAllPoints()
	self:SetParent(UIParent)
	self:Hide()
	
	safecall(self, 'OnRelease')
end


--[[ Embedding ]]--

if not old then
	LibStub('ClassHandler-1.0'):Embed(Sushi)
else
	Sushi:UpdateEmbeds()
end