--[[
Copyright 2008, 2009, 2010, 2011 João Cardoso
Sushi is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Sushi List.

Sushi is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Sushi is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushi. If not, see <http://www.gnu.org/licenses/>.
--]]

local Sushi = LibStub('Sushi-2.0')
local Button = Sushi:NewWidgetClass('Button', {
	frameType = 'Button',
	template = 'UIPanelButtonTemplate2',
	insets = {left = 11, right = 11, bottom = 5},
	version = 2,
})

if not Button then
	return
end


--[[ Events ]]--

function Button:OnCreate()
	self:SetScript('OnClick', self.OnClick)
	self:SetScript('OnEnter', self.OnEnter)
	self:SetScript('OnLeave', self.OnLeave)
	self.SetLabel = self.SetText
	self.GetLabel = self.GetText
end

function Button:OnRelease()
	self:SetDescription(nil)
	self:SetDisabled(nil)
	self:SetSmall(nil)
	self:SetText(nil)
end

function Button:OnClick()
	PlaySound('igMainMenuOptionCheckBoxOn')
	self:FireCallback('OnClick')
	self:FireCallback('OnUpdate')
end


--[[ Text ]]--

function Button:SetText(text)
	self:GetFontString():SetText(text)
	self:SetWidth(self:GetTextWidth() + 15)
end

function Button:SetDisabled(disabled)
	if not disabled then
		self:Enable()
	else
		self:Disable()
	end
end

function Button:SetSmall(small)
	if small then
		self:SetHighlightFontObject('GameFontHighlightSmall')
		self:SetDisabledFontObject('GameFontDisableSmall')
		self:SetNormalFontObject('GameFontNormalSmall')
	else
		self:SetHighlightFontObject('GameFontHighlight')
		self:SetDisabledFontObject('GameFontDisable')
		self:SetNormalFontObject('GameFontNormal')
	end
end

function Button:IsSmall(small)
	return self:GetNormalFontObject() == 'GameFontNormalSmall'
end


--[[ Tooltip ]]--

function Button:SetDescription(desc)
	self.desc = desc
end

function Button:GetDescription()
	return self.desc
end

function Button:OnEnter()
	local desc = self:GetDescription()
	if desc then
		GameTooltip:SetOwner(self, 'ANCHOR_RIGHT')
		GameTooltip:SetText(desc, nil, nil, nil, nil, 1)
		GameTooltip:Show()
	end
end

function Button:OnLeave()
	if self:GetDescription() then
		GameTooltip:Hide()
	end
end


--[[ Embedding ]]--

Button:UpdateEmbeds()