--[[
Copyright 2008, 2009, 2010, 2011 João Cardoso
Sushi is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Sushi.

Sushi is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Sushi is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushi. If not, see <http://www.gnu.org/licenses/>.
--]]

local Sushi = LibStub('Sushi-2.0')
local Button = Sushi:GetClass('Button')
local Check, old = Sushi:NewWidgetClass('CheckButton', {
	frameType = 'CheckButton',
	template = 'InterfaceOptionsCheckButtonTemplate',
	insets = {left = 10, right = 20},
	width = 150, height = 34,
	version = 1,
})

if not Check then
	return
end


--[[ Events ]]--

function Check:OnCreate()
	self:SetFontString(_G[self:GetName()..'Text'])
	self.SetValue = self.SetChecked
	self.GetValue = self.GetChecked
	
	Button.OnCreate(self)
end

function Check:OnRelease()
	Button.OnRelease(self)
	self:SetChecked(nil)
end

function Check:OnClick()
	local checked = self:GetChecked()
	if checked then
		PlaySound('igMainMenuOptionCheckBoxOn')
	else
		PlaySound('igMainMenuOptionCheckBoxOff')
	end
	
	self:FireCallback('OnValueChanged', checked)
	self:FireCallback('OnClick', checked)
	self:FireCallback('OnUpdate')
end


--[[ Small ]]--

function Check:SetSmall(small)
	if small then
		self:SetDisabledFontObject('GameFontDisableSmall')
		self:SetNormalFontObject('GameFontHighlightSmall')
	else
		self:SetDisabledFontObject('GameFontDisable')
		self:SetNormalFontObject('GameFontHighlight')
	end
end

function Check:IsSmall()
	return self:GetNormalFontObject() == 'GameFontHighlightSmall'
end


--[[ Embbedding ]]--

if not old then
	Button:Embed(Check, 'OnCreate', 'OnRelease', 'OnClick', 'SetText', 'SetSmall', 'IsSmall')
else
	Check:UpdateEmbeds()
end