--[[
Copyright 2008, 2009, 2010, 2011 João Cardoso
Sushi is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Sushi.

Sushi is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Sushi is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushi. If not, see <http://www.gnu.org/licenses/>.
--]]

local Header = LibStub('Sushi-2.0'):NewWidgetClass('Header', {
	frameType = 'Frame',
	insets = {top = 5, bottom = 3, left = 12, right = 12},
	version = 1,
})

if not Header then
	return
end


--[[ Events ]]--

function Header:OnCreate()
	local Text = self:CreateFontString()
	Text:SetPoint('TOPLEFT')
	Text:SetJustifyH('LEFT')
	
	local Underline = self:CreateTexture()
	Underline:SetPoint('BOTTOMRIGHT')
	Underline:SetPoint('BOTTOMLEFT')
	Underline:SetTexture(1,1,1, .2)
	Underline:SetHeight(1)
	
	self.SetRealWidth = getmetatable(self).__index.SetWidth
	self.SetLabel = self.SetText
	self.GetLabel = self.GetText
	self.Underline = Underline
	self.Text = Text
end

function Header:OnAcquire()
	local parent = self:GetParent()
	self:SetWidth(parent and parent:GetWidth() - 12 or 0)
	self:SetFont('GameFontNormal')
	self:SetUnderlined(nil)
	self:SetText(nil)
end


--[[ Text ]]--

function Header:SetText(text)
	self.Text:SetText(text)
	self:UpdateHeight()
end

function Header:GetText()
	return self.Text:GetText()
end

function Header:SetFont(font)
	self.Text:SetFontObject(font)
	self:UpdateHeight()
end

function Header:GetFont()
	return self.Text:GetFontObject()
end

function Header:SetUnderlined(enable)
	if enable then
		self.Underline:Show()
	else
		self.Underline:Hide()
	end
	self:UpdateHeight()
end

function Header:IsUnderlined()
	return self.Underline:IsShown()
end


--[[ Size ]]--

function Header:SetWidth(width)
	self.Text:SetWidth(width)
	self:SetRealWidth(width)
	self:UpdateHeight()
end

function Header:UpdateHeight()
	self:SetHeight(self.Text:GetHeight() + (self:IsUnderlined() and 3 or 0))
end


--[[ Embedding ]]--

Header:UpdateEmbeds()