local L = Scrap_Locals
local Language = GetLocale()


--[[ English ]]--

L["Add"] = "Add to Junk List"
L["Added"] = "Added to junk list: %s"
L["AdvancedOptions"] = "Advanced Options"
L["AutoSell"] = "Auto Sell"
L["AutoSellDesc"] = "If enabled, Scrap will automatically sell all|nyour junk when you visit a merchant."
L["Junk"] = "Junk"
L["Loading"] = "Loading..."
L["LowConsume"] = "Sell Low Consumables"
L["LowConsumeDesc"] = "If enabled, Scrap will sell |cffff2020any|r consumable which is too low for your level."
L["LowEquip"] = "Sell Low Equipment"
L["LowEquipDesc"] = "If enabled, Scrap will sell |cffff2020any|r soulbound equipment which has a much lower level than the one you are wearing."
L["NotJunk"] = "Not Junk"
L["PanelDescription"] = "These options allow you to configure Scrap even further. The trash shall not pass!"
L["Remove"] = "Remove from Junk List"
L["Removed"] = "Removed from junk list: %s"
L["SafeSell"] = "Safe Mode"
L["SafeSellDesc"] = "If enabled, Scrap won't sell more than 12 items at a time, so that you may buy them back."
L["ScrapList"] = "Scrap List"
L["SellJunk"] = "Sell Junk"
L["ShowTutorials"] = "Show Tutorials"
L["SoldJunk"] = "You sold your junk for %s"
L["ToggleJunk"] = "Add/Remove from Junk List"
L["Tutorial"] = "You are now using |cffffd200Scrap|r, by |cffffd200Jaliborc|r, an addon which sells all your junk when you visit a merchant.|n|n|cffffd200Left Clicking|r on the Scrap button will sell all your junk. |cffffd200Right Clicking|r on the button will bring up extra options."
L["Tutorial2"] = "You can specify which items you want Scrap to sell or not: to add or remove an item from your |cffffd200Junk List|r, drag it from your bags into the Scrap button."


--[[ Português ]]--
if Language == 'ptBR' then
L["Add"] = "Definir como Lixo" 
L["Added"] = "Definido como lixo: %s" 
L["AdvancedOptions"] = "Opções Avançadas" 
L["AutoSell"] = "Vender Automaticamente" 
L["AutoSellDesc"] = "Se activado, Scrap venderá automaticamente todo o seu lixo quando visitar um comerciante." 
L["Junk"] = "Lixo" 
L["Loading"] = "Carregando..." 
L["NotJunk"] = "Útil" 
L["PanelDescription"] = "Estas opções permitem configurar o Scrap ainda mais. O lixo não passará!" 
L["Remove"] = "Definir como Útil" 
L["Removed"] = "Definido como útil: %s" 
L["SafeSell"] = "Modo Seguro" 
L["ScrapList"] = "Lista de Lixo" 
L["SellJunk"] = "Vender Lixo"
L["ShowTutorials"] = "Ver Tutoriais"
L["SoldJunk"] = "Vendeu o seu lixo por %s"


--[[ German ]]--

elseif Language == 'deDE' then
L["Add"] = "Zur Müllliste hinzufügen"
L["Added"] = "Zur Müllliste hinzugefügt: %s"
L["AdvancedOptions"] = "Erweiterte Einstellungen"
L["AutoSell"] = "Automatisch verkaufen"
L["AutoSellDesc"] = "Wenn aktiviert, wird Scrap deinen Müll automaitsch beim Händler verkaufen."
L["Junk"] = "Müll"
L["Loading"] = "Lade..."
L["NotJunk"] = "Kein Müll"
L["Remove"] = "Von der Müllliste entfernen"
L["Removed"] = "Von der Müllliste entfernt: %s"
L["SafeSell"] = "Sicherheitsmodus"
L["SafeSellDesc"] = "Wenn eingeschaltet wird Scrap nicht mehr als 12 Gegenstände verkaufen, damit sie zurückgekauft werden können."
L["SellJunk"] = "Müll verkaufen"
L["ShowTutorials"] = "Zeige Anleitungen"
L["SoldJunk"] = "Du hast deinen Müll für %s verkauft"
L["Tutorial"] = "Du benutzt nun Scrap, ein Addon zum Verkaufen all der Gegenstände, die du nicht brauchst, mit nur einem Klick.|n|n|cffffd200Linksklick|r auf den Scrap-Button verkauft deinen gesamten Müll. |cffffd200Rechtsklick|r öffnet weitere Optionen."
L["Tutorial2"] = "Du kannst einstellen, welche Gegenstände von Scrap verkauft oder auch nicht verkauft werden sollen: Um einen Gegenstand zur |cffffd200Müllliste|r hinzuzufügen oder zu entfernen, zieh es aus deinen Taschen auf den Scrap-Button."


--[[ French ]]--

elseif Language == 'frFR' then
L["Add"] = "Ajouter à la liste de camelote"
L["Added"] = "Ajouté à la liste de camelote: %s"
L["AdvancedOptions"] = "Options avancées"
L["AutoSell"] = "Vente automatique"
L["AutoSellDesc"] = "Si activé, Scrap vendra automatiquement tous votre camelote lors d'une visite chez un marchand."
L["Junk"] = "Camelote"
L["Loading"] = "Chargement..."
L["LowConsume"] = "Vendre les consommables de faible niveau"
L["LowConsumeDesc"] = "Si activé, Scrap vendra |cffff2020tous|r les objets consommables qui sont trop faibles pour votre niveau."
L["LowEquip"] = "Vendre l'équipement de faible niveau"
L["LowEquipDesc"] = "Si activé, Scrap vendra |cffff2020tout|r l'équipement lié ayant un niveau beaucoup plus bas que celui que vous portez."
L["NotJunk"] = "Utile"
L["PanelDescription"] = "Ces options vous permettent de configurer Scrap encore mieux. La camelote ne passera pas !"
L["Remove"] = "Enlever de la liste de camelote"
L["Removed"] = "Enlevé de la liste de camelote: %s"
L["SafeSell"] = "Mode sécurisé"
L["SafeSellDesc"] = "Si activé, Scrap ne vendra pas plus de 12 objets à la fois, de façon à ce que vous puissiez les racheter."
L["ScrapList"] = "Liste d'inutiles"
L["SellJunk"] = "Vendre la camelote"
L["ShowTutorials"] = "Afficher les didacticiels"
L["SoldJunk"] = "Camelote vendu pour %s"
L["Tutorial"] = "Vous utilisez maintenant Scrap, un add-on qui vous permet de vendre tous les objets que vous ne voulez plus en un clic au marchand.|n|n|cffffd200Cliquez gauche|r sur le bouton Scrap vendra tous votre camelote. |cffffd200Cliquez droit|r sur le bouton vous affichera les options supplémentaires."
L["Tutorial2"] = "Vous pouvez spécifier quels objets vous voulez que Scrap vende ou non : pour ajouter ou enlever un objet de votre |cffffd200liste de camelote|r, déplacez l'objet de votre sac vers le bouton Scrap."


--[[ Simplified Chinese ]]--

elseif Language == 'zhCN' then
L["Add"] = "添加到垃圾列表"
L["Added"] = "已添加到垃圾列表: %s"
L["AutoSell"] = "自动出售"
L["AutoSellDesc"] = "开启此功能，Scrap会在你访问商人时自动出售所有垃圾。"
L["Remove"] = "从垃圾列表删除"
L["Removed"] = "已从垃圾列表删除: %s"
L["SellJunk"] = "出售垃圾"
L["ShowTutorials"] = "显示教学"
L["SoldJunk"] = "你出售垃圾共获得 %s"
L["Tutorial"] = "你正在使用Scrap，本插件可以让你在商人处一键出售所有你不需要的物品。|n|n|cffffd200左键单击|rScrap按钮出售所有垃圾。|cffffd200右键单击|rScrap按钮弹出选项。"
L["Tutorial2"] = "你可以自行决定Scrap帮你出售哪些物品: 如要对|cffffd200垃圾列表|r进行添加或删除，只需将物品从你的背包拖拽到Scrap按钮。"


--[[ Traditional Chinese ]]--

elseif Language == 'zhTW' then
L["Add"] = "添加到垃圾清單"
L["Added"] = "已添加到垃圾清單: %s"
L["AutoSell"] = "自動出售"
L["AutoSellDesc"] = "開啟此功能，Scrap會在你訪問商人時自動出售所有垃圾。"
L["Junk"] = "垃圾"
L["Loading"] = "載入中..."
L["NotJunk"] = "非垃圾"
L["Remove"] = "從垃圾清單移除"
L["Removed"] = "已從垃圾清單移除: %s"
L["ScrapList"] = "Scrap清單"
L["SellJunk"] = "出售垃圾"
L["ShowTutorials"] = "顯示教學"
L["SoldJunk"] = "你出售垃圾共獲得 %s"
L["Tutorial"] = "你正在使用Scrap，本組件可讓你在商人處單擊出售所有你不需要的物品。|n|n|cffffd200左鍵點擊|rScrap按鈕出售所有垃圾。|cffffd200右鍵點擊|rScrap按鈕顯示選單。"
L["Tutorial2"] = "你可以自行決定Scrap幫助你出售哪些物品: 如要對|cffffd200垃圾清單|r進行添加或移除，只需將物品從你的背包拖拽到Scrap按鈕。"


--[[ Spanish ]]--

elseif Language == 'esES' or Language == 'esMX' then
L["Add"] = "Añadir a la Lista de Basura"
L["Added"] = "Añadido a la Lista de Basura: %s"
L["AutoSell"] = "Auto Vender"
L["AutoSellDesc"] = "Si está habilitado, Scrap venderá automáticamente toda tu basura cuando visites a un mercader."
L["Junk"] = "Basura"
L["Loading"] = "Cargando..."
L["Remove"] = "Eliminar de la Lista de Basura"
L["Removed"] = "Eliminado de la Lista de Basura: %s"
L["SellJunk"] = "Vender Basura"
L["ShowTutorials"] = "Mostrar Tutoriales"
L["SoldJunk"] = "Has vendido tu basura por %s"
L["Tutorial"] = "Estás usando Scrap, un addon que te permite vender la basura que no necesitas con un simple click cada vez que visitas a un mercader.|n|n|cffffd200Click Izquierdo|r en el Botón Scrap venderá toda tu basura. |cffffd200Click Derecho|r en el botón mostrará opciones extra."
L["Tutorial2"] = "Puedes especificar que objetos quieres vender o no: para añadir o eliminar un objeto de tu |cffffd200Lista de Basura|r, arrástralo desde tus bolsas al Botón Scrap."


--[[ Russian ]]--

elseif Language == 'ruRU' then
L["Add"] = "Добавить в список хлама"
L["Added"] = "Добавлено в список хлама: %s"
L["AdvancedOptions"] = "Расширенные настройки"
L["AutoSell"] = "Авто продажа"
L["AutoSellDesc"] = "Если включено, Scrap автоматически будет продавать хлам когда вы посещаете торговца."
L["Junk"] = "Хлам"
L["Loading"] = "Загрузка..."
L["LowConsume"] = "Продавать низкоуровневые расходуемые товары"
L["LowConsumeDesc"] = "Если включено, Scrap будет продавать |cffff2020все|r низкоуровневые для вас расходуемые товары."
L["LowEquip"] = "Продавать низкоуровневую экипировку"
L["LowEquipDesc"] = "Если включено, Scrap будет продавать |cffff2020всю|r привязанную экипировку, уровень которой намного меньше, чем надетой на вас."
L["NotJunk"] = "Не хлам"
L["PanelDescription"] = "Более тонкая настройка Scrap. Хлам не пройдет!"
L["Remove"] = "Удалить из списка хлама"
L["Removed"] = "Удалено из списка хлама: %s"
L["SafeSell"] = "Безопасный режим"
L["SafeSellDesc"] = "Если включено, Scrap не будет продавать более 12 предметов за раз, тем самым сохраняя возможность выкупа."
L["ScrapList"] = "Список хлама"
L["SellJunk"] = "Продать хлам"
L["ShowTutorials"] = "Показать учебник"
L["SoldJunk"] = "Вы продали хлама на %s"
L["Tutorial"] = "Вы сейчас используете Scrap - дополнение, которое позволяет вам продавать весь ваш имеющийся хлам нажатием одной кнопки!|n|n|cffffd200Левая кнопка мыши|r на кнопке Scrap продаст ваш хлам. |cffffd200Правая кнопка мыши|r откроет вам дополнительные опции."
L["Tutorial2"] = "Вы можете указать, какие предметы вы хотите, чтобы Scrap продавал или нет: для добавления или удаления предмета с вашего |cffffd200Списка хлама|r, перетащите предмет на кнопку Scrap."
end


--[[ Globals ]]--

BINDING_HEADER_SCRAP = 'Scrap'
BINDING_NAME_SCRAP_SELL = L.SellJunk
BINDING_NAME_SCRAP_TOGGLE = L.ToggleJunk