--[[
Copyright 2008, 2009, 2010, 2011 João Libório Cardoso
Scrap is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Scrap.

Scrap is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Scrap is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Scrap. If not, see <http://www.gnu.org/licenses/>.
--]]

local Dropdown = CreateFrame('Frame', 'ScrapDropdown', nil, 'UIDropDownMenuTemplate')
local Tutorials = LibStub('CustomTutorials-2.0')
local L = Scrap_Locals

function Dropdown:Toggle(anchor)
	local info = {
		{
		    text = 'Scrap',
		    notCheckable = 1,
		    isTitle = 1
    	},
   		{
		    text = L.AutoSell,
		    notCheckable = 1,
			hasArrow = 1,
			menuList = {
		    	{
			    	text = ENABLE,
			    	func = function() Scrap_AutoSell = true end,
			    	checked = function() return Scrap_AutoSell end,
			    	tooltipTitle = L.AutoSell,
		    		tooltipText = L.AutoSellDesc,
		   			tooltipOnButton = 1,
		    	},
		    	{
			    	text = DISABLE,
			    	func = function() Scrap_AutoSell = nil end,
			    	checked = function() return not Scrap_AutoSell end,
			    	tooltipTitle = L.AutoSell,
		    		tooltipText = L.AutoSellDesc,
		    		tooltipOnButton = 1,
		    	},
		    }
    	},
    	{
		    text = L.AdvancedOptions,
		    notCheckable = 1,
		    func = function()
		    	InterfaceOptionsFrame_OpenToCategory(ScrapPanel)
		    end,
    	},
    	{
		    text = L.ShowTutorials,
		    notCheckable = 1,
		    func = function()
		    	Tutorials.ResetTutorials('Scrap')
		    	Tutorials.TriggerTutorial('Scrap', 2)
		    end,
    	}
	}

	EasyMenu(info, self, anchor or 'Scrap', 0, 0, 'MENU')
end