--[[
Copyright 2008, 2009, 2010, 2011 João Libório Cardoso
Scrap is distributed under the terms of the GNU General Public License (or the Lesser GPL).
This file is part of Scrap.

Scrap is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Scrap is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Scrap. If not, see <http://www.gnu.org/licenses/>.
--]]

local Panel = LibStub('Sushi-2.0'):CreateWidget('Container')
local HasPawn = IsAddOnLoaded('Pawn_Scrap')
local L = Scrap_Locals


--[[ Main ]]--

function Panel:Startup()
	local Author = self:CreateFontString(nil, nil, 'GameFontDisableSmall')
	Author:SetText('Copyright 2008-2011 João Libório Cardoso')
	Author:SetPoint('BOTTOMRIGHT', -4, 4)

	self:SetParent(ScrapPanel)
	self:SetPoint('BOTTOMRIGHT', -4, 5)
	self:SetPoint('TOPLEFT', 4, -11)
	self:SetSize(0, 0)

	self:SetLayout('List')
	self:SetChildren('Initialize')
	self.Startup = nil
end

function Panel:Initialize()
	self:CreateHeader('Scrap', 'GameFontNormalLarge')
	self:CreateHeader(L.PanelDescription, 'GameFontHighlightSmall').insets = {bottom = 11}
	
	self:Create('CheckButton', 'AutoSell')
	self:Create('CheckButton', 'LowEquip', HasPawn)
	
	local safeSell = self:Create('CheckButton', 'SafeSell', not Scrap_LowEquip and not HasPawn)
	safeSell:RegisterCallback('OnValueChanged', function(v) Scrap_Unsafe = not v end)
	safeSell:SetChecked(not Scrap_Unsafe)
	safeSell.insets = {left = 10}
	
	self:Create('CheckButton', 'LowConsume')
end


--[[ API ]]--

function Panel:CreateHeader(text, font)
	local child = self:CreateChild('Header')
	child:SetText(L[text] or text)
	child:SetFont(font)
	return child
end

function Panel:Create(class, text, disabled)
	local arg = 'Scrap_' .. text
	local child = self:CreateChild(class)
	child:SetDescription(L[text .. 'Desc'])
	child:SetDisabled(disabled)
  child:SetLabel(L[text])
  child:SetValue(_G[arg])
	
	child:RegisterCallback('OnValueChanged', function(v)
		_G[arg] = v
	end)
	return child
end

Panel:Startup()