--[[
Name: LibBabble-DigSites-3.0
Revision: $Rev: 28 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-digsites-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-DigSites-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 28 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	["Abyssal Sands Fossil Ridge"] = "Abyssal Sands Fossil Ridge",
	["Aerie Peak Digsite"] = "Aerie Peak Digsite",
	["Agol'watha Digsite"] = "Agol'watha Digsite",
	["Akhenet Fields Digsite"] = "Akhenet Fields Digsite",
	["Altar of Quetz'lun Digsite"] = "Altar of Quetz'lun Digsite",
	["Altar of Sseratus Digsite"] = "Altar of Sseratus Digsite",
	["Altar of Zul Digsite"] = "Altar of Zul Digsite",
	["Ancestral Grounds Digsite"] = "Ancestral Grounds Digsite",
	["Andorhal Fossil Bank"] = "Andorhal Fossil Bank",
	["Arklon Ruins Digsite"] = "Arklon Ruins Digsite",
	["Bael Modan Digsite"] = "Bael Modan Digsite",
	["Baleheim Digsite"] = "Baleheim Digsite",
	["Balia'mah Digsite"] = "Balia'mah Digsite",
	["Bal'lal Ruins Digsite"] = "Bal'lal Ruins Digsite",
	["Biel'aran Ridge Digsite"] = "Biel'aran Ridge Digsite",
	["Bleeding Hollow Ruins Digsite"] = "Bleeding Hollow Ruins Digsite",
	["Boha'mu Ruins Digsite"] = "Boha'mu Ruins Digsite",
	["Bonechewer Ruins Digsite"] = "Bonechewer Ruins Digsite",
	["Bone Wastes Digsite"] = "Bone Wastes Digsite",
	["Broken Commons Digsite"] = "Broken Commons Digsite",
	["Broken Pillar Digsite"] = "Broken Pillar Digsite",
	["Brunnhildar Village Digsite"] = "Brunnhildar Village Digsite",
	["Burning Blade Digsite"] = "Burning Blade Digsite",
	["Chow Farmstead Digsite"] = "Chow Farmstead Digsite",
	["Coilskar Point Digsite"] = "Coilskar Point Digsite",
	["Constellas Digsite"] = "Constellas Digsite",
	["Cursed Landing Digsite"] = "Cursed Landing Digsite",
	["Darkmist Digsite"] = "Darkmist Digsite",
	["Den of Sorrow Digsite"] = "Den of Sorrow Digsite",
	["Destroyed Village Digsite"] = "Destroyed Village Digsite",
	["Dire Maul Digsite"] = "Dire Maul Digsite",
	["Dragonmaw Fortress"] = "Dragonmaw Fortress",
	["Drakil'Jin Ruins Digsite"] = "Drakil'Jin Ruins Digsite",
	["Dreadmaul Fossil Field"] = "Dreadmaul Fossil Field",
	["Dunemaul Fossil Ridge"] = "Dunemaul Fossil Ridge",
	["Dun Garok Digsite"] = "Dun Garok Digsite",
	["Dunwald Ruins Digsite"] = "Dunwald Ruins Digsite",
	["East Auchindoun Digsite"] = "East Auchindoun Digsite",
	["Eastern Ruins of Thaurissan"] = "Eastern Ruins of Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Eastern Zul'Kunda Digsite",
	["Eastern Zul'Mamwe Digsite"] = "Eastern Zul'Mamwe Digsite",
	["Eastmoon Ruins Digsite"] = "Eastmoon Ruins Digsite",
	["East Snow Covered Hills Digsite"] = "East Snow Covered Hills Digsite",
	["East Summer Fields Digsite"] = "East Summer Fields Digsite",
	["Eclipse Point Digsite"] = "Eclipse Point Digsite",
	["Emperor's Approach Digsite"] = "Emperor's Approach Digsite",
	["Emperor's Omen Digsite"] = "Emperor's Omen Digsite",
	["En'kilah Digsite"] = "En'kilah Digsite",
	["Ethel Rethor Digsite"] = "Ethel Rethor Digsite",
	["Fallsong Village Digsite"] = "Fallsong Village Digsite",
	["Felstone Fossil Field"] = "Felstone Fossil Field",
	["Fields of Blood Fossil Bank"] = "Fields of Blood Fossil Bank",
	["Fire Camp Osul Digsite"] = "Fire Camp Osul Digsite",
	["Five Sisters Digsite"] = "Five Sisters Digsite",
	["Forest Heart Digsite"] = "Forest Heart Digsite",
	["Forest Song Digsite"] = "Forest Song Digsite",
	["Frostwhisper Gorge Digsite"] = "Frostwhisper Gorge Digsite",
	["Gate to Golden Valley Digsite"] = "Gate to Golden Valley Digsite",
	["Gjalerbron Digsite"] = "Gjalerbron Digsite",
	["Gong of Hope Digsite"] = "Gong of Hope Digsite",
	["Gor'gaz Outpost Digsite"] = "Gor'gaz Outpost Digsite",
	["Grangol'var Village Digsite"] = "Grangol'var Village Digsite",
	["Great Bridge Digsite"] = "Great Bridge Digsite",
	["Greenwarden's Fossil Bank"] = "Greenwarden's Fossil Bank",
	["Grim Batol Digsite"] = "Grim Batol Digsite",
	["Grimesilt Digsite"] = "Grimesilt Digsite",
	["Grimsilt Digsite"] = "Grimsilt Digsite",
	["Grove of Aessina Digsite"] = "Grove of Aessina Digsite",
	["Grumblepaw Ranch Digsite"] = "Grumblepaw Ranch Digsite",
	["Gurubashi Arena Digsite"] = "Gurubashi Arena Digsite",
	["Halaa Digsite"] = "Halaa Digsite",
	["Halgrind Digsite"] = "Halgrind Digsite",
	["Hammertoe's Digsite"] = "Hammertoe's Digsite",
	["Hatred's Vice Digsite"] = "Hatred's Vice Digsite",
	["Hellfire Basin Digsite"] = "Hellfire Basin Digsite",
	["Hellfire Citadel Digsite"] = "Hellfire Citadel Digsite",
	["Humboldt Conflagration Digsite"] = "Humboldt Conflagration Digsite",
	["Illidari Point Digsite"] = "Illidari Point Digsite",
	["Infectis Scar Fossil Field"] = "Infectis Scar Fossil Field",
	["Ironband's Excavation Site"] = "Ironband's Excavation Site",
	["Ironbeard's Tomb"] = "Ironbeard's Tomb",
	["Ironwood Digsite"] = "Ironwood Digsite",
	["Jade Temple Grounds Digsite"] = "Jade Temple Grounds Digsite",
	["Jaedenar Digsite"] = "Jaedenar Digsite",
	["Jintha'Alor Lower City Digsite"] = "Jintha'Alor Lower City Digsite",
	["Jintha'Alor Upper City Digsite"] = "Jintha'Alor Upper City Digsite",
	["Jotunheim Digsite"] = "Jotunheim Digsite",
	["Keset Pass Digsite"] = "Keset Pass Digsite",
	["Khartut's Tomb Digsite"] = "Khartut's Tomb Digsite",
	["Kodo Graveyard"] = "Kodo Graveyard",
	["Kolramas Digsite"] = "Kolramas Digsite",
	["Krasarang Wilds Digsite"] = "Krasarang Wilds Digsite",
	["Kun-Lai Peak Digsite"] = "Kun-Lai Peak Digsite",
	["Lake Kel'Theril Digsite"] = "Lake Kel'Theril Digsite",
	["Lake of Stars Digsite"] = "Lake of Stars Digsite",
	["Lakeridge Highway Fossil Bank"] = "Lakeridge Highway Fossil Bank",
	["Laughing Skull Digsite"] = "Laughing Skull Digsite",
	["Lost Dynasty Digsite"] = "Lost Dynasty Digsite",
	["Lower Lakkari Tar Pits"] = "Lower Lakkari Tar Pits",
	["Mannoroc Coven Digsite"] = "Mannoroc Coven Digsite",
	["Marshlands Fossil Bank"] = "Marshlands Fossil Bank",
	["Mistfall Village Digsite"] = "Mistfall Village Digsite",
	["Misty Reed Fossil Bank"] = "Misty Reed Fossil Bank",
	["Moonrest Gardens Digsite"] = "Moonrest Gardens Digsite",
	["Morlos'Aran Digsite"] = "Morlos'Aran Digsite",
	["Nar'shola (Middle Tier) Digsite"] = "Nar'shola (Middle Tier) Digsite",
	["Nazj'vel Digsite"] = "Nazj'vel Digsite",
	["Neferset Digsite"] = "Neferset Digsite",
	["Nek'mani Wellspring Digsite"] = "Nek'mani Wellspring Digsite",
	["Nifflevar Digsite"] = "Nifflevar Digsite",
	["Nightmare Scar Digsite"] = "Nightmare Scar Digsite",
	["Niuzao Temple Digsite"] = "Niuzao Temple Digsite",
	["Njorndar Village Digsite"] = "Njorndar Village Digsite",
	["North Fruited Fields Digsite"] = "North Fruited Fields Digsite",
	["North Great Wall Digsite"] = "North Great Wall Digsite",
	["North Isildien Digsite"] = "North Isildien Digsite",
	["Northridge Fossil Field"] = "Northridge Fossil Field",
	["North Ruins of Dojan Digsite"] = "North Ruins of Dojan Digsite",
	["North Ruins of Guo-Lai Digsite"] = "North Ruins of Guo-Lai Digsite",
	["North Summer Fields Digsite"] = "North Summer Fields Digsite",
	["North Temple of the Red Crane Digsite"] = "North Temple of the Red Crane Digsite",
	["Obelisk of the Stars Digsite"] = "Obelisk of the Stars Digsite",
	["Old Village Digsite"] = "Old Village Digsite",
	["Oneiros Digsite"] = "Oneiros Digsite",
	["Orchard Digsite"] = "Orchard Digsite",
	["Orsis Digsite"] = "Orsis Digsite",
	["Owl Wing Thicket Digsite"] = "Owl Wing Thicket Digsite",
	["Paoquan Hollow Digsite"] = "Paoquan Hollow Digsite",
	["Pit of Fiends Digsite"] = "Pit of Fiends Digsite",
	["Pit of Narjun Digsite"] = "Pit of Narjun Digsite",
	["Plaguewood Digsite"] = "Plaguewood Digsite",
	["Pools of Purity Digsite"] = "Pools of Purity Digsite",
	["Pyrox Flats Digsite"] = "Pyrox Flats Digsite",
	["Quagmire Fossil Field"] = "Quagmire Fossil Field",
	["Quel'Dormir Gardens Digsite"] = "Quel'Dormir Gardens Digsite",
	["Quel'Lithien Lodge Digsite"] = "Quel'Lithien Lodge Digsite",
	["Ravenwind Digsite"] = "Ravenwind Digsite",
	["Red Reaches Fossil Bank"] = "Red Reaches Fossil Bank",
	["Remote Village Digsite"] = "Remote Village Digsite",
	["Riplash Ruins Digsite"] = "Riplash Ruins Digsite",
	["River Delta Digsite"] = "River Delta Digsite",
	["Ruins of Aboraz"] = "Ruins of Aboraz",
	["Ruins of Ahmtul Digsite"] = "Ruins of Ahmtul Digsite",
	["Ruins of Ammon Digsite"] = "Ruins of Ammon Digsite",
	["Ruins of Arkkoran"] = "Ruins of Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Ruins of Baa'ri Digsite",
	["Ruins of Eldarath"] = "Ruins of Eldarath",
	["Ruins of Eldre'Thar"] = "Ruins of Eldre'Thar",
	["Ruins of Enkaat Digsite"] = "Ruins of Enkaat Digsite",
	["Ruins of Farahlon Digsite"] = "Ruins of Farahlon Digsite",
	["Ruins of Gan Shi Digsite"] = "Ruins of Gan Shi Digsite",
	["Ruins of Jubuwal"] = "Ruins of Jubuwal",
	["Ruins of Khintaset Digsite"] = "Ruins of Khintaset Digsite",
	["Ruins of Korja Digsite"] = "Ruins of Korja Digsite",
	["Ruins of Lar'donir Digsite"] = "Ruins of Lar'donir Digsite",
	["Ruins of Ordil'Aran"] = "Ruins of Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Ruins of Shandaral Digsite",
	["Ruins of Stardust"] = "Ruins of Stardust",
	["Sahket Wastes Digsite"] = "Sahket Wastes Digsite",
	["Sanctuary of Malorne Digsite"] = "Sanctuary of Malorne Digsite",
	["Sands of Nasam"] = "Sands of Nasam",
	["Sargeron Digsite"] = "Sargeron Digsite",
	["Savage Coast Raptor Fields"] = "Savage Coast Raptor Fields",
	["Schnottz's Landing"] = "Schnottz's Landing",
	["Scorched Plain Digsite"] = "Scorched Plain Digsite",
	["Scourgeholme Digsite"] = "Scourgeholme Digsite",
	["Screaming Reaches Fossil Field"] = "Screaming Reaches Fossil Field",
	["Setting Sun Garrison Digsite"] = "Setting Sun Garrison Digsite",
	["Shadra'Alor Digsite"] = "Shadra'Alor Digsite",
	["Sha'naar Digsite"] = "Sha'naar Digsite",
	["Shanze'Dao Digsite"] = "Shanze'Dao Digsite",
	["Shield Hill Digsite"] = "Shield Hill Digsite",
	["Shrine Meadow Digsite"] = "Shrine Meadow Digsite",
	["Shrine of Goldrinn Digsite"] = "Shrine of Goldrinn Digsite",
	["Shrine of the Dawn Digsite"] = "Shrine of the Dawn Digsite",
	["Sifreldar Village Digsite"] = "Sifreldar Village Digsite",
	["Singing Marshes Digsite"] = "Singing Marshes Digsite",
	["Skorn Digsite"] = "Skorn Digsite",
	["Slitherblade Shore Digsite"] = "Slitherblade Shore Digsite",
	["Small Gate Digsite"] = "Small Gate Digsite",
	["Snow Covered Hills Digsite"] = "Snow Covered Hills Digsite",
	["Solarsal Digsite"] = "Solarsal Digsite",
	["South Fruited Fields Digsite"] = "South Fruited Fields Digsite",
	["South Great Wall Digsite"] = "South Great Wall Digsite",
	["South Isildien Digsite"] = "South Isildien Digsite",
	["Southmoon Ruins Digsite"] = "Southmoon Ruins Digsite",
	["South Orchard Digsite"] = "South Orchard Digsite",
	["South Ruins of Dojan Digsite"] = "South Ruins of Dojan Digsite",
	["South Ruins of Guo-Lai Digsite"] = "South Ruins of Guo-Lai Digsite",
	["Southshore Fossil Field"] = "Southshore Fossil Field",
	["Southwind Village Digsite"] = "Southwind Village Digsite",
	["Sra'thik Digsite"] = "Sra'thik Digsite",
	["Steps of Fate Digsite"] = "Steps of Fate Digsite",
	["Stonetalon Peak"] = "Stonetalon Peak",
	["Sunken Temple Digsite"] = "Sunken Temple Digsite",
	["Sunspring Post Digsite"] = "Sunspring Post Digsite",
	["Talramas Digsite"] = "Talramas Digsite",
	["Temple of Uldum Digsite"] = "Temple of Uldum Digsite",
	["Terrace of Gurthan Digsite"] = "Terrace of Gurthan Digsite",
	["Terror Run Fossil Field"] = "Terror Run Fossil Field",
	["Terrorweb Tunnel Digsite"] = "Terrorweb Tunnel Digsite",
	["Terror Wing Fossil Field"] = "Terror Wing Fossil Field",
	["Thandol Span"] = "Thandol Span",
	["The Arboretum Digsite"] = "The Arboretum Digsite",
	["The Spring Road Digsite"] = "The Spring Road Digsite",
	["Thoradin's Wall"] = "Thoradin's Wall",
	["Thundermar Ruins Digsite"] = "Thundermar Ruins Digsite",
	["Thunderwood Digsite"] = "Thunderwood Digsite",
	["Tian Digsite"] = "Tian Digsite",
	["Tiger's Wood Digsite"] = "Tiger's Wood Digsite",
	["Tomb of the Watchers Digsite"] = "Tomb of the Watchers Digsite",
	["Tombs of the Precursors Digsite"] = "Tombs of the Precursors Digsite",
	["Torjari Pit Digsite"] = "Torjari Pit Digsite",
	["Tu Shen Digsite"] = "Tu Shen Digsite",
	["Tuurem Digsite"] = "Tuurem Digsite",
	["Twilight Grove Digsite"] = "Twilight Grove Digsite",
	["Twin Spire Ruins Digsite"] = "Twin Spire Ruins Digsite",
	["Uldaman Entrance Digsite"] = "Uldaman Entrance Digsite",
	["Unearthed Grounds"] = "Unearthed Grounds",
	["Upper Lakkari Tar Pits"] = "Upper Lakkari Tar Pits",
	["Valkyrion Digsite"] = "Valkyrion Digsite",
	["Valley of Bones"] = "Valley of Bones",
	["Valley of Kings Digsite"] = "Valley of Kings Digsite",
	["Veridian Grove Digsite"] = "Veridian Grove Digsite",
	["Violet Stand Digsite"] = "Violet Stand Digsite",
	["Voldrune Digsite"] = "Voldrune Digsite",
	["Vul'Gol Fossil Bank"] = "Vul'Gol Fossil Bank",
	["Warden's Cage Digsite"] = "Warden's Cage Digsite",
	["West Auchindoun Digsite"] = "West Auchindoun Digsite",
	["Western Ruins of Thaurissan"] = "Western Ruins of Thaurissan",
	["Western Zul'Kunda Digsite"] = "Western Zul'Kunda Digsite",
	["Western Zul'Mamwe Digsite"] = "Western Zul'Mamwe Digsite",
	["West Old Village Digsite"] = "West Old Village Digsite",
	["West Ruins of Guo-Lai Digsite"] = "West Ruins of Guo-Lai Digsite",
	["West Summer Fields Digsite"] = "West Summer Fields Digsite",
	["Whelgar's Excavation Site"] = "Whelgar's Excavation Site",
	["Winterbough Digsite"] = "Winterbough Digsite",
	["Witherbark Digsite"] = "Witherbark Digsite",
	["Writhingwood Digsite"] = "Writhingwood Digsite",
	["Wyrmbog Fossil Field"] = "Wyrmbog Fossil Field",
	["Wyrmskull Digsite"] = "Wyrmskull Digsite",
	["Ymirheim Digsite"] = "Ymirheim Digsite",
	["Zeth'Gor Digsite"] = "Zeth'Gor Digsite",
	["Zhu Province Digsite"] = "Zhu Province Digsite",
	["Ziata'jai Digsite"] = "Ziata'jai Digsite",
	["Zim'Rhuk Digsite"] = "Zim'Rhuk Digsite",
	["Zol'Heb Digsite"] = "Zol'Heb Digsite",
	["Zoram Strand Digsite"] = "Zoram Strand Digsite",
	["Zul'Farrak Digsite"] = "Zul'Farrak Digsite",
	["Zul'Mashar Digsite"] = "Zul'Mashar Digsite",
}


if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)
elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Fossilienkamm der Ewigen Sande", -- Needs review
	["Aerie Peak Digsite"] = "Ausgrabungsstätte des Nistgipfels",
	["Agol'watha Digsite"] = "Ausgrabungsstätte von Agol'watha",
	["Akhenet Fields Digsite"] = "Ausgrabungsstätte der Felder von Akhenet",
	["Altar of Quetz'lun Digsite"] = "Ausgrabungsstätte am Altar von Quetz'lun",
	["Altar of Sseratus Digsite"] = "Ausgrabungsstätte am Altar von Sseratus",
	["Altar of Zul Digsite"] = "Ausgrabungsstätte am Altar von Zul",
	["Ancestral Grounds Digsite"] = "Ausgrabungsstätte des Ahnengrunds",
	["Andorhal Fossil Bank"] = "Fossilienbank von Andorhal",
	["Arklon Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Arklon",
	["Bael Modan Digsite"] = "Ausgrabungsstätte von Bael Modan",
	["Baleheim Digsite"] = "Ausgrabungsstätte Quälheim",
	["Balia'mah Digsite"] = "Ausgrabungsstätte von Balia'mah",
	["Bal'lal Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Bal'lal",
	["Biel'aran Ridge Digsite"] = "Ausgrabungsstätte des Biel'arangrats",
	["Bleeding Hollow Ruins Digsite"] = "Ausgrabungsstätte der Ruinen des Blutenden Auges",
	["Boha'mu Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Boha'mu",
	["Bonechewer Ruins Digsite"] = "Ausgrabungsstätte der Ruinen der Knochenmalmer",
	["Bone Wastes Digsite"] = "Ausgrabungsstätte der Knochenwüste",
	["Broken Commons Digsite"] = "Ausgrabungsstätte der Zerstörten Allmende",
	["Broken Pillar Digsite"] = "Ausgrabungsstätte der Zerbrochenen Säule",
	["Brunnhildar Village Digsite"] = "Ausgrabungsstätte von Brunnhildar",
	["Burning Blade Digsite"] = "Ausgrabungsstätte der Brennenden Klinge",
	["Chow Farmstead Digsite"] = "Ausgrabungsstätte am Bauernhof der Chows",
	["Coilskar Point Digsite"] = "Ausgrabungsstätte der Echsennarbe",
	["Constellas Digsite"] = "Ausgrabungsstätte von Constellas",
	["Cursed Landing Digsite"] = "Ausgrabungsstätte am Verfluchten Landeplatz",
	["Darkmist Digsite"] = "Ausgrabungsstätte bei Graunebel",
	["Den of Sorrow Digsite"] = "Ausgrabungsstätte an der Höhle der Trauer",
	["Destroyed Village Digsite"] = "Ausgrabungsstätte beim zerstörten Dorf",
	["Dire Maul Digsite"] = "Ausgrabungsstätte des Düsterbruchs",
	["Dragonmaw Fortress"] = "Festung des Drachenmals",
	["Drakil'Jin Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Drakil'jin",
	["Dreadmaul Fossil Field"] = "Fossilienfeld am Schreckensfelsen",
	["Dunemaul Fossil Ridge"] = "Fossilienkamm der Dünenbrecher",
	["Dun Garok Digsite"] = "Ausgrabungsstätte von Dun Garok",
	["Dunwald Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Dunwald",
	["East Auchindoun Digsite"] = "Östliche Ausgrabungsstätte von Auchindoun",
	["Eastern Ruins of Thaurissan"] = "Östliche Ruinen von Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Östliche Ausgrabungsstätte von Zul'Kunda",
	["Eastern Zul'Mamwe Digsite"] = "Östliche Ausgrabungsstätte von Zul'Mamwe",
	["Eastmoon Ruins Digsite"] = "Ausgrabungsstätte der Ostmondruinen",
	["East Snow Covered Hills Digsite"] = "Östliche Ausgrabungsstätte der schneebedeckten Hügel",
	["East Summer Fields Digsite"] = "Östliche Ausgrabungsstätte der Sommerfelder",
	["Eclipse Point Digsite"] = "Ausgrabungsstätte der Stätte der Mondfinsternis",
	["Emperor's Approach Digsite"] = "Ausgrabungsstätte des Kaisergangs",
	["Emperor's Omen Digsite"] = "Ausgrabungsstätte am Omen des Kaisers",
	["En'kilah Digsite"] = "Ausgrabungsstätte von En'kilah",
	["Ethel Rethor Digsite"] = "Ausgrabungsstätte von Ethel Rethor", -- Needs review
	["Fallsong Village Digsite"] = "Ausgrabungsstätte von Fallsang",
	["Felstone Fossil Field"] = "Teufelssteinfossilienfeld",
	["Fields of Blood Fossil Bank"] = "Fossilienbank der Felder des Blutes", -- Needs review
	["Fire Camp Osul Digsite"] = "Ausgrabungsstätte vom Streitlager Osul",
	["Five Sisters Digsite"] = "Ausgrabungsstätte bei den Fünf Schwestern",
	["Forest Heart Digsite"] = "Ausgrabungsstätte am Herz des Waldes",
	["Forest Song Digsite"] = "Ausgrabungsstätte von Waldeslied", -- Needs review
	["Frostwhisper Gorge Digsite"] = "Ausgrabungsstätte der Frosthauchschlucht", -- Needs review
	["Gate to Golden Valley Digsite"] = "Ausgrabungsstätte am Tor zum goldenen Tal",
	["Gjalerbron Digsite"] = "Ausgrabungsstätte von Gjalerbron",
	["Gong of Hope Digsite"] = "Ausgrabungsstätte am Gong der Hoffnung",
	["Gor'gaz Outpost Digsite"] = "Ausgrabungsstätte des Außenpostens von Gor'gaz",
	["Grangol'var Village Digsite"] = "Ausgrabungsstätte von Grangol'var",
	["Great Bridge Digsite"] = "Ausgrabungsstätte an der großen Brücke",
	["Greenwarden's Fossil Bank"] = "Fossilienbank des Grünen Gürtels",
	["Grim Batol Digsite"] = "Ausgrabungsstätte von Grim Batol", -- Needs review
	["Grimesilt Digsite"] = "Grimmsilts Ausgrabungsstätte",
	["Grimsilt Digsite"] = "Grimmsilts Ausgrabungsstätte", -- Needs review
	["Grove of Aessina Digsite"] = "Ausgrabungsstätte des Hains von Aessina", -- Needs review
	["Grumblepaw Ranch Digsite"] = "Ausgrabungsstätte am Gehöft Moschuspranke",
	["Gurubashi Arena Digsite"] = "Ausgrabungsstätte an der Arena der Gurubashiarena",
	["Halaa Digsite"] = "Ausgrabungsstätte von Haala",
	["Halgrind Digsite"] = "Ausgrabungsstätte von Halgrind",
	["Hammertoe's Digsite"] = "Hammerzehs Grabungsstätte",
	["Hatred's Vice Digsite"] = "Ausgrabungsstätte von Haderzwinge",
	["Hellfire Basin Digsite"] = "Ausgrabungsstätte des Höllenfeuerbecken",
	["Hellfire Citadel Digsite"] = "Ausgrabungsstätte der Höllenfeuerzitadelle",
	["Humboldt Conflagration Digsite"] = "Ausgrabungsstätte der Humboldtfeuersbrunst",
	["Illidari Point Digsite"] = "Ausgrabungsstätte der Stätte der Illidari",
	["Infectis Scar Fossil Field"] = "Fossilienfeld der Infektnarbe",
	["Ironband's Excavation Site"] = "Eisenbands Ausgrabungsstätte",
	["Ironbeard's Tomb"] = "Eisenbarts Grabmal",
	["Ironwood Digsite"] = "Ausgrabungsstätte des Eisenwaldes", -- Needs review
	["Jade Temple Grounds Digsite"] = "Ausgrabungsstätte der Anlagen des Jadetempels",
	["Jaedenar Digsite"] = "Ausgrabungsstätte von Jaedenar", -- Needs review
	["Jintha'Alor Lower City Digsite"] = "Ausgrabungsstätte des unteren Viertels von Jintha'Alor",
	["Jintha'Alor Upper City Digsite"] = "Ausgrabungsstätte des oberen Viertels von Jintha'Alor",
	["Jotunheim Digsite"] = "Ausgrabungsstätte von Jotunheim",
	["Keset Pass Digsite"] = "Ausgrabungsstätte am Kesetpass", -- Needs review
	["Khartut's Tomb Digsite"] = "Ausgrabungsstätte des Grabs des Khartut", -- Needs review
	["Kodo Graveyard"] = "Kodofriedhof", -- Needs review
	["Kolramas Digsite"] = "Ausgrabungsstätte von Kolramas",
	["Krasarang Wilds Digsite"] = "Ausgrabungsstätte der Krasarangwildnis",
	["Kun-Lai Peak Digsite"] = "Ausgrabungsstätte des Kun-Lai-Gipfels",
	["Lake Kel'Theril Digsite"] = "Ausgrabungsstätte des Kel'Therilsees", -- Needs review
	["Lake of Stars Digsite"] = "Ausgrabungsstätte des Sternensees",
	["Lakeridge Highway Fossil Bank"] = "Fossilienbank am Uferpfad",
	["Laughing Skull Digsite"] = "Ausgrabungsstätte des Lachenden Schädels",
	["Lost Dynasty Digsite"] = "Ausgrabungsstätte der verlorenen Dynastie",
	["Lower Lakkari Tar Pits"] = "Untere Teergruben von Lakkari", -- Needs review
	["Mannoroc Coven Digsite"] = "Ausgrabungsstätte am Zirkel der Mannoroc", -- Needs review
	["Marshlands Fossil Bank"] = "Fossilienbank der Marschen", -- Needs review
	["Mistfall Village Digsite"] = "Ausgrabungsstätte von Nebelhauch",
	["Misty Reed Fossil Bank"] = "Fossilienbank am Nebelschilfstrand",
	["Moonrest Gardens Digsite"] = "Ausgrabungsstätte der Mondruhgärten",
	["Morlos'Aran Digsite"] = "Ausgrabungsstätte von Morlos'Aran", -- Needs review
	["Nar'shola (Middle Tier) Digsite"] = "Ausgrabungsstätte von Nar'shola",
	["Nazj'vel Digsite"] = "Ausgrabungsstätte von Nazj'vel", -- Needs review
	["Neferset Digsite"] = "Ausgrabungsstätte von Neferset", -- Needs review
	["Nek'mani Wellspring Digsite"] = "Ausgrabungsstätte am Nek'maniquellbrunnen",
	["Nifflevar Digsite"] = "Ausgrabungsstätte von Nifflevar",
	["Nightmare Scar Digsite"] = "Ausgrabungsstätte der Alptraumnarbe", -- Needs review
	["Niuzao Temple Digsite"] = "Ausgrabungsstätte des Niuzaotempels",
	["Njorndar Village Digsite"] = "Ausgrabungsstätte von Njorndar",
	["North Fruited Fields Digsite"] = "Nördliche Ausgrabungsstätte der fruchttragenden Felder",
	["North Great Wall Digsite"] = "Nördliche Ausgrabungsstätte der großen Mauer",
	["North Isildien Digsite"] = "Ausgrabungsstätte von Nordisildien", -- Needs review
	["Northridge Fossil Field"] = "Fossilienfeld am Nordkamm", -- Needs review
	["North Ruins of Dojan Digsite"] = "Nördliche Ausgrabungsstätte der Ruinen von Dojan",
	["North Ruins of Guo-Lai Digsite"] = "Nördliche Ausgrabungsstätte der Guo-Lai-Ruinen",
	["North Summer Fields Digsite"] = "Nördliche Ausgrabungsstätte der Sommerfelder",
	["North Temple of the Red Crane Digsite"] = "Nördliche Ausgrabungsstätte des Tempels des Roten Kranichs",
	["Obelisk of the Stars Digsite"] = "Ausgrabungsstätte am Obelisken der Sterne", -- Needs review
	["Old Village Digsite"] = "Ausgrabungsstätte des alten Dorfes",
	["Oneiros Digsite"] = "Ausgrabungsstätte von Oneiros", -- Needs review
	["Orchard Digsite"] = "Ausgrabungsstätte am Obstgarten",
	["Orsis Digsite"] = "Ausgrabungsstätte von Orsis", -- Needs review
	["Owl Wing Thicket Digsite"] = "Ausgrabungsstätte des Eulenflügeldickichts", -- Needs review
	["Paoquan Hollow Digsite"] = "Ausgrabungsstätte der Paoquansenke",
	["Pit of Fiends Digsite"] = "Ausgrabungsstätte der Schreckensgrube", -- Needs review
	["Pit of Narjun Digsite"] = "Ausgrabungsstätte der Grube von Narjun",
	["Plaguewood Digsite"] = "Ausgrabungsstätte des Pestwaldes", -- Needs review
	["Pools of Purity Digsite"] = "Ausgrabungsstätte bei den Teichen der Reinheit",
	["Pyrox Flats Digsite"] = "Ausgrabungsstätte der Pyroxebenen", -- Needs review
	["Quagmire Fossil Field"] = "Fossilienfeld im Morast", -- Needs review
	["Quel'Dormir Gardens Digsite"] = "Ausgrabungsstätte der Gärten von Quel'Dormir",
	["Quel'Lithien Lodge Digsite"] = "Ausgrabungsstätte bei der Jagdhütte Quel'Lithien", -- Needs review
	["Ravenwind Digsite"] = "Ausgrabungsstätte von Rabenwind", -- Needs review
	["Red Reaches Fossil Bank"] = "Fossilienbank der Roten Weiten", -- Needs review
	["Remote Village Digsite"] = "Ausgrabungsstätte des entlegenen Dorfes",
	["Riplash Ruins Digsite"] = "Ausgrabungsstätte der Ruinen der Peitschennarbe",
	["River Delta Digsite"] = "Ausgrabungsstätte am Flussdelta", -- Needs review
	["Ruins of Aboraz"] = "Ruinen von Aboraz", -- Needs review
	["Ruins of Ahmtul Digsite"] = "Ausgrabungsstätte der Ruinen von Ahmtul", -- Needs review
	["Ruins of Ammon Digsite"] = "Ausgrabungsstätte der Ruinen von Ammon", -- Needs review
	["Ruins of Arkkoran"] = "Ruinen von Arkkoran", -- Needs review
	["Ruins of Baa'ri Digsite"] = "Ausgrabungsstätte der Ruinen von Baa'ri",
	["Ruins of Eldarath"] = "Ruinen von Eldarath", -- Needs review
	["Ruins of Eldre'Thar"] = "Ruinen von Eldre'Thar", -- Needs review
	["Ruins of Enkaat Digsite"] = "Ausgrabungsstätte der Ruinen von Enkaat",
	["Ruins of Farahlon Digsite"] = "Ausgrabungsstätte der Ruinen von Farahlon",
	["Ruins of Gan Shi Digsite"] = "Ausgrabungsstätte der Terrasse der Zehn Donner",
	["Ruins of Jubuwal"] = "Ruinen von Jubuwal", -- Needs review
	["Ruins of Khintaset Digsite"] = "Ausgrabungsstätte der Ruinen von Khintaset", -- Needs review
	["Ruins of Korja Digsite"] = "Ausgrabungsstätte der Ruinen von Korja",
	["Ruins of Lar'donir Digsite"] = "Ausgrabungsstätte der Ruinen von Lar'donir", -- Needs review
	["Ruins of Ordil'Aran"] = "Ruinen von Ordil'Aran", -- Needs review
	["Ruins of Shandaral Digsite"] = "Ausgrabungsstätte der Ruinen von Shandaral",
	["Ruins of Stardust"] = "Sternenstaubruinen", -- Needs review
	["Sahket Wastes Digsite"] = "Ausgrabungsstätte der Sahketwüste", -- Needs review
	["Sanctuary of Malorne Digsite"] = "Ausgrabungsstätte des Heiligtums von Malorne", -- Needs review
	["Sands of Nasam"] = "Sande von Nasam",
	["Sargeron Digsite"] = "Ausgrabungsstätte von Sargeron", -- Needs review
	["Savage Coast Raptor Fields"] = "Raptorfelder der Ungezähmten Küste", -- Needs review
	["Schnottz's Landing"] = "Grabungsstätte bei Schnottz' Landeplatz", -- Needs review
	["Scorched Plain Digsite"] = "Ausgrabungsstätte der Verbrannten Ebene", -- Needs review
	["Scourgeholme Digsite"] = "Ausgrabungsstätte von Geißelholme",
	["Screaming Reaches Fossil Field"] = "Fossilienfelder der Schreienden Weiten",
	["Setting Sun Garrison Digsite"] = "Ausgrabungsstätte der Garnison der Untergehenden Sonne",
	["Shadra'Alor Digsite"] = "Ausgrabungsstätte von Shadra'Alor", -- Needs review
	["Sha'naar Digsite"] = "Ausgrabungsstätte von Sha'naar",
	["Shanze'Dao Digsite"] = "Ausgrabungsstätte von Shanze'Dao",
	["Shield Hill Digsite"] = "Ausgrabungsstätte des Schildhügels",
	["Shrine Meadow Digsite"] = "Ausgrabungsstätte der Schreinaue",
	["Shrine of Goldrinn Digsite"] = "Ausgrabungsstätte des Schrein von Goldrinn",
	["Shrine of the Dawn Digsite"] = "Ausgrabungsstätte des Schreins der Morgensonne",
	["Sifreldar Village Digsite"] = "Ausgrabungsstätte von Sifreldar",
	["Singing Marshes Digsite"] = "Ausgrabungsstätte der singenden Marschen",
	["Skorn Digsite"] = "Ausgrabungsstätte von Skorn",
	["Slitherblade Shore Digsite"] = "Ausgrabungsstätte am Strand der Zackenkämme",
	["Small Gate Digsite"] = "Ausgrabungsstätte am kleinen Tor",
	["Snow Covered Hills Digsite"] = "Ausgrabungsstätte der schneebedeckten Hügel",
	["Solarsal Digsite"] = "Ausgrabungsstätte von Solarsal",
	["South Fruited Fields Digsite"] = "Südliche Ausgrabungsstätte der fruchttragenden Felder",
	["South Great Wall Digsite"] = "Südliche Ausgrabungsstätte der großen Mauer",
	["South Isildien Digsite"] = "Ausgrabungsstätte von Südisildien",
	["Southmoon Ruins Digsite"] = "Ausgrabungsstätte der Südmondruinen",
	["South Orchard Digsite"] = "Südliche Ausgrabungsstätte am Obstgarten",
	["South Ruins of Dojan Digsite"] = "Südliche Ausgrabungsstätte der Ruinen von Dojan",
	["South Ruins of Guo-Lai Digsite"] = "Südliche Ausgrabungsstätte der Guo-Lai-Ruinen",
	["Southshore Fossil Field"] = "Fossilienfeld von Süderstade", -- Needs review
	["Southwind Village Digsite"] = "Ausgrabungsstätte des Südwindpostens",
	["Sra'thik Digsite"] = "Ausgrabungsstätte von Sra'thik",
	["Steps of Fate Digsite"] = "Ausgrabungsstätte der Schicksalsstiege",
	["Stonetalon Peak"] = "Steinkrallengipfel",
	["Sunken Temple Digsite"] = "Ausgrabungsstätte des Versunkenen Tempels", -- Needs review
	["Sunspring Post Digsite"] = "Ausgrabungsstätte des Sonnenwindpostens",
	["Talramas Digsite"] = "Ausgrabungsstätte von Talramas",
	["Temple of Uldum Digsite"] = "Ausgrabungsstätte des Tempels von Uldum",
	["Terrace of Gurthan Digsite"] = "Ausgrabungsstätte der Terrasse von Gurthan",
	["Terror Run Fossil Field"] = "Fossilienfeld der Terrorflucht",
	["Terrorweb Tunnel Digsite"] = "Ausgrabungsstätte des Schreckenstunnels", -- Needs review
	["Terror Wing Fossil Field"] = "Fossilienfeld am Schreckenspfad", -- Needs review
	["Thandol Span"] = "Thandolübergang", -- Needs review
	["The Arboretum Digsite"] = "Ausgrabungsstätte des Arboretums",
	["The Spring Road Digsite"] = "Ausgrabungsstätte an der Lenzstraße",
	["Thoradin's Wall"] = "Thoradinswall", -- Needs review
	["Thundermar Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Donnermar", -- Needs review
	["Thunderwood Digsite"] = "Ausgrabungsstätte am Donnerholz",
	["Tian Digsite"] = "Ausgrabungsstätte von Tian",
	["Tiger's Wood Digsite"] = "Ausgrabungsstätte des Tigergehölzes", -- Needs review
	["Tomb of the Watchers Digsite"] = "Ausgrabungsstätte am Grab der Behüter", -- Needs review
	["Tombs of the Precursors Digsite"] = "Ausgrabungsstätte der Gräber der Wegbereiter",
	["Torjari Pit Digsite"] = "Ausgrabungsstätte der Torjarigrube",
	["Tu Shen Digsite"] = "Ausgrabungstätte von Tu-Shen",
	["Tuurem Digsite"] = "Ausgrabungsstätte von Tuurem",
	["Twilight Grove Digsite"] = "Ausgrabungsstätte am Zwielichtshain", -- Needs review
	["Twin Spire Ruins Digsite"] = "Ausgrabungsstätte der Ruinen der Zwillingsspitze",
	["Uldaman Entrance Digsite"] = "Ausgrabungsstätte am Eingang nach Uldaman", -- Needs review
	["Unearthed Grounds"] = "Die Grabstätte",
	["Upper Lakkari Tar Pits"] = "Obere Teergruben von Lakkari",
	["Valkyrion Digsite"] = "Ausgrabungsstätte von Valkyrion",
	["Valley of Bones"] = "Tal der Knochen",
	["Valley of Kings Digsite"] = "Ausgrabungsstätte im Tal der Könige",
	["Veridian Grove Digsite"] = "Ausgrabungsstätte im Hain von Pel'zin",
	["Violet Stand Digsite"] = "Ausgrabungsstätte der Violetten Wacht",
	["Voldrune Digsite"] = "Ausgrabungsstätte von Voldrune",
	["Vul'Gol Fossil Bank"] = "Fossilienbank von Vul'Gol", -- Needs review
	["Warden's Cage Digsite"] = "Ausgrabungsstätte des Kerkers des Wächters",
	["West Auchindoun Digsite"] = "Westliche Ausgrabungsstätte von Auchindoun",
	["Western Ruins of Thaurissan"] = "Westliche Ruinen von Thaurissan", -- Needs review
	["Western Zul'Kunda Digsite"] = "Westliche Ausgrabungsstätte von Zul'Kunda", -- Needs review
	["Western Zul'Mamwe Digsite"] = "Westliche Ausgrabungsstätte von Zul'Mamwe", -- Needs review
	["West Old Village Digsite"] = "Westliche Ausgrabungsstätte des alten Dorfes",
	["West Ruins of Guo-Lai Digsite"] = "Westliche Ausgrabungsstätte der Guo-Lai-Ruinen",
	["West Summer Fields Digsite"] = "Westliche Ausgrabungsstätte der Sommerfelder",
	["Whelgar's Excavation Site"] = "Whelgars Ausgrabungsstätte", -- Needs review
	["Winterbough Digsite"] = "Ausgrabungsstätte der Winterastlichtung",
	["Witherbark Digsite"] = "Ausgrabungsstätte der Bleichborken", -- Needs review
	["Writhingwood Digsite"] = "Ausgrabungsstätte des Windegehölzes",
	["Wyrmbog Fossil Field"] = "Fossilienfeld des Drachensumpfes",
	["Wyrmskull Digsite"] = "Ausgrabungsstätte von Wyrmskol",
	["Ymirheim Digsite"] = "Ausgrabungsstätte von Ymirheim",
	["Zeth'Gor Digsite"] = "Ausgrabungsstätte von Zeth'Gor",
	["Zhu Province Digsite"] = "Ausgrabungsstätte der Provinz Zhu",
	["Ziata'jai Digsite"] = "Ausgrabungsstätte von Ziata'jai", -- Needs review
	["Zim'Rhuk Digsite"] = "Ausgrabungsstätte von Zim'Rhuk",
	["Zol'Heb Digsite"] = "Ausgrabungsstätte von Zol'Heb",
	["Zoram Strand Digsite"] = "Ausgrabungsstätte am Zoramstrand",
	["Zul'Farrak Digsite"] = "Ausgrabungsstätte von Zul'Farrak",
	["Zul'Mashar Digsite"] = "Ausgrabungsstätte von Zul'Mashar", -- Needs review
}
elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Crête de fossiles du désert Abysséen",
	["Aerie Peak Digsite"] = "Site de fouilles de Nid-de-l'Aigle",
	["Agol'watha Digsite"] = "Site de fouilles d'Agol'watha",
	["Akhenet Fields Digsite"] = "Site de fouilles des champs d'Akhenet",
	["Altar of Quetz'lun Digsite"] = "Site de fouilles de l'autel de Quetz'lun",
	["Altar of Sseratus Digsite"] = "Site de fouilles de l'autel de Sseratus",
	["Altar of Zul Digsite"] = "Site de fouilles de l'autel de Zul",
	["Ancestral Grounds Digsite"] = "Site de fouilles des terres Ancestrales",
	["Andorhal Fossil Bank"] = "Banc de fossiles d'Andorhal",
	["Arklon Ruins Digsite"] = "Site de fouilles des ruines Arklon",
	["Bael Modan Digsite"] = "Site de fouilles de Bael Modan",
	["Baleheim Digsite"] = "Site de fouilles de Torvheim",
	["Balia'mah Digsite"] = "Site de fouilles de Balia'mah",
	["Bal'lal Ruins Digsite"] = "Site de fouilles des ruines de Bal'lal",
	["Biel'aran Ridge Digsite"] = "Site de fouilles de la crête de Biel'aran",
	["Bleeding Hollow Ruins Digsite"] = "Site de fouilles des ruines de l'Orbite sanglante",
	["Boha'mu Ruins Digsite"] = "Site de fouilles des ruines de Boha'mu",
	["Bonechewer Ruins Digsite"] = "Site de fouilles des ruines Mâche-les-os",
	["Bone Wastes Digsite"] = "Site de fouilles du désert des Ossements",
	["Broken Commons Digsite"] = "Site de fouilles des communs en ruine",
	["Broken Pillar Digsite"] = "Site de fouilles du pilier brisé",
	["Brunnhildar Village Digsite"] = "Site de fouilles de Brunnhildar",
	["Burning Blade Digsite"] = "Site de fouilles de la Lame ardente",
	["Chow Farmstead Digsite"] = "Site de fouilles de la ferme de Chow",
	["Coilskar Point Digsite"] = "Site de fouilles de la halte de Glissentaille",
	["Constellas Digsite"] = "Site de fouilles de Constellas",
	["Cursed Landing Digsite"] = "Site de fouilles de l'accostage Maudit",
	["Darkmist Digsite"] = "Site de fouilles de Sombrebrume",
	["Den of Sorrow Digsite"] = "Site de fouilles de la tanière de la Mélancolie",
	["Destroyed Village Digsite"] = "Site de fouilles du village détruit",
	["Dire Maul Digsite"] = "Site de fouilles de Hache-Tripes",
	["Dragonmaw Fortress"] = "Forteresse Gueule-de-dragon",
	["Drakil'Jin Ruins Digsite"] = "Site de fouilles des ruines de Drakil'jin",
	["Dreadmaul Fossil Field"] = "Champ de fossiles Cognepeur",
	["Dunemaul Fossil Ridge"] = "Crête de fossiles des Cognedunes",
	["Dun Garok Digsite"] = "Site de fouilles de Dun Garok",
	["Dunwald Ruins Digsite"] = "Site de fouilles des ruines de Dunwald",
	["East Auchindoun Digsite"] = "Site de fouilles d'Auchindoun est",
	["Eastern Ruins of Thaurissan"] = "Ruines est de Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Site de fouilles de Zul'Kunda est",
	["Eastern Zul'Mamwe Digsite"] = "Site de fouilles de Zul'Mamwe est",
	["Eastmoon Ruins Digsite"] = "Site de fouilles des ruines d'Estelune",
	["East Snow Covered Hills Digsite"] = "Site de fouille des collines enneigées est",
	["East Summer Fields Digsite"] = "Site de fouilles des champs de l’Été",
	["Eclipse Point Digsite"] = "Site de fouilles de la halte de l'Éclipse",
	["Emperor's Approach Digsite"] = "Site de fouilles de la marche de l’empereur",
	["Emperor's Omen Digsite"] = "Site de fouilles du Présage de l’empereur",
	["En'kilah Digsite"] = "Site de fouilles d'En'kilah",
	["Ethel Rethor Digsite"] = "Site de fouilles d'Ethel Rethor",
	["Fallsong Village Digsite"] = "Site de fouilles de Chant-des-Flots",
	["Felstone Fossil Field"] = "Champ de fossiles de Gangrepierre",
	["Fields of Blood Fossil Bank"] = "Banc de fossiles des champs du Sang",
	["Fire Camp Osul Digsite"] = "Site de fouilles du campement d’Osul",
	["Five Sisters Digsite"] = "Site de fouilles des Cinq Sœurs",
	["Forest Heart Digsite"] = "Site de fouilles du Cœur de la Forêt",
	["Forest Song Digsite"] = "Site de fouilles de Chant des forêts",
	["Frostwhisper Gorge Digsite"] = "Site de fouilles du Blanc murmure",
	["Gate to Golden Valley Digsite"] = "Site de fouilles de la porte de la vallée dorée",
	["Gjalerbron Digsite"] = "Site de fouilles de Gjalerbron",
	["Gong of Hope Digsite"] = "Site de fouilles du Gong de l’Espoir",
	["Gor'gaz Outpost Digsite"] = "Site de fouilles de l'avant-poste de Gor'gaz",
	["Grangol'var Village Digsite"] = "Site de fouilles de Grangol'var",
	["Great Bridge Digsite"] = "Site de fouilles du Grand Pont",
	["Greenwarden's Fossil Bank"] = "Banc de fossiles du Gardien vert",
	["Grim Batol Digsite"] = "Site de fouilles de Grim Batol",
	["Grimesilt Digsite"] = "Site de fouilles de Crasseboue",
	["Grimsilt Digsite"] = "Site de fouilles de Crasseboue", -- Needs review
	["Grove of Aessina Digsite"] = "Site de fouilles du bosquet d'Aessina",
	["Grumblepaw Ranch Digsite"] = "Site de fouilles de la ferme Grogne Patte",
	["Gurubashi Arena Digsite"] = "Site de fouilles de l'arène des Gurubashi",
	["Halaa Digsite"] = "Site de fouilles d'Halaa",
	["Halgrind Digsite"] = "Site de fouilles de Halegrince",
	["Hammertoe's Digsite"] = "Site de fouilles de Martèlorteil",
	["Hatred's Vice Digsite"] = "Site de fouilles de l’Étau de la haine",
	["Hellfire Basin Digsite"] = "Site de fouilles du bassin des Flammes infernales",
	["Hellfire Citadel Digsite"] = "Site de fouilles de la citadelle Flammes infernales",
	["Humboldt Conflagration Digsite"] = "Site de fouilles de la déflagration de Humboldt",
	["Illidari Point Digsite"] = "Site de fouilles de la halte Illidari",
	["Infectis Scar Fossil Field"] = "Champ de fossiles de la Balafre infecte",
	["Ironband's Excavation Site"] = "Excavations de Baguefer",
	["Ironbeard's Tomb"] = "Tombe de Barbe-de-fer",
	["Ironwood Digsite"] = "Site de fouilles bois-de-fer",
	["Jade Temple Grounds Digsite"] = "Site de fouilles des jardins du Temple de jade",
	["Jaedenar Digsite"] = "Site de fouilles de Jaedenar",
	["Jintha'Alor Lower City Digsite"] = "Site de fouilles de la ville basse de Jinth'Alor",
	["Jintha'Alor Upper City Digsite"] = "Site de fouilles de la ville haute de Jinth'Alor",
	["Jotunheim Digsite"] = "Site de fouilles de Jotunheim",
	["Keset Pass Digsite"] = "Site de fouilles de la passe de Keset",
	["Khartut's Tomb Digsite"] = "Site de fouilles de la tombe de Khartut",
	["Kodo Graveyard"] = "Cimetière des Kodos",
	["Kolramas Digsite"] = "Site de fouilles de Kolramas",
	["Krasarang Wilds Digsite"] = "Site de fouilles des Étendues sauvages de Krasarang",
	["Kun-Lai Peak Digsite"] = "Site de fouilles du pic Kun-Lai",
	["Lake Kel'Theril Digsite"] = "Site de fouilles du lac Kel'Theril",
	["Lake of Stars Digsite"] = "Site de fouilles du lac aux Étoiles",
	["Lakeridge Highway Fossil Bank"] = "Banc de fossiles de la grand-route de la crête du Lac",
	["Laughing Skull Digsite"] = "Site de fouilles des ruines du Crâne ricanant",
	["Lost Dynasty Digsite"] = "Site de fouilles de la Dynastie perdue",
	["Lower Lakkari Tar Pits"] = "Fosses de goudron de Lakkari inférieures",
	["Mannoroc Coven Digsite"] = "Site de fouilles du convent de Mannoroc",
	["Marshlands Fossil Bank"] = "Banc de fossiles de la Fondrière",
	["Mistfall Village Digsite"] = "Site de fouilles de Tombe-Brume",
	["Misty Reed Fossil Bank"] = "Banc de fossiles de Brumejonc",
	["Moonrest Gardens Digsite"] = "Site de fouilles des jardins de Repos-de-Lune",
	["Morlos'Aran Digsite"] = "Site de fouilles de Morlos'Aran",
	["Nar'shola (Middle Tier) Digsite"] = "Site de fouilles de Nar'shola (étage du milieu)",
	["Nazj'vel Digsite"] = "Site de fouilles Nazj'vel",
	["Neferset Digsite"] = "Site de fouilles de Neferset",
	["Nek'mani Wellspring Digsite"] = "Site de fouilles de la fontaine des Nek'mani",
	["Nifflevar Digsite"] = "Site de fouilles de Nifflevar",
	["Nightmare Scar Digsite"] = "Site de fouilles de la balafre du Cauchemar",
	["Niuzao Temple Digsite"] = "Site de fouilles du temple de Niuzao",
	["Njorndar Village Digsite"] = "Site de fouilles de Njorndar",
	["North Fruited Fields Digsite"] = "Site de fouilles nord des champs Fruitiers",
	["North Great Wall Digsite"] = "Site de fouilles nord de la Grande Muraille",
	["North Isildien Digsite"] = "Site de fouilles d'Isildien nord",
	["Northridge Fossil Field"] = "Champ de fossiles de la crête du Nord",
	["North Ruins of Dojan Digsite"] = "Site de fouilles nord des ruines de Dojan",
	["North Ruins of Guo-Lai Digsite"] = "Site de fouilles nord des ruines de Guo-Lai",
	["North Summer Fields Digsite"] = "Site de fouilles nord des champs de l’Été",
	["North Temple of the Red Crane Digsite"] = "Site de fouilles nord du temple de la Grue rouge",
	["Obelisk of the Stars Digsite"] = "Site de fouilles de l'obélisque des Étoiles",
	["Old Village Digsite"] = "Site de fouilles du vieux village",
	["Oneiros Digsite"] = "Site de fouilles d'Oneiros",
	["Orchard Digsite"] = "Site de fouilles du verger",
	["Orsis Digsite"] = "Site de fouilles d'Orsis",
	["Owl Wing Thicket Digsite"] = "Site de fouilles du fourré de l'Aile de la chouette",
	["Paoquan Hollow Digsite"] = "Site de fouilles du creux de Paoquan",
	["Pit of Fiends Digsite"] = "Site de fouilles de la fosse aux Démons",
	["Pit of Narjun Digsite"] = "Site de fouilles de la fosse de Narjun",
	["Plaguewood Digsite"] = "Site de fouilles de Pestebois",
	["Pools of Purity Digsite"] = "Site de fouilles des bassins de la Pureté",
	["Pyrox Flats Digsite"] = "Site de fouilles de la plaine de Pyrox",
	["Quagmire Fossil Field"] = "Champ de fossiles du Bourbier",
	["Quel'Dormir Gardens Digsite"] = "Site de fouilles des jardins de Quel'Dormir",
	["Quel'Lithien Lodge Digsite"] = "Site de fouilles du gîte de Quel'Lithien",
	["Ravenwind Digsite"] = "Site de fouilles de Vent-du-Corbeau",
	["Red Reaches Fossil Bank"] = "Banc de fossiles des confins Rouges",
	["Remote Village Digsite"] = "Site de fouilles du village lointain",
	["Riplash Ruins Digsite"] = "Site de fouilles des ruines des Courcinglants",
	["River Delta Digsite"] = "Site de fouilles du delta du fleuve",
	["Ruins of Aboraz"] = "Ruines d'Aboraz",
	["Ruins of Ahmtul Digsite"] = "Site de fouilles des ruines d'Ahmtul",
	["Ruins of Ammon Digsite"] = "Site de fouilles des ruines d'Ammon",
	["Ruins of Arkkoran"] = "Ruines d'Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Site de fouilles des ruines de Baa'ri",
	["Ruins of Eldarath"] = "Ruines d'Eldarath",
	["Ruins of Eldre'Thar"] = "Ruines d'Eldre'Thar",
	["Ruins of Enkaat Digsite"] = "Site de fouilles des ruines d'Enkaat",
	["Ruins of Farahlon Digsite"] = "Site de fouilles des ruines de Farahlon",
	["Ruins of Gan Shi Digsite"] = "Site de fouilles des ruines de Gan Shi",
	["Ruins of Jubuwal"] = "Ruines de Jubuwal",
	["Ruins of Khintaset Digsite"] = "Site de fouilles des ruines de Khintaset",
	["Ruins of Korja Digsite"] = "Site de fouilles des ruines de Korja",
	["Ruins of Lar'donir Digsite"] = "Site de fouilles des ruines de Lar'donir",
	["Ruins of Ordil'Aran"] = "Ruines d'Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Site de fouilles des ruines de Shandaral",
	["Ruins of Stardust"] = "Ruines de Chimétoile",
	["Sahket Wastes Digsite"] = "Site de fouilles du désert de Sahket",
	["Sanctuary of Malorne Digsite"] = "Site de fouilles du sanctuaire de Malorne",
	["Sands of Nasam"] = "Sables de Nasam",
	["Sargeron Digsite"] = "Site de fouilles de Sargeron",
	["Savage Coast Raptor Fields"] = "Champs de raptors de la côte Sauvage",
	["Schnottz's Landing"] = "Accostage de Schnottz",
	["Scorched Plain Digsite"] = "Site de fouilles de la plaine Incendiée",
	["Scourgeholme Digsite"] = "Site de fouilles de Fléaulme",
	["Screaming Reaches Fossil Field"] = "Champ de fossile des confins Hurlants",
	["Setting Sun Garrison Digsite"] = "Site de fouilles de la garnison du Soleil couchant",
	["Shadra'Alor Digsite"] = "Site de fouilles de Shadra'Alor",
	["Sha'naar Digsite"] = "Site de fouilles de Sha'naar",
	["Shanze'Dao Digsite"] = "Site de fouilles mogu de Shanze’Dao",
	["Shield Hill Digsite"] = "Site de fouilles de la colline du Bouclier",
	["Shrine Meadow Digsite"] = "Site de fouilles de la prairie du Sanctuaire",
	["Shrine of Goldrinn Digsite"] = "Site de fouilles du sanctuaire de Goldrinn",
	["Shrine of the Dawn Digsite"] = "Site de fouilles du sanctuaire de l’Aube",
	["Sifreldar Village Digsite"] = "Site de fouilles de Sifreldar",
	["Singing Marshes Digsite"] = "Site de fouilles des marais Chantants",
	["Skorn Digsite"] = "Site de fouilles de Skorn",
	["Slitherblade Shore Digsite"] = "Site de fouilles du rivage des Ondulames",
	["Small Gate Digsite"] = "Site de fouilles de la petite porte",
	["Snow Covered Hills Digsite"] = "Site de fouilles des collines enneigées",
	["Solarsal Digsite"] = "Site de fouilles de Solarsal",
	["South Fruited Fields Digsite"] = "Site de fouilles sud des champs Fruitiers",
	["South Great Wall Digsite"] = "Site de fouilles sud de la Grande Muraille",
	["South Isildien Digsite"] = "Site de fouilles d'Isildien sud",
	["Southmoon Ruins Digsite"] = "Site de fouilles des ruines de Sudelune",
	["South Orchard Digsite"] = "Site de fouilles sud du verger",
	["South Ruins of Dojan Digsite"] = "Site de fouilles sud des ruines de Dojan",
	["South Ruins of Guo-Lai Digsite"] = "Site de fouilles sud des ruines de Guo-Lai",
	["Southshore Fossil Field"] = "Champ de fossiles d'Austrivage",
	["Southwind Village Digsite"] = "Site de fouilles de Sudevent",
	["Sra'thik Digsite"] = "Site de fouilles sra’thik",
	["Steps of Fate Digsite"] = "Site de fouilles des marches du Destin",
	["Stonetalon Peak"] = "Pic des Serres-Rocheuses",
	["Sunken Temple Digsite"] = "Site de fouilles du temple Englouti",
	["Sunspring Post Digsite"] = "Site de fouilles du poste de Berceau-de-l'Été",
	["Talramas Digsite"] = "Site de fouilles de Talramas",
	["Temple of Uldum Digsite"] = "Site de fouilles du temple d'Uldum",
	["Terrace of Gurthan Digsite"] = "Site de fouilles de la terrasse de Gurthan",
	["Terror Run Fossil Field"] = "Champ de fossiles des coteaux de la Terreur",
	["Terrorweb Tunnel Digsite"] = "Site de fouilles du tunnel de Tisse-terreur",
	["Terror Wing Fossil Field"] = "Champ de fossiles de l'Aile de la terreur",
	["Thandol Span"] = "Viaduc de Thandol",
	["The Arboretum Digsite"] = "Site de fouilles de l’Arboretum",
	["The Spring Road Digsite"] = "Site de fouilles de la coulée du Printemps",
	["Thoradin's Wall"] = "Mur de Thoradin",
	["Thundermar Ruins Digsite"] = "Site de fouilles des ruines de Tonnemar",
	["Thunderwood Digsite"] = "Site de fouilles du bois du Tonnerre",
	["Tian Digsite"] = "Site de fouilles de Tian",
	["Tiger's Wood Digsite"] = "Site de fouilles du bois du Tigre",
	["Tomb of the Watchers Digsite"] = "Site de fouilles du tombeau des Gardiens",
	["Tombs of the Precursors Digsite"] = "Site de fouilles des tombes des Précurseurs",
	["Torjari Pit Digsite"] = "Site de fouilles de la fosse Torjari",
	["Tu Shen Digsite"] = "Site de fouilles de Tu Shen",
	["Tuurem Digsite"] = "Site de fouilles de Tuurem",
	["Twilight Grove Digsite"] = "Site de fouilles du bosquet Crépusculaire",
	["Twin Spire Ruins Digsite"] = "Site de fouilles des ruines des Flèches jumelles",
	["Uldaman Entrance Digsite"] = "Site de fouilles de l'entrée d'Uldaman",
	["Unearthed Grounds"] = "Terres Exhumées",
	["Upper Lakkari Tar Pits"] = "Fosses de goudron de Lakkari supérieures",
	["Valkyrion Digsite"] = "Site de fouilles de Valkyrion",
	["Valley of Bones"] = "Vallée des Ossements",
	["Valley of Kings Digsite"] = "Site de fouilles de la vallée des Rois",
	["Veridian Grove Digsite"] = "Site de fouilles du Bosquet véridien",
	["Violet Stand Digsite"] = "Site de fouilles du séjour Pourpre",
	["Voldrune Digsite"] = "Site de fouilles de Voldrune",
	["Vul'Gol Fossil Bank"] = "Banc de fossiles de Vul'Gol",
	["Warden's Cage Digsite"] = "Site de fouilles de la Cage de la gardienne",
	["West Auchindoun Digsite"] = "Site de fouilles d'Auchindoun ouest",
	["Western Ruins of Thaurissan"] = "Ruines de Thaurissan ouest",
	["Western Zul'Kunda Digsite"] = "Site de fouilles de Zul'Kunda ouest",
	["Western Zul'Mamwe Digsite"] = "Site de fouilles de Zul'Mamwe ouest",
	["West Old Village Digsite"] = "Site de fouilles ouest du vieux village",
	["West Ruins of Guo-Lai Digsite"] = "Site de fouilles ouest de Guo-Lai",
	["West Summer Fields Digsite"] = "Site de fouilles ouest des champs de l’Été",
	["Whelgar's Excavation Site"] = "Excavations de Whelgar",
	["Winterbough Digsite"] = "Site de fouilles de Rameau-de-l’Hiver",
	["Witherbark Digsite"] = "Site de fouilles de Fanécorce",
	["Writhingwood Digsite"] = "Site de fouilles du bois Grouillant",
	["Wyrmbog Fossil Field"] = "Champ de fossiles de Tourbière du Ver",
	["Wyrmskull Digsite"] = "Site de fouilles de Crâne-du-ver",
	["Ymirheim Digsite"] = "Site de fouilles d'Ymirheim",
	["Zeth'Gor Digsite"] = "Site de fouilles de Zeth'Gor",
	["Zhu Province Digsite"] = "Site de fouilles de la province de Zhu",
	["Ziata'jai Digsite"] = "Site de fouilles de Ziata'jai",
	["Zim'Rhuk Digsite"] = "Site de fouilles de Zim'Rhuk",
	["Zol'Heb Digsite"] = "Site de fouilles de Zol'Heb",
	["Zoram Strand Digsite"] = "Site de fouilles de la grève de Zoram",
	["Zul'Farrak Digsite"] = "Site de fouilles de Zul'Farrak",
	["Zul'Mashar Digsite"] = "Site de fouilles de Zul'Mashar",
}
elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "끝없는 사막 화석 마루",
	["Aerie Peak Digsite"] = "맹금의 봉우리 발굴현장",
	["Agol'watha Digsite"] = "아골와타 발굴현장",
	["Akhenet Fields Digsite"] = "아케네트 농장 발굴현장",
	["Altar of Quetz'lun Digsite"] = "쿠에츠룬의 제단 발굴현장",
	["Altar of Sseratus Digsite"] = "세라투스의 제단 발굴현장",
	["Altar of Zul Digsite"] = "줄의 제단 발굴현장",
	["Ancestral Grounds Digsite"] = "선조의 터 발굴현장",
	["Andorhal Fossil Bank"] = "안돌할 화석 강둑",
	["Arklon Ruins Digsite"] = "알클론 폐허 발굴현장",
	["Bael Modan Digsite"] = "바엘 모단 발굴현장",
	["Baleheim Digsite"] = "베일하임 발굴현장",
	["Balia'mah Digsite"] = "발리아마 발굴현장",
	["Bal'lal Ruins Digsite"] = "발랄 폐허 발굴현장",
	["Biel'aran Ridge Digsite"] = "비엘아란 마루 발굴현장",
	["Bleeding Hollow Ruins Digsite"] = "피눈물 폐허 발굴현장",
	["Boha'mu Ruins Digsite"] = "보하무 폐허 발굴현장",
	["Bonechewer Ruins Digsite"] = "해골이빨 폐허 발굴현장",
	["Bone Wastes Digsite"] = "해골 무덤 발굴현장",
	["Broken Commons Digsite"] = "파괴된 광장 발굴현장",
	["Broken Pillar Digsite"] = "무너진 기둥 발굴현장",
	["Brunnhildar Village Digsite"] = "브룬힐다르 마을 발굴현장",
	["Burning Blade Digsite"] = "불타는 칼날단 발굴현장",
	["Chow Farmstead Digsite"] = "초우 농장 발굴현장",
	["Coilskar Point Digsite"] = "갈퀴흉터 거점 발굴현장",
	["Constellas Digsite"] = "콘스텔라스 발굴현장",
	["Cursed Landing Digsite"] = "저주받은 선착장 발굴현장",
	["Darkmist Digsite"] = "암흑안개 발굴현장",
	["Den of Sorrow Digsite"] = "슬픔의 동굴 발굴현장",
	["Destroyed Village Digsite"] = "파괴된 마을 발굴현장",
	["Dire Maul Digsite"] = "혈투의 전장 발굴현장",
	["Dragonmaw Fortress"] = "용아귀 요새",
	["Drakil'Jin Ruins Digsite"] = "드라킬진 폐허 발굴현장", -- Needs review
	["Dreadmaul Fossil Field"] = "우레망치 화석 벌판",
	["Dunemaul Fossil Ridge"] = "모래망치 화석 마루",
	["Dun Garok Digsite"] = "던 가록 발굴현장",
	["Dunwald Ruins Digsite"] = "둔왈트 폐허 발굴현장",
	["East Auchindoun Digsite"] = "아킨둔 동부 발굴현장",
	["Eastern Ruins of Thaurissan"] = "타우릿산의 폐허 동부",
	["Eastern Zul'Kunda Digsite"] = "동부 줄쿤다 발굴현장",
	["Eastern Zul'Mamwe Digsite"] = "동부 줄맘웨 발굴현장",
	["Eastmoon Ruins Digsite"] = "동쪽 달 폐허 발굴현장",
	["East Snow Covered Hills Digsite"] = "눈 덮인 언덕 동부 발굴현장",
	["East Summer Fields Digsite"] = "여름벌 동부 발굴현장",
	["Eclipse Point Digsite"] = "해그늘 주둔지 발굴현장",
	["Emperor's Approach Digsite"] = "황제의 진입로 발굴현장",
	["Emperor's Omen Digsite"] = "황제의 예언 발굴현장",
	["En'kilah Digsite"] = "엔킬라 발굴현장",
	["Ethel Rethor Digsite"] = "에텔 레소르 발굴현장",
	["Fallsong Village Digsite"] = "가을노래 마을 발굴현장",
	["Felstone Fossil Field"] = "펠스톤 화석 벌판",
	["Fields of Blood Fossil Bank"] = "피의 들판 화석 강둑",
	["Fire Camp Osul Digsite"] = "불의 야영지 오술 발굴현장",
	["Five Sisters Digsite"] = "다섯 자매 바위 발굴현장",
	["Forest Heart Digsite"] = "숲의 심장 발굴현장",
	["Forest Song Digsite"] = "숲의 노래 발굴현장",
	["Frostwhisper Gorge Digsite"] = "서리속삭임 골짜기 발굴현장",
	["Gate to Golden Valley Digsite"] = "황금 계곡 관문 발굴현장",
	["Gjalerbron Digsite"] = "샬레르브론 발굴현장",
	["Gong of Hope Digsite"] = "희망의 징 발굴현장",
	["Gor'gaz Outpost Digsite"] = "고르가즈 전초기지 발굴현장",
	["Grangol'var Village Digsite"] = "그란골바르 마을 발굴현장",
	["Great Bridge Digsite"] = "대교 발굴현장",
	["Greenwarden's Fossil Bank"] = "신록수호자의 화석 강둑",
	["Grim Batol Digsite"] = "그림 바톨 발굴현장",
	["Grimesilt Digsite"] = "검댕가루 발굴현", -- Needs review
	["Grimsilt Digsite"] = "검댕가루 발굴현장",
	["Grove of Aessina Digsite"] = "아에시나의 숲 발굴현장",
	["Grumblepaw Ranch Digsite"] = "그럼블포 농장 발굴현장",
	["Gurubashi Arena Digsite"] = "구루바시 투기장 발굴현장",
	["Halaa Digsite"] = "할라아 발굴현장",
	["Halgrind Digsite"] = "할그린드 발굴현장",
	["Hammertoe's Digsite"] = "해머토의 발굴현장",
	["Hatred's Vice Digsite"] = "증오의 소굴 발굴현장",
	["Hellfire Basin Digsite"] = "지옥불 분지 발굴현장",
	["Hellfire Citadel Digsite"] = "지옥불 성채 발굴현장",
	["Humboldt Conflagration Digsite"] = "훔볼트 불자리 발굴현장",
	["Illidari Point Digsite"] = "일리다리 거점 발굴현장",
	["Infectis Scar Fossil Field"] = "오염의 흉터 화석 벌판",
	["Ironband's Excavation Site"] = "아이언밴드의 발굴현장",
	["Ironbeard's Tomb"] = "아이언비어드의 고분",
	["Ironwood Digsite"] = "강철나무 발굴현장",
	["Jade Temple Grounds Digsite"] = "옥룡사 정원 발굴현장",
	["Jaedenar Digsite"] = "제데나르 발굴현장",
	["Jintha'Alor Lower City Digsite"] = "진타알로 하층부 발굴현장",
	["Jintha'Alor Upper City Digsite"] = "진타알로 상층부 발굴현장",
	["Jotunheim Digsite"] = "요툰하임 발굴현장",
	["Keset Pass Digsite"] = "케세트 고개 발굴현장",
	["Khartut's Tomb Digsite"] = "카르투트의 무덤 발굴현장",
	["Kodo Graveyard"] = "코도 무덤",
	["Kolramas Digsite"] = "콜라마스 발굴현장",
	["Krasarang Wilds Digsite"] = "크라사랑 밀림 발굴현장",
	["Kun-Lai Peak Digsite"] = "쿤라이 봉우리 발굴현장",
	["Lake Kel'Theril Digsite"] = "켈테릴 호수 발굴현장",
	["Lake of Stars Digsite"] = "별의 호수 발굴현장",
	["Lakeridge Highway Fossil Bank"] = "호수마루 오솔길 화석 강둑",
	["Laughing Skull Digsite"] = "웃는 해골 발굴현장",
	["Lost Dynasty Digsite"] = "잃어버린 왕조 발굴현장",
	["Lower Lakkari Tar Pits"] = "락카리 잿구덩이 하층",
	["Mannoroc Coven Digsite"] = "만노로크 소굴 발굴현장",
	["Marshlands Fossil Bank"] = "늪지대 화석 강둑",
	["Mistfall Village Digsite"] = "안개내림 마을 발굴현장",
	["Misty Reed Fossil Bank"] = "안개갈대 화석 강둑",
	["Moonrest Gardens Digsite"] = "달쉼터 정원 발굴현장",
	["Morlos'Aran Digsite"] = "모를로스아란 발굴현장",
	["Nar'shola (Middle Tier) Digsite"] = "나르숄라 중앙 지구 발굴현장",
	["Nazj'vel Digsite"] = "나즈벨 발굴현장",
	["Neferset Digsite"] = "네페르세트 발굴현장",
	["Nek'mani Wellspring Digsite"] = "네크마니 수원지 발굴현장",
	["Nifflevar Digsite"] = "니플바르 발굴현장",
	["Nightmare Scar Digsite"] = "악몽의 흉터 발굴현장",
	["Niuzao Temple Digsite"] = "니우짜오 사원 발굴현장",
	["Njorndar Village Digsite"] = "요른다르 마을 발굴현장",
	["North Fruited Fields Digsite"] = "결실의 땅 북부 발굴현장",
	["North Great Wall Digsite"] = "장벽 북부 발굴현장",
	["North Isildien Digsite"] = "이실디엔 북부 발굴현장",
	["Northridge Fossil Field"] = "북마루 화석 벌판",
	["North Ruins of Dojan Digsite"] = "도잔의 폐허 북부 발굴현장",
	["North Ruins of Guo-Lai Digsite"] = "구오라이 폐허 북부 발굴현장",
	["North Summer Fields Digsite"] = "여름벌 북부 발굴현장",
	["North Temple of the Red Crane Digsite"] = "주학사 북부 발굴현장",
	["Obelisk of the Stars Digsite"] = "별의 방첨탑 발굴현장",
	["Old Village Digsite"] = "옛 마을 발굴현장",
	["Oneiros Digsite"] = "오네이로스 발굴현장",
	["Orchard Digsite"] = "과수원 발굴현장",
	["Orsis Digsite"] = "오르시스 발굴현장",
	["Owl Wing Thicket Digsite"] = "올빼미날개 숲 발굴현장",
	["Paoquan Hollow Digsite"] = "파오취앤 대나무숲 발굴현장",
	["Pit of Fiends Digsite"] = "악마의 구덩이 발굴현장",
	["Pit of Narjun Digsite"] = "나르준의 구덩이 발굴현장",
	["Plaguewood Digsite"] = "역병숲 발굴현장",
	["Pools of Purity Digsite"] = "순수의 웅덩이 발굴현장",
	["Pyrox Flats Digsite"] = "휘석 평원 발굴현장",
	["Quagmire Fossil Field"] = "먼지 수렁 화석 벌판",
	["Quel'Dormir Gardens Digsite"] = "쿠엘도르미르 정원 발굴현장",
	["Quel'Lithien Lodge Digsite"] = "쿠엘리시엔 오두막 발굴현장",
	["Ravenwind Digsite"] = "까마귀바람 발굴현장",
	["Red Reaches Fossil Bank"] = "붉은 굽이 화석 강둑",
	["Remote Village Digsite"] = "외딴 마을 발굴현장",
	["Riplash Ruins Digsite"] = "채찍파도 폐허 발굴현장",
	["River Delta Digsite"] = "강 삼각주 발굴현장",
	["Ruins of Aboraz"] = "아보라즈의 폐허",
	["Ruins of Ahmtul Digsite"] = "암툴 폐허",
	["Ruins of Ammon Digsite"] = "암몬 폐허 발굴현장",
	["Ruins of Arkkoran"] = "아크코란의 폐허",
	["Ruins of Baa'ri Digsite"] = "바아리 폐허 발굴현장",
	["Ruins of Eldarath"] = "엘다라스 폐허",
	["Ruins of Eldre'Thar"] = "엘드레타르 폐허",
	["Ruins of Enkaat Digsite"] = "엔카트 폐허 발굴현장",
	["Ruins of Farahlon Digsite"] = "파랄론 폐허 발굴현장",
	["Ruins of Gan Shi Digsite"] = "간 스의 폐허 발굴현장",
	["Ruins of Jubuwal"] = "주부왈의 폐허",
	["Ruins of Khintaset Digsite"] = "킨타세트 폐허 발굴현장",
	["Ruins of Korja Digsite"] = "코르자의 폐허 발굴현장",
	["Ruins of Lar'donir Digsite"] = "라르도니르 폐허 발굴현장",
	["Ruins of Ordil'Aran"] = "오르딜아란의 폐허",
	["Ruins of Shandaral Digsite"] = "샨다랄 폐허 발굴현장",
	["Ruins of Stardust"] = "별가루의 폐허",
	["Sahket Wastes Digsite"] = "사케트 황무지 발굴현장",
	["Sanctuary of Malorne Digsite"] = "말로른의 성역 발굴현장",
	["Sands of Nasam"] = "나삼의 갯벌",
	["Sargeron Digsite"] = "살게론 발굴현장",
	["Savage Coast Raptor Fields"] = "폭풍 해안 랩터 벌판",
	["Schnottz's Landing"] = "슈노츠 비행기지",
	["Scorched Plain Digsite"] = "불타버린 평원 발굴현장",
	["Scourgeholme Digsite"] = "스컬지홀름 발굴현장",
	["Screaming Reaches Fossil Field"] = "비명굽이 산마루 화석 벌판",
	["Setting Sun Garrison Digsite"] = "석양 주둔지 발굴현장",
	["Shadra'Alor Digsite"] = "샤드라알로 발굴현장",
	["Sha'naar Digsite"] = "샤나르 발굴현장",
	["Shanze'Dao Digsite"] = "샨쩌 다오 발굴현장",
	["Shield Hill Digsite"] = "방패 언덕 발굴현장",
	["Shrine Meadow Digsite"] = "제단 초원 발굴현장",
	["Shrine of Goldrinn Digsite"] = "골드린의 제단 발굴현장",
	["Shrine of the Dawn Digsite"] = "새벽의 제단 발굴현장",
	["Sifreldar Village Digsite"] = "시프렐다르 마을 발굴현장",
	["Singing Marshes Digsite"] = "노래하는 습지대 발굴현장",
	["Skorn Digsite"] = "스코른 발굴현장",
	["Slitherblade Shore Digsite"] = "뱀갈퀴 해안 발굴현장",
	["Small Gate Digsite"] = "작은 관문 발굴현장",
	["Snow Covered Hills Digsite"] = "눈 덮인 언덕 발굴현장",
	["Solarsal Digsite"] = "솔라살 발굴현장",
	["South Fruited Fields Digsite"] = "결실의 땅 남부 발굴현장",
	["South Great Wall Digsite"] = "장벽 남부 발굴현장",
	["South Isildien Digsite"] = "이실디엔 남부 발굴현장",
	["Southmoon Ruins Digsite"] = "남쪽 달 폐허 발굴현장",
	["South Orchard Digsite"] = "과수원 남부 발굴현장",
	["South Ruins of Dojan Digsite"] = "도잔의 폐허 남부 발굴현장",
	["South Ruins of Guo-Lai Digsite"] = "구오라이 폐허 남부 발굴현장",
	["Southshore Fossil Field"] = "남녘해안 화석 벌판",
	["Southwind Village Digsite"] = "마파람 마을 발굴현장",
	["Sra'thik Digsite"] = "스라티크 발굴현장",
	["Steps of Fate Digsite"] = "운명의 계단 발굴현장",
	["Stonetalon Peak"] = "돌발톱 봉우리",
	["Sunken Temple Digsite"] = "가라앉은 사원 발굴현장",
	["Sunspring Post Digsite"] = "태양여울 주둔지 발굴현장",
	["Talramas Digsite"] = "탈라마스 발굴현장",
	["Temple of Uldum Digsite"] = "울둠 사원 발굴현장",
	["Terrace of Gurthan Digsite"] = "구르단 정원 발굴현장",
	["Terror Run Fossil Field"] = "공포의 터 화석 벌판",
	["Terrorweb Tunnel Digsite"] = "공포의 거미굴 발굴현장",
	["Terror Wing Fossil Field"] = "공포의 날개 화석 벌판",
	["Thandol Span"] = "탄돌 교각",
	["The Arboretum Digsite"] = "도원 발굴현장",
	["The Spring Road Digsite"] = "봄길 발굴현장",
	["Thoradin's Wall"] = "소라딘의 성벽",
	["Thundermar Ruins Digsite"] = "썬더마 폐허 발굴현장",
	["Thunderwood Digsite"] = "천둥숲 발굴현장",
	["Tian Digsite"] = "티엔 발굴현장",
	["Tiger's Wood Digsite"] = "호랑이숲 발굴현장",
	["Tomb of the Watchers Digsite"] = "감시자의 무덤 발굴현장",
	["Tombs of the Precursors Digsite"] = "선도자의 무덤 발굴현장",
	["Torjari Pit Digsite"] = "토자리 구덩이 발굴현장",
	["Tu Shen Digsite"] = "투 셴 발굴현장",
	["Tuurem Digsite"] = "투렘 발굴현장",
	["Twilight Grove Digsite"] = "황혼의 숲 발굴현장",
	["Twin Spire Ruins Digsite"] = "쌍둥이 첨탑 폐허 발굴현장",
	["Uldaman Entrance Digsite"] = "울다만 입구 발굴현장",
	["Unearthed Grounds"] = "발굴된 땅",
	["Upper Lakkari Tar Pits"] = "락카리 잿구덩이 상층",
	["Valkyrion Digsite"] = "발키리온 발굴현장",
	["Valley of Bones"] = "뼈의 골짜기",
	["Valley of Kings Digsite"] = "왕의 계곡 발굴현장",
	["Veridian Grove Digsite"] = "청록 숲 발굴현장",
	["Violet Stand Digsite"] = "보랏빛 단 발굴현장",
	["Voldrune Digsite"] = "볼드룬 발굴현장",
	["Vul'Gol Fossil Bank"] = "벌골 화석 강둑",
	["Warden's Cage Digsite"] = "감시자의 수용소 발굴현장",
	["West Auchindoun Digsite"] = "아킨둔 서부 발굴현장",
	["Western Ruins of Thaurissan"] = "타우릿산의 폐허 서부",
	["Western Zul'Kunda Digsite"] = "서부 줄쿤다 발굴현장",
	["Western Zul'Mamwe Digsite"] = "서부 줄맘웨 발굴현장",
	["West Old Village Digsite"] = "옛 마을 서부 발굴현장",
	["West Ruins of Guo-Lai Digsite"] = "구오라이 폐허 서부 발굴현장",
	["West Summer Fields Digsite"] = "여름벌 서부 발굴현장",
	["Whelgar's Excavation Site"] = "웰가르의 발굴현장",
	["Winterbough Digsite"] = "겨울가지 발굴현장",
	["Witherbark Digsite"] = "마른나무껍질 발굴현장",
	["Writhingwood Digsite"] = "고통숲 발굴현장",
	["Wyrmbog Fossil Field"] = "용의 둥지 화석 벌판",
	["Wyrmskull Digsite"] = "고룡해골 발굴현장",
	["Ymirheim Digsite"] = "이미르하임 발굴현장",
	["Zeth'Gor Digsite"] = "제스고르 발굴현장",
	["Zhu Province Digsite"] = "쥬 지구 발굴현장",
	["Ziata'jai Digsite"] = "지아타자이 발굴현장",
	["Zim'Rhuk Digsite"] = "짐루크 발굴현장",
	["Zol'Heb Digsite"] = "졸헤브 발굴현장",
	["Zoram Strand Digsite"] = "조람 해안 발굴현장",
	["Zul'Farrak Digsite"] = "줄파락 발굴현장",
	["Zul'Mashar Digsite"] = "줄마샤르 발굴현장",
}
elseif GAME_LOCALE == "esES" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Cresta de fósiles de las Arenas Abisales", -- Needs review
	["Aerie Peak Digsite"] = "Excavación de Pico Nidal", -- Needs review
	["Agol'watha Digsite"] = "Excavación de Agol'watha",
	["Akhenet Fields Digsite"] = "Excavación de los Campos de Akhenet",
	["Altar of Quetz'lun Digsite"] = "Excavación del Altar de Quetz'lun",
	["Altar of Sseratus Digsite"] = "Excavación del Altar de Sseratus",
	["Altar of Zul Digsite"] = "Excavación de El Altar de Zul", -- Needs review
	["Ancestral Grounds Digsite"] = "Excavación de las Tierras Ancestrales",
	["Andorhal Fossil Bank"] = "Banco de fósiles de Andorhal",
	["Arklon Ruins Digsite"] = "Excavación de las Ruinas Arklon",
	["Bael Modan Digsite"] = "Excavación de Bael Modan",
	["Baleheim Digsite"] = "Excavación de Baleheim",
	["Balia'mah Digsite"] = "Excavación de Balia'mah",
	["Bal'lal Ruins Digsite"] = "Excavación de la Ruina de Bal'lal",
	["Biel'aran Ridge Digsite"] = "Excavación de la Cresta Biel'aran",
	["Bleeding Hollow Ruins Digsite"] = "Excavación de las Ruinas Foso Sangrante",
	["Boha'mu Ruins Digsite"] = "Excavación de las Ruinas Boha'mu",
	["Bonechewer Ruins Digsite"] = "Excavación de las Ruinas Mascahuesos",
	["Bone Wastes Digsite"] = "Excavación de El Vertedero de Huesos",
	["Broken Commons Digsite"] = "Excavación de la Ágora",
	["Broken Pillar Digsite"] = "Excavación del Pilar Partido",
	["Brunnhildar Village Digsite"] = "Excavación del Poblado Brunnhildar",
	["Burning Blade Digsite"] = "Excavación de las Ruinas Filo Ardiente",
	["Chow Farmstead Digsite"] = "Excavación de la Granja de Tallarín",
	["Coilskar Point Digsite"] = "Excavación del Alto Cicatriz Espiral",
	["Constellas Digsite"] = "Excavación de Constellas",
	["Cursed Landing Digsite"] = "Excavación de El Embarcadero Maldito",
	["Darkmist Digsite"] = "Excavación de Niebla Negra",
	["Den of Sorrow Digsite"] = "Excavación de la Guarida del Pesar",
	["Destroyed Village Digsite"] = "Excavación de la Aldea Derruida",
	["Dire Maul Digsite"] = "Excavación de La Masacre",
	["Dragonmaw Fortress"] = "Fortaleza Faucedraco",
	["Drakil'Jin Ruins Digsite"] = "Excavación de las Ruinas de Drakil'Jin", -- Needs review
	["Dreadmaul Fossil Field"] = "Campo de fósiles Machacamiedo",
	["Dunemaul Fossil Ridge"] = "Cresta de fósiles de Machacaduna",
	["Dun Garok Digsite"] = "Excavación de Dun Garok",
	["Dunwald Ruins Digsite"] = "Excavación de las Ruinas Montocre",
	["East Auchindoun Digsite"] = "Excavación de Auchindoun oriental",
	["Eastern Ruins of Thaurissan"] = "Ruinas de Thaurissan del Este",
	["Eastern Zul'Kunda Digsite"] = "Excavación de Zul'Kunda del Este",
	["Eastern Zul'Mamwe Digsite"] = "Excavación de Zul'Mamwe del Este",
	["Eastmoon Ruins Digsite"] = "Excavación de las Ruinas de Lunaeste",
	["East Snow Covered Hills Digsite"] = "Excavación del este de las Colinas Nevadas",
	["East Summer Fields Digsite"] = "Excavación este de Los Campos Estivales",
	["Eclipse Point Digsite"] = "Excavación de Punta Eclipse",
	["Emperor's Approach Digsite"] = "Excavación de La Vía del Emperador",
	["Emperor's Omen Digsite"] = "Excavación del Augurio del Emperador",
	["En'kilah Digsite"] = "Excavación de En'kilah",
	["Ethel Rethor Digsite"] = "Excavación de Ethel Rethor",
	["Fallsong Village Digsite"] = "Excavación del Poblado Canción de Otoño",
	["Felstone Fossil Field"] = "Campo de fósiles Piedramácula",
	["Fields of Blood Fossil Bank"] = "Banco de fósiles de los Campos de Sangre",
	["Fire Camp Osul Digsite"] = "Excavación del Campamento Osul",
	["Five Sisters Digsite"] = "Excavación de Las Cinco Hermanas",
	["Forest Heart Digsite"] = "Excavación del Corazón del Bosque",
	["Forest Song Digsite"] = "Excavación de la Canción del Bosque",
	["Frostwhisper Gorge Digsite"] = "Excavación del Cañón Levescarcha",
	["Gate to Golden Valley Digsite"] = "Excavación de la Puerta del Valle Dorado",
	["Gjalerbron Digsite"] = "Excavación de Gjalerbron",
	["Gong of Hope Digsite"] = "Excavación de El Gong de la Esperanza",
	["Gor'gaz Outpost Digsite"] = "Excavación de la Avanzada Gor'gaz",
	["Grangol'var Village Digsite"] = "Excavación del Poblado Grangol'var",
	["Great Bridge Digsite"] = "Excavación del Gran Puente",
	["Greenwarden's Fossil Bank"] = "Banco de fósiles del Guardaverde",
	["Grim Batol Digsite"] = "Excavación de Grim Batol",
	["Grimesilt Digsite"] = "Excavación de Limugre",
	["Grimsilt Digsite"] = "Excavación de Limugre",
	["Grove of Aessina Digsite"] = "Excavación de la Arboleda de Aessina",
	["Grumblepaw Ranch Digsite"] = "Excavación del Rancho Zarpa Rumiante",
	["Gurubashi Arena Digsite"] = "Excavación de la Arena Gurubashi",
	["Halaa Digsite"] = "Excavación de Halaa",
	["Halgrind Digsite"] = "Excavación de Haltorboll",
	["Hammertoe's Digsite"] = "Excavación de Piemartillo",
	["Hatred's Vice Digsite"] = "Excavación de la Corrupción del Odio",
	["Hellfire Basin Digsite"] = "Excavación de la Cuenca del Fuego Infernal",
	["Hellfire Citadel Digsite"] = "Excavación de la Ciudadela del Fuego Infernal",
	["Humboldt Conflagration Digsite"] = "Excavación de la Conflagración de Humboldt",
	["Illidari Point Digsite"] = "Excavación del Alto Illidari",
	["Infectis Scar Fossil Field"] = "Campo de fósiles de La Cicatriz Purulenta",
	["Ironband's Excavation Site"] = "Excavación de Vetaferro",
	["Ironbeard's Tomb"] = "Tumba de Barbaférrea",
	["Ironwood Digsite"] = "Excavación de maderaférrea", -- Needs review
	["Jade Temple Grounds Digsite"] = "Excavación de las Tierras del Templo de Jade",
	["Jaedenar Digsite"] = "Excavación de Jaedenar",
	["Jintha'Alor Lower City Digsite"] = "Excavación de la parte baja de Jintha'Alor",
	["Jintha'Alor Upper City Digsite"] = "Excavación de la parte alta de Jintha'Alor",
	["Jotunheim Digsite"] = "Excavación de Jotunheim",
	["Keset Pass Digsite"] = "Excavación del Paso de Keset",
	["Khartut's Tomb Digsite"] = "Excavación de la Tumba de Khartut",
	["Kodo Graveyard"] = "Cementerio de Kodos",
	["Kolramas Digsite"] = "Excavación de Kolramas",
	["Krasarang Wilds Digsite"] = "Excavación de la Espesura Krasarang",
	["Kun-Lai Peak Digsite"] = "Excavación del Pico Kun-Lai",
	["Lake Kel'Theril Digsite"] = "Excavación del Lago Kel'Theril",
	["Lake of Stars Digsite"] = "Excavación del Lago de los Astros",
	["Lakeridge Highway Fossil Bank"] = "Banco de fósiles del Camino del Lago",
	["Laughing Skull Digsite"] = "Excavación de las Ruinas Riecráneos",
	["Lost Dynasty Digsite"] = "Excavación de la Dinastía Perdida",
	["Lower Lakkari Tar Pits"] = "Fosas de Alquitrán inferiores",
	["Mannoroc Coven Digsite"] = "Excavación del Aquelarre Mannoroc",
	["Marshlands Fossil Bank"] = "Banco de fósiles de Los Pantanales",
	["Mistfall Village Digsite"] = "Excavación de la Aldea Bruma Otoñal",
	["Misty Reed Fossil Bank"] = "Banco de fósiles de Juncobruma",
	["Moonrest Gardens Digsite"] = "Excavación de los Jardines Reposo Lunar",
	["Morlos'Aran Digsite"] = "Excavación de Morlos'Aran",
	["Nar'shola (Middle Tier) Digsite"] = "Excavación de Nar'shola (nivel medio)",
	["Nazj'vel Digsite"] = "Excavación de Nazj'vel",
	["Neferset Digsite"] = "Excavación de Neferset",
	["Nek'mani Wellspring Digsite"] = "Excavación del Manantial Nek'mani",
	["Nifflevar Digsite"] = "Excavación de Nifflevar",
	["Nightmare Scar Digsite"] = "Excavación del Paraje Pesadilla",
	["Niuzao Temple Digsite"] = "Excavación del Templo de Niuzao",
	["Njorndar Village Digsite"] = "Excavación del Poblado Njorndar",
	["North Fruited Fields Digsite"] = "Excavación norte de Los Cultivos Florecientes",
	["North Great Wall Digsite"] = "Excavación norte de la Gran Muralla",
	["North Isildien Digsite"] = "Excavación de Isildien norte",
	["Northridge Fossil Field"] = "Campo de fósiles Crestanorte",
	["North Ruins of Dojan Digsite"] = "Excavación norte de las Ruinas de Dojan",
	["North Ruins of Guo-Lai Digsite"] = "Excavación norte de las Ruinas de Guo-Lai",
	["North Summer Fields Digsite"] = "Excavación norte de Los Campos Estivales",
	["North Temple of the Red Crane Digsite"] = "Excavación norte del Templo de la Grulla Roja",
	["Obelisk of the Stars Digsite"] = "Excavación del Obelisco de las Estrellas",
	["Old Village Digsite"] = "Excavación de la Antigua Aldea",
	["Oneiros Digsite"] = "Excavación de Oneiros",
	["Orchard Digsite"] = "Excavación del Huerto",
	["Orsis Digsite"] = "Excavación de Orsis",
	["Owl Wing Thicket Digsite"] = "Excavación del Matorral del Ala del Búho",
	["Paoquan Hollow Digsite"] = "Excavación de la Espesura Paoquan",
	["Pit of Fiends Digsite"] = "Excavación de El Foso de los Mefistos", -- Needs review
	["Pit of Narjun Digsite"] = "Excavación de El Foso de Narjun",
	["Plaguewood Digsite"] = "Excavación del Bosque de la Peste",
	["Pools of Purity Digsite"] = "Excavación de las Pozas de la Pureza",
	["Pyrox Flats Digsite"] = "Excavación de Llanos de Pirox",
	["Quagmire Fossil Field"] = "Campo de fósiles de El Lodazal",
	["Quel'Dormir Gardens Digsite"] = "Excavación de los Jardines de Quel'Dormir",
	["Quel'Lithien Lodge Digsite"] = "Excavación del Refugio Quel'Lithien",
	["Ravenwind Digsite"] = "Excavación de las Ruinas de Viento Azabache",
	["Red Reaches Fossil Bank"] = "Banco de fósiles de Las Costas Rojas",
	["Remote Village Digsite"] = "Excavación de la Aldea Remota",
	["Riplash Ruins Digsite"] = "Excavación de las Ruinas Tralladón",
	["River Delta Digsite"] = "Excavación del Delta", -- Needs review
	["Ruins of Aboraz"] = "Ruinas de Aboraz",
	["Ruins of Ahmtul Digsite"] = "Excavación de las Ruinas de Ahmtul",
	["Ruins of Ammon Digsite"] = "Excavación de las Ruinas de Ammon",
	["Ruins of Arkkoran"] = "Ruinas de Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Excavación de las Ruinas de Baa'ri",
	["Ruins of Eldarath"] = "Ruinas de Eldarath",
	["Ruins of Eldre'Thar"] = "Ruinas de Eldre'thar",
	["Ruins of Enkaat Digsite"] = "Excavación de las Ruinas de Enkaat",
	["Ruins of Farahlon Digsite"] = "Excavación de las Ruinas de Farahlon",
	["Ruins of Gan Shi Digsite"] = "Excavación de las Ruinas de Gan Shi",
	["Ruins of Jubuwal"] = "Ruinas de Jubuwal",
	["Ruins of Khintaset Digsite"] = "Excavación de las Ruinas de Khintaset",
	["Ruins of Korja Digsite"] = "Excavación de las Ruinas de Korja",
	["Ruins of Lar'donir Digsite"] = "Excavación de las Ruinas de Lar'donir",
	["Ruins of Ordil'Aran"] = "Las Ruinas de Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Excavación de las Ruinas de Shandaral",
	["Ruins of Stardust"] = "Las Ruinas del Polvo Estelar",
	["Sahket Wastes Digsite"] = "Excavación de las Ruinas de Sahket",
	["Sanctuary of Malorne Digsite"] = "Excavación del Santuario de Malorne",
	["Sands of Nasam"] = "Arenas de Nasam",
	["Sargeron Digsite"] = "Excavación de Sargeron",
	["Savage Coast Raptor Fields"] = "Campos de raptores de La Costa Salvaje",
	["Schnottz's Landing"] = "Embarcadero de Schnottz",
	["Scorched Plain Digsite"] = "Excavación de La Llanura Agostada",
	["Scourgeholme Digsite"] = "Excavación de la Ciudad de la Plaga",
	["Screaming Reaches Fossil Field"] = "Campo de fósiles de la Cuenca de los Gritos",
	["Setting Sun Garrison Digsite"] = "Excavación del Baluarte del Sol Poniente",
	["Shadra'Alor Digsite"] = "Excavación de Shadra'Alor",
	["Sha'naar Digsite"] = "Excavación de Sha'naar",
	["Shanze'Dao Digsite"] = "Excavación de Shanze'Dao",
	["Shield Hill Digsite"] = "Excavación de la Colina Escudo",
	["Shrine Meadow Digsite"] = "Excavación del Prado Santuario",
	["Shrine of Goldrinn Digsite"] = "Excavación del Santuario de Goldrinn",
	["Shrine of the Dawn Digsite"] = "Excavación del Santuario del Alba",
	["Sifreldar Village Digsite"] = "Excavación del Poblado Sifreldar",
	["Singing Marshes Digsite"] = "Excavación del Marjal Exótico",
	["Skorn Digsite"] = "Excavación de Skorn",
	["Slitherblade Shore Digsite"] = "Excavación de la Costa Filozante",
	["Small Gate Digsite"] = "Excavación de la Puerta Pequeña",
	["Snow Covered Hills Digsite"] = "Excavación de las Colinas Nevadas",
	["Solarsal Digsite"] = "Excavación de Solarsal",
	["South Fruited Fields Digsite"] = "Excavación sur de Los Cultivos Florecientes",
	["South Great Wall Digsite"] = "Excavación sur de la Gran Muralla",
	["South Isildien Digsite"] = "Excavación de Isildien sur",
	["Southmoon Ruins Digsite"] = "Excavación de las Ruinas de Lunasur",
	["South Orchard Digsite"] = "Excavación del Huerto del sur",
	["South Ruins of Dojan Digsite"] = "Excavación sur de las Ruinas de Dojan",
	["South Ruins of Guo-Lai Digsite"] = "Excavación sur de las Ruinas de Guo-Lai",
	["Southshore Fossil Field"] = "Campo de fósiles de Costasur",
	["Southwind Village Digsite"] = "Excavación de la Aldea del Viento del Sur",
	["Sra'thik Digsite"] = "Excavación Sra'thik",
	["Steps of Fate Digsite"] = "Excavación de Los Pasos del Sino",
	["Stonetalon Peak"] = "Cima del Espolón",
	["Sunken Temple Digsite"] = "Excavación del Templo Sumergido",
	["Sunspring Post Digsite"] = "Excavación del Puesto Primasol",
	["Talramas Digsite"] = "Excavación de Talramas",
	["Temple of Uldum Digsite"] = "Excavación del Templo de Uldum",
	["Terrace of Gurthan Digsite"] = "Excavación del Bancal Gurthan",
	["Terror Run Fossil Field"] = "Campo de fósiles del Camino del Terror",
	["Terrorweb Tunnel Digsite"] = "Excavación del Túnel Terroarácnido", -- Needs review
	["Terror Wing Fossil Field"] = "Campo de fósiles del Ala del Terror",
	["Thandol Span"] = "Puente Thandol",
	["The Arboretum Digsite"] = "Excavación de El Arboretum",
	["The Spring Road Digsite"] = "Excavación de La Senda Florida",
	["Thoradin's Wall"] = "Muralla de Thoradin",
	["Thundermar Ruins Digsite"] = "Excavación de las Ruinas de Bramal",
	["Thunderwood Digsite"] = "Excavación de El Bosque del Trueno",
	["Tian Digsite"] = "Excavación de Tian",
	["Tiger's Wood Digsite"] = "Excavación de El Bosque del Tigre",
	["Tomb of the Watchers Digsite"] = "Excavación de la Tumba de los Vigías",
	["Tombs of the Precursors Digsite"] = "Excavación de las Tumbas de los Precursores",
	["Torjari Pit Digsite"] = "Excavación de La Fosa Torjari",
	["Tu Shen Digsite"] = "Excavación de Tu Shen",
	["Tuurem Digsite"] = "Excavación de Tuurem",
	["Twilight Grove Digsite"] = "Excavación de la Arboleda del Crepúsculo",
	["Twin Spire Ruins Digsite"] = "Excavación de las Ruinas de las Agujas Gemelas",
	["Uldaman Entrance Digsite"] = "Excavación de la Entrada de Uldaman",
	["Unearthed Grounds"] = "Campos Desenterrados",
	["Upper Lakkari Tar Pits"] = "Fosas de Alquitrán superiores",
	["Valkyrion Digsite"] = "Excavación de Valkyrion",
	["Valley of Bones"] = "Valle de los Huesos",
	["Valley of Kings Digsite"] = "Excavación del Valle de los Reyes",
	["Veridian Grove Digsite"] = "Excavación de la Arboleda Veridiana",
	["Violet Stand Digsite"] = "Excavación de El Confín Violeta",
	["Voldrune Digsite"] = "Excavación de Runavold",
	["Vul'Gol Fossil Bank"] = "Banco de fósiles de Vul'Gol",
	["Warden's Cage Digsite"] = "Excavación de la Jaula de la Guardiana",
	["West Auchindoun Digsite"] = "Excavación de Auchindoun occidental",
	["Western Ruins of Thaurissan"] = "Ruinas de Thaurissan del Oeste",
	["Western Zul'Kunda Digsite"] = "Excavación de Zul'Kunda del Oeste",
	["Western Zul'Mamwe Digsite"] = "Excavación de Zul'Mamwe del Oeste",
	["West Old Village Digsite"] = "Excavación del oeste de la Antigua Aldea",
	["West Ruins of Guo-Lai Digsite"] = "Excavación oeste de Guo-Lai",
	["West Summer Fields Digsite"] = "Excavación oeste de Los Campos Estivales",
	["Whelgar's Excavation Site"] = "Excavación de Whelgar",
	["Winterbough Digsite"] = "Excavación de Brote Invernal",
	["Witherbark Digsite"] = "Excavación Secacorteza",
	["Writhingwood Digsite"] = "Excavación de Bosquetormento",
	["Wyrmbog Fossil Field"] = "Campo de fósiles de Ciénaga de Fuego",
	["Wyrmskull Digsite"] = "Excavación de Calavermis",
	["Ymirheim Digsite"] = "Excavación de Ymirheim",
	["Zeth'Gor Digsite"] = "Excavación de Zeth'Gor",
	["Zhu Province Digsite"] = "Excavación de la Provincia Zhu",
	["Ziata'jai Digsite"] = "Excavación de Ziata'jai",
	["Zim'Rhuk Digsite"] = "Excavación de Zim'Rhuk",
	["Zol'Heb Digsite"] = "Excavación de Zol'Heb",
	["Zoram Strand Digsite"] = "Excavación de La Ensenada de Zoram",
	["Zul'Farrak Digsite"] = "Excavación de Zul'Farrak",
	["Zul'Mashar Digsite"] = "Excavación de Zul'Mashar",
}
elseif GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Cresta de fósiles de las Arenas Abisales",
	["Aerie Peak Digsite"] = "Excavación de Pico Nidal",
	["Agol'watha Digsite"] = "Excavación de Agol'watha",
	["Akhenet Fields Digsite"] = "Excavación de los Campos de Akhenet",
	["Altar of Quetz'lun Digsite"] = "Excavación del Altar de Quetz'lun",
	["Altar of Sseratus Digsite"] = "Excavación del Altar de Sseratus",
	["Altar of Zul Digsite"] = "Excavación de El Altar de Zul",
	["Ancestral Grounds Digsite"] = "Excavación de las Tierras Ancestrales",
	["Andorhal Fossil Bank"] = "Banco de fósiles de Andorhal",
	["Arklon Ruins Digsite"] = "Excavación de las Ruinas Arklon",
	["Bael Modan Digsite"] = "Excavación de Bael Modan",
	["Baleheim Digsite"] = "Excavación de Baleheim",
	["Balia'mah Digsite"] = "Excavación de Balia'mah",
	["Bal'lal Ruins Digsite"] = "Excavación de la Ruina de Bal'lal",
	["Biel'aran Ridge Digsite"] = "Excavación de la Cresta Biel'aran",
	["Bleeding Hollow Ruins Digsite"] = "Excavación de las Ruinas Foso Sangrante",
	["Boha'mu Ruins Digsite"] = "Excavación de las Ruinas Boha'mu",
	["Bonechewer Ruins Digsite"] = "Excavación de las Ruinas Mascahuesos",
	["Bone Wastes Digsite"] = "Excavación de El Vertedero de Huesos",
	["Broken Commons Digsite"] = "Excavación de la Ágora",
	["Broken Pillar Digsite"] = "Excavación del Pilar Partido",
	["Brunnhildar Village Digsite"] = "Excavación del Poblado Brunnhildar",
	["Burning Blade Digsite"] = "Excavación de las Ruinas Filo Ardiente",
	["Chow Farmstead Digsite"] = "Excavación de la Granja de Tallarín",
	["Coilskar Point Digsite"] = "Excavación del Alto Cicatriz Espiral",
	["Constellas Digsite"] = "Excavación de Constellas",
	["Cursed Landing Digsite"] = "Excavación de El Embarcadero Maldito",
	["Darkmist Digsite"] = "Excavación de Niebla Negra",
	["Den of Sorrow Digsite"] = "Excavación de la Guarida del Pesar",
	["Destroyed Village Digsite"] = "Excavación de la Aldea Derruida",
	["Dire Maul Digsite"] = "Excavación de La Masacre",
	["Dragonmaw Fortress"] = "Fortaleza Faucedraco",
	["Drakil'Jin Ruins Digsite"] = "Excavación de las Ruinas de Drakil'Jin",
	["Dreadmaul Fossil Field"] = "Campo de fósiles Machacamiedo",
	["Dunemaul Fossil Ridge"] = "Cresta de fósiles de Machacaduna",
	["Dun Garok Digsite"] = "Excavación de Dun Garok",
	["Dunwald Ruins Digsite"] = "Excavación de las Ruinas Montocre",
	["East Auchindoun Digsite"] = "Excavación de Auchindoun oriental",
	["Eastern Ruins of Thaurissan"] = "Ruinas de Thaurissan del Este",
	["Eastern Zul'Kunda Digsite"] = "Excavación de Zul'Kunda del Este",
	["Eastern Zul'Mamwe Digsite"] = "Excavación de Zul'Mamwe del Este",
	["Eastmoon Ruins Digsite"] = "Excavación de las Ruinas de Lunaeste",
	["East Snow Covered Hills Digsite"] = "Excavación del este de las Colinas Nevadas",
	["East Summer Fields Digsite"] = "Excavación este de Los Campos Estivales",
	["Eclipse Point Digsite"] = "Excavación de Punta Eclipse",
	["Emperor's Approach Digsite"] = "Excavación de La Vía del Emperador",
	["Emperor's Omen Digsite"] = "Excavación del Augurio del Emperador",
	["En'kilah Digsite"] = "Excavación de En'kilah",
	["Ethel Rethor Digsite"] = "Excavación de Ethel Rethor",
	["Fallsong Village Digsite"] = "Excavación del Poblado Canción de Otoño",
	["Felstone Fossil Field"] = "Campo de fósiles Piedramácula",
	["Fields of Blood Fossil Bank"] = "Banco de fósiles de los Campos de Sangre",
	["Fire Camp Osul Digsite"] = "Excavación del Campamento Osul",
	["Five Sisters Digsite"] = "Excavación de Las Cinco Hermanas",
	["Forest Heart Digsite"] = "Excavación del Corazón del Bosque",
	["Forest Song Digsite"] = "Excavación de la Canción del Bosque",
	["Frostwhisper Gorge Digsite"] = "Excavación del Cañón Levescarcha",
	["Gate to Golden Valley Digsite"] = "Excavación de la Puerta del Valle Dorado",
	["Gjalerbron Digsite"] = "Excavación de Gjalerbron",
	["Gong of Hope Digsite"] = "Excavación de El Gong de la Esperanza",
	["Gor'gaz Outpost Digsite"] = "Excavación de la Avanzada Gor'gaz",
	["Grangol'var Village Digsite"] = "Excavación del Poblado Grangol'var",
	["Great Bridge Digsite"] = "Excavación del Gran Puente",
	["Greenwarden's Fossil Bank"] = "Banco de fósiles del Guardaverde",
	["Grim Batol Digsite"] = "Excavación de Grim Batol",
	["Grimesilt Digsite"] = "Excavación de Limugre",
	["Grimsilt Digsite"] = "Excavación de Limugre",
	["Grove of Aessina Digsite"] = "Excavación de la Arboleda de Aessina",
	["Grumblepaw Ranch Digsite"] = "Excavación del Rancho Zarpa Rumiante",
	["Gurubashi Arena Digsite"] = "Excavación de la Arena Gurubashi",
	["Halaa Digsite"] = "Excavación de Halaa",
	["Halgrind Digsite"] = "Excavación de Haltorboll",
	["Hammertoe's Digsite"] = "Excavación de Piemartillo",
	["Hatred's Vice Digsite"] = "Excavación de la Corrupción del Odio",
	["Hellfire Basin Digsite"] = "Excavación de la Cuenca del Fuego Infernal",
	["Hellfire Citadel Digsite"] = "Excavación de la Ciudadela del Fuego Infernal",
	["Humboldt Conflagration Digsite"] = "Excavación de la Conflagración de Humboldt",
	["Illidari Point Digsite"] = "Excavación del Alto Illidari",
	["Infectis Scar Fossil Field"] = "Campo de fósiles de La Cicatriz Purulenta",
	["Ironband's Excavation Site"] = "Excavación de Vetaferro",
	["Ironbeard's Tomb"] = "Tumba de Barbaférrea",
	["Ironwood Digsite"] = "Excavación de maderaférrea",
	["Jade Temple Grounds Digsite"] = "Excavación de las Tierras del Templo de Jade",
	["Jaedenar Digsite"] = "Excavación de Jaedenar",
	["Jintha'Alor Lower City Digsite"] = "Excavación de la parte baja de Jintha'Alor",
	["Jintha'Alor Upper City Digsite"] = "Excavación de la parte alta de Jintha'Alor",
	["Jotunheim Digsite"] = "Excavación de Jotunheim",
	["Keset Pass Digsite"] = "Excavación del Paso de Keset",
	["Khartut's Tomb Digsite"] = "Excavación de la Tumba de Khartut",
	["Kodo Graveyard"] = "Cementerio de Kodos",
	["Kolramas Digsite"] = "Excavación de Kolramas",
	["Krasarang Wilds Digsite"] = "Excavación de la Espesura Krasarang",
	["Kun-Lai Peak Digsite"] = "Excavación del Pico Kun-Lai",
	["Lake Kel'Theril Digsite"] = "Excavación del Lago Kel'Theril",
	["Lake of Stars Digsite"] = "Excavación del Lago de los Astros",
	["Lakeridge Highway Fossil Bank"] = "Banco de fósiles del Camino del Lago",
	["Laughing Skull Digsite"] = "Excavación de las Ruinas Riecráneos",
	["Lost Dynasty Digsite"] = "Excavación de la Dinastía Perdida",
	["Lower Lakkari Tar Pits"] = "Fosas de Alquitrán inferiores",
	["Mannoroc Coven Digsite"] = "Excavación del Aquelarre Mannoroc",
	["Marshlands Fossil Bank"] = "Banco de fósiles de Los Pantanales",
	["Mistfall Village Digsite"] = "Excavación de la Aldea Bruma Otoñal",
	["Misty Reed Fossil Bank"] = "Banco de fósiles de Juncobruma",
	["Moonrest Gardens Digsite"] = "Excavación de los Jardines Reposo Lunar",
	["Morlos'Aran Digsite"] = "Excavación de Morlos'Aran",
	["Nar'shola (Middle Tier) Digsite"] = "Excavación de Nar'shola (nivel medio)",
	["Nazj'vel Digsite"] = "Excavación de Nazj'vel",
	["Neferset Digsite"] = "Excavación de Neferset",
	["Nek'mani Wellspring Digsite"] = "Excavación del Manantial Nek'mani",
	["Nifflevar Digsite"] = "Excavación de Nifflevar",
	["Nightmare Scar Digsite"] = "Excavación del Paraje Pesadilla",
	["Niuzao Temple Digsite"] = "Excavación del Templo de Niuzao",
	["Njorndar Village Digsite"] = "Excavación del Poblado Njorndar",
	["North Fruited Fields Digsite"] = "Excavación norte de Los Cultivos Florecientes",
	["North Great Wall Digsite"] = "Excavación norte de la Gran Muralla",
	["North Isildien Digsite"] = "Excavación de Isildien norte",
	["Northridge Fossil Field"] = "Campo de fósiles Crestanorte",
	["North Ruins of Dojan Digsite"] = "Excavación norte de las Ruinas de Dojan",
	["North Ruins of Guo-Lai Digsite"] = "Excavación norte de las Ruinas de Guo-Lai",
	["North Summer Fields Digsite"] = "Excavación norte de Los Campos Estivales",
	["North Temple of the Red Crane Digsite"] = "Excavación norte del Templo de la Grulla Roja",
	["Obelisk of the Stars Digsite"] = "Excavación del Obelisco de las Estrellas",
	["Old Village Digsite"] = "Excavación de la Antigua Aldea",
	["Oneiros Digsite"] = "Excavación de Oneiros",
	["Orchard Digsite"] = "Excavación del Huerto",
	["Orsis Digsite"] = "Excavación de Orsis",
	["Owl Wing Thicket Digsite"] = "Excavación del Matorral del Ala del Búho",
	["Paoquan Hollow Digsite"] = "Excavación de la Espesura Paoquan",
	["Pit of Fiends Digsite"] = "Excavación de El Foso de los Mefistos",
	["Pit of Narjun Digsite"] = "Excavación de El Foso de Narjun",
	["Plaguewood Digsite"] = "Excavación del Bosque de la Peste",
	["Pools of Purity Digsite"] = "Excavación de las Pozas de la Pureza",
	["Pyrox Flats Digsite"] = "Excavación de Llanos de Pirox",
	["Quagmire Fossil Field"] = "Campo de fósiles de El Lodazal",
	["Quel'Dormir Gardens Digsite"] = "Excavación de los Jardines de Quel'Dormir",
	["Quel'Lithien Lodge Digsite"] = "Excavación del Refugio Quel'Lithien",
	["Ravenwind Digsite"] = "Excavación de las Ruinas de Viento Azabache",
	["Red Reaches Fossil Bank"] = "Banco de fósiles de Las Costas Rojas",
	["Remote Village Digsite"] = "Excavación de la Aldea Remota",
	["Riplash Ruins Digsite"] = "Excavación de las Ruinas Tralladón",
	["River Delta Digsite"] = "Excavación del Delta",
	["Ruins of Aboraz"] = "Ruinas de Aboraz",
	["Ruins of Ahmtul Digsite"] = "Excavación de las Ruinas de Ahmtul",
	["Ruins of Ammon Digsite"] = "Excavación de las Ruinas de Ammon",
	["Ruins of Arkkoran"] = "Ruinas de Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Excavación de las Ruinas de Baa'ri",
	["Ruins of Eldarath"] = "Ruinas de Eldarath",
	["Ruins of Eldre'Thar"] = "Ruinas de Eldre'thar",
	["Ruins of Enkaat Digsite"] = "Excavación de las Ruinas de Enkaat",
	["Ruins of Farahlon Digsite"] = "Excavación de las Ruinas de Farahlon",
	["Ruins of Gan Shi Digsite"] = "Excavación de las Ruinas de Gan Shi",
	["Ruins of Jubuwal"] = "Ruinas de Jubuwal",
	["Ruins of Khintaset Digsite"] = "Excavación de las Ruinas de Khintaset",
	["Ruins of Korja Digsite"] = "Excavación de las Ruinas de Korja",
	["Ruins of Lar'donir Digsite"] = "Excavación de las Ruinas de Lar'donir",
	["Ruins of Ordil'Aran"] = "Las Ruinas de Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Excavación de las Ruinas de Shandaral",
	["Ruins of Stardust"] = "Las Ruinas del Polvo Estelar",
	["Sahket Wastes Digsite"] = "Excavación de las Ruinas de Sahket",
	["Sanctuary of Malorne Digsite"] = "Excavación del Santuario de Malorne",
	["Sands of Nasam"] = "Arenas de Nasam",
	["Sargeron Digsite"] = "Excavación de Sargeron",
	["Savage Coast Raptor Fields"] = "Campos de raptores de La Costa Salvaje",
	["Schnottz's Landing"] = "Embarcadero de Schnottz",
	["Scorched Plain Digsite"] = "Excavación de La Llanura Agostada",
	["Scourgeholme Digsite"] = "Excavación de la Ciudad de la Plaga",
	["Screaming Reaches Fossil Field"] = "Campo de fósiles de la Cuenca de los Gritos",
	["Setting Sun Garrison Digsite"] = "Excavación del Baluarte del Sol Poniente",
	["Shadra'Alor Digsite"] = "Excavación de Shadra'Alor",
	["Sha'naar Digsite"] = "Excavación de Sha'naar",
	["Shanze'Dao Digsite"] = "Excavación de Shanze'Dao",
	["Shield Hill Digsite"] = "Excavación de la Colina Escudo",
	["Shrine Meadow Digsite"] = "Excavación del Prado Santuario",
	["Shrine of Goldrinn Digsite"] = "Excavación del Santuario de Goldrinn",
	["Shrine of the Dawn Digsite"] = "Excavación del Santuario del Alba",
	["Sifreldar Village Digsite"] = "Excavación del Poblado Sifreldar",
	["Singing Marshes Digsite"] = "Excavación del Marjal Exótico",
	["Skorn Digsite"] = "Excavación de Skorn",
	["Slitherblade Shore Digsite"] = "Excavación de la Costa Filozante",
	["Small Gate Digsite"] = "Excavación de la Puerta Pequeña",
	["Snow Covered Hills Digsite"] = "Excavación de las Colinas Nevadas",
	["Solarsal Digsite"] = "Excavación de Solarsal",
	["South Fruited Fields Digsite"] = "Excavación sur de Los Cultivos Florecientes",
	["South Great Wall Digsite"] = "Excavación sur de la Gran Muralla",
	["South Isildien Digsite"] = "Excavación de Isildien sur",
	["Southmoon Ruins Digsite"] = "Excavación de las Ruinas de Lunasur",
	["South Orchard Digsite"] = "Excavación del Huerto del sur",
	["South Ruins of Dojan Digsite"] = "Excavación sur de las Ruinas de Dojan",
	["South Ruins of Guo-Lai Digsite"] = "Excavación sur de las Ruinas de Guo-Lai",
	["Southshore Fossil Field"] = "Campo de fósiles de Costasur",
	["Southwind Village Digsite"] = "Excavación de la Aldea del Viento del Sur",
	["Sra'thik Digsite"] = "Excavación Sra'thik",
	["Steps of Fate Digsite"] = "Excavación de Los Pasos del Sino",
	["Stonetalon Peak"] = "Cima del Espolón",
	["Sunken Temple Digsite"] = "Excavación del Templo Sumergido",
	["Sunspring Post Digsite"] = "Excavación del Puesto Primasol",
	["Talramas Digsite"] = "Excavación de Talramas",
	["Temple of Uldum Digsite"] = "Excavación del Templo de Uldum",
	["Terrace of Gurthan Digsite"] = "Excavación del Bancal Gurthan",
	["Terror Run Fossil Field"] = "Campo de fósiles del Camino del Terror",
	["Terrorweb Tunnel Digsite"] = "Excavación del Túnel Terroarácnido",
	["Terror Wing Fossil Field"] = "Campo de fósiles del Ala del Terror",
	["Thandol Span"] = "Puente Thandol",
	["The Arboretum Digsite"] = "Excavación de El Arboretum",
	["The Spring Road Digsite"] = "Excavación de La Senda Florida",
	["Thoradin's Wall"] = "Muralla de Thoradin",
	["Thundermar Ruins Digsite"] = "Excavación de las Ruinas de Bramal",
	["Thunderwood Digsite"] = "Excavación de El Bosque del Trueno",
	["Tian Digsite"] = "Excavación de Tian",
	["Tiger's Wood Digsite"] = "Excavación de El Bosque del Tigre",
	["Tomb of the Watchers Digsite"] = "Excavación de la Tumba de los Vigías",
	["Tombs of the Precursors Digsite"] = "Excavación de las Tumbas de los Precursores",
	["Torjari Pit Digsite"] = "Excavación de La Fosa Torjari",
	["Tu Shen Digsite"] = "Excavación de Tu Shen",
	["Tuurem Digsite"] = "Excavación de Tuurem",
	["Twilight Grove Digsite"] = "Excavación de la Arboleda del Crepúsculo",
	["Twin Spire Ruins Digsite"] = "Excavación de las Ruinas de las Agujas Gemelas",
	["Uldaman Entrance Digsite"] = "Excavación de la Entrada de Uldaman",
	["Unearthed Grounds"] = "Campos Desenterrados",
	["Upper Lakkari Tar Pits"] = "Fosas de Alquitrán superiores",
	["Valkyrion Digsite"] = "Excavación de Valkyrion",
	["Valley of Bones"] = "Valle de los Huesos",
	["Valley of Kings Digsite"] = "Excavación del Valle de los Reyes",
	["Veridian Grove Digsite"] = "Excavación de la Arboleda Veridiana",
	["Violet Stand Digsite"] = "Excavación de El Confín Violeta",
	["Voldrune Digsite"] = "Excavación de Runavold",
	["Vul'Gol Fossil Bank"] = "Banco de fósiles de Vul'Gol",
	["Warden's Cage Digsite"] = "Excavación de la Jaula de la Guardiana",
	["West Auchindoun Digsite"] = "Excavación de Auchindoun occidental",
	["Western Ruins of Thaurissan"] = "Ruinas de Thaurissan del Oeste",
	["Western Zul'Kunda Digsite"] = "Excavación de Zul'Kunda del Oeste",
	["Western Zul'Mamwe Digsite"] = "Excavación de Zul'Mamwe del Oeste",
	["West Old Village Digsite"] = "Excavación del oeste de la Antigua Aldea",
	["West Ruins of Guo-Lai Digsite"] = "Excavación oeste de Guo-Lai",
	["West Summer Fields Digsite"] = "Excavación oeste de Los Campos Estivales",
	["Whelgar's Excavation Site"] = "Excavación de Whelgar",
	["Winterbough Digsite"] = "Excavación de Brote Invernal",
	["Witherbark Digsite"] = "Excavación Secacorteza",
	["Writhingwood Digsite"] = "Excavación de Bosquetormento",
	["Wyrmbog Fossil Field"] = "Campo de fósiles de Ciénaga de Fuego",
	["Wyrmskull Digsite"] = "Excavación de Calavermis",
	["Ymirheim Digsite"] = "Excavación de Ymirheim",
	["Zeth'Gor Digsite"] = "Excavación de Zeth'Gor",
	["Zhu Province Digsite"] = "Excavación de la Provincia Zhu",
	["Ziata'jai Digsite"] = "Excavación de Ziata'jai",
	["Zim'Rhuk Digsite"] = "Excavación de Zim'Rhuk",
	["Zol'Heb Digsite"] = "Excavación de Zol'Heb",
	["Zoram Strand Digsite"] = "Excavación de La Ensenada de Zoram",
	["Zul'Farrak Digsite"] = "Excavación de Zul'Farrak",
	["Zul'Mashar Digsite"] = "Excavación de Zul'Mashar",
}
elseif GAME_LOCALE == "ptBR" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Cadeia de Fósseis das Areias Abissais",
	["Aerie Peak Digsite"] = "Sítio de Escavação do Ninho da Águia", -- Needs review
	["Agol'watha Digsite"] = "Sítio de Escavação de Agol'watha", -- Needs review
	["Akhenet Fields Digsite"] = "Sítio de Escavação dos Campos Akhenet", -- Needs review
	["Altar of Quetz'lun Digsite"] = "Sítio de Escavação do Altar de Quetz'lun",
	["Altar of Sseratus Digsite"] = "Sítio de Escavação do Altar de Sseratus",
	["Altar of Zul Digsite"] = "Sítio de Escavação do Altar de Zul", -- Needs review
	["Ancestral Grounds Digsite"] = "Sítio de Escavação das Terras Ancestrais", -- Needs review
	["Andorhal Fossil Bank"] = "Banco de Fósseis de Andorhal", -- Needs review
	["Arklon Ruins Digsite"] = "Sítio de Escavação das Ruínas Arklon", -- Needs review
	["Bael Modan Digsite"] = "Sítio de Escavação de Bael Modan",
	["Baleheim Digsite"] = "Sítio de Escavação de Baleheim",
	["Balia'mah Digsite"] = "Sítio de Escavação de Balia'mah", -- Needs review
	["Bal'lal Ruins Digsite"] = "Sítio de Escavação das Ruínas de Bal'lal", -- Needs review
	["Biel'aran Ridge Digsite"] = "Sítio de Escavação da Crista Biel'aran",
	["Bleeding Hollow Ruins Digsite"] = "Sítio de Escavação das Ruínas dos Olhos Sangrentos",
	["Boha'mu Ruins Digsite"] = "Sítio de Escavação das Ruínas de Boha'mu",
	["Bonechewer Ruins Digsite"] = "Sítio de Escavação das Ruínas Mascaosso",
	["Bone Wastes Digsite"] = "Sítio de Escavação do Deserto de Ossos",
	["Broken Commons Digsite"] = "Sítio de Escavação do Pátio Partido", -- Needs review
	["Broken Pillar Digsite"] = "Sítio de Escavação do Pilar Partido",
	["Brunnhildar Village Digsite"] = "Sítio de Escavação da Aldeia Brunnhildar", -- Needs review
	["Burning Blade Digsite"] = "Sítio de Escavação da Lâmina Ardente",
	["Chow Farmstead Digsite"] = "Sítio de Escavação da Fazenda do Chow",
	["Coilskar Point Digsite"] = "Sítio de Escavação do Pontal dos Serpentálios",
	["Constellas Digsite"] = "Sítio de Escavação de Constellas",
	["Cursed Landing Digsite"] = "Sítio de Escavação do Porto Amaldiçoado", -- Needs review
	["Darkmist Digsite"] = "Sítio de Escavação de Névoa Negra", -- Needs review
	["Den of Sorrow Digsite"] = "Sítio de Escavação do Covil da Tristeza",
	["Destroyed Village Digsite"] = "Sítio de Escavação da Vila Destruída",
	["Dire Maul Digsite"] = "Sítio de Escavação do Gládio Cruel",
	["Dragonmaw Fortress"] = "Fortaleza Presa do Dragão",
	["Drakil'Jin Ruins Digsite"] = "Sítio de Escavação das Ruínas de Drakil'jin",
	["Dreadmaul Fossil Field"] = "Campo de Fósseis do Malhorrendo", -- Needs review
	["Dunemaul Fossil Ridge"] = "Cadeia de Fósseis de Dunamalho", -- Needs review
	["Dun Garok Digsite"] = "Sítio de Escavação de Dun Garok", -- Needs review
	["Dunwald Ruins Digsite"] = "Sítio de Escavação das Ruínas Dunwald", -- Needs review
	["East Auchindoun Digsite"] = "Sítio de Escavação de Auchindoun do Leste",
	["Eastern Ruins of Thaurissan"] = "Ruínas do Leste de Thaurissan", -- Needs review
	["Eastern Zul'Kunda Digsite"] = "Sítio de Escavação Leste de Zul'Kunda", -- Needs review
	["Eastern Zul'Mamwe Digsite"] = "Sítio de Escavação Leste de Zul'Mamwe", -- Needs review
	["Eastmoon Ruins Digsite"] = "Sítio de Escavação das Ruínas de Lunaleste", -- Needs review
	["East Snow Covered Hills Digsite"] = "Sítio de Escavação a Leste das Colinas Cobertas de Neve",
	["East Summer Fields Digsite"] = "Sítio de Escavação dos Campos de Verão do Leste",
	["Eclipse Point Digsite"] = "Sítio de Escavação da Ponta do Eclipse",
	["Emperor's Approach Digsite"] = "Sítio de Escavação do Caminho do Imperador",
	["Emperor's Omen Digsite"] = "Sítio de Escavação do Agouro do Imperador",
	["En'kilah Digsite"] = "Sítio de Escavação de En'kilah", -- Needs review
	["Ethel Rethor Digsite"] = "Sítio de Escavação de Ethel Rethor", -- Needs review
	["Fallsong Village Digsite"] = "Sítio de Escavação da Vila Canção do Outono",
	["Felstone Fossil Field"] = "Campo de Fósseis de Pedravil", -- Needs review
	["Fields of Blood Fossil Bank"] = "Banco de Fósseis dos Campos de Sangue", -- Needs review
	["Fire Camp Osul Digsite"] = "Sítio de Escavação da Guarnição Avançada Osul",
	["Five Sisters Digsite"] = "Sítio de Escavação das Cinco Irmãs",
	["Forest Heart Digsite"] = "Sítio de Escavação Coração da Floresta",
	["Forest Song Digsite"] = "Sítio de Escavação da Cantilenda", -- Needs review
	["Frostwhisper Gorge Digsite"] = "Sítio de Escavação da Garganta dos Sussurros Gelados", -- Needs review
	["Gate to Golden Valley Digsite"] = "Sítio de Escavação do Portal do Vale Dourado",
	["Gjalerbron Digsite"] = "Sítio de Escavação de Gjalerbron",
	["Gong of Hope Digsite"] = "Sítio de Escavação do Gongo da Esperança",
	["Gor'gaz Outpost Digsite"] = "Sítio de Escavação do Acampamento Gor'gaz",
	["Grangol'var Village Digsite"] = "Sítio de Escavação da Aldeia Grangol'var",
	["Great Bridge Digsite"] = "Sítio de Escavação da Grande Ponte",
	["Greenwarden's Fossil Bank"] = "Banco de Fósseis do Verdião", -- Needs review
	["Grim Batol Digsite"] = "Sítio de Escavação de Grim Batol", -- Needs review
	["Grimesilt Digsite"] = "Sítio de Escavação de Pedrassuja", -- Needs review
	["Grimsilt Digsite"] = "Sítio de Escavação de Pedrassuja",
	["Grove of Aessina Digsite"] = "Sítio de Escavação do Bosque de Aessina",
	["Grumblepaw Ranch Digsite"] = "Sítio de Escavação do Rancho Pata que Rosna",
	["Gurubashi Arena Digsite"] = "Sítio de Escavação da Arena de Gurubashi", -- Needs review
	["Halaa Digsite"] = "Sítio de Escavação de Halaa",
	["Halgrind Digsite"] = "Sítio de Escavação de Halgrind",
	["Hammertoe's Digsite"] = "Sítio de Escavação do Pé-de-malho", -- Needs review
	["Hatred's Vice Digsite"] = "Sítio de Escavação do Torno do Ódio",
	["Hellfire Basin Digsite"] = "Sítio de Escavação da Bacia Fogo do Inferno",
	["Hellfire Citadel Digsite"] = "Sítio de Escavação da Cidadela Fogo do Inferno",
	["Humboldt Conflagration Digsite"] = "Sítio de Escavação da Conflagração de Humboldt", -- Needs review
	["Illidari Point Digsite"] = "Sítio de Escavação do Pontal Illidari",
	["Infectis Scar Fossil Field"] = "Campo de Fósseis da Fenda Infectis", -- Needs review
	["Ironband's Excavation Site"] = "Sítio de Escavação de Bandaferro", -- Needs review
	["Ironbeard's Tomb"] = "Tumba dos Barbaférreos", -- Needs review
	["Ironwood Digsite"] = "Sítio de Escavação de Pau-ferro",
	["Jade Temple Grounds Digsite"] = "Sítio de Escavação do Pátio do Templo de Jade",
	["Jaedenar Digsite"] = "Sítio de Escavação de Jaedenar", -- Needs review
	["Jintha'Alor Lower City Digsite"] = "Sítio de Escavação da cidade baixa de Jintha'Alor", -- Needs review
	["Jintha'Alor Upper City Digsite"] = "Sítio de Escavação da cidade alta de Jintha'Alor", -- Needs review
	["Jotunheim Digsite"] = "Sítio de Escavação de Jotunheim",
	["Keset Pass Digsite"] = "Sítio de Escavação do Desfiladeiro de Keset", -- Needs review
	["Khartut's Tomb Digsite"] = "Sítio de Escavação da Tumba de Khartut", -- Needs review
	["Kodo Graveyard"] = "Cemitério dos Kodos", -- Needs review
	["Kolramas Digsite"] = "Sítio de Escavação de Kolramas", -- Needs review
	["Krasarang Wilds Digsite"] = "Sítio de Escavação da Selva de Krasarang",
	["Kun-Lai Peak Digsite"] = "Sítio de Escavação do Pico Kun-Lai",
	["Lake Kel'Theril Digsite"] = "Sítio de Escavação do Lago Kel'Theril",
	["Lake of Stars Digsite"] = "Sítio de Escavação do Lago das Estrelas",
	["Lakeridge Highway Fossil Bank"] = "Banco de Fósseis da Estrada Beira-lago", -- Needs review
	["Laughing Skull Digsite"] = "Sítio de Escavação da Gargaveira",
	["Lost Dynasty Digsite"] = "Sítio de Escavação da Dinastia Perdida",
	["Lower Lakkari Tar Pits"] = "Poços de Piche Lakkari Inferiores",
	["Mannoroc Coven Digsite"] = "Sítio de Escavação das Ruínas de Mannoroc", -- Needs review
	["Marshlands Fossil Bank"] = "Banco de Fósseis dos Pântanos", -- Needs review
	["Mistfall Village Digsite"] = "Sítio de Escavação de Vila da Bruma Baixa",
	["Misty Reed Fossil Bank"] = "Banco de Fósseis de Brumalga", -- Needs review
	["Moonrest Gardens Digsite"] = "Sítio de Escavação dos Jardins Lua Serena",
	["Morlos'Aran Digsite"] = "Sítio de Escavação de Morlos'Aran",
	["Nar'shola (Middle Tier) Digsite"] = "Sítio de Escavação de Nar'shola (Camada Central)",
	["Nazj'vel Digsite"] = "Sítio de Escavação de Nazj'vel",
	["Neferset Digsite"] = "Sítio de Escavação de Neferset", -- Needs review
	["Nek'mani Wellspring Digsite"] = "Sítio de Escavação do Olho-d'água Nek'mani", -- Needs review
	["Nifflevar Digsite"] = "Sítio de Escavação de Niffelvar", -- Needs review
	["Nightmare Scar Digsite"] = "Sítio de Escavação da Garganta do Pesadelo", -- Needs review
	["Niuzao Temple Digsite"] = "Sítio de Escavação do Templo Niuzao",
	["Njorndar Village Digsite"] = "Sítio de Escavação da Vila Njorndar",
	["North Fruited Fields Digsite"] = "Sítio de Escavação dos Campos Frutíferos do Norte",
	["North Great Wall Digsite"] = "Sítio de Escavação da Grande Muralha do Norte",
	["North Isildien Digsite"] = "Sítio de Escavação de Isildien do Norte", -- Needs review
	["Northridge Fossil Field"] = "Campo de Fósseis de Beiranorte", -- Needs review
	["North Ruins of Dojan Digsite"] = "Sítio de Escavação das Ruínas de Dojan do Norte",
	["North Ruins of Guo-Lai Digsite"] = "Sítio de Escavação das Ruínas de Guo-Lai do Norte",
	["North Summer Fields Digsite"] = "Sítio de Escavação dos Campos do Verão do Norte",
	["North Temple of the Red Crane Digsite"] = "Sítio de Escavação ao Norte do Templo da Garça Vermelha",
	["Obelisk of the Stars Digsite"] = "Sítio de Escavação do Obelisco das Estrelas", -- Needs review
	["Old Village Digsite"] = "Sítio de Escavação da Vila Antiga",
	["Oneiros Digsite"] = "Sítio de Escavação de Oneiros", -- Needs review
	["Orchard Digsite"] = "Sítio de Escavação do Pomar",
	["Orsis Digsite"] = "Sítio de Escavação de Orsis", -- Needs review
	["Owl Wing Thicket Digsite"] = "Sítio de Escavação do Matagal da Asa da Coruja", -- Needs review
	["Paoquan Hollow Digsite"] = "Sítio de Escavação da Ravina Paoquan",
	["Pit of Fiends Digsite"] = "Sítio de Escavação do Fosso dos Demônios",
	["Pit of Narjun Digsite"] = "Sítio de Escavação do Fosso de Narjun",
	["Plaguewood Digsite"] = "Sítio de Escavação do Bosque Pestilento", -- Needs review
	["Pools of Purity Digsite"] = "Sítio de Escavação das Lagoas da Pureza",
	["Pyrox Flats Digsite"] = "Sítio de Escavação das Planícies Pyrox", -- Needs review
	["Quagmire Fossil Field"] = "Campo de Fósseis do Atoleiro", -- Needs review
	["Quel'Dormir Gardens Digsite"] = "Sítio de Escavação dos Jardins de Quel'Durmar",
	["Quel'Lithien Lodge Digsite"] = "Sítio de Escavação do Abrigo Quel'Lithien", -- Needs review
	["Ravenwind Digsite"] = "Sítio de Escavação dos Ventos Corvejantes",
	["Red Reaches Fossil Bank"] = "Banco de Fósseis do Recôndito Vermelho",
	["Remote Village Digsite"] = "Sítio de Escavação da Vila Distante",
	["Riplash Ruins Digsite"] = "Sítio de Escavação das Ruínas Quebramar",
	["River Delta Digsite"] = "Sítio de Escavação do Delta do Rio", -- Needs review
	["Ruins of Aboraz"] = "Ruínas de Aboraz", -- Needs review
	["Ruins of Ahmtul Digsite"] = "Sítio de Escavação das Ruínas de Ahmtul", -- Needs review
	["Ruins of Ammon Digsite"] = "Sítio de Escavação das Ruínas de Ammon", -- Needs review
	["Ruins of Arkkoran"] = "Ruínas de Arkkoran", -- Needs review
	["Ruins of Baa'ri Digsite"] = "Sítio de Escavação das Ruínas de Baa'ri",
	["Ruins of Eldarath"] = "Ruínas de Eldarath", -- Needs review
	["Ruins of Eldre'Thar"] = "Ruínas de Eldre'thar", -- Needs review
	["Ruins of Enkaat Digsite"] = "Sítio de Escavação das Ruínas de Enkaat", -- Needs review
	["Ruins of Farahlon Digsite"] = "Sítio de Escavação das Ruínas de Farahlon", -- Needs review
	["Ruins of Gan Shi Digsite"] = "Sítio de Escavação das Ruínas de Gan Shi",
	["Ruins of Jubuwal"] = "Ruínas de Jubuwal", -- Needs review
	["Ruins of Khintaset Digsite"] = "Sítio de Escavação das Ruínas de Khintaset",
	["Ruins of Korja Digsite"] = "Sítio de Escavação das Ruínas de Korja",
	["Ruins of Lar'donir Digsite"] = "Sítio de Escavação das Ruínas de Lar'donir",
	["Ruins of Ordil'Aran"] = "Ruínas de Ordil'Aran", -- Needs review
	["Ruins of Shandaral Digsite"] = "Sítio de Escavação das Ruínas de Shandaral",
	["Ruins of Stardust"] = "Ruínas de Poeira Estelar", -- Needs review
	["Sahket Wastes Digsite"] = "Sítio de Escavação do Deserto Sahket",
	["Sanctuary of Malorne Digsite"] = "Sítio de Escavação do Santuário de Malorne", -- Needs review
	["Sands of Nasam"] = "Areias de Nasam",
	["Sargeron Digsite"] = "Sítio de Escavação de Sargeron", -- Needs review
	["Savage Coast Raptor Fields"] = "Campos de Raptores da Costa Selvagem",
	["Schnottz's Landing"] = "Porto de Schnottz", -- Needs review
	["Scorched Plain Digsite"] = "Sítio de Escavação da Terra Queimada",
	["Scourgeholme Digsite"] = "Sítio de Escavação do Forte do Flagelo",
	["Screaming Reaches Fossil Field"] = "Campo de Fósseis da Costa dos Gritos", -- Needs review
	["Setting Sun Garrison Digsite"] = "Sítio de Escavação da Guarnição do Sol Poente",
	["Shadra'Alor Digsite"] = "Sítio de Escavação de Shadra'Alor",
	["Sha'naar Digsite"] = "Sítio de Escavação de Sha'naar",
	["Shanze'Dao Digsite"] = "Sítio de Escavação de Shanze'Dao",
	["Shield Hill Digsite"] = "Sítio de Escavação do Monte Égide",
	["Shrine Meadow Digsite"] = "Sítio de Escavação da Campina Sagrada",
	["Shrine of Goldrinn Digsite"] = "Sítio de Escavação do Santuário de Goldrinn", -- Needs review
	["Shrine of the Dawn Digsite"] = "Sítio de Escavação do Templo da Aurora",
	["Sifreldar Village Digsite"] = "Sítio de Escavação da Aldeia Sifreldar",
	["Singing Marshes Digsite"] = "Sítio de Escavação dos Pântanos Cantantes",
	["Skorn Digsite"] = "Sítio de Escavação de Skorn",
	["Slitherblade Shore Digsite"] = "Sítio de Escavação da Praia Sibilâmina", -- Needs review
	["Small Gate Digsite"] = "Sítio de Escavação do Portão Pequeno",
	["Snow Covered Hills Digsite"] = "Sítio de Escavação das Colinas Cobertas de Neve",
	["Solarsal Digsite"] = "Sítio de Escavação de Solarsal",
	["South Fruited Fields Digsite"] = "Sítio de Escavação dos Campos Frutíferos do Sul",
	["South Great Wall Digsite"] = "Sítio de Escavação da Grande Muralha do Sul",
	["South Isildien Digsite"] = "Sítio de Escavação de Isildien do Sul", -- Needs review
	["Southmoon Ruins Digsite"] = "Sítio de Escavação das Ruínas de Lunassul",
	["South Orchard Digsite"] = "Sítio de Escavação ao Sul do Pomar",
	["South Ruins of Dojan Digsite"] = "Sítio de Escavação das Ruínas de Dojan do Sul",
	["South Ruins of Guo-Lai Digsite"] = "Sítio de Escavação das Ruínas de Guo-Lai do Sul",
	["Southshore Fossil Field"] = "Campo de Fósseis da Costa Sul",
	["Southwind Village Digsite"] = "Sítio de Escavação da Vila do Vento Sul", -- Needs review
	["Sra'thik Digsite"] = "Sítio de Escavação Sra'thik",
	["Steps of Fate Digsite"] = "Sítio de Escavação dos Passos do Destino",
	["Stonetalon Peak"] = "Morro das Torres de Pedra", -- Needs review
	["Sunken Temple Digsite"] = "Sítio de Escavação do Templo Submerso",
	["Sunspring Post Digsite"] = "Sítio de Escavação do Posto Solavera",
	["Talramas Digsite"] = "Sítio de Escavação de Talramas",
	["Temple of Uldum Digsite"] = "Sítio de Escavação do Templo de Uldum", -- Needs review
	["Terrace of Gurthan Digsite"] = "Sítio de Escavação do Terraço de Gurthan",
	["Terror Run Fossil Field"] = "Campos de Fósseis de Terroral", -- Needs review
	["Terrorweb Tunnel Digsite"] = "Sítio de Escavação do Túnel Terrorteia",
	["Terror Wing Fossil Field"] = "Campo de Fósseis do Asa do Terror", -- Needs review
	["Thandol Span"] = "Ponte Thandol",
	["The Arboretum Digsite"] = "Sítio de Escavação do Arboreto",
	["The Spring Road Digsite"] = "Sítio de Escavação da Estrada da Primavera",
	["Thoradin's Wall"] = "Muralha de Thoradin", -- Needs review
	["Thundermar Ruins Digsite"] = "Sítio de Escavação das Ruínas Trondamar",
	["Thunderwood Digsite"] = "Sítio de Escavação de Pau-de-trovão",
	["Tian Digsite"] = "Sítio de Escavação de Tian",
	["Tiger's Wood Digsite"] = "Sítio de Escavação do Bosque dos Tigres",
	["Tomb of the Watchers Digsite"] = "Sítio de Escavação da Tumba dos Observadores",
	["Tombs of the Precursors Digsite"] = "Sítio de Escavação das Tumbas dos Antecessores", -- Needs review
	["Torjari Pit Digsite"] = "Sítio de Escavação do Poço Torjari",
	["Tu Shen Digsite"] = "Sítio de Escavação de Tu Shen",
	["Tuurem Digsite"] = "Sítio de Escavação de Tuurem",
	["Twilight Grove Digsite"] = "Sítio de Escavação do Bosque do Crepúsculo",
	["Twin Spire Ruins Digsite"] = "Sítio de Escavação das Ruínas das Agulhas Gêmeas",
	["Uldaman Entrance Digsite"] = "Sítio de Escavação da Entrada de Uldaman",
	["Unearthed Grounds"] = "Terras Escavadas", -- Needs review
	["Upper Lakkari Tar Pits"] = "Poços de Piche Lakkari Superiores", -- Needs review
	["Valkyrion Digsite"] = "Sítio de Escavação de Valkyrion",
	["Valley of Bones"] = "Vale dos Ossos",
	["Valley of Kings Digsite"] = "Sítio de Escavação do Vale dos Reis",
	["Veridian Grove Digsite"] = "Sítio de Escavação do Bosque Víride",
	["Violet Stand Digsite"] = "Sítio de Escavação da Fortaleza Violácea",
	["Voldrune Digsite"] = "Sítio de Escavação de Runavold",
	["Vul'Gol Fossil Bank"] = "Banco de Fósseis de Vul'Gol",
	["Warden's Cage Digsite"] = "Sítio de Escavação da Jaula do Carcereiro",
	["West Auchindoun Digsite"] = "Sítio de Escavação de Auchindoun do Oeste",
	["Western Ruins of Thaurissan"] = "Ruínas do Oeste de Thaurissan",
	["Western Zul'Kunda Digsite"] = "Sítio de Escavação Oeste de Zul'Kunda",
	["Western Zul'Mamwe Digsite"] = "Sítio de Escavação Oeste de Zul'Mamwe",
	["West Old Village Digsite"] = "Sítio de Escavação a Oeste da Vila Antiga",
	["West Ruins of Guo-Lai Digsite"] = "Sítio de Escavação das Ruínas de Guo-Lai do Oeste",
	["West Summer Fields Digsite"] = "Sítio de Escavação dos Campos de Verão do Oeste",
	["Whelgar's Excavation Site"] = "Sítio de Escavação de Whelgar", -- Needs review
	["Winterbough Digsite"] = "Sítio de Escavação de Galho Invernal",
	["Witherbark Digsite"] = "Sítio de Escavação Cascasseca", -- Needs review
	["Writhingwood Digsite"] = "Sítio de Escavação do Bosque Retorcido",
	["Wyrmbog Fossil Field"] = "Campo de Fósseis do Pântano da Serpe", -- Needs review
	["Wyrmskull Digsite"] = "Sítio de Escavação da Caveira de Dragão",
	["Ymirheim Digsite"] = "Sítio de Escavação de Ymarheim",
	["Zeth'Gor Digsite"] = "Sítio de Escavação de Zeth'Gor",
	["Zhu Province Digsite"] = "Sítio de Escavação da Província de Zhu",
	["Ziata'jai Digsite"] = "Sítio de Escavação de Ziata'jai", -- Needs review
	["Zim'Rhuk Digsite"] = "Sítio de Escavação de Zim'Rhuk",
	["Zol'Heb Digsite"] = "Sítio de Escavação de Zol'Heb",
	["Zoram Strand Digsite"] = "Sítio de Escavação da Praia de Zoram", -- Needs review
	["Zul'Farrak Digsite"] = "Sítio de Escavação de Zul'Farrak", -- Needs review
	["Zul'Mashar Digsite"] = "Sítio de Escavação de Zul'Mashar",
}
elseif GAME_LOCALE == "itIT" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Cresta Fossile delle Sabbie Abissali",
	["Aerie Peak Digsite"] = "Scavi del Picco dell'Aquila",
	["Agol'watha Digsite"] = "Scavi di Agol'watha",
	["Akhenet Fields Digsite"] = "Scavi dei Campi di Akhenet",
	["Altar of Quetz'lun Digsite"] = "Scavi dell'Altare di Quetz'lun",
	["Altar of Sseratus Digsite"] = "Scavi dell'Altare di Sseratus",
	["Altar of Zul Digsite"] = "Scavi dell'Altare di Zul",
	["Ancestral Grounds Digsite"] = "Scavi delle Terre Ancestrali",
	["Andorhal Fossil Bank"] = "Banco Fossile di Andorhal",
	["Arklon Ruins Digsite"] = "Scavi delle Rovine di Arklon",
	["Bael Modan Digsite"] = "Scavi di Bael Modan",
	["Baleheim Digsite"] = "Scavi di Baleheim",
	["Balia'mah Digsite"] = "Scavi di Balia'mah",
	["Bal'lal Ruins Digsite"] = "Scavi delle Rovine di Bal'lal",
	["Biel'aran Ridge Digsite"] = "Scavi dell'Altura di Biel'aran",
	["Bleeding Hollow Ruins Digsite"] = "Scavi delle Rovine dei Guerci Insanguinati",
	["Boha'mu Ruins Digsite"] = "Scavi delle Rovine di Boha'mu",
	["Bonechewer Ruins Digsite"] = "Scavi delle Rovine dei Tritaossa",
	["Bone Wastes Digsite"] = "Scavi delle Distese d'Ossa",
	["Broken Commons Digsite"] = "Scavi del Piazzale in Rovina",
	["Broken Pillar Digsite"] = "Scavi del Pilastro Spezzato",
	["Brunnhildar Village Digsite"] = "Scavi di Brunnhildar",
	["Burning Blade Digsite"] = "Scavi delle Lame Ardenti",
	["Chow Farmstead Digsite"] = "Scavi della Fattoria dei Chow",
	["Coilskar Point Digsite"] = "Scavi del Presidio dei Malaspira",
	["Constellas Digsite"] = "Scavi di Constellas",
	["Cursed Landing Digsite"] = "Scavi dell'Approdo Maledetto",
	["Darkmist Digsite"] = "Scavi di Brumafosca",
	["Den of Sorrow Digsite"] = "Scavi dell’Antro del Cordoglio",
	["Destroyed Village Digsite"] = "Scavi del Villaggio Distrutto",
	["Dire Maul Digsite"] = "Scavi di Maglio Infausto",
	["Dragonmaw Fortress"] = "Fortezza delle Fauci di Drago",
	["Drakil'Jin Ruins Digsite"] = "Scavi delle Rovine di Drakil'jin",
	["Dreadmaul Fossil Field"] = "Area Fossile dei Maglioinfame",
	["Dunemaul Fossil Ridge"] = "Cresta Fossile dei Mazzaduna",
	["Dun Garok Digsite"] = "Scavi di Dun Garok",
	["Dunwald Ruins Digsite"] = "Scavi delle Rovine di Dunwald",
	["East Auchindoun Digsite"] = "Scavi di Auchindoun Orientale",
	["Eastern Ruins of Thaurissan"] = "Rovine Orientali di Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Scavi di Zul'Kunda Orientale",
	["Eastern Zul'Mamwe Digsite"] = "Scavi di Zul'Mamwe Orientale",
	["Eastmoon Ruins Digsite"] = "Scavi delle Rovine di Luna dell'Est",
	["East Snow Covered Hills Digsite"] = "Scavi delle Colline Innevate Orientali",
	["East Summer Fields Digsite"] = "Scavi dei Campi Soleggiati Orientali",
	["Eclipse Point Digsite"] = "Scavi del Presidio dell'Eclisse",
	["Emperor's Approach Digsite"] = "Scavi dell’Approccio dell'Imperatore",
	["Emperor's Omen Digsite"] = "Scavi del Presagio dell'Imperatore",
	["En'kilah Digsite"] = "Scavi di En'kilah",
	["Ethel Rethor Digsite"] = "Scavi di Ethel Rethor",
	["Fallsong Village Digsite"] = "Scavi di Acquamantra",
	["Felstone Fossil Field"] = "Area Fossile di Vilpietra",
	["Fields of Blood Fossil Bank"] = "Banco Fossile dei Campi del Sangue",
	["Fire Camp Osul Digsite"] = "Scavi del Presidio del Fuoco Osul",
	["Five Sisters Digsite"] = "Scavi delle Cinque Sorelle",
	["Forest Heart Digsite"] = "Scavi del Cuore della Foresta",
	["Forest Song Digsite"] = "Scavi di Cantaselva",
	["Frostwhisper Gorge Digsite"] = "Scavi della Gola Eco Freddo",
	["Gate to Golden Valley Digsite"] = "Scavi della Porta della Valle Dorata",
	["Gjalerbron Digsite"] = "Scavi di Gjalerbron",
	["Gong of Hope Digsite"] = "Scavi del Gong della Speranza",
	["Gor'gaz Outpost Digsite"] = "Scavi dell'Avamposto di Gor'gaz",
	["Grangol'var Village Digsite"] = "Scavi di Grangol'var",
	["Great Bridge Digsite"] = "Scavi del Grande Ponte",
	["Greenwarden's Fossil Bank"] = "Banco Fossile di Guardiaverde",
	["Grim Batol Digsite"] = "Scavi di Grim Batol",
	["Grimesilt Digsite"] = "Scavi di Golasporca",
	["Grimsilt Digsite"] = "Scavi di Golasporca",
	["Grove of Aessina Digsite"] = "Scavi della Selva di Aessina",
	["Grumblepaw Ranch Digsite"] = "Scavi della Tenuta degli Zampa Brontolante",
	["Gurubashi Arena Digsite"] = "Scavi dell'Arena dei Gurubashi",
	["Halaa Digsite"] = "Scavi di Halaa",
	["Halgrind Digsite"] = "Scavi di Halgrind",
	["Hammertoe's Digsite"] = "Scavi di Mazzadito",
	["Hatred's Vice Digsite"] = "Scavi della Morsa dell'Odio",
	["Hellfire Basin Digsite"] = "Scavi della Conca del Fuoco Infernale",
	["Hellfire Citadel Digsite"] = "Scavi della Cittadella del Fuoco Infernale",
	["Humboldt Conflagration Digsite"] = "Scavi della Conflagrazione di Humboldt",
	["Illidari Point Digsite"] = "Scavi del Presidio Illidariano",
	["Infectis Scar Fossil Field"] = "Area Fossile della Cicatrice Infetta",
	["Ironband's Excavation Site"] = "Scavi di Ferrocollo",
	["Ironbeard's Tomb"] = "Sepolcro di Barbaferrea",
	["Ironwood Digsite"] = "Scavi di Legnoduro",
	["Jade Temple Grounds Digsite"] = "Scavi dei Giardini del Tempio di Giada",
	["Jaedenar Digsite"] = "Scavi di Jaedenar",
	["Jintha'Alor Lower City Digsite"] = "Scavi della Città Bassa di Jintha'Alor",
	["Jintha'Alor Upper City Digsite"] = "Scavi della Città Alta di Jintha'Alor",
	["Jotunheim Digsite"] = "Scavi di Jotunheim",
	["Keset Pass Digsite"] = "Scavi del Passo di Keset",
	["Khartut's Tomb Digsite"] = "Scavi della Tomba di Khartut",
	["Kodo Graveyard"] = "Cimitero dei Kodo",
	["Kolramas Digsite"] = "Scavi di Kolramas",
	["Krasarang Wilds Digsite"] = "Scavi della Giungla di Krasarang",
	["Kun-Lai Peak Digsite"] = "Scavi del Picco del Kun-Lai",
	["Lake Kel'Theril Digsite"] = "Scavi del Lago Kel'Theril",
	["Lake of Stars Digsite"] = "Scavi del Lago delle Stelle",
	["Lakeridge Highway Fossil Bank"] = "Banchina Fossile del Cammino Bordolago",
	["Laughing Skull Digsite"] = "Scavi dei Teschio Ridente",
	["Lost Dynasty Digsite"] = "Scavi della Dinastia Perduta",
	["Lower Lakkari Tar Pits"] = "Pozze di Pece Inferiori di Lakkari",
	["Mannoroc Coven Digsite"] = "Scavi della Congrega di Mannoroc",
	["Marshlands Fossil Bank"] = "Banco Fossile degli Acquitrini Selvaggi",
	["Mistfall Village Digsite"] = "Scavi di Calanebbia",
	["Misty Reed Fossil Bank"] = "Banco Fossile di Cannamarcia",
	["Moonrest Gardens Digsite"] = "Scavi dei Giardini di Lunanuova",
	["Morlos'Aran Digsite"] = "Scavi di Morlos'Aran",
	["Nar'shola (Middle Tier) Digsite"] = "Scavi di Nar'shola Centrale",
	["Nazj'vel Digsite"] = "Scavi di Nazj'vel",
	["Neferset Digsite"] = "Scavi di Neferset",
	["Nek'mani Wellspring Digsite"] = "Scavi della Sorgente di Nek'mani",
	["Nifflevar Digsite"] = "Scavi di Nifflevar",
	["Nightmare Scar Digsite"] = "Scavi della Faglia dell'Incubo",
	["Niuzao Temple Digsite"] = "Scavi del Tempio di Niuzao",
	["Njorndar Village Digsite"] = "Scavi di Njorndar",
	["North Fruited Fields Digsite"] = "Scavi del Granfrutteto Settentrionale",
	["North Great Wall Digsite"] = "Scavi della Gran Muraglia Settentrionale",
	["North Isildien Digsite"] = "Scavi di Isildien Settentrionale",
	["Northridge Fossil Field"] = "Area Fossile della Cresta Nord",
	["North Ruins of Dojan Digsite"] = "Scavi delle Rovine di Dojan Settentrionali",
	["North Ruins of Guo-Lai Digsite"] = "Scavi delle Rovine di Guo-Lai Settentrionali",
	["North Summer Fields Digsite"] = "Scavi dei Campi Soleggiati Settentrionali",
	["North Temple of the Red Crane Digsite"] = "Scavi del Tempio Settentrionale della Gru Rossa",
	["Obelisk of the Stars Digsite"] = "Scavi dell'Obelisco delle Stelle",
	["Old Village Digsite"] = "Scavi dell'Antico Villaggio",
	["Oneiros Digsite"] = "Scavi di Oneiros",
	["Orchard Digsite"] = "Scavi del Frutteto",
	["Orsis Digsite"] = "Scavi di Orsis",
	["Owl Wing Thicket Digsite"] = "Scavi della Selva Ala di Gufo",
	["Paoquan Hollow Digsite"] = "Scavi del Rifugio di Paoquan",
	["Pit of Fiends Digsite"] = "Scavi della Fossa dei Demoni",
	["Pit of Narjun Digsite"] = "Scavi della Fossa di Narjun",
	["Plaguewood Digsite"] = "Scavi di Malaselva",
	["Pools of Purity Digsite"] = "Scavi degli Stagni della Purezza",
	["Pyrox Flats Digsite"] = "Scavi delle Pianure di Pyrox",
	["Quagmire Fossil Field"] = "Area Fossile delle Acque Stagnanti",
	["Quel'Dormir Gardens Digsite"] = "Scavi dei Giardini di Quel'Dormir",
	["Quel'Lithien Lodge Digsite"] = "Scavi del Padiglione Quel'Lithien",
	["Ravenwind Digsite"] = "Scavi di Corvovento",
	["Red Reaches Fossil Bank"] = "Banco Fossile delle Insenature Rosse",
	["Remote Village Digsite"] = "Scavi del Villaggio Remoto",
	["Riplash Ruins Digsite"] = "Scavi delle Rovine degli Sferzalama",
	["River Delta Digsite"] = "Scavi del Delta del Fiume",
	["Ruins of Aboraz"] = "Rovine di Aboraz",
	["Ruins of Ahmtul Digsite"] = "Scavi delle Rovine di Ahmtul",
	["Ruins of Ammon Digsite"] = "Scavi delle Rovine di Ammon",
	["Ruins of Arkkoran"] = "Rovine di Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Scavi delle Rovine di Baa'ri",
	["Ruins of Eldarath"] = "Rovine di Eldarath",
	["Ruins of Eldre'Thar"] = "Rovine di Eldre'thar",
	["Ruins of Enkaat Digsite"] = "Scavi delle Rovine di Enkaat",
	["Ruins of Farahlon Digsite"] = "Scavi delle Rovine di Farahlon",
	["Ruins of Gan Shi Digsite"] = "Scavi delle Rovine di Gan Shi",
	["Ruins of Jubuwal"] = "Rovine di Jubuwal",
	["Ruins of Khintaset Digsite"] = "Scavi delle Rovine di Khintaset",
	["Ruins of Korja Digsite"] = "Scavi delle Rovine di Korja",
	["Ruins of Lar'donir Digsite"] = "Scavi delle Rovine di Lar'donir",
	["Ruins of Ordil'Aran"] = "Rovine di Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Scavi delle Rovine di Shandaral",
	["Ruins of Stardust"] = "Rovine della Polvere Stellare",
	["Sahket Wastes Digsite"] = "Scavi delle Piane di Sahket",
	["Sanctuary of Malorne Digsite"] = "Scavi del Sacrario di Malorne",
	["Sands of Nasam"] = "Sabbie di Nasam",
	["Sargeron Digsite"] = "Scavi di Sargeron",
	["Savage Coast Raptor Fields"] = "Campi dei Raptor della Costa Selvaggia",
	["Schnottz's Landing"] = "Approdo di Schnottz",
	["Scorched Plain Digsite"] = "Scavi della Pianura Bruciata",
	["Scourgeholme Digsite"] = "Scavi dei Bastioni del Flagello",
	["Screaming Reaches Fossil Field"] = "Area Fossile dei Confini Urlanti",
	["Setting Sun Garrison Digsite"] = "Scavi della Guarnigione del Sole Calante",
	["Shadra'Alor Digsite"] = "Scavi di Shadra'Alor",
	["Sha'naar Digsite"] = "Scavi di Sha'naar",
	["Shanze'Dao Digsite"] = "Scavi di Shanze'Dao",
	["Shield Hill Digsite"] = "Scavi del Colle degli Scudi",
	["Shrine Meadow Digsite"] = "Scavi della Prateria del Santuario",
	["Shrine of Goldrinn Digsite"] = "Scavi del Sacrario di Goldrinn",
	["Shrine of the Dawn Digsite"] = "Scavi del Santuario dell'Alba",
	["Sifreldar Village Digsite"] = "Scavi di Sifreldar",
	["Singing Marshes Digsite"] = "Scavi delle Paludi Risonanti",
	["Skorn Digsite"] = "Scavi di Skorn",
	["Slitherblade Shore Digsite"] = "Scavi della Spiaggia dei Lamasalmastra",
	["Small Gate Digsite"] = "Scavi della Piccola Porta",
	["Snow Covered Hills Digsite"] = "Scavi delle Colline Innevate",
	["Solarsal Digsite"] = "Scavi di Solarsal",
	["South Fruited Fields Digsite"] = "Scavi del Granfrutteto Meridionale",
	["South Great Wall Digsite"] = "Scavi della Gran Muraglia Meridionale",
	["South Isildien Digsite"] = "Scavi di Isildien Meridionale",
	["Southmoon Ruins Digsite"] = "Scavi delle Rovine di Luna del Sud",
	["South Orchard Digsite"] = "Scavi del Frutteto Meridionale",
	["South Ruins of Dojan Digsite"] = "Scavi delle Rovine di Dojan Meridionali",
	["South Ruins of Guo-Lai Digsite"] = "Scavi delle Rovine di Guo-Lai Meridionali",
	["Southshore Fossil Field"] = "Area Fossile di Riva del Sud",
	["Southwind Village Digsite"] = "Scavi di Vento del Sud",
	["Sra'thik Digsite"] = "Scavi di Sra'thik",
	["Steps of Fate Digsite"] = "Scavi della Scalinata del Fato",
	["Stonetalon Peak"] = "Picco di Petrartiglio",
	["Sunken Temple Digsite"] = "Scavi del Tempio Sommerso",
	["Sunspring Post Digsite"] = "Scavi dell'Accampamento di Solenuovo",
	["Talramas Digsite"] = "Scavi di Talramas",
	["Temple of Uldum Digsite"] = "Scavi del Tempio di Uldum",
	["Terrace of Gurthan Digsite"] = "Scavi della Terrazza dei Gurthan",
	["Terror Run Fossil Field"] = "Area Fossile della Landa del Terrore",
	["Terrorweb Tunnel Digsite"] = "Scavi della Galleria dell'Orrore Brulicante",
	["Terror Wing Fossil Field"] = "Area Fossile del Terrore Alato",
	["Thandol Span"] = "Viadotto di Thandol",
	["The Arboretum Digsite"] = "Scavi dell'Arboreto",
	["The Spring Road Digsite"] = "Scavi della Via della Primavera",
	["Thoradin's Wall"] = "Muro di Thoradin",
	["Thundermar Ruins Digsite"] = "Scavi delle Rovine di Tuonocupo",
	["Thunderwood Digsite"] = "Scavi di Legnotuono",
	["Tian Digsite"] = "Scavi del Monastero di Tian",
	["Tiger's Wood Digsite"] = "Scavi della Tana delle Tigri",
	["Tomb of the Watchers Digsite"] = "Scavi della Tomba dei Guardiani",
	["Tombs of the Precursors Digsite"] = "Scavi delle Tombe dei Precursori",
	["Torjari Pit Digsite"] = "Scavi della Fossa di Torjari",
	["Tu Shen Digsite"] = "Scavi del Tumulo di Tu Shen",
	["Tuurem Digsite"] = "Scavi di Tuurem",
	["Twilight Grove Digsite"] = "Scavi del Bosco del Crepuscolo",
	["Twin Spire Ruins Digsite"] = "Scavi delle Rovine delle Guglie Gemelle",
	["Uldaman Entrance Digsite"] = "Scavi dell'Ingresso a Uldaman",
	["Unearthed Grounds"] = "Terre Dissotterrate",
	["Upper Lakkari Tar Pits"] = "Pozze di Pece Superiori di Lakkari",
	["Valkyrion Digsite"] = "Scavi di Valkyrion",
	["Valley of Bones"] = "Valle delle Ossa",
	["Valley of Kings Digsite"] = "Scavi della Valle dei Re",
	["Veridian Grove Digsite"] = "Scavi del Bosco Veridiano",
	["Violet Stand Digsite"] = "Scavi del Baluardo Violaceo",
	["Voldrune Digsite"] = "Scavi di Voldrune",
	["Vul'Gol Fossil Bank"] = "Banco Fossile di Vul'Gol",
	["Warden's Cage Digsite"] = "Scavi della Prigione della Guardiana",
	["West Auchindoun Digsite"] = "Scavi di Auchindoun Occidentale",
	["Western Ruins of Thaurissan"] = "Rovine Occidentali di Thaurissan",
	["Western Zul'Kunda Digsite"] = "Scavi di Zul'Kunda Occidentale",
	["Western Zul'Mamwe Digsite"] = "Scavi di Zul'Mamwe Occidentale",
	["West Old Village Digsite"] = "Scavi dell'Antico Villaggio Occidentale",
	["West Ruins of Guo-Lai Digsite"] = "Scavi delle Rovine di Guo-Lai Occidentali",
	["West Summer Fields Digsite"] = "Scavi dei Campi Soleggiati Occidentali",
	["Whelgar's Excavation Site"] = "Scavi di Whelgar",
	["Winterbough Digsite"] = "Scavi della Radura Invernale",
	["Witherbark Digsite"] = "Scavi di Scorzasecca",
	["Writhingwood Digsite"] = "Scavi di Boscotorto",
	["Wyrmbog Fossil Field"] = "Area Fossile del Brago dei Dragoni",
	["Wyrmskull Digsite"] = "Scavi del Cranio del Drago",
	["Ymirheim Digsite"] = "Scavi di Ymirheim",
	["Zeth'Gor Digsite"] = "Scavi di Zeth'Gor",
	["Zhu Province Digsite"] = "Scavi della Provincia di Zhu",
	["Ziata'jai Digsite"] = "Scavi di Ziata'jai",
	["Zim'Rhuk Digsite"] = "Scavi di Zim'Rhuk",
	["Zol'Heb Digsite"] = "Scavi di Zol'Heb",
	["Zoram Strand Digsite"] = "Scavi della Spiaggia di Zoram",
	["Zul'Farrak Digsite"] = "Scavi di Zul'Farrak",
	["Zul'Mashar Digsite"] = "Scavi di Zul'Mashar",
}
elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "Безбрежные пески - окаменелости",
	["Aerie Peak Digsite"] = "Заоблачный пик - раскопки",
	["Agol'watha Digsite"] = "Агол'вата - раскопки",
	["Akhenet Fields Digsite"] = "Поля Акхенет - раскопки",
	["Altar of Quetz'lun Digsite"] = "Алтарь Кетц'лун - раскопки",
	["Altar of Sseratus Digsite"] = "Алтарь Шшератуса - раскопки",
	["Altar of Zul Digsite"] = "Алтарь Зула - раскопки",
	["Ancestral Grounds Digsite"] = "Земли Предков - раскопки",
	["Andorhal Fossil Bank"] = "Андорал - окаменелости",
	["Arklon Ruins Digsite"] = "Руины Арклон - раскопки",
	["Bael Modan Digsite"] = "Бейл Модан - раскопки",
	["Baleheim Digsite"] = "Гибльхейм - раскопки",
	["Balia'mah Digsite"] = "Балиа'ма - раскопки",
	["Bal'lal Ruins Digsite"] = "Руины Бал'лал - раскопки",
	["Biel'aran Ridge Digsite"] = "Гряда Бейл'аран - раскопки",
	["Bleeding Hollow Ruins Digsite"] = "Руины Кровавой Глазницы - раскопки",
	["Boha'mu Ruins Digsite"] = "Руины Боха'му - раскопки",
	["Bonechewer Ruins Digsite"] = "Руины Костеглодов - раскопки",
	["Bone Wastes Digsite"] = "Костяные пустоши - раскопки",
	["Broken Commons Digsite"] = "Разоренные земли - раскопки",
	["Broken Pillar Digsite"] = "Разбитая Колонна - раскопки",
	["Brunnhildar Village Digsite"] = "Деревня Бруннхильдар - раскопки",
	["Burning Blade Digsite"] = "Пылающий Клинок - раскопки",
	["Chow Farmstead Digsite"] = "Ферма Чоу - раскопки",
	["Coilskar Point Digsite"] = "Лагерь Змеиных Колец - раскопки",
	["Constellas Digsite"] = "Констеллас - раскопки",
	["Cursed Landing Digsite"] = "Проклятый лагерь - раскопки",
	["Darkmist Digsite"] = "Мглистая пещера - раскопки",
	["Den of Sorrow Digsite"] = "Логово Печали - раскопки",
	["Destroyed Village Digsite"] = "Разрушенная деревня - раскопки",
	["Dire Maul Digsite"] = "Забытый Город - раскопки",
	["Dragonmaw Fortress"] = "Крепость Драконьей Пасти",
	["Drakil'Jin Ruins Digsite"] = "Руины Дракил'джин - раскопки",
	["Dreadmaul Fossil Field"] = "Молот Ужаса - окаменелости",
	["Dunemaul Fossil Ridge"] = "Песчаный Молот - окаменелости",
	["Dun Garok Digsite"] = "Дун Гарок - раскопки",
	["Dunwald Ruins Digsite"] = "Развалины Дунвальда - раскопки",
	["East Auchindoun Digsite"] = "Восточный Аукиндон - раскопки",
	["Eastern Ruins of Thaurissan"] = "Восточные руины Тауриссана",
	["Eastern Zul'Kunda Digsite"] = "Восточная Зул'Кунда - раскопки",
	["Eastern Zul'Mamwe Digsite"] = "Восточный Зул'Мамве - раскопки",
	["Eastmoon Ruins Digsite"] = "Руины Восточной Луны - раскопки",
	["East Snow Covered Hills Digsite"] = "Восточные заснеженные холмы - раскопки",
	["East Summer Fields Digsite"] = "Западные летние поля - раскопки",
	["Eclipse Point Digsite"] = "Лагерь Затмения - раскопки",
	["Emperor's Approach Digsite"] = "Императорский проход - раскопки",
	["Emperor's Omen Digsite"] = "Знамение Императора - раскопки",
	["En'kilah Digsite"] = "Эн'кила - раскопки",
	["Ethel Rethor Digsite"] = "Этель-Ретор - раскопки",
	["Fallsong Village Digsite"] = "Деревня Поющего Водопада - раскопки",
	["Felstone Fossil Field"] = "Поле Джанис - окаменелости",
	["Fields of Blood Fossil Bank"] = "Кровавые поля - окаменелости",
	["Fire Camp Osul Digsite"] = "Огненный лагерь осулов - раскопки",
	["Five Sisters Digsite"] = "Пять Сестер - раскопки",
	["Forest Heart Digsite"] = "Сердце леса - раскопки",
	["Forest Song Digsite"] = "Лесная Песнь - раскопки",
	["Frostwhisper Gorge Digsite"] = "Теснина Ледяного Шепота - раскопки",
	["Gate to Golden Valley Digsite"] = "Ворота в Золотую долину - раскопки",
	["Gjalerbron Digsite"] = "Гьялерброн - раскопки",
	["Gong of Hope Digsite"] = "Гонг Надежды - раскопки",
	["Gor'gaz Outpost Digsite"] = "Форт Гор'газ - раскопки",
	["Grangol'var Village Digsite"] = "Деревня Грангол'вар - раскопки",
	["Great Bridge Digsite"] = "Великий мост - раскопки",
	["Greenwarden's Fossil Bank"] = "Роща Стража Природы - окаменелости",
	["Grim Batol Digsite"] = "Грим Батол - раскопки",
	["Grimesilt Digsite"] = "Гримсилт - раскопки",
	["Grimsilt Digsite"] = "Гримсилт - раскопки", -- Needs review
	["Grove of Aessina Digsite"] = "Роща Эссины - раскопки",
	["Grumblepaw Ranch Digsite"] = "Ранчо Ворчелапов - раскопки",
	["Gurubashi Arena Digsite"] = "Арена Гурубаши - раскопки",
	["Halaa Digsite"] = "Халаа - раскопки",
	["Halgrind Digsite"] = "Халгринд - раскопки",
	["Hammertoe's Digsite"] = "Карьер Тяжелоступа - раскопки",
	["Hatred's Vice Digsite"] = "Хватка Ненависти - раскопки",
	["Hellfire Basin Digsite"] = "Яма Адского Пламени - раскопки",
	["Hellfire Citadel Digsite"] = "Цитадель Адского Пламени - раскопки",
	["Humboldt Conflagration Digsite"] = "Пожарище Гумбольдта - раскопки",
	["Illidari Point Digsite"] = "Аванпост Иллидари - раскопки",
	["Infectis Scar Fossil Field"] = "Чумной овраг - окаменелости",
	["Ironband's Excavation Site"] = "Раскопки Сталекрута",
	["Ironbeard's Tomb"] = "Гробница Железноборода",
	["Ironwood Digsite"] = "Железнолесья - раскопки",
	["Jade Temple Grounds Digsite"] = "Земли Нефритового храма - раскопки",
	["Jaedenar Digsite"] = "Джеденар - раскопки",
	["Jintha'Alor Lower City Digsite"] = "Джинта'Алор, Нижний Город - раскопки",
	["Jintha'Alor Upper City Digsite"] = "Джинта'Алор, Верхний Город - раскопки",
	["Jotunheim Digsite"] = "Йотунхейм - раскопки",
	["Keset Pass Digsite"] = "Тропа Кесета - раскопки",
	["Khartut's Tomb Digsite"] = "Гробница Хартута - раскопки",
	["Kodo Graveyard"] = "Кладбище кодо",
	["Kolramas Digsite"] = "Колрамас - раскопки",
	["Krasarang Wilds Digsite"] = "Красарангские джунгли - раскопки",
	["Kun-Lai Peak Digsite"] = "Вершина Кунь-Лай - раскопки",
	["Lake Kel'Theril Digsite"] = "Озеро Кел'Терил - раскопки",
	["Lake of Stars Digsite"] = "Озеро Звезд - раскопки",
	["Lakeridge Highway Fossil Bank"] = "Озерный тракт - окаменелости",
	["Laughing Skull Digsite"] = "Веселый Череп - раскопки",
	["Lost Dynasty Digsite"] = "Забытая династия - раскопки",
	["Lower Lakkari Tar Pits"] = "Нижние Смоляные ямы Лаккари",
	["Mannoroc Coven Digsite"] = "Поле Маннорок - раскопки",
	["Marshlands Fossil Bank"] = "Топи - окаменелости",
	["Mistfall Village Digsite"] = "Деревня Туманного Водопада - раскопки",
	["Misty Reed Fossil Bank"] = "Тростниковый берег - окаменелости",
	["Moonrest Gardens Digsite"] = "Сады Лунного Покоя - раскопки",
	["Morlos'Aran Digsite"] = "Морлос'Аран - раскопки",
	["Nar'shola (Middle Tier) Digsite"] = "Нар'шола (центральный ярус) - раскопки",
	["Nazj'vel Digsite"] = "Назж'вел - раскопки",
	["Neferset Digsite"] = "Неферсет - раскопки",
	["Nek'mani Wellspring Digsite"] = "Родник Нек'Мани - раскопки",
	["Nifflevar Digsite"] = "Ниффлвар - раскопки",
	["Nightmare Scar Digsite"] = "Ров Кошмаров - раскопки",
	["Niuzao Temple Digsite"] = "Храм Нюцзао - раскопки",
	["Njorndar Village Digsite"] = "Деревня Ньорндар - раскопки",
	["North Fruited Fields Digsite"] = "Северные Урожайные поля - раскопки",
	["North Great Wall Digsite"] = "Северная часть Великой Стены - раскопки",
	["North Isildien Digsite"] = "Северный Исильдиэн - раскопки",
	["Northridge Fossil Field"] = "Северный Кряж - окаменелости",
	["North Ruins of Dojan Digsite"] = "Северные руины Доцзян- раскопки",
	["North Ruins of Guo-Lai Digsite"] = "Северные руины Го-Лай - раскопки",
	["North Summer Fields Digsite"] = "Северные летние поля - раскопки",
	["North Temple of the Red Crane Digsite"] = "Северная часть Храма Красного Журавля",
	["Obelisk of the Stars Digsite"] = "Обелиск Звезд - раскопки",
	["Old Village Digsite"] = "Старая деревня - раскопки",
	["Oneiros Digsite"] = "Онейрос - раскопки",
	["Orchard Digsite"] = "Сад - раскопки",
	["Orsis Digsite"] = "Орсис - раскопки",
	["Owl Wing Thicket Digsite"] = "Совиная чаща - раскопки",
	["Paoquan Hollow Digsite"] = "Лощина Паоцюань - раскопки",
	["Pit of Fiends Digsite"] = "Яма чудовищ - раскопки", -- Needs review
	["Pit of Narjun Digsite"] = "Провал Наржуна - раскопки",
	["Plaguewood Digsite"] = "Чумной лес - раскопки",
	["Pools of Purity Digsite"] = "Пруды Чистоты - раскопки",
	["Pyrox Flats Digsite"] = "Пироксовые равнины - раскопки",
	["Quagmire Fossil Field"] = "Трясина - окаменелости",
	["Quel'Dormir Gardens Digsite"] = "Сады Кель'Дормир - раскопки",
	["Quel'Lithien Lodge Digsite"] = "Сторожка Кель'Литиен - раскопки",
	["Ravenwind Digsite"] = "Яростный Ветер - раскопки",
	["Red Reaches Fossil Bank"] = "Красные берега - окаменелости",
	["Remote Village Digsite"] = "Далекая деревня - раскопки",
	["Riplash Ruins Digsite"] = "Руины Терзающего Бича - раскопки",
	["River Delta Digsite"] = "Дельта Вир'наала - раскопки",
	["Ruins of Aboraz"] = "Руины Абораза",
	["Ruins of Ahmtul Digsite"] = "Руины Атмула - раскопки",
	["Ruins of Ammon Digsite"] = "Руины Аммона - раскопки",
	["Ruins of Arkkoran"] = "Руины храма Арккоран",
	["Ruins of Baa'ri Digsite"] = "Руины Баа'ри - раскопки",
	["Ruins of Eldarath"] = "Руины Эльдарата",
	["Ruins of Eldre'Thar"] = "Руины Эльдре'тара",
	["Ruins of Enkaat Digsite"] = "Руины Энкаата - раскопки",
	["Ruins of Farahlon Digsite"] = "Руины Фаралона - раскопки",
	["Ruins of Gan Shi Digsite"] = "Руины Гань Ши - раскопки",
	["Ruins of Jubuwal"] = "Руины Жубуваля",
	["Ruins of Khintaset Digsite"] = "Руины Кинтасета - раскопки",
	["Ruins of Korja Digsite"] = "Руины Корцзя - раскопки",
	["Ruins of Lar'donir Digsite"] = "Руины Лар'донира - раскопки",
	["Ruins of Ordil'Aran"] = "Руины Ордил'Арана",
	["Ruins of Shandaral Digsite"] = "Руины Шандарала - раскопки",
	["Ruins of Stardust"] = "Руины Звездной Пыли",
	["Sahket Wastes Digsite"] = "Пустоши Сакет - раскопки",
	["Sanctuary of Malorne Digsite"] = "Святилище Малорна - раскопки",
	["Sands of Nasam"] = "Пески Назама", -- Needs review
	["Sargeron Digsite"] = "Саргерон - раскопки",
	["Savage Coast Raptor Fields"] = "Гибельный берег, поля ящеров",
	["Schnottz's Landing"] = "Лагерь Шнотца",
	["Scorched Plain Digsite"] = "Выжженная равнина - раскопки",
	["Scourgeholme Digsite"] = "Плетхольм - раскопки",
	["Screaming Reaches Fossil Field"] = "Вопящие плёсы - окаменелости",
	["Setting Sun Garrison Digsite"] = "Гарнизон Заходящего Солнца - раскопки",
	["Shadra'Alor Digsite"] = "Шадра'Алор - раскопки",
	["Sha'naar Digsite"] = "Ша'наар - раскопки",
	["Shanze'Dao Digsite"] = "Шань'цзэ Дао - раскопки",
	["Shield Hill Digsite"] = "Заградительный холм - раскопки",
	["Shrine Meadow Digsite"] = "Долина у святилища - раскопки",
	["Shrine of Goldrinn Digsite"] = "Святилище Голдринна - раскопки",
	["Shrine of the Dawn Digsite"] = "Святилище Рассвета - раскопки",
	["Sifreldar Village Digsite"] = "Деревня Сифрельдар - раскопки",
	["Singing Marshes Digsite"] = "Поющие болота - раскопки",
	["Skorn Digsite"] = "Скорн - раскопки",
	["Slitherblade Shore Digsite"] = "Берег Скользящего Плавника - раскопки",
	["Small Gate Digsite"] = "Малые ворота - раскопки",
	["Snow Covered Hills Digsite"] = "Заснеженные холмы - раскопки",
	["Solarsal Digsite"] = "Соларсаль - раскопки",
	["South Fruited Fields Digsite"] = "Южные Урожайные поля - раскопки",
	["South Great Wall Digsite"] = "Южная часть Великой Стены - раскопки",
	["South Isildien Digsite"] = "Южный Исильдиэн - раскопки",
	["Southmoon Ruins Digsite"] = "Руины Южной Луны - раскопки",
	["South Orchard Digsite"] = "Южная часть сада - раскопки",
	["South Ruins of Dojan Digsite"] = "Южные руины Доцзян - раскопки",
	["South Ruins of Guo-Lai Digsite"] = "Южные руины Го-Лай - раскопки",
	["Southshore Fossil Field"] = "Южнобережье - окаменелости",
	["Southwind Village Digsite"] = "Деревня Южного Ветра - раскопки",
	["Sra'thik Digsite"] = "Шра'тик - раскопки",
	["Steps of Fate Digsite"] = "Шаги Судьбы - раскопки",
	["Stonetalon Peak"] = "Пик Каменного Когтя",
	["Sunken Temple Digsite"] = "Затонувший храм - раскопки",
	["Sunspring Post Digsite"] = "Застава Солнечного Источника - раскопки",
	["Talramas Digsite"] = "Талрамас - раскопки",
	["Temple of Uldum Digsite"] = "Храм Ульдума - раскопки",
	["Terrace of Gurthan Digsite"] = "Терраса Гуртан - раскопки",
	["Terror Run Fossil Field"] = "Путь Ужаса - окаменелости",
	["Terrorweb Tunnel Digsite"] = "Туннель Ужаса - раскопки",
	["Terror Wing Fossil Field"] = "Тропа Крылатого Ужаса - окаменелости",
	["Thandol Span"] = "Мост Тандола",
	["The Arboretum Digsite"] = "Дендрарий - раскопки",
	["The Spring Road Digsite"] = "Весенняя тропа - раскопки",
	["Thoradin's Wall"] = "Стена Торадина",
	["Thundermar Ruins Digsite"] = "Руины Громтара - раскопки",
	["Thunderwood Digsite"] = "Громовой лес - раскопки",
	["Tian Digsite"] = "Чунь Тянь - раскопки",
	["Tiger's Wood Digsite"] = "Тигриный лес - раскопки",
	["Tomb of the Watchers Digsite"] = "Гробница Стражей - раскопки",
	["Tombs of the Precursors Digsite"] = "Гробницы Предтеч - раскопки",
	["Torjari Pit Digsite"] = "Тораждарская яма - раскопки",
	["Tu Shen Digsite"] = "Кладбище Ту-Шэнь - раскопки",
	["Tuurem Digsite"] = "Туурем - раскопки",
	["Twilight Grove Digsite"] = "Мглистая роща - раскопки",
	["Twin Spire Ruins Digsite"] = "Руины Двух Башен - раскопки",
	["Uldaman Entrance Digsite"] = "Вход в Ульдаман - раскопки",
	["Unearthed Grounds"] = "Место раскопок",
	["Upper Lakkari Tar Pits"] = "Верхние Смоляные ямы Лаккари",
	["Valkyrion Digsite"] = "Валькирион - раскопки",
	["Valley of Bones"] = "Долина Костей",
	["Valley of Kings Digsite"] = "Долина Королей - раскопки",
	["Veridian Grove Digsite"] = "Зеленая роща - раскопки",
	["Violet Stand Digsite"] = "Аметистовая застава - раскопки",
	["Voldrune Digsite"] = "Волдрун - раскопки",
	["Vul'Gol Fossil Bank"] = "Вул'Гол - окаменелости",
	["Warden's Cage Digsite"] = "Клеть Стражницы - раскопки",
	["West Auchindoun Digsite"] = "Западный Аукиндон - раскопки",
	["Western Ruins of Thaurissan"] = "Западные руины Тауриссана",
	["Western Zul'Kunda Digsite"] = "Западная Зул'Кунда - раскопки",
	["Western Zul'Mamwe Digsite"] = "Западный Зул'Мамве - раскопки",
	["West Old Village Digsite"] = "Западная часть старой деревни - раскопки",
	["West Ruins of Guo-Lai Digsite"] = "Западные руины Го-Лай - раскопки",
	["West Summer Fields Digsite"] = "Западные летние поля - раскопки",
	["Whelgar's Excavation Site"] = "Раскопки Вельгара",
	["Winterbough Digsite"] = "Опушка Зимней Ветви - раскопки",
	["Witherbark Digsite"] = "Деревня Сухокожих - раскопки",
	["Writhingwood Digsite"] = "Кривое дерево - раскопки",
	["Wyrmbog Fossil Field"] = "Драконьи топи - окаменелости",
	["Wyrmskull Digsite"] = "Драконий Череп - раскопки",
	["Ymirheim Digsite"] = "Имирхейм - раскопки",
	["Zeth'Gor Digsite"] = "Зет'Гор - раскопки",
	["Zhu Province Digsite"] = "Провинция Чжу - раскопки",
	["Ziata'jai Digsite"] = "Зиата'джаи - раскопки",
	["Zim'Rhuk Digsite"] = "Зим'Рук - раскопки",
	["Zol'Heb Digsite"] = "Зол'Хеб - раскопки",
	["Zoram Strand Digsite"] = "Зорамское взморье - раскопки",
	["Zul'Farrak Digsite"] = "Зул'Фаррак - раскопки",
	["Zul'Mashar Digsite"] = "Зул'Машар - раскопки",
}
elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "深沙化石岭",
	["Aerie Peak Digsite"] = "鹰巢山挖掘场",
	["Agol'watha Digsite"] = "亚戈瓦萨挖掘场",
	["Akhenet Fields Digsite"] = "埃卡赫莱平原挖掘场",
	["Altar of Quetz'lun Digsite"] = "奎丝鲁恩祭坛挖掘场",
	["Altar of Sseratus Digsite"] = "西莱图斯祭坛挖掘场",
	["Altar of Zul Digsite"] = "祖尔祭坛挖掘场",
	["Ancestral Grounds Digsite"] = "先祖之地挖掘场",
	["Andorhal Fossil Bank"] = "安多哈尔化石堆",
	["Arklon Ruins Digsite"] = "阿尔科隆废墟挖掘场",
	["Bael Modan Digsite"] = "巴尔莫丹挖掘场",
	["Baleheim Digsite"] = "拜尔海姆挖掘场",
	["Balia'mah Digsite"] = "巴里亚曼挖掘场",
	["Bal'lal Ruins Digsite"] = "巴拉尔废墟挖掘场",
	["Biel'aran Ridge Digsite"] = "贝耶拉兰山挖掘场",
	["Bleeding Hollow Ruins Digsite"] = "血环废墟挖掘场",
	["Boha'mu Ruins Digsite"] = "博哈姆废墟挖掘场",
	["Bonechewer Ruins Digsite"] = "噬骨废墟挖掘场",
	["Bone Wastes Digsite"] = "白骨荒野挖掘场",
	["Broken Commons Digsite"] = "平民区废墟挖掘场",
	["Broken Pillar Digsite"] = "破碎石柱挖掘场",
	["Brunnhildar Village Digsite"] = "布伦希尔达村挖掘场",
	["Burning Blade Digsite"] = "火刃挖掘场",
	["Chow Farmstead Digsite"] = "周家农田挖掘场",
	["Coilskar Point Digsite"] = "库斯卡岗哨挖掘场",
	["Constellas Digsite"] = "克斯特拉斯挖掘场",
	["Cursed Landing Digsite"] = "被诅咒的登陆点挖掘场",
	["Darkmist Digsite"] = "黑雾挖掘场",
	["Den of Sorrow Digsite"] = "悲伤之穴挖掘场",
	["Destroyed Village Digsite"] = "被摧毁的村庄挖掘场",
	["Dire Maul Digsite"] = "厄运之槌挖掘场",
	["Dragonmaw Fortress"] = "龙喉要塞",
	["Drakil'Jin Ruins Digsite"] = "达基尔金废墟挖掘场",
	["Dreadmaul Fossil Field"] = "巨槌化石场",
	["Dunemaul Fossil Ridge"] = "砂槌化石岭",
	["Dun Garok Digsite"] = "丹加洛克挖掘场",
	["Dunwald Ruins Digsite"] = "顿沃德废墟挖掘场",
	["East Auchindoun Digsite"] = "东奥金顿挖掘场",
	["Eastern Ruins of Thaurissan"] = "东索瑞森废墟",
	["Eastern Zul'Kunda Digsite"] = "东祖昆达挖掘场",
	["Eastern Zul'Mamwe Digsite"] = "东祖玛维挖掘场",
	["Eastmoon Ruins Digsite"] = "东月废墟挖掘场",
	["East Snow Covered Hills Digsite"] = "雪山东部挖掘场",
	["East Summer Fields Digsite"] = "仲夏原东部挖掘场",
	["Eclipse Point Digsite"] = "日蚀岗哨挖掘场",
	["Emperor's Approach Digsite"] = "帝皇之疆挖掘场",
	["Emperor's Omen Digsite"] = "皇帝的预言地挖掘场",
	["En'kilah Digsite"] = "恩其拉挖掘场",
	["Ethel Rethor Digsite"] = "艾瑟雷索挖掘场",
	["Fallsong Village Digsite"] = "瀑歌村挖掘场",
	["Felstone Fossil Field"] = "费尔斯通化石场",
	["Fields of Blood Fossil Bank"] = "鲜血旷野化石堆",
	["Fire Camp Osul Digsite"] = "奥苏尔火营挖掘场",
	["Five Sisters Digsite"] = "五姝林挖掘场",
	["Forest Heart Digsite"] = "翠林之心挖掘场",
	["Forest Song Digsite"] = "林歌神殿挖掘场",
	["Frostwhisper Gorge Digsite"] = "霜语峡谷挖掘场",
	["Gate to Golden Valley Digsite"] = "锦绣谷大门挖掘场",
	["Gjalerbron Digsite"] = "亚勒伯龙挖掘场",
	["Gong of Hope Digsite"] = "希望之锣挖掘场",
	["Gor'gaz Outpost Digsite"] = "高加兹前哨挖掘场",
	["Grangol'var Village Digsite"] = "格兰戈瓦村挖掘场",
	["Great Bridge Digsite"] = "长桥挖掘场",
	["Greenwarden's Fossil Bank"] = "绿色守卫者化石堆",
	["Grim Batol Digsite"] = "格瑞姆巴托挖掘场",
	["Grimesilt Digsite"] = "煤渣挖掘场",
	["Grimsilt Digsite"] = "煤渣挖掘场",
	["Grove of Aessina Digsite"] = "艾森娜林地挖掘场",
	["Grumblepaw Ranch Digsite"] = "怨掌农场挖掘场",
	["Gurubashi Arena Digsite"] = "古拉巴什挖掘场",
	["Halaa Digsite"] = "哈兰挖掘场",
	["Halgrind Digsite"] = "哈尔格林德挖掘场",
	["Hammertoe's Digsite"] = "铁趾挖掘场",
	["Hatred's Vice Digsite"] = "仇恨之恶挖掘场",
	["Hellfire Basin Digsite"] = "地狱火盆地挖掘场",
	["Hellfire Citadel Digsite"] = "地狱火堡垒挖掘场",
	["Humboldt Conflagration Digsite"] = "洪堡焚烧峡谷挖掘场",
	["Illidari Point Digsite"] = "伊利达雷岗哨挖掘场",
	["Infectis Scar Fossil Field"] = "魔刃之痕化石场",
	["Ironband's Excavation Site"] = "铁环挖掘场",
	["Ironbeard's Tomb"] = "铁须之墓",
	["Ironwood Digsite"] = "铁木挖掘场",
	["Jade Temple Grounds Digsite"] = "青龙寺庭院挖掘场",
	["Jaedenar Digsite"] = "加德纳尔挖掘场",
	["Jintha'Alor Lower City Digsite"] = "辛萨罗下层挖掘场",
	["Jintha'Alor Upper City Digsite"] = "辛萨罗上层挖掘场",
	["Jotunheim Digsite"] = "尤顿海姆挖掘场",
	["Keset Pass Digsite"] = "柯塞特小径挖掘场",
	["Khartut's Tomb Digsite"] = "卡塔图陵墓挖掘场",
	["Kodo Graveyard"] = "科多兽坟场",
	["Kolramas Digsite"] = "科尔拉玛斯挖掘场",
	["Krasarang Wilds Digsite"] = "卡桑琅丛林挖掘场",
	["Kun-Lai Peak Digsite"] = "昆莱之峰挖掘场",
	["Lake Kel'Theril Digsite"] = "凯斯利尔湖挖掘场",
	["Lake of Stars Digsite"] = "群星湖挖掘场",
	["Lakeridge Highway Fossil Bank"] = "湖边大道化石堆",
	["Laughing Skull Digsite"] = "嘲颅挖掘场",
	["Lost Dynasty Digsite"] = "失落王朝挖掘场",
	["Lower Lakkari Tar Pits"] = "下层拉卡利油沼",
	["Mannoroc Coven Digsite"] = "玛诺洛克集会所挖掘场",
	["Marshlands Fossil Bank"] = "沼泽地化石堆",
	["Mistfall Village Digsite"] = "雾临村挖掘场",
	["Misty Reed Fossil Bank"] = "芦苇化石堆",
	["Moonrest Gardens Digsite"] = "眠月花园挖掘场",
	["Morlos'Aran Digsite"] = "摩罗萨兰挖掘场",
	["Nar'shola (Middle Tier) Digsite"] = "纳舒拉（中层）挖掘场",
	["Nazj'vel Digsite"] = "纳兹维尔挖掘场",
	["Neferset Digsite"] = "尼斐塞特挖掘场",
	["Nek'mani Wellspring Digsite"] = "纳克迈尼圣泉挖掘场",
	["Nifflevar Digsite"] = "尼弗莱瓦挖掘场",
	["Nightmare Scar Digsite"] = "噩梦之痕挖掘场",
	["Niuzao Temple Digsite"] = "砮皂寺挖掘场",
	["Njorndar Village Digsite"] = "约尔达村挖掘场",
	["North Fruited Fields Digsite"] = "水果农田北部挖掘场",
	["North Great Wall Digsite"] = "长城北部挖掘场",
	["North Isildien Digsite"] = "北伊斯迪尔挖掘场",
	["Northridge Fossil Field"] = "北山化石场",
	["North Ruins of Dojan Digsite"] = "都阳废墟北部挖掘场",
	["North Ruins of Guo-Lai Digsite"] = "郭莱遗迹北部挖掘场",
	["North Summer Fields Digsite"] = "仲夏原北部挖掘场",
	["North Temple of the Red Crane Digsite"] = "朱鹤寺北部挖掘场",
	["Obelisk of the Stars Digsite"] = "群星方尖碑挖掘场",
	["Old Village Digsite"] = "古老村庄挖掘场",
	["Oneiros Digsite"] = "奥奈罗斯挖掘场",
	["Orchard Digsite"] = "果园挖掘场",
	["Orsis Digsite"] = "奥西斯挖掘场",
	["Owl Wing Thicket Digsite"] = "枭翼树丛挖掘场",
	["Paoquan Hollow Digsite"] = "抱拳林挖掘场",
	["Pit of Fiends Digsite"] = "邪魔之坑挖掘场",
	["Pit of Narjun Digsite"] = "纳尔苏深渊挖掘场",
	["Plaguewood Digsite"] = "病木林挖掘场",
	["Pools of Purity Digsite"] = "纯净之池挖掘场",
	["Pyrox Flats Digsite"] = "漫火平原挖掘场",
	["Quagmire Fossil Field"] = "泥潭沼泽化石场",
	["Quel'Dormir Gardens Digsite"] = "奎尔多米尔花园挖掘场",
	["Quel'Lithien Lodge Digsite"] = "奎尔林斯小屋挖掘场",
	["Ravenwind Digsite"] = "鸦风挖掘场",
	["Red Reaches Fossil Bank"] = "赤色海岸化石堆",
	["Remote Village Digsite"] = "偏远村庄挖掘场",
	["Riplash Ruins Digsite"] = "裂鞭废墟挖掘场",
	["River Delta Digsite"] = "三角洲挖掘场",
	["Ruins of Aboraz"] = "阿博拉兹废墟",
	["Ruins of Ahmtul Digsite"] = "阿胡图尔遗迹挖掘场",
	["Ruins of Ammon Digsite"] = "阿蒙遗迹挖掘场",
	["Ruins of Arkkoran"] = "亚考兰神殿废墟",
	["Ruins of Baa'ri Digsite"] = "巴尔里废墟挖掘场",
	["Ruins of Eldarath"] = "埃达拉斯废墟",
	["Ruins of Eldre'Thar"] = "埃德雷萨废墟",
	["Ruins of Enkaat Digsite"] = "恩卡特废墟挖掘场",
	["Ruins of Farahlon Digsite"] = "法兰伦废墟挖掘场",
	["Ruins of Gan Shi Digsite"] = "钢狮废墟挖掘场",
	["Ruins of Jubuwal"] = "朱布瓦尔废墟",
	["Ruins of Khintaset Digsite"] = "辛塔希特遗迹挖掘场",
	["Ruins of Korja Digsite"] = "科夏废墟挖掘场",
	["Ruins of Lar'donir Digsite"] = "拉多尼尔遗迹挖掘场",
	["Ruins of Ordil'Aran"] = "奥迪拉兰废墟",
	["Ruins of Shandaral Digsite"] = "杉达拉废墟挖掘场",
	["Ruins of Stardust"] = "星尘废墟",
	["Sahket Wastes Digsite"] = "沙赫柯特荒原挖掘场",
	["Sanctuary of Malorne Digsite"] = "玛洛恩庇护所挖掘场",
	["Sands of Nasam"] = "纳萨姆沙地挖掘场",
	["Sargeron Digsite"] = "萨格隆挖掘场",
	["Savage Coast Raptor Fields"] = "野人海岸迅猛龙遗址",
	["Schnottz's Landing"] = "司克诺兹登陆点挖掘场",
	["Scorched Plain Digsite"] = "焦痕平原挖掘场",
	["Scourgeholme Digsite"] = "天灾城挖掘场",
	["Screaming Reaches Fossil Field"] = "尖啸河滩化石场",
	["Setting Sun Garrison Digsite"] = "残阳关卫戍营挖掘场",
	["Shadra'Alor Digsite"] = "沙德拉洛挖掘场",
	["Sha'naar Digsite"] = "沙纳尔挖掘场",
	["Shanze'Dao Digsite"] = "山泽岛挖掘场",
	["Shield Hill Digsite"] = "盾牌岭挖掘场",
	["Shrine Meadow Digsite"] = "神龛草地挖掘场",
	["Shrine of Goldrinn Digsite"] = "戈德林圣殿挖掘场",
	["Shrine of the Dawn Digsite"] = "黎明神龛挖掘场",
	["Sifreldar Village Digsite"] = "希弗列尔达村挖掘场",
	["Singing Marshes Digsite"] = "轻歌沼泽挖掘场",
	["Skorn Digsite"] = "斯克恩挖掘场",
	["Slitherblade Shore Digsite"] = "滑刃海岸挖掘场",
	["Small Gate Digsite"] = "小门挖掘场",
	["Snow Covered Hills Digsite"] = "雪山挖掘场",
	["Solarsal Digsite"] = "索兰萨尔挖掘场",
	["South Fruited Fields Digsite"] = "水果农田挖掘场",
	["South Great Wall Digsite"] = "长城南部挖掘场",
	["South Isildien Digsite"] = "南伊斯迪尔挖掘场",
	["Southmoon Ruins Digsite"] = "南月废墟挖掘场",
	["South Orchard Digsite"] = "果园南部挖掘场",
	["South Ruins of Dojan Digsite"] = "都阳废墟南部挖掘场",
	["South Ruins of Guo-Lai Digsite"] = "郭莱遗迹南部挖掘场",
	["Southshore Fossil Field"] = "南海镇化石场",
	["Southwind Village Digsite"] = "南风村挖掘场",
	["Sra'thik Digsite"] = "瑟拉提克挖掘场",
	["Steps of Fate Digsite"] = "天命阶梯挖掘场",
	["Stonetalon Peak"] = "石爪峰",
	["Sunken Temple Digsite"] = "沉没的神庙挖掘场",
	["Sunspring Post Digsite"] = "日泉岗哨挖掘场",
	["Talramas Digsite"] = "塔尔拉玛斯挖掘场",
	["Temple of Uldum Digsite"] = "奥丹姆神殿挖掘场",
	["Terrace of Gurthan Digsite"] = "格尔桑平台挖掘场",
	["Terror Run Fossil Field"] = "恐惧小道化石场",
	["Terrorweb Tunnel Digsite"] = "恶蛛隧道挖掘场",
	["Terror Wing Fossil Field"] = "龙翼小径化石场",
	["Thandol Span"] = "萨多尔大桥",
	["The Arboretum Digsite"] = "百木园挖掘场",
	["The Spring Road Digsite"] = "春之路挖掘场",
	["Thoradin's Wall"] = "索拉丁之墙",
	["Thundermar Ruins Digsite"] = "桑德玛尔废墟挖掘场",
	["Thunderwood Digsite"] = "雷木林挖掘场",
	["Tian Digsite"] = "天禅院挖掘场",
	["Tiger's Wood Digsite"] = "猛虎林挖掘场",
	["Tomb of the Watchers Digsite"] = "观察者陵墓挖掘场",
	["Tombs of the Precursors Digsite"] = "先贤陵墓挖掘场",
	["Torjari Pit Digsite"] = "托加尼洼地挖掘场",
	["Tu Shen Digsite"] = "徒圣挖掘场",
	["Tuurem Digsite"] = "图雷姆挖掘场",
	["Twilight Grove Digsite"] = "黎明森林挖掘场",
	["Twin Spire Ruins Digsite"] = "双塔废墟挖掘场",
	["Uldaman Entrance Digsite"] = "奥达曼入口挖掘场",
	["Unearthed Grounds"] = "不毛之地",
	["Upper Lakkari Tar Pits"] = "上层拉卡利油沼",
	["Valkyrion Digsite"] = "瓦基里安挖掘场",
	["Valley of Bones"] = "白骨之谷",
	["Valley of Kings Digsite"] = "国王谷挖掘场",
	["Veridian Grove Digsite"] = "碧绿林地挖掘场",
	["Violet Stand Digsite"] = "紫罗兰哨站挖掘场",
	["Voldrune Digsite"] = "沃德伦挖掘场",
	["Vul'Gol Fossil Bank"] = "沃古尔化石堆",
	["Warden's Cage Digsite"] = "守望者牢笼挖掘场",
	["West Auchindoun Digsite"] = "西奥金顿挖掘场",
	["Western Ruins of Thaurissan"] = "西索瑞森废墟",
	["Western Zul'Kunda Digsite"] = "西祖昆达挖掘场",
	["Western Zul'Mamwe Digsite"] = "西祖玛维挖掘场",
	["West Old Village Digsite"] = "古老村庄西部挖掘场",
	["West Ruins of Guo-Lai Digsite"] = "郭莱废墟西部挖掘场",
	["West Summer Fields Digsite"] = "仲夏原西部挖掘场",
	["Whelgar's Excavation Site"] = "维尔加挖掘场",
	["Winterbough Digsite"] = "冬花挖掘场",
	["Witherbark Digsite"] = "枯木挖掘场",
	["Writhingwood Digsite"] = "盘绕古木挖掘场",
	["Wyrmbog Fossil Field"] = "巨龙沼泽化石场",
	["Wyrmskull Digsite"] = "龙颅挖掘场",
	["Ymirheim Digsite"] = "伊米海姆挖掘场",
	["Zeth'Gor Digsite"] = "塞斯高挖掘场",
	["Zhu Province Digsite"] = "朱家界挖掘场",
	["Ziata'jai Digsite"] = "赞塔加挖掘场",
	["Zim'Rhuk Digsite"] = "希姆鲁克挖掘场",
	["Zol'Heb Digsite"] = "佐尔赫布挖掘场",
	["Zoram Strand Digsite"] = "佐拉姆海岸挖掘场",
	["Zul'Farrak Digsite"] = "祖尔法拉克挖掘场",
	["Zul'Mashar Digsite"] = "祖玛沙尔挖掘场",
}
elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations {
	["Abyssal Sands Fossil Ridge"] = "深沙平原古山脊",
	["Aerie Peak Digsite"] = "鷹巢山挖掘場",
	["Agol'watha Digsite"] = "亞戈瓦薩挖掘場",
	["Akhenet Fields Digsite"] = "雅奇涅特原野挖掘場",
	["Altar of Quetz'lun Digsite"] = "奎茲倫祭壇挖掘場",
	["Altar of Sseratus Digsite"] = "司瑟拉圖斯祭壇挖掘場",
	["Altar of Zul Digsite"] = "祖爾祭壇挖掘場",
	["Ancestral Grounds Digsite"] = "先祖之地挖掘場",
	["Andorhal Fossil Bank"] = "安多哈爾古河岸",
	["Arklon Ruins Digsite"] = "阿克隆廢墟挖掘場",
	["Bael Modan Digsite"] = "巴爾莫丹挖掘場",
	["Baleheim Digsite"] = "貝爾海姆挖掘場",
	["Balia'mah Digsite"] = "巴里亞曼挖掘場",
	["Bal'lal Ruins Digsite"] = "巴拉爾廢墟挖掘場",
	["Biel'aran Ridge Digsite"] = "畢耶拉蘭山脊挖掘場",
	["Bleeding Hollow Ruins Digsite"] = "血之谷廢墟挖掘場",
	["Boha'mu Ruins Digsite"] = "波哈姆廢墟挖掘場",
	["Bonechewer Ruins Digsite"] = "噬骨者廢墟挖掘場",
	["Bone Wastes Digsite"] = "白骨荒野挖掘場",
	["Broken Commons Digsite"] = "平民區廢墟挖掘場",
	["Broken Pillar Digsite"] = "破碎石柱挖掘場",
	["Brunnhildar Village Digsite"] = "布倫希爾達村挖掘場",
	["Burning Blade Digsite"] = "燃刃挖掘場",
	["Chow Farmstead Digsite"] = "周家莊挖掘場",
	["Coilskar Point Digsite"] = "考斯卡崗哨挖掘場",
	["Constellas Digsite"] = "克斯特拉斯挖掘場",
	["Cursed Landing Digsite"] = "詛咒臺地挖掘場",
	["Darkmist Digsite"] = "暗霧挖掘場",
	["Den of Sorrow Digsite"] = "悲愁洞府挖掘場",
	["Destroyed Village Digsite"] = "被摧毀的村莊挖掘場",
	["Dire Maul Digsite"] = "厄運之槌挖掘場",
	["Dragonmaw Fortress"] = "龍喉堡壘",
	["Drakil'Jin Ruins Digsite"] = "德拉齊金遺跡挖掘場",
	["Dreadmaul Fossil Field"] = "巨槌古原野",
	["Dunemaul Fossil Ridge"] = "砂槌古山脊",
	["Dun Garok Digsite"] = "丹加洛克挖掘場",
	["Dunwald Ruins Digsite"] = "登瓦德廢墟挖掘場",
	["East Auchindoun Digsite"] = "奧齊頓東部挖掘場",
	["Eastern Ruins of Thaurissan"] = "索瑞森東部廢墟",
	["Eastern Zul'Kunda Digsite"] = "祖昆達東部挖掘場",
	["Eastern Zul'Mamwe Digsite"] = "祖瑪維東部挖掘場",
	["Eastmoon Ruins Digsite"] = "東月廢墟挖掘場",
	["East Snow Covered Hills Digsite"] = "被雪覆蓋山上東邊的挖掘場",
	["East Summer Fields Digsite"] = "夏之原東部挖掘場",
	["Eclipse Point Digsite"] = "日蝕崗哨挖掘場",
	["Emperor's Approach Digsite"] = "帝迎大道挖掘場",
	["Emperor's Omen Digsite"] = "帝王之兆挖掘場",
	["En'kilah Digsite"] = "恩吉拉挖掘場",
	["Ethel Rethor Digsite"] = "艾瑟雷索挖掘場",
	["Fallsong Village Digsite"] = "秋歌村挖掘場",
	["Felstone Fossil Field"] = "費爾斯通古原野",
	["Fields of Blood Fossil Bank"] = "鮮血草原古河岸",
	["Fire Camp Osul Digsite"] = "歐索火焰營地挖掘場",
	["Five Sisters Digsite"] = "五仙石挖掘場",
	["Forest Heart Digsite"] = "森林之心挖掘場",
	["Forest Song Digsite"] = "林歌神殿挖掘場",
	["Frostwhisper Gorge Digsite"] = "霜語峽谷挖掘場",
	["Gate to Golden Valley Digsite"] = "金色山谷之門挖掘場",
	["Gjalerbron Digsite"] = "夏勒布隆挖掘場",
	["Gong of Hope Digsite"] = "希望之鑼挖掘場",
	["Gor'gaz Outpost Digsite"] = "葛卡茲哨站挖掘場",
	["Grangol'var Village Digsite"] = "葛蘭戈瓦村挖掘場",
	["Great Bridge Digsite"] = "大橋挖掘場",
	["Greenwarden's Fossil Bank"] = "綠意守望者之林古河岸",
	["Grim Batol Digsite"] = "格瑞姆巴托挖掘場",
	["Grimesilt Digsite"] = "煤渣挖掘場",
	["Grimsilt Digsite"] = "煤渣挖掘場", -- Needs review
	["Grove of Aessina Digsite"] = "艾森娜之林挖掘場",
	["Grumblepaw Ranch Digsite"] = "波爪農場挖掘場",
	["Gurubashi Arena Digsite"] = "古拉巴什競技場挖掘場",
	["Halaa Digsite"] = "哈剌挖掘場",
	["Halgrind Digsite"] = "霍葛萊挖掘場",
	["Hammertoe's Digsite"] = "鐵趾挖掘場",
	["Hatred's Vice Digsite"] = "仇恨之惡挖掘場",
	["Hellfire Basin Digsite"] = "地獄火盆地挖掘場",
	["Hellfire Citadel Digsite"] = "地獄火堡壘挖掘場",
	["Humboldt Conflagration Digsite"] = "杭伯特焚焰地挖掘場",
	["Illidari Point Digsite"] = "伊利達瑞崗哨挖掘場",
	["Infectis Scar Fossil Field"] = "魔刃之痕古原野",
	["Ironband's Excavation Site"] = "鐵環挖掘場",
	["Ironbeard's Tomb"] = "鐵鬚之墓",
	["Ironwood Digsite"] = "鐵木挖掘場",
	["Jade Temple Grounds Digsite"] = "玉廟庭挖掘場",
	["Jaedenar Digsite"] = "加德納爾挖掘場",
	["Jintha'Alor Lower City Digsite"] = "辛薩羅城下層挖掘場",
	["Jintha'Alor Upper City Digsite"] = "辛薩羅城上層挖掘場",
	["Jotunheim Digsite"] = "卓頓海姆挖掘場",
	["Keset Pass Digsite"] = "奇瑟小徑挖掘場",
	["Khartut's Tomb Digsite"] = "卡爾吐特之墓挖掘場",
	["Kodo Graveyard"] = "科多獸墳場",
	["Kolramas Digsite"] = "科爾拉瑪斯挖掘場",
	["Krasarang Wilds Digsite"] = "喀撒朗蠻荒挖掘場",
	["Kun-Lai Peak Digsite"] = "崑萊頂峰挖掘場",
	["Lake Kel'Theril Digsite"] = "凱斯利爾湖挖掘場",
	["Lake of Stars Digsite"] = "星辰湖挖掘場",
	["Lakeridge Highway Fossil Bank"] = "湖邊大道古河岸",
	["Laughing Skull Digsite"] = "獰笑骷髏挖掘場",
	["Lost Dynasty Digsite"] = "失落皇朝",
	["Lower Lakkari Tar Pits"] = "拉卡利油沼低地",
	["Mannoroc Coven Digsite"] = "瑪諾洛克集會所挖掘場",
	["Marshlands Fossil Bank"] = "沼澤地古河岸",
	["Mistfall Village Digsite"] = "霧臨村挖掘場",
	["Misty Reed Fossil Bank"] = "蘆葦古河岸",
	["Moonrest Gardens Digsite"] = "月眠花園挖掘場",
	["Morlos'Aran Digsite"] = "莫洛亞藍挖掘場",
	["Nar'shola (Middle Tier) Digsite"] = "納爾朔拉殿堂(中層)挖掘場",
	["Nazj'vel Digsite"] = "納傑韋爾挖掘場",
	["Neferset Digsite"] = "奈斐賽特挖掘場",
	["Nek'mani Wellspring Digsite"] = "納克邁尼聖泉挖掘場",
	["Nifflevar Digsite"] = "尼弗瓦挖掘場",
	["Nightmare Scar Digsite"] = "惡夢之痕挖掘場",
	["Niuzao Temple Digsite"] = "怒兆寺挖掘場",
	["Njorndar Village Digsite"] = "尼約達村挖掘場",
	["North Fruited Fields Digsite"] = "豐果園北部挖掘場",
	["North Great Wall Digsite"] = "長城北部挖掘場",
	["North Isildien Digsite"] = "伊斯迪爾北部挖掘場",
	["Northridge Fossil Field"] = "北山古化石原野",
	["North Ruins of Dojan Digsite"] = "朵迦廢墟北部挖掘場",
	["North Ruins of Guo-Lai Digsite"] = "郭萊廢墟北部挖掘場",
	["North Summer Fields Digsite"] = "夏之原北部挖掘場",
	["North Temple of the Red Crane Digsite"] = "紅鶴寺北部挖掘場",
	["Obelisk of the Stars Digsite"] = "眾星方尖碑挖掘場",
	["Old Village Digsite"] = "老村子挖掘場",
	["Oneiros Digsite"] = "奧奈羅斯挖掘場",
	["Orchard Digsite"] = "果園挖掘場",
	["Orsis Digsite"] = "奧爾希斯挖掘場",
	["Owl Wing Thicket Digsite"] = "梟翼樹叢挖掘場",
	["Paoquan Hollow Digsite"] = "泡泉谷挖掘場",
	["Pit of Fiends Digsite"] = "魔鬼之淵挖掘場",
	["Pit of Narjun Digsite"] = "那金之淵挖掘場",
	["Plaguewood Digsite"] = "病木林挖掘場",
	["Pools of Purity Digsite"] = "純淨之池挖掘場",
	["Pyrox Flats Digsite"] = "派洛克斯平原挖掘場",
	["Quagmire Fossil Field"] = "泥潭沼澤古原野",
	["Quel'Dormir Gardens Digsite"] = "奎多米爾花園挖掘場",
	["Quel'Lithien Lodge Digsite"] = "奎爾林斯小屋挖掘場",
	["Ravenwind Digsite"] = "鴉風挖掘場",
	["Red Reaches Fossil Bank"] = "紅色海岸古河岸",
	["Remote Village Digsite"] = "偏遠村子挖掘場",
	["Riplash Ruins Digsite"] = "裂鞭遺跡挖掘場",
	["River Delta Digsite"] = "三角洲挖掘場",
	["Ruins of Aboraz"] = "阿博拉茲廢墟",
	["Ruins of Ahmtul Digsite"] = "阿姆圖爾廢墟挖掘場",
	["Ruins of Ammon Digsite"] = "亞蒙廢墟挖掘場",
	["Ruins of Arkkoran"] = "亞考蘭廢墟",
	["Ruins of Baa'ri Digsite"] = "巴瑞廢墟挖掘場",
	["Ruins of Eldarath"] = "埃達拉斯廢墟",
	["Ruins of Eldre'Thar"] = "艾爾德雷薩廢墟",
	["Ruins of Enkaat Digsite"] = "安卡特廢墟挖掘場",
	["Ruins of Farahlon Digsite"] = "法拉隆廢墟挖掘場",
	["Ruins of Gan Shi Digsite"] = "剛石廢墟挖掘場",
	["Ruins of Jubuwal"] = "朱布瓦爾廢墟",
	["Ruins of Khintaset Digsite"] = "克因塔賽廢墟挖掘場",
	["Ruins of Korja Digsite"] = "廓亞廢墟挖掘場",
	["Ruins of Lar'donir Digsite"] = "拉多尼爾廢墟挖掘場",
	["Ruins of Ordil'Aran"] = "奧迪拉蘭廢墟",
	["Ruins of Shandaral Digsite"] = "珊達拉遺跡挖掘場",
	["Ruins of Stardust"] = "星塵廢墟",
	["Sahket Wastes Digsite"] = "薩克特荒原挖掘場",
	["Sanctuary of Malorne Digsite"] = "瑪洛尼聖地挖掘場",
	["Sands of Nasam"] = "納森沙地",
	["Sargeron Digsite"] = "薩格隆挖掘場",
	["Savage Coast Raptor Fields"] = "野人海岸迅猛龍平原",
	["Schnottz's Landing"] = "舒諾茲營地",
	["Scorched Plain Digsite"] = "烈焰平原挖掘場",
	["Scourgeholme Digsite"] = "天譴岸地挖掘場",
	["Screaming Reaches Fossil Field"] = "尖嘯河岸古原野",
	["Setting Sun Garrison Digsite"] = "落陽要塞挖掘場",
	["Shadra'Alor Digsite"] = "沙德拉洛挖掘場",
	["Sha'naar Digsite"] = "夏納挖掘場",
	["Shanze'Dao Digsite"] = "衫織島挖掘場",
	["Shield Hill Digsite"] = "盾丘挖掘場",
	["Shrine Meadow Digsite"] = "草地聖壇挖掘場",
	["Shrine of Goldrinn Digsite"] = "戈德林聖壇挖掘場",
	["Shrine of the Dawn Digsite"] = "曙光廟挖掘場",
	["Sifreldar Village Digsite"] = "希弗爾達村挖掘場",
	["Singing Marshes Digsite"] = "歌頌沼澤挖掘場",
	["Skorn Digsite"] = "斯考恩挖掘場",
	["Slitherblade Shore Digsite"] = "滑刃水濱挖掘場",
	["Small Gate Digsite"] = "小門挖掘場",
	["Snow Covered Hills Digsite"] = "被雪覆蓋山上的挖掘場",
	["Solarsal Digsite"] = "索蘭薩爾挖掘場",
	["South Fruited Fields Digsite"] = "豐果園南部挖掘場",
	["South Great Wall Digsite"] = "長城南部挖掘場",
	["South Isildien Digsite"] = "伊斯迪爾南部挖掘場",
	["Southmoon Ruins Digsite"] = "南月廢墟挖掘場",
	["South Orchard Digsite"] = "果園南部挖掘場",
	["South Ruins of Dojan Digsite"] = "朵迦廢墟南部挖掘場",
	["South Ruins of Guo-Lai Digsite"] = "郭萊廢墟南部挖掘場",
	["Southshore Fossil Field"] = "南海鎮古原野",
	["Southwind Village Digsite"] = "南風村挖掘場",
	["Sra'thik Digsite"] = "斯拉席克挖掘場",
	["Steps of Fate Digsite"] = "天命之階挖掘場",
	["Stonetalon Peak"] = "石爪峰",
	["Sunken Temple Digsite"] = "沉沒的神廟挖掘場",
	["Sunspring Post Digsite"] = "日春崗哨挖掘場",
	["Talramas Digsite"] = "塔爾拉瑪斯挖掘場",
	["Temple of Uldum Digsite"] = "奧丹姆神廟挖掘場",
	["Terrace of Gurthan Digsite"] = "葛薩恩臺地挖掘場",
	["Terror Run Fossil Field"] = "恐懼小道古原野",
	["Terrorweb Tunnel Digsite"] = "惡蛛隧道挖掘場",
	["Terror Wing Fossil Field"] = "龍翼小徑古原野",
	["Thandol Span"] = "薩多爾大橋",
	["The Arboretum Digsite"] = "落英園挖掘場",
	["The Spring Road Digsite"] = "春之道挖掘場",
	["Thoradin's Wall"] = "索拉丁之牆",
	["Thundermar Ruins Digsite"] = "桑德瑪遺跡挖掘場",
	["Thunderwood Digsite"] = "雷林挖掘場",
	["Tian Digsite"] = "天僧挖掘場",
	["Tiger's Wood Digsite"] = "猛虎之林挖掘場",
	["Tomb of the Watchers Digsite"] = "看守者之墓挖掘場",
	["Tombs of the Precursors Digsite"] = "先驅者之墓挖掘場",
	["Torjari Pit Digsite"] = "托加利坑挖掘場",
	["Tu Shen Digsite"] = "土神挖掘場",
	["Tuurem Digsite"] = "杜瑞挖掘場",
	["Twilight Grove Digsite"] = "暮光森林挖掘場",
	["Twin Spire Ruins Digsite"] = "雙塔廢墟挖掘場",
	["Uldaman Entrance Digsite"] = "奧達曼挖掘場",
	["Unearthed Grounds"] = "掘出的遺址",
	["Upper Lakkari Tar Pits"] = "拉卡利油沼高原",
	["Valkyrion Digsite"] = "華爾基倫挖掘場",
	["Valley of Bones"] = "白骨之谷",
	["Valley of Kings Digsite"] = "國王谷挖掘場",
	["Veridian Grove Digsite"] = "翠綠林挖掘場",
	["Violet Stand Digsite"] = "紫羅蘭看臺挖掘場",
	["Voldrune Digsite"] = "沃德盧恩挖掘場",
	["Vul'Gol Fossil Bank"] = "沃古爾古河岸",
	["Warden's Cage Digsite"] = "典獄官監牢挖掘場",
	["West Auchindoun Digsite"] = "奧齊頓西部挖掘場",
	["Western Ruins of Thaurissan"] = "索瑞森西部廢墟",
	["Western Zul'Kunda Digsite"] = "祖昆達西部挖掘場",
	["Western Zul'Mamwe Digsite"] = "祖瑪維西部挖掘場",
	["West Old Village Digsite"] = "老村子西部挖掘場",
	["West Ruins of Guo-Lai Digsite"] = "郭萊廢墟西部挖掘場",
	["West Summer Fields Digsite"] = "夏之原西部挖掘場",
	["Whelgar's Excavation Site"] = "維爾加挖掘場",
	["Winterbough Digsite"] = "冬枝挖掘場",
	["Witherbark Digsite"] = "枯木挖掘場",
	["Writhingwood Digsite"] = "扭曲之木挖掘場",
	["Wyrmbog Fossil Field"] = "巨龍泥沼古原野",
	["Wyrmskull Digsite"] = "龍顱挖掘場",
	["Ymirheim Digsite"] = "依米海姆挖掘場",
	["Zeth'Gor Digsite"] = "薩斯葛爾挖掘場",
	["Zhu Province Digsite"] = "祝家界挖掘場",
	["Ziata'jai Digsite"] = "贊塔加挖掘場",
	["Zim'Rhuk Digsite"] = "辛茹克挖掘場",
	["Zol'Heb Digsite"] = "佐爾希伯挖掘場",
	["Zoram Strand Digsite"] = "佐拉姆海岸挖掘場",
	["Zul'Farrak Digsite"] = "祖爾法拉克挖掘場",
	["Zul'Mashar Digsite"] = "祖爾瑪夏挖掘場",
}

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
