--[[
	Library contains a dataset for Map file names and floors giving the raw map data
	it also has a few functions to help determine distance and directions.
--]]
local MAJOR, MINOR = "LibMapData-1.0", 16057
assert(LibStub, MAJOR.." requires LibStub")

local lib = LibStub:NewLibrary(MAJOR, MINOR)
if not lib then return end
lib.callbacks = lib.callbacks or LibStub("CallbackHandler-1.0"):New(lib)

local watchFrame = CreateFrame("Frame")
local lastMap, lastFloor = nil,0
local mapData = {}
local mapToLocal = {}
local localToMap = {}
local idToMap = {}
local GetPlayerFacing, GetPlayerMapPosition,SetMapToCurrentZone = GetPlayerFacing, GetPlayerMapPosition, SetMapToCurrentZone
local atan2 = math.atan2
local PI2 = math.pi*2
local floor = math.floor
local type,assert = type,assert
local wowMoP
do
	local _, _, _, interface = GetBuildInfo()
	wowMoP = (interface >= 50000)
end

--- Constants
lib.MAP_NORMAL = 0
lib.MAP_INSTANCE = 1
lib.MAP_RAID = 2
lib.MAP_BG = 3
lib.MAP_ARENA = 4
lib.MAP_SENARIO = 5
 -- estimated world map size
local worldMapWidth = 47714.278579261
local worlMapHeight = 31809.64857610083
local missingCache = {
	data = {},
	aid = {},
	locale = {}
}

local contOffsets = {
	[1] = {-8590.40725049343,5628.692856102324},
	[2] = {18542.31220836664, 3585.574573158966},
	[3] = {0,0},
	[4] = {16020.94044398222,454.2451915717977},
	[5] = {0,0},
	[6] = {0,0},
}

local transforms_x = {
	[1] = 10133.3330078125,
	[2] = -2400.0,
	[3] = 0,
	[4] = 0,
	[5] = 0,
	[6] = 0, --1600,
}
local transforms_y = {
	[1] = 17600.0,
	[2] = 2400.0,
	[3] = 0,
	[4] = 0,
	[5] = 0,
	[6] = 0, --2800,
}

do
	-- Format: 
	-- floors = number of floors
	-- area_id = in game area id
	-- floor_index = width,height, ulX,ulY, lrXx,lrY, mapid
	local emptyMaps = { 
		['floors'] = 0,['name'] = WORLD_MAP, ['continent'] = 0, ['phase'] = 0, ['map_type'] = 0,
		[1] = {0,0,0,0,0,0,0}
	}
	setmetatable(mapData, { __index = function(t, k) 
			if k then 
				if missingCache.data[k] == nil then
					--print("LibMapData-1.0 is missing data for ",k) 
					missingCache.data[k] = true
				end
			end 
			return emptyMaps 
		end 
	})
	setmetatable(idToMap, { __index = function(t, k) 
			if k then 
				if missingCache.aid[k] == nil then
					--print("LibMapData-1.0 is missing data for area id ",k) 
					missingCache.aid[k] = true
				end
			end 
			return k 
		end
	})
	setmetatable(mapToLocal, { __index = function(t,k) 
			if k then 
				if missingCache.locale[k] == nil then
					--print("LibMapData-1.0 is missing localized data for ",k) 
					missingCache.locale[k] = true
				end
			end
			return k 
		end
	})
		mapData[4] = { 
			['floors'] = 0, ['name'] = "Durotar", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5287.4996337890625,3524.9998779296875,1962.4998779296875,1808.333251953125,7249.99951171875,-1716.6666259765625},
		}
		mapData[9] = { 
			['floors'] = 0, ['name'] = "Mulgore", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5449.999755859375,3633.333251953125,-2204.16650390625,-168.75,3245.833251953125,-3802.083251953125},
		}
		mapData[11] = { 
			['floors'] = 0, ['name'] = "Barrens", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5745.83332824707,3831.2498779296875,-202.0833282470703,1810.4166259765625,5543.75,-2020.833251953125},
		}
		mapData[13] = { 
			['floors'] = 0, ['name'] = "Kalimdor", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {36799.810546875,24533.2001953125,-17066.599609375,12799.900390625,19733.2109375,-11733.2998046875},
		}
		mapData[14] = { 
			['floors'] = 0, ['name'] = "Azeroth", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {40741.181640625,27149.6875,-18171.970703125,11176.34375,22569.2109375,-15973.34375},
		}
		mapData[16] = { 
			['floors'] = 0, ['name'] = "Arathi", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3477.083251953125,2318.7498474121094,1127.083251953125,-141.66665649414062,4604.16650390625,-2460.41650390625},
		}
		mapData[17] = { 
			['floors'] = 0, ['name'] = "Badlands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3070.833251953125,2045.8330078125,1902.083251953125,-5854.16650390625,4972.91650390625,-7899.99951171875},
		}
		mapData[19] = { 
			['floors'] = 0, ['name'] = "BlastedLands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3662.5,2441.666015625,1193.75,-10583.3330078125,4856.25,-13024.9990234375},
		}
		mapData[20] = { 
			['floors'] = 0, ['name'] = "Tirisfal", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4518.7498779296875,3012.4998168945312,-3033.333251953125,3837.499755859375,1485.4166259765625,824.9999389648438},
		}
		mapData[21] = { 
			['floors'] = 0, ['name'] = "Silverpine", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4199.999755859375,2799.9998779296875,-3449.999755859375,1666.6666259765625,750.0,-1133.333251953125},
		}
		mapData[22] = { 
			['floors'] = 0, ['name'] = "WesternPlaguelands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4299.999908447266,2866.666534423828,-416.6666564941406,3366.66650390625,3883.333251953125,499.9999694824219},
		}
		mapData[23] = { 
			['floors'] = 0, ['name'] = "EasternPlaguelands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4031.25,2687.4998779296875,2287.5,3704.16650390625,6318.75,1016.6666259765625},
		}
		mapData[24] = { 
			['floors'] = 0, ['name'] = "HillsbradFoothills", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4862.4998779296875,3241.6666259765625,-1849.9998779296875,1481.25,3012.5,-1760.4166259765625},
		}
		mapData[26] = { 
			['floors'] = 0, ['name'] = "Hinterlands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3850.0,2566.6666259765625,1575.0,1466.6666259765625,5425.0,-1100.0},
		}
		mapData[27] = { 
			['floors'] = 0, ['name'] = "DunMorogh", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4897.91650390625,3264.5830078125,-2137.5,-3941.66650390625,2760.41650390625,-7206.24951171875},
		}
		mapData[28] = { 
			['floors'] = 0, ['name'] = "SearingGorge", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2231.2498474121094,1487.49951171875,322.9166564941406,-6100.0,2554.16650390625,-7587.49951171875},
		}
		mapData[29] = { 
			['floors'] = 0, ['name'] = "BurningSteppes", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3152.0831909179688,2099.99951171875,464.58331298828125,-6985.41650390625,3616.66650390625,-9085.416015625},
		}
		mapData[30] = { 
			['floors'] = 0, ['name'] = "Elwynn", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3470.833251953125,2314.5830078125,-1535.4166259765625,-7939.5830078125,1935.4166259765625,-10254.166015625},
		}
		mapData[32] = { 
			['floors'] = 0, ['name'] = "DeadwindPass", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2499.9999389648438,1666.6669921875,833.3333129882812,-9866.666015625,3333.333251953125,-11533.3330078125},
		}
		mapData[34] = { 
			['floors'] = 0, ['name'] = "Duskwood", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2699.9999389648438,1800.0,-833.3333129882812,-9716.666015625,1866.6666259765625,-11516.666015625},
		}
		mapData[35] = { 
			['floors'] = 0, ['name'] = "LochModan", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2758.3331298828125,1839.5830078125,1993.7498779296875,-4487.5,4752.0830078125,-6327.0830078125},
		}
		mapData[36] = { 
			['floors'] = 0, ['name'] = "Redridge", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2568.7498779296875,1712.5,1479.1666259765625,-8514.5830078125,4047.91650390625,-10227.0830078125},
		}
		mapData[37] = { 
			['floors'] = 0, ['name'] = "StranglethornJungle", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4099.9998779296875,2733.3330078125,-1743.7498779296875,-11016.666015625,2356.25,-13749.9990234375},
		}
		mapData[38] = { 
			['floors'] = 0, ['name'] = "SwampOfSorrows", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2508.3330078125,1672.9169921875,2081.25,-9535.416015625,4589.5830078125,-11208.3330078125},
		}
		mapData[39] = { 
			['floors'] = 0, ['name'] = "Westfall", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3499.9998168945312,2333.3330078125,-3016.66650390625,-9400.0,483.33331298828125,-11733.3330078125},
		}
		mapData[40] = { 
			['floors'] = 0, ['name'] = "Wetlands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4135.416687011719,2756.25,389.58331298828125,-2147.91650390625,4525.0,-4904.16650390625},
		}
		mapData[41] = { 
			['floors'] = 0, ['name'] = "Teldrassil", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5874.999755859375,3916.66650390625,-4235.41650390625,11847.916015625,1639.583251953125,7931.24951171875},
		}
		mapData[42] = { 
			['floors'] = 0, ['name'] = "Darkshore", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {6464.5830078125,4310.416259765625,-3016.66650390625,8222.916015625,3447.91650390625,3912.499755859375},
		}
		mapData[43] = { 
			['floors'] = 0, ['name'] = "Ashenvale", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5766.6663818359375,3843.7498779296875,-1699.9998779296875,4672.91650390625,4066.66650390625,829.1666259765625},
		}
		mapData[61] = { 
			['floors'] = 0, ['name'] = "ThousandNeedles", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {4399.999694824219,2933.3330078125,433.33331298828125,-3966.66650390625,4833.3330078125,-6899.99951171875},
		}
		mapData[81] = { 
			['floors'] = 0, ['name'] = "StonetalonMountains", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5899.9998779296875,3933.3331298828125,-3902.083251953125,3404.16650390625,1997.9166259765625,-529.1666259765625},
		}
		mapData[101] = { 
			['floors'] = 0, ['name'] = "Desolace", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {4495.8330078125,2997.9165649414062,-4233.3330078125,452.08331298828125,262.5,-2545.833251953125},
		}
		mapData[121] = { 
			['floors'] = 0, ['name'] = "Feralas", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {6949.999755859375,4633.3330078125,-5441.66650390625,-2366.66650390625,1508.333251953125,-6999.99951171875},
		}
		mapData[141] = { 
			['floors'] = 0, ['name'] = "Dustwallow", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5250.0,3500.0,975.0,-2033.333984375,6225.0,-5533.333984375},
		}
		mapData[161] = { 
			['floors'] = 0, ['name'] = "Tanaris", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {7212.499515533447,4808.3330078125,62.499996185302734,-5770.8330078125,7274.99951171875,-10579.166015625},
		}
		mapData[181] = { 
			['floors'] = 0, ['name'] = "Aszhara", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5514.58349609375,3677.0833740234375,3372.91650390625,5381.25,8887.5,1704.1666259765625},
		}
		mapData[182] = { 
			['floors'] = 0, ['name'] = "Felwood", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {6062.4996337890625,4041.666259765625,-1797.9166259765625,7237.49951171875,4264.5830078125,3195.833251953125},
		}
		mapData[201] = { 
			['floors'] = 0, ['name'] = "UngoroCrater", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {3699.9998168945312,2466.66650390625,-533.3333129882812,-5966.66650390625,3166.66650390625,-8433.3330078125},
		}
		mapData[241] = { 
			['floors'] = 0, ['name'] = "Moonglade", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {2308.333251953125,1539.5830078125,1381.25,8491.666015625,3689.583251953125,6952.0830078125},
		}
		mapData[261] = { 
			['floors'] = 0, ['name'] = "Silithus", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {4058.333251953125,2706.24951171875,-2983.333251953125,-5872.91650390625,1075.0,-8579.166015625},
		}
		mapData[281] = { 
			['floors'] = 0, ['name'] = "Winterspring", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {6149.9998779296875,4100.0,991.6666259765625,8793.75,7141.66650390625,4693.75},
		}
		mapData[301] = { 
			['floors'] = 0, ['name'] = "StormwindCity", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {1737.4999589920044,1158.3330078125,-1722.9166259765625,-7995.8330078125,14.583333015441895,-9154.166015625},
		}
		mapData[321] = { 
			['floors'] = 1, ['name'] = "Orgrimmar", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1739.375,1159.58349609375,3506.35400390625,2486.666748046875,5245.72900390625,1327.083251953125},
		}
		mapData[341] = { 
			['floors'] = 0, ['name'] = "Ironforge", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {790.6250610351562,527.6044921875,713.5913696289062,-4569.2412109375,1504.2164306640625,-5096.845703125},
		}
		mapData[362] = { 
			['floors'] = 0, ['name'] = "ThunderBluff", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1043.7499389648438,695.8333129882812,-516.6666259765625,-849.9999389648438,527.0833129882812,-1545.833251953125},
		}
		mapData[381] = { 
			['floors'] = 0, ['name'] = "Darnassus", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1539.5833740234375,1027.0830078125,-3187.5,10464.5830078125,-1647.9166259765625,9437.5},
		}
		mapData[382] = { 
			['floors'] = 0, ['name'] = "Undercity", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {959.3750305175781,640.1041259765625,-873.192626953125,1877.9453125,86.18240356445312,1237.8411865234375},
		}
		mapData[401] = { 
			['floors'] = 0, ['name'] = "AlteracValley", ['rzti'] = 30, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {4237.4998779296875,2824.9998779296875,-1781.2498779296875,1085.4166259765625,2456.25,-1739.583251953125},
		}
		mapData[443] = { 
			['floors'] = 0, ['name'] = "WarsongGulch", ['rzti'] = 489, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {1145.8333129882812,764.5833129882812,-2041.6666259765625,1627.083251953125,-895.8333129882812,862.4999389648438},
		}
		mapData[461] = { 
			['floors'] = 0, ['name'] = "ArathiBasin", ['rzti'] = 529, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {1756.2499237060547,1170.833251953125,-1858.333251953125,1508.333251953125,-102.08332824707031,337.5},
		}
		mapData[462] = { 
			['floors'] = 0, ['name'] = "EversongWoods", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 1,
			[1] = {4925.0,3283.3330078125,4487.5,11041.666015625,9412.5,7758.3330078125},
		}
		mapData[463] = { 
			['floors'] = 0, ['name'] = "Ghostlands", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 1,
			[1] = {3300.0,2199.99951171875,5283.3330078125,8266.666015625,8583.3330078125,6066.66650390625},
		}
		mapData[464] = { 
			['floors'] = 0, ['name'] = "AzuremystIsle", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 1,
			[1] = {4070.8330078125,2714.5830078125,10500.0,-2793.75,14570.8330078125,-5508.3330078125},
		}
		mapData[465] = { 
			['floors'] = 0, ['name'] = "Hellfire", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5164.5830078125,3443.7498779296875,-5539.5830078125,1481.25,-375.0,-1962.4998779296875},
		}
		mapData[466] = { 
			['floors'] = 0, ['name'] = "Expansion01", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {17464.078125,11642.71875,-12996.0390625,5821.359375,4468.0390625,-5821.359375},
		}
		mapData[467] = { 
			['floors'] = 0, ['name'] = "Zangarmarsh", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5027.08349609375,3352.083251953125,-9475.0,1935.4166259765625,-4447.91650390625,-1416.6666259765625},
		}
		mapData[471] = { 
			['floors'] = 0, ['name'] = "TheExodar", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 1,
			[1] = {1056.7705078125,704.687744140625,11066.3671875,-3609.683349609375,12123.1376953125,-4314.37109375},
		}
		mapData[473] = { 
			['floors'] = 0, ['name'] = "ShadowmoonValley", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5500.0,3666.6663818359375,-4225.0,-1947.9166259765625,1275.0,-5614.5830078125},
		}
		mapData[475] = { 
			['floors'] = 0, ['name'] = "BladesEdgeMountains", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5424.999755859375,3616.6663818359375,-8845.8330078125,4408.3330078125,-3420.833251953125,791.6666259765625},
		}
		mapData[476] = { 
			['floors'] = 0, ['name'] = "BloodmystIsle", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 1,
			[1] = {3262.4990234375,2174.9999389648438,10075.0,-758.3333129882812,13337.4990234375,-2933.333251953125},
		}
		mapData[477] = { 
			['floors'] = 0, ['name'] = "Nagrand", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5525.0,3683.333168029785,-10295.8330078125,41.666664123535156,-4770.8330078125,-3641.66650390625},
		}
		mapData[478] = { 
			['floors'] = 0, ['name'] = "TerokkarForest", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5399.999755859375,3600.0000610351562,-7083.3330078125,-999.9999389648438,-1683.333251953125,-4600.0},
		}
		mapData[479] = { 
			['floors'] = 0, ['name'] = "Netherstorm", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {5574.999671936035,3716.666748046875,-5483.3330078125,5456.25,91.66666412353516,1739.583251953125},
		}
		mapData[480] = { 
			['floors'] = 0, ['name'] = "SilvermoonCity", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 1,
			[1] = {1211.45849609375,806.7705078125,6400.75,10153.708984375,7612.20849609375,9346.9384765625},
		}
		mapData[481] = { 
			['floors'] = 0, ['name'] = "ShattrathCity", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {1306.25,870.8333740234375,-6135.2587890625,-1473.9544677734375,-4829.0087890625,-2344.787841796875},
		}
		mapData[482] = { 
			['floors'] = 0, ['name'] = "NetherstormArena", ['rzti'] = 566, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {2270.8331909179688,1514.5833740234375,-2660.41650390625,2918.75,-389.58331298828125,1404.1666259765625},
		}
		mapData[485] = { 
			['floors'] = 0, ['name'] = "Northrend", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {17751.3984375,11834.265014648438,-9217.15234375,10593.375,8534.24609375,-1240.8900146484375},
		}
		mapData[486] = { 
			['floors'] = 0, ['name'] = "BoreanTundra", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {5764.5830078125,3843.7498779296875,-8570.8330078125,4897.91650390625,-2806.25,1054.1666259765625},
		}
		mapData[488] = { 
			['floors'] = 0, ['name'] = "Dragonblight", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {5608.3331298828125,3739.5833740234375,-3627.083251953125,5575.0,1981.2498779296875,1835.4166259765625},
		}
		mapData[490] = { 
			['floors'] = 0, ['name'] = "GrizzlyHills", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {5249.9998779296875,3499.9998779296875,1110.4166259765625,5516.66650390625,6360.41650390625,2016.6666259765625},
		}
		mapData[491] = { 
			['floors'] = 0, ['name'] = "HowlingFjord", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {6045.8328857421875,4031.2498168945312,1397.9166259765625,3116.66650390625,7443.74951171875,-914.5833129882812},
		}
		mapData[492] = { 
			['floors'] = 0, ['name'] = "IcecrownGlacier", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {6270.833312988281,4181.25,-5443.75,9427.0830078125,827.0833129882812,5245.8330078125},
		}
		mapData[493] = { 
			['floors'] = 0, ['name'] = "SholazarBasin", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {4356.25,2904.16650390625,-6929.16650390625,7287.49951171875,-2572.91650390625,4383.3330078125},
		}
		mapData[495] = { 
			['floors'] = 0, ['name'] = "TheStormPeaks", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {7112.4996337890625,4741.666015625,-1841.6666259765625,10197.916015625,5270.8330078125,5456.25},
		}
		mapData[496] = { 
			['floors'] = 0, ['name'] = "ZulDrak", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {4993.75,3329.16650390625,600.0,7668.74951171875,5593.75,4339.5830078125},
		}
		mapData[499] = { 
			['floors'] = 0, ['name'] = "Sunwell", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 1,
			[1] = {3327.0830078125,2218.7490234375,5302.0830078125,13568.7490234375,8629.166015625,11350.0},
		}
		mapData[501] = { 
			['floors'] = 0, ['name'] = "LakeWintergrasp", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {2974.9998779296875,1983.333251953125,-4329.16650390625,5716.66650390625,-1354.1666259765625,3733.333251953125},
		}
		mapData[502] = { 
			['floors'] = 0, ['name'] = "ScarletEnclave", ['rzti'] = 609, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {3162.5,2108.3333740234375,4047.91650390625,3087.5,7210.41650390625,979.1666259765625},
		}
		mapData[504] = { 
			['floors'] = 2, ['name'] = "Dalaran", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = { 830.0150146484375,553.33984375,-222.4949951171875,5513.330078125,-1052.510009765625,6066.669921875 },
			[2] = { 563.2239990234375,375.48974609375,-352.64599609375,5599.85009765625,-915.8699951171875,5975.33984375 },
		}
		mapData[510] = { 
			['floors'] = 0, ['name'] = "CrystalsongForest", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {2722.9166259765625,1814.5830078125,-1443.75,6502.0830078125,1279.1666259765625,4687.5},
		}
		mapData[512] = { 
			['floors'] = 0, ['name'] = "StrandoftheAncients", ['rzti'] = 607, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {1743.7499389648438,1162.4999389648438,-787.5,1883.333251953125,956.2499389648438,720.8333129882812},
		}
		mapData[520] = { 
			['floors'] = 1, ['name'] = "TheNexus", ['rzti'] = 576, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1101.2809753417969,734.1875,708.0689697265625,64.07550048828125,-393.2120056152344,798.2630004882812 },
		}
		mapData[521] = { 
			['floors'] = 2, ['name'] = "CoTStratholme", ['rzti'] = 595, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1824.9999389648438,1216.66650390625,-2152.083251953125,2297.91650390625,-327.08331298828125,1081.25},
			[2] = { 1125.2999877929688,750.199951171875,-731.0599975585938,1891.760009765625,-1856.3599853515625,2641.9599609375 },
		}
		mapData[522] = { 
			['floors'] = 1, ['name'] = "Ahnkahet", ['rzti'] = 619, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 972.41796875,648.2790222167969,1205.719970703125,200.40499877929688,233.302001953125,848.6840209960938 },
		}
		mapData[523] = { 
			['floors'] = 3, ['name'] = "UtgardeKeep", ['rzti'] = 574, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 734.5809936523438,489.7215003967285,310.406005859375,25.666500091552734,-424.17498779296875,515.3880004882812 },
			[2] = { 481.0810089111328,320.72029304504395,238.156005859375,-16.33329963684082,-242.9250030517578,304.3869934082031 },
			[3] = { 736.5810089111328,491.0545120239258,510.906005859375,-75.33350372314453,-225.6750030517578,415.72100830078125 },
		}
		mapData[524] = { 
			['floors'] = 2, ['name'] = "UtgardePinnacle", ['rzti'] = 575, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 548.9360198974609,365.95701599121094,697.5590209960938,186.9199981689453,148.6230010986328,552.8770141601562 },
			[2] = { 756.1799430847168,504.11900329589844,747.5579833984375,157.83900451660156,-8.621959686279297,661.9580078125 },
		}
		mapData[525] = { 
			['floors'] = 2, ['name'] = "HallsofLightning", ['rzti'] = 602, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 566.2350158691406,377.489990234375,282.54901123046875,1157.050048828125,-283.6860046386719,1534.5400390625 },
			[2] = { 708.2370147705078,472.1600341796875,538.5490112304688,959.719970703125,-169.68800354003906,1431.8800048828125 },
		}
		mapData[526] = { 
			['floors'] = 1, ['name'] = "Ulduar77", ['rzti'] = 599, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 920.1960144042969,613.466064453125,-206.32400512695312,762.4439697265625,-1126.52001953125,1375.9100341796875 },
		}
		mapData[527] = { 
			['floors'] = 1, ['name'] = "TheEyeofEternity", ['rzti'] = 616, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 430.070068359375,286.7130126953125,-1036.7099609375,611.1279907226562,-1466.780029296875,897.8410034179688 },
		}
		mapData[528] = { 
			['floors'] = 4, ['name'] = "Nexus80", ['rzti'] = 578, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 514.7069702148438,343.13897705078125,-787.2529907226562,877.0709838867188,-1301.9599609375,1220.2099609375 },
			[2] = { 664.7069702148438,443.13897705078125,-712.2529907226562,927.0709838867188,-1376.9599609375,1370.2099609375 },
			[3] = { 514.7069702148438,343.13897705078125,-787.2529907226562,927.0709838867188,-1301.9599609375,1270.2099609375 },
			[4] = { 294.70098876953125,196.4639892578125,-897.2589721679688,990.406005859375,-1191.9599609375,1186.8699951171875 },
		}
		mapData[529] = { 
			['floors'] = 6, ['name'] = "Ulduar", ['rzti'] = 603, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {3287.4998779296875,2191.6666259765625,-1583.333251953125,1168.75,1704.1666259765625,-1022.9166259765625},
			[2] = { 669.4509887695312,446.300048828125,445.2349853515625,1392.7099609375,-224.21600341796875,1839.010009765625 },
			[3] = { 1328.4609985351562,885.639892578125,674.739990234375,1679.0400390625,-653.7210083007812,2564.679931640625 },
			[4] = { 910.5,607.0,315.75,1612.0,-594.75,2219.0 },
			[5] = { 1569.4599609375,1046.300048828125,-1684.989990234375,2122.530029296875,-3254.449951171875,3168.830078125 },
			[6] = { 619.468994140625,412.97998046875,310.0140075683594,1834.77001953125,-309.4549865722656,2247.75 },
		}
		mapData[530] = { 
			['floors'] = 1, ['name'] = "Gundrak", ['rzti'] = 604, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 905.0330505371094,603.35009765625,-259.8869934082031,1465.52001953125,-1164.9200439453125,2068.8701171875 },
		}
		mapData[531] = { 
			['floors'] = 0, ['name'] = "TheObsidianSanctum", ['rzti'] = 615, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {1162.4999179840088,775.0,-1133.333251953125,3616.66650390625,29.16666603088379,2841.66650390625},
		}
		mapData[532] = { 
			['floors'] = 1, ['name'] = "VaultofArchavon", ['rzti'] = 624, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1398.2550048828125,932.1700134277344,812.5189819335938,-634.0800170898438,-585.7360229492188,298.0899963378906 },
		}
		mapData[533] = { 
			['floors'] = 3, ['name'] = "AzjolNerub", ['rzti'] = 601, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 752.9739990234375,501.9830017089844,30.0,292.1419982910156,-722.9739990234375,794.125 },
			[2] = { 292.9739990234375,195.31597900390625,-400.0,450.4739990234375,-692.9739990234375,645.7899780273438 },
			[3] = { 367.5,245.0,-462.125,395.0,-829.625,640.0 },
		}
		mapData[534] = { 
			['floors'] = 2, ['name'] = "DrakTharonKeep", ['rzti'] = 600, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 619.9410095214844,413.2939910888672,927.010009765625,-595.8599853515625,307.0690002441406,-182.5659942626953 },
			[2] = { 619.9410095214844,413.2939910888672,1002.010009765625,-595.8599853515625,382.0690002441406,-182.5659942626953 },
		}
		mapData[535] = { 
			['floors'] = 6, ['name'] = "Naxxramas", ['rzti'] = 533, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1093.830078125,729.219970703125,3734.10009765625,2886.610107421875,2640.27001953125,3615.830078125 },
			[2] = { 1093.830078125,729.219970703125,4234.10009765625,2886.610107421875,3140.27001953125,3615.830078125 },
			[3] = { 1200.0,800.0,3787.0,2336.0,2587.0,3136.0 },
			[4] = { 1200.330078125,800.219970703125,4287.35009765625,2336.610107421875,3087.02001953125,3136.830078125 },
			[5] = { 2069.809814453125,1379.8798828125,4400.08984375,2311.340087890625,2330.280029296875,3691.219970703125 },
			[6] = { 655.93994140625,437.2900390625,5522.2900390625,3379.25,4866.35009765625,3816.5400390625 },
		}
		mapData[536] = { 
			['floors'] = 1, ['name'] = "VioletHold", ['rzti'] = 608, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 256.22900390625,170.820068359375,-665.3469848632812,1813.3499755859375,-921.5759887695312,1984.1700439453125 },
		}
		mapData[539] = { 
			['floors'] = 0, ['name'] = "GilneasX", ['rzti'] = 638, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {3145.833251953125,2097.9166870117188,-3439.583251953125,-533.3333129882812,-293.75,-2631.25},
		}
		mapData[540] = { 
			['floors'] = 0, ['name'] = "IsleofConquest", ['rzti'] = 628, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {2650.0,1766.6665840148926,-525.0,1708.333251953125,2125.0,-58.33333206176758},
		}
		mapData[541] = { 
			['floors'] = 0, ['name'] = "HrothgarsLanding", ['rzti'] = 571, ['map_type'] = 0, ['continent'] = 4, ['transform'] = 0,
			[1] = {3677.0831298828125,2452.083984375,-2797.91650390625,10781.25,879.1666259765625,8329.166015625},
		}
		mapData[542] = { 
			['floors'] = 1, ['name'] = "TheArgentColiseum", ['rzti'] = 650, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 369.9861869812012,246.65798950195312,41.25519943237305,446.3609924316406,-328.7309875488281,693.0189819335938 },
		}
		mapData[543] = { 
			['floors'] = 2, ['name'] = "TheArgentColiseum", ['rzti'] = 649, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 369.9861869812012,246.65798950195312,41.25519943237305,446.3609924316406,-328.7309875488281,693.0189819335938 },
			[2] = { 739.9960174560547,493.33001708984375,211.25999450683594,433.02398681640625,-528.7360229492188,926.35400390625 },
		}
		mapData[544] = { 
			['floors'] = 7, ['name'] = "TheLostIsles", ['rzti'] = 648, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 274.0,182.6666259765625,-2815.0,514.1666870117188,-3089.0,696.8333129882812 },
			[2] = { 1012.5,675.0,-716.25,825.0,-1728.75,1500.0 },
			[3] = { 528.0001220703125,352.0001220703125,-1622.4998779296875,1716.5999755859375,-2150.5,2068.60009765625 },
			[4] = { 327.489990234375,218.32666015625,-1752.510009765625,1748.4366455078125,-2080.0,1966.7633056640625 },
			[5] = { 175.0,116.666015625,-1057.5,-8438.3330078125,-1232.5,-8321.6669921875 },
			[6] = { 175.0,116.666015625,-997.5,-8568.3330078125,-1172.5,-8451.6669921875 },
			[7] = { 330.0,220.0,-1130.0,-8700.0,-1460.0,-8480.0 },
		}
		mapData[545] = { 
			['floors'] = 3, ['name'] = "Gilneas", ['rzti'] = 654, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 420.0,280.0,-720.0,-1260.0,-1140.0,-980.0 },
			[2] = { 250.4697265625,166.97998046875,-2459.76513671875,-1666.989990234375,-2710.23486328125,-1500.010009765625 },
			[3] = { 280.4697265625,186.97998046875,-2444.76513671875,-1666.989990234375,-2725.23486328125,-1480.010009765625 },
		}
		mapData[601] = { 
			['floors'] = 1, ['name'] = "TheForgeofSouls", ['rzti'] = 632, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1448.099853515625,965.400390625,-1686.030029296875,4814.52978515625,-3134.1298828125,5779.93017578125 },
		}
		mapData[602] = { 
			['floors'] = 0, ['name'] = "PitofSaron", ['rzti'] = 658, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1533.3333129882812,1022.9166717529297,-839.5833129882812,1256.25,693.75,233.3333282470703},
		}
		mapData[603] = { 
			['floors'] = 1, ['name'] = "HallsofReflection", ['rzti'] = 668, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 879.02001953125,586.01953125,-1469.989990234375,5126.990234375,-2349.010009765625,5713.009765625 },
		}
		mapData[604] = { 
			['floors'] = 8, ['name'] = "IcecrownCitadel", ['rzti'] = 631, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1355.4700927734375,903.6470336914062,-1384.3299560546875,-764.8400268554688,-2739.800048828125,138.8070068359375 },
			[2] = { 1067.0,711.3336906433105,-1631.0,-754.6669921875,-2698.0,-43.33330154418945 },
			[3] = { 195.469970703125,130.31500244140625,-2116.330078125,-580.31298828125,-2311.800048828125,-449.99798583984375 },
			[4] = { 773.7100830078125,515.810302734375,-1993.5699462890625,4012.409912109375,-2767.280029296875,4528.22021484375 },
			[5] = { 1148.739990234375,765.820068359375,-2216.06005859375,4002.409912109375,-3364.800048828125,4768.22998046875 },
			[6] = { 373.7099609375,249.1298828125,-2586.570068359375,4455.75,-2960.280029296875,4704.8798828125 },
			[7] = { 293.260009765625,195.50701904296875,2271.550048828125,410.2919921875,1978.2900390625,605.7990112304688 },
			[8] = { 247.929931640625,165.28799438476562,2648.260009765625,414.1080017089844,2400.330078125,579.39599609375 },
		}
		mapData[605] = { 
			['floors'] = 7, ['name'] = "Kezan", ['rzti'] = 648, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 274.0,182.6666259765625,-2815.0,514.1666870117188,-3089.0,696.8333129882812 },
			[2] = { 1012.5,675.0,-716.25,825.0,-1728.75,1500.0 },
			[3] = { 528.0001220703125,352.0001220703125,-1622.4998779296875,1716.5999755859375,-2150.5,2068.60009765625 },
			[4] = { 327.489990234375,218.32666015625,-1752.510009765625,1748.4366455078125,-2080.0,1966.7633056640625 },
			[5] = { 175.0,116.666015625,-1057.5,-8438.3330078125,-1232.5,-8321.6669921875 },
			[6] = { 175.0,116.666015625,-997.5,-8568.3330078125,-1172.5,-8451.6669921875 },
			[7] = { 330.0,220.0,-1130.0,-8700.0,-1460.0,-8480.0 },
		}
		mapData[606] = { 
			['floors'] = 0, ['name'] = "Hyjal", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {4245.8333740234375,2831.249755859375,929.1666259765625,6195.8330078125,5175.0,3364.583251953125},
		}
		mapData[607] = { 
			['floors'] = 0, ['name'] = "SouthernBarrens", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {7412.5,4941.666656494141,-1356.25,204.16665649414062,6056.25,-4737.5},
		}
		mapData[609] = { 
			['floors'] = 0, ['name'] = "TheRubySanctum", ['rzti'] = 724, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {752.0833129882812,502.083251953125,-902.0833129882812,3429.16650390625,-150.0,2927.083251953125},
		}
		mapData[610] = { 
			['floors'] = 0, ['name'] = "VashjirKelpForest", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {2802.0830078125,1868.750244140625,-5070.8330078125,-4018.749755859375,-2268.75,-5887.5},
		}
		mapData[611] = { 
			['floors'] = 3, ['name'] = "GilneasCity", ['rzti'] = 654, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 420.0,280.0,-720.0,-1260.0,-1140.0,-980.0 },
			[2] = { 250.4697265625,166.97998046875,-2459.76513671875,-1666.989990234375,-2710.23486328125,-1500.010009765625 },
			[3] = { 280.4697265625,186.97998046875,-2444.76513671875,-1666.989990234375,-2725.23486328125,-1480.010009765625 },
		}
		mapData[613] = { 
			['floors'] = 0, ['name'] = "Vashjir", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {6945.832763671875,4631.249755859375,-8754.166015625,-3720.833251953125,-1808.333251953125,-8352.0830078125},
		}
		mapData[614] = { 
			['floors'] = 0, ['name'] = "VashjirDepths", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4075.0,2716.66650390625,-8233.3330078125,-4906.25,-4158.3330078125,-7622.91650390625},
		}
		mapData[615] = { 
			['floors'] = 0, ['name'] = "VashjirRuins", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {4849.9996337890625,3233.3330078125,-6681.24951171875,-4756.25,-1831.2498779296875,-7989.5830078125},
		}
		mapData[626] = { 
			['floors'] = 0, ['name'] = "TwinPeaks", ['rzti'] = 726, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {1214.583251953125,810.41650390625,-931.2499389648438,2266.66650390625,283.33331298828125,1456.25},
		}
		mapData[640] = { 
			['floors'] = 0, ['name'] = "Deepholm", ['rzti'] = 646, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {5099.9998779296875,3399.9998779296875,-3052.083251953125,2795.833251953125,2047.9166259765625,-604.1666259765625},
		}
		mapData[673] = { 
			['floors'] = 0, ['name'] = "TheCapeOfStranglethorn", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3945.8331298828125,2631.25,-2108.333251953125,-12516.666015625,1837.4998779296875,-15147.916015625},
		}
		mapData[677] = { 
			['floors'] = 0, ['name'] = "BattleforGilneas", ['rzti'] = 728, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {889.583251953125,593.7498779296875,-1933.333251953125,-1306.25,-1043.75,-1899.9998779296875},
		}
		mapData[678] = { 
			['floors'] = 3, ['name'] = "Gilneas_terrain1", ['rzti'] = 654, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 420.0,280.0,-720.0,-1260.0,-1140.0,-980.0 },
			[2] = { 250.4697265625,166.97998046875,-2459.76513671875,-1666.989990234375,-2710.23486328125,-1500.010009765625 },
			[3] = { 280.4697265625,186.97998046875,-2444.76513671875,-1666.989990234375,-2725.23486328125,-1480.010009765625 },
		}
		mapData[679] = { 
			['floors'] = 3, ['name'] = "Gilneas_terrain2", ['rzti'] = 654, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 420.0,280.0,-720.0,-1260.0,-1140.0,-980.0 },
			[2] = { 250.4697265625,166.97998046875,-2459.76513671875,-1666.989990234375,-2710.23486328125,-1500.010009765625 },
			[3] = { 280.4697265625,186.97998046875,-2444.76513671875,-1666.989990234375,-2725.23486328125,-1480.010009765625 },
		}
		mapData[680] = { 
			['floors'] = 1, ['name'] = "Ragefire", ['rzti'] = 389, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 738.864013671875,492.5762023925781,285.9930114746094,-452.9530029296875,-452.8710021972656,39.623199462890625 },
		}
		mapData[681] = { 
			['floors'] = 7, ['name'] = "TheLostIsles_terrain1", ['rzti'] = 648, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 274.0,182.6666259765625,-2815.0,514.1666870117188,-3089.0,696.8333129882812 },
			[2] = { 1012.5,675.0,-716.25,825.0,-1728.75,1500.0 },
			[3] = { 528.0001220703125,352.0001220703125,-1622.4998779296875,1716.5999755859375,-2150.5,2068.60009765625 },
			[4] = { 327.489990234375,218.32666015625,-1752.510009765625,1748.4366455078125,-2080.0,1966.7633056640625 },
			[5] = { 175.0,116.666015625,-1057.5,-8438.3330078125,-1232.5,-8321.6669921875 },
			[6] = { 175.0,116.666015625,-997.5,-8568.3330078125,-1172.5,-8451.6669921875 },
			[7] = { 330.0,220.0,-1130.0,-8700.0,-1460.0,-8480.0 },
		}
		mapData[682] = { 
			['floors'] = 7, ['name'] = "TheLostIsles_terrain2", ['rzti'] = 648, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = { 274.0,182.6666259765625,-2815.0,514.1666870117188,-3089.0,696.8333129882812 },
			[2] = { 1012.5,675.0,-716.25,825.0,-1728.75,1500.0 },
			[3] = { 528.0001220703125,352.0001220703125,-1622.4998779296875,1716.5999755859375,-2150.5,2068.60009765625 },
			[4] = { 327.489990234375,218.32666015625,-1752.510009765625,1748.4366455078125,-2080.0,1966.7633056640625 },
			[5] = { 175.0,116.666015625,-1057.5,-8438.3330078125,-1232.5,-8321.6669921875 },
			[6] = { 175.0,116.666015625,-997.5,-8568.3330078125,-1172.5,-8451.6669921875 },
			[7] = { 330.0,220.0,-1130.0,-8700.0,-1460.0,-8480.0 },
		}
		mapData[683] = { 
			['floors'] = 0, ['name'] = "Hyjal_terrain1", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {4245.8333740234375,2831.249755859375,929.1666259765625,6195.8330078125,5175.0,3364.583251953125},
		}
		mapData[684] = { 
			['floors'] = 0, ['name'] = "RuinsofGilneas", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {3145.833251953125,2097.9166870117188,-3439.583251953125,-533.3333129882812,-293.75,-2631.25},
		}
		mapData[685] = { 
			['floors'] = 0, ['name'] = "RuinsofGilneasCity", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {889.583251953125,593.7498779296875,-1933.333251953125,-1306.25,-1043.75,-1899.9998779296875},
		}
		mapData[686] = { 
			['floors'] = 0, ['name'] = "ZulFarrak", ['rzti'] = 209, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1383.3332214355469,922.9166259765625,-1624.9998779296875,2052.083251953125,-241.66665649414062,1129.1666259765625},
		}
		mapData[687] = { 
			['floors'] = 1, ['name'] = "TheTempleOfAtalHakkar", ['rzti'] = 109, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 695.0289916992188,463.3529815673828,252.27099609375,-718.5189819335938,-442.75799560546875,-255.16600036621094 },
		}
		mapData[688] = { 
			['floors'] = 3, ['name'] = "BlackfathomDeeps", ['rzti'] = 48, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 884.2200012207031,589.4799728393555,381.2959899902344,-677.14697265625,-502.92401123046875,-87.66699981689453 },
			[2] = { 884.2200317382812,589.4800109863281,581.2960205078125,-927.14697265625,-302.92401123046875,-337.6669616699219 },
			[3] = { 284.22400426864624,189.482666015625,281.2980041503906,-877.1483154296875,-2.9260001182556152,-687.6656494140625 },
		}
		mapData[689] = { 
			['floors'] = 0, ['name'] = "StranglethornVale", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {6552.0830078125,4368.75,-2977.083251953125,-10964.5830078125,3574.999755859375,-15333.3330078125},
		}
		mapData[690] = { 
			['floors'] = 1, ['name'] = "TheStockade", ['rzti'] = 34, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 378.1529998779297,252.10249519348145,188.33099365234375,-31.469499588012695,-189.82200622558594,220.63299560546875 },
		}
		mapData[691] = { 
			['floors'] = 4, ['name'] = "Gnomeregan", ['rzti'] = 90, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 769.6679992675781,513.1119995117188,277.7720031738281,-694.0,-491.89599609375,-180.88800048828125 },
			[2] = { 769.6679992675781,513.1119995117188,77.77200317382812,-714.0,-691.89599609375,-200.88800048828125 },
			[3] = { 869.6679992675781,579.7780151367188,127.77200317382812,-967.3330078125,-741.89599609375,-387.55499267578125 },
			[4] = { 869.6697082519531,579.7799987792969,-72.99929809570312,-937.333984375,-942.6690063476562,-357.5539855957031 },
		}
		mapData[692] = { 
			['floors'] = 2, ['name'] = "Uldaman", ['rzti'] = 70, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 893.6680145263672,595.7789916992188,248.5489959716797,-391.4729919433594,-645.1190185546875,204.30599975585938 },
			[2] = { 492.57041931152344,328.3804931640625,-52.54859924316406,-57.77349853515625,-545.1190185546875,270.60699462890625 },
		}
		mapData[696] = { 
			['floors'] = 1, ['name'] = "MoltenCore", ['rzti'] = 409, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1264.800064086914,843.1990661621094,1395.56005859375,459.8609924316406,130.75999450683594,1303.06005859375 },
		}
		mapData[697] = { 
			['floors'] = 0, ['name'] = "ZulGurub", ['rzti'] = 309, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1877.083251953125,1252.0830078125,693.75,-11308.3330078125,2570.833251953125,-12560.416015625},
		}
		mapData[699] = { 
			['floors'] = 6, ['name'] = "DireMaul", ['rzti'] = 429, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1275.0,850.0,387.5,200.0,-887.5,1050.0 },
			[2] = { 525.0,350.0,-125.0,-150.0,-650.0,200.0 },
			[3] = { 487.5,325.0,-231.25,-150.0,-718.75,175.0 },
			[4] = { 750.0,500.0,-325.0,-250.0,-1075.0,250.0 },
			[5] = { 800.0008010864258,533.3339996337891,900.0,-281.6669921875,99.99919891357422,251.66700744628906 },
			[6] = { 975.0,650.0,862.5,-200.0,-112.5,450.0 },
		}
		mapData[700] = { 
			['floors'] = 0, ['name'] = "TwilightHighlands", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {5270.8330078125,3514.5830078125,2437.5,-2156.25,7708.3330078125,-5670.8330078125},
		}
		mapData[704] = { 
			['floors'] = 2, ['name'] = "BlackrockDepths", ['rzti'] = 230, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1407.0609741210938,938.0407562255859,884.7239990234375,248.63966369628906,-522.3369750976562,1186.680419921875 },
			[2] = { 1507.0609741210938,1004.7074279785156,934.7239990234375,495.3028259277344,-572.3369750976562,1500.01025390625 },
		}
		mapData[708] = { 
			['floors'] = 0, ['name'] = "TolBarad", ['rzti'] = 732, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {2014.5832924842834,1343.75,-2010.4166259765625,-560.4166259765625,4.166666507720947,-1904.1666259765625},
		}
		mapData[709] = { 
			['floors'] = 0, ['name'] = "TolBaradDailyArea", ['rzti'] = 732, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {1837.5,1224.9999389648438,-2412.5,377.08331298828125,-575.0,-847.9166259765625},
		}
		mapData[710] = { 
			['floors'] = 1, ['name'] = "TheShatteredHalls", ['rzti'] = 540, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1063.7474670410156,709.1649932861328,432.6392517089844,-91.74800109863281,-631.1082153320312,617.4169921875 },
		}
		mapData[717] = { 
			['floors'] = 0, ['name'] = "RuinsofAhnQiraj", ['rzti'] = 509, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {2512.4998779296875,1675.0,-3035.41650390625,-8233.3330078125,-522.9166259765625,-9908.3330078125},
		}
		mapData[718] = { 
			['floors'] = 1, ['name'] = "OnyxiasLair", ['rzti'] = 249, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 483.1179885864258,322.0787887573242,371.7349853515625,-223.83299255371094,-111.38300323486328,98.24579620361328 },
		}
		mapData[720] = { 
			['floors'] = 0, ['name'] = "Uldum", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {6193.749755859375,4129.16650390625,-2441.66650390625,-8029.16650390625,3752.083251953125,-12158.3330078125},
		}
		mapData[721] = { 
			['floors'] = 7, ['name'] = "BlackrockSpire", ['rzti'] = 229, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
			[2] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
			[3] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
			[4] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
			[5] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
			[6] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
			[7] = { 886.8390140533447,591.2260131835938,876.2520141601562,-286.8280029296875,-10.586999893188477,304.39801025390625 },
		}
		mapData[722] = { 
			['floors'] = 2, ['name'] = "AuchenaiCrypts", ['rzti'] = 558, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 742.5404357910156,495.02699279785156,414.98321533203125,-140.0760040283203,-327.5572204589844,354.95098876953125 },
			[2] = { 817.5404663085938,545.0269927978516,602.4832153320312,-210.0760040283203,-215.0572509765625,334.95098876953125 },
		}
		mapData[723] = { 
			['floors'] = 2, ['name'] = "SethekkHalls", ['rzti'] = 556, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 703.4954833984375,468.9969940185547,187.6982421875,-295.3429870605469,-515.7972412109375,173.6540069580078 },
			[2] = { 703.4954833984375,468.9969940185547,187.6982421875,-295.3429870605469,-515.7972412109375,173.6540069580078 },
		}
		mapData[724] = { 
			['floors'] = 1, ['name'] = "ShadowLabyrinth", ['rzti'] = 555, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 841.5223541259766,561.0148887634277,656.4431762695312,-498.2179870605469,-185.0791778564453,62.79690170288086 },
		}
		mapData[725] = { 
			['floors'] = 1, ['name'] = "TheBloodFurnace", ['rzti'] = 542, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1003.5190124511719,669.0126876831055,504.5299987792969,-65.87670135498047,-498.989013671875,603.135986328125 },
		}
		mapData[726] = { 
			['floors'] = 1, ['name'] = "TheUnderbog", ['rzti'] = 546, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 894.9199981689453,596.6133575439453,653.9429931640625,-172.87818908691406,-240.9770050048828,423.73516845703125 },
		}
		mapData[727] = { 
			['floors'] = 2, ['name'] = "TheSteamvault", ['rzti'] = 545, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 876.7640075683594,584.5094146728516,716.7420043945312,-425.94219970703125,-160.02200317382812,158.5672149658203 },
			[2] = { 876.7640075683594,584.5094146728516,716.7420043945312,-425.94219970703125,-160.02200317382812,158.5672149658203 },
		}
		mapData[728] = { 
			['floors'] = 1, ['name'] = "TheSlavePens", ['rzti'] = 547, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 890.0581245422363,593.3720703125,836.1240234375,-391.65203857421875,-53.93410110473633,201.72003173828125 },
		}
		mapData[729] = { 
			['floors'] = 1, ['name'] = "TheBotanica", ['rzti'] = 553, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 757.4024810791016,504.93499755859375,107.64924621582031,-256.9100036621094,-649.7532348632812,248.02499389648438 },
		}
		mapData[730] = { 
			['floors'] = 2, ['name'] = "TheMechanar", ['rzti'] = 554, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 676.2380065917969,450.82540130615234,341.7799987792969,-100.83919525146484,-334.4580078125,349.9862060546875 },
			[2] = { 676.2380065917969,450.82536697387695,341.7799987792969,-37.8393440246582,-334.4580078125,412.98602294921875 },
		}
		mapData[731] = { 
			['floors'] = 3, ['name'] = "TheArcatraz", ['rzti'] = 552, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 689.6840209960938,459.7893524169922,405.1050109863281,-75.42433166503906,-284.5790100097656,384.3650207519531 },
			[2] = { 546.0480499267578,364.0320129394531,245.2870330810547,44.0,-300.7610168457031,408.0320129394531 },
			[3] = { 636.6840057373047,424.4560241699219,422.6050109863281,150.83297729492188,-214.07899475097656,575.2890014648438 },
		}
		mapData[732] = { 
			['floors'] = 1, ['name'] = "ManaTombs", ['rzti'] = 557, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 823.28515625,548.8568115234375,546.35107421875,-458.7860107421875,-276.93408203125,90.07080078125 },
		}
		mapData[733] = { 
			['floors'] = 0, ['name'] = "CoTTheBlackMorass", ['rzti'] = 269, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1087.5,725.0,-7649.99951171875,-1500.0,-6562.49951171875,-2225.0},
		}
		mapData[734] = { 
			['floors'] = 0, ['name'] = "CoTHillsbradFoothills", ['rzti'] = 560, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {2331.2499389648438,1554.1666259765625,-1854.1666259765625,3127.083251953125,477.08331298828125,1572.9166259765625},
		}
		mapData[736] = { 
			['floors'] = 0, ['name'] = "GilneasBattleground2", ['rzti'] = 761, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {1302.0832824707031,868.75,-1745.833251953125,1604.1666259765625,-443.7499694824219,735.4166259765625},
		}
		mapData[737] = { 
			['floors'] = 0, ['name'] = "TheMaelstrom", ['rzti'] = 730, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {1550.0,1033.333251953125,-1556.25,1370.833251953125,-6.25,337.5},
		}
		mapData[747] = { 
			['floors'] = 0, ['name'] = "LostCityofTolvir", ['rzti'] = 755, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {970.833251953125,647.9169921875,1004.1666259765625,-10591.666015625,1974.9998779296875,-11239.5830078125},
		}
		mapData[748] = { 
			['floors'] = 0, ['name'] = "Uldum_terrain1", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {6193.749755859375,4129.16650390625,-2441.66650390625,-8029.16650390625,3752.083251953125,-12158.3330078125},
		}
		mapData[749] = { 
			['floors'] = 1, ['name'] = "WailingCaverns", ['rzti'] = 43, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 936.4750061035156,624.3166656494141,375.9460144042969,-410.1463317871094,-560.5289916992188,214.1703338623047 },
		}
		mapData[750] = { 
			['floors'] = 2, ['name'] = "Maraudon", ['rzti'] = 349, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 975.0,650.0,827.5,550.0,-147.5,1200.0 },
			[2] = { 1637.5,1091.666000366211,1158.75,-208.33299255371094,-478.75,883.3330078125 },
		}
		mapData[751] = { 
			['floors'] = 0, ['name'] = "TheMaelstromContinent", ['rzti'] = 4294967295, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {0.0,0.0,-0.0,0.0,-0.0,0.0},
		}
		mapData[752] = { 
			['floors'] = 1, ['name'] = "BaradinHold", ['rzti'] = 757, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 585.0,390.0,-1032.5,125.0,-1617.5,515.0 },
		}
		mapData[753] = { 
			['floors'] = 2, ['name'] = "BlackrockCaverns", ['rzti'] = 645, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1019.5079345703125,679.6723194122314,-439.9320068359375,6.666669845581055,-1459.43994140625,686.3389892578125 },
			[2] = { 1019.5079345703125,679.6723194122314,-239.9320068359375,6.666669845581055,-1259.43994140625,686.3389892578125 },
		}
		mapData[754] = { 
			['floors'] = 2, ['name'] = "BlackwingDescent", ['rzti'] = 669, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 849.6940155029297,566.4623410701752,675.5850219726562,-567.4619750976562,-174.10899353027344,-0.9996340274810791 },
			[2] = { 999.6929779052734,666.4620056152344,750.583984375,-307.4620056152344,-249.10899353027344,359.0 },
		}
		mapData[755] = { 
			['floors'] = 4, ['name'] = "BlackwingLair", ['rzti'] = 469, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 499.42803955078125,332.94970703125,1344.050048828125,-7727.06982421875,844.6220092773438,-7394.1201171875 },
			[2] = { 649.4270629882812,432.94970703125,1379.050048828125,-7777.06982421875,729.6229858398438,-7344.1201171875 },
			[3] = { 649.4270629882812,432.94970703125,1369.050048828125,-7757.06982421875,719.6229858398438,-7324.1201171875 },
			[4] = { 649.4270629882812,432.94970703125,1419.050048828125,-7637.06982421875,769.6229858398438,-7204.1201171875 },
		}
		mapData[756] = { 
			['floors'] = 2, ['name'] = "TheDeadmines", ['rzti'] = 36, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 559.2640075683594,372.84250259399414,796.6220092773438,-337.5090026855469,237.35800170898438,35.333499908447266 },
			[2] = { 499.26300048828125,332.84230041503906,1016.6199951171875,-267.5090026855469,517.3569946289062,65.33329772949219 },
		}
		mapData[757] = { 
			['floors'] = 1, ['name'] = "GrimBatol", ['rzti'] = 670, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 869.0474319458008,579.364990234375,952.780029296875,-880.9869995117188,83.73259735107422,-301.62200927734375 },
		}
		mapData[758] = { 
			['floors'] = 3, ['name'] = "TheBastionofTwilight", ['rzti'] = 671, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1078.3349990844727,718.8899841308594,1184.7705078125,-899.8469848632812,106.43550872802734,-180.95700073242188 },
			[2] = { 778.343017578125,518.8949584960938,1034.77001953125,-1289.8499755859375,256.427001953125,-770.9550170898438 },
			[3] = { 1042.342025756836,694.8949584960938,1267.27001953125,-1402.8499755859375,224.92799377441406,-707.9550170898438 },
		}
		mapData[759] = { 
			['floors'] = 3, ['name'] = "HallsofOrigination", ['rzti'] = 644, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1531.7509765625,1021.1673054695129,304.781005859375,-1018.1700439453125,-1226.969970703125,2.9972615242004395 },
			[2] = { 1272.7550354003906,848.5034255981445,1115.2900390625,-934.8350219726562,-157.46499633789062,-86.33159637451172 },
			[3] = { 1128.7689819335938,752.5126647949219,403.29400634765625,-884.84033203125,-725.4749755859375,-132.32766723632812 },
		}
		mapData[760] = { 
			['floors'] = 1, ['name'] = "RazorfenDowns", ['rzti'] = 129, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 709.0489501953125,472.699951171875,-570.8909912109375,2209.85009765625,-1279.93994140625,2682.550048828125 },
		}
		mapData[761] = { 
			['floors'] = 1, ['name'] = "RazorfenKraul", ['rzti'] = 47, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 736.449951171875,490.9598388671875,-1322.469970703125,1858.6800537109375,-2058.919921875,2349.639892578125 },
		}
		mapData[762] = { 
			['floors'] = 4, ['name'] = "ScarletMonastery", ['rzti'] = 189, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 619.9839477539062,413.32275390625,-947.9860229492188,1616.858642578125,-1567.969970703125,2030.181396484375 },
			[2] = { 320.1909942626953,213.4604949951172,482.4639892578125,93.90550231933594,162.2729949951172,307.3659973144531 },
			[3] = { 612.6966094970703,408.4599609375,562.4240112304688,1600.6400146484375,-50.27259826660156,2009.0999755859375 },
			[4] = { 703.300048828125,468.86669921875,-1040.68994140625,812.4237060546875,-1743.989990234375,1281.2904052734375 },
		}
		mapData[763] = { 
			['floors'] = 4, ['name'] = "Scholomance", ['rzti'] = 289, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 320.0489044189453,213.36499786376953,68.63890075683594,104.33300018310547,-251.41000366210938,317.697998046875 },
			[2] = { 440.04901123046875,293.36640548706055,128.63900756835938,44.33259963989258,-311.4100036621094,337.6990051269531 },
			[3] = { 410.07799530029297,273.385799407959,113.63899993896484,34.32120132446289,-296.4389953613281,307.7070007324219 },
			[4] = { 531.0420074462891,354.0281982421875,174.1219940185547,-66.32119750976562,-356.9200134277344,287.7070007324219 },
		}
		mapData[764] = { 
			['floors'] = 7, ['name'] = "ShadowfangKeep", ['rzti'] = 33, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 352.4300537109375,234.9533920288086,-2003.7698974609375,-319.88299560546875,-2356.199951171875,-84.92960357666016 },
			[2] = { 212.4267578125,141.6179962158203,-2147.556640625,-303.2149963378906,-2359.9833984375,-161.5970001220703 },
			[3] = { 152.429931640625,101.61996459960938,-2103.77001953125,-193.21603393554688,-2256.199951171875,-91.5960693359375 },
			[4] = { 152.429931640625,101.62469482421875,-2103.77001953125,-193.21499633789062,-2256.199951171875,-91.59030151367188 },
			[5] = { 152.429931640625,101.62469482421875,-2103.77001953125,-193.21499633789062,-2256.199951171875,-91.59030151367188 },
			[6] = { 198.429931640625,132.28662872314453,-2080.77001953125,-182.5460205078125,-2279.199951171875,-50.25939178466797 },
			[7] = { 272.429931640625,181.61996459960938,-2023.77001953125,-278.2160339355469,-2296.199951171875,-96.5960693359375 },
		}
		mapData[765] = { 
			['floors'] = 2, ['name'] = "Stratholme", ['rzti'] = 329, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 705.719970703125,470.47998046875,3617.679931640625,3338.969970703125,2911.9599609375,3809.449951171875 },
			[2] = { 1005.720458984375,670.480224609375,3967.68017578125,3498.969970703125,2961.959716796875,4169.4501953125 },
		}
		mapData[766] = { 
			['floors'] = 3, ['name'] = "AhnQiraj", ['rzti'] = 531, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 2777.5441131591797,1851.6962890625,-138.0760040283203,-9510.9833984375,-2915.6201171875,-7659.287109375 },
			[2] = { 977.5599365234375,651.70654296875,-1538.0699462890625,-8703.5029296875,-2515.6298828125,-8051.79638671875 },
			[3] = { 577.56005859375,385.0400390625,-1738.06982421875,-8720.169921875,-2315.6298828125,-8335.1298828125 },
		}
		mapData[767] = { 
			['floors'] = 2, ['name'] = "ThroneofTides", ['rzti'] = 643, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 998.1719360351562,665.447998046875,-308.89801025390625,-679.447998046875,-1307.0699462890625,-14.0 },
			[2] = { 998.1719360351562,665.447998046875,-308.89801025390625,-329.447998046875,-1307.0699462890625,336.0 },
		}
		mapData[768] = { 
			['floors'] = 1, ['name'] = "TheStonecore", ['rzti'] = 725, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1317.1289978027344,878.0869750976562,-384.1210021972656,797.4829711914062,-1701.25,1675.5699462890625 },
		}
		mapData[769] = { 
			['floors'] = 1, ['name'] = "Skywall", ['rzti'] = 657, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 2018.7250366210938,1345.8180236816406,910.9349975585938,-1457.1500244140625,-1107.7900390625,-111.33200073242188 },
		}
		mapData[770] = { 
			['floors'] = 0, ['name'] = "TwilightHighlands_terrain1", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {5270.8330078125,3514.5830078125,2437.5,-2156.25,7708.3330078125,-5670.8330078125},
		}
		mapData[772] = { 
			['floors'] = 0, ['name'] = "AhnQirajTheFallenKingdom", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {4049.9998321533203,2700.0,-3891.66650390625,-8033.3330078125,158.3333282470703,-10733.3330078125},
		}
		mapData[773] = { 
			['floors'] = 1, ['name'] = "ThroneoftheFourWinds", ['rzti'] = 754, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1500.0,1000.0,-25.0,-550.0,-1525.0,450.0 },
		}
		mapData[775] = { 
			['floors'] = 0, ['name'] = "CoTMountHyjal", ['rzti'] = 534, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {2499.999755859375,1666.66650390625,1525.0,6145.8330078125,4024.999755859375,4479.16650390625},
		}
		mapData[776] = { 
			['floors'] = 1, ['name'] = "GruulsLair", ['rzti'] = 565, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 525.0,350.0,50.0,-12.5,-475.0,337.5 },
		}
		mapData[779] = { 
			['floors'] = 1, ['name'] = "MagtheridonsLair", ['rzti'] = 544, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 556.0,370.6666946411133,170.5,-115.3333511352539,-385.5,255.33334350585938 },
		}
		mapData[780] = { 
			['floors'] = 1, ['name'] = "CoilfangReservoir", ['rzti'] = 548, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1575.0029754638672,1050.0020141601562,1362.50048828125,-400.0,-212.5024871826172,650.0020141601562 },
		}
		mapData[781] = { 
			['floors'] = 0, ['name'] = "ZulAman", ['rzti'] = 568, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1268.7499389648438,845.8333129882812,-1852.083251953125,568.75,-583.3333129882812,-277.08331298828125},
		}
		mapData[782] = { 
			['floors'] = 1, ['name'] = "TempestKeep", ['rzti'] = 550, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1575.0,1050.0,787.5,-100.0,-787.5,950.0 },
		}
		mapData[789] = { 
			['floors'] = 2, ['name'] = "SunwellPlateau", ['rzti'] = 580, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 906.25,604.1666259765625,-1206.25,2012.4998779296875,-300.0,1408.333251953125 },
			[2] = { 465.0,310.0,-377.5,1580.0,-842.5,1890.0 },
		}
		mapData[793] = { 
			['floors'] = 0, ['name'] = "ZulGurub", ['rzti'] = 859, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {2120.833251953125,1414.5830078125,612.5,-11225.0,2733.333251953125,-12639.5830078125},
		}
		mapData[795] = { 
			['floors'] = 0, ['name'] = "MoltenFront", ['rzti'] = 861, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {1189.5833129882812,793.7499389648438,-933.3333129882812,1702.083251953125,256.25,908.3333129882812},
		}
		mapData[796] = { 
			['floors'] = 7, ['name'] = "BlackTemple", ['rzti'] = 564, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1252.2495784759521,834.8330078125,-23.87053871154785,-240.0,-1276.1201171875,594.8330078125 },
			[2] = { 975.0,650.0,176.0,380.0,-799.0,1030.0 },
			[3] = { 1005.0,670.0,191.0,400.0,-814.0,1070.0 },
			[4] = { 440.0009765625,293.333984375,-134.99951171875,343.3330078125,-575.00048828125,636.6669921875 },
			[5] = { 670.0,446.66668701171875,70.0,664.1636352539062,-600.0,1110.830322265625 },
			[6] = { 705.0,470.0,67.5,450.0,-637.5,920.0 },
			[7] = { 355.0,236.6666259765625,-137.5,606.6666870117188,-492.5,843.3333129882812 },
		}
		mapData[797] = { 
			['floors'] = 1, ['name'] = "HellfireRamparts", ['rzti'] = 543, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 694.56005859375,463.0400390625,-1294.719970703125,-1492.47998046875,-1989.280029296875,-1029.43994140625 },
		}
		mapData[798] = { 
			['floors'] = 2, ['name'] = "MagistersTerrace", ['rzti'] = 585, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 530.3340148925781,353.55596923828125,304.22601318359375,-27.79583740234375,-226.10800170898438,325.7601318359375 },
			[2] = { 530.3340148925781,353.55599212646484,304.22601318359375,-27.79589080810547,-226.10800170898438,325.7601013183594 },
		}
		mapData[799] = { 
			['floors'] = 17, ['name'] = "Karazhan", ['rzti'] = 532, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 550.048828125,366.69921875,2225.0244140625,-11189.599609375,1674.9755859375,-10822.900390625 },
			[2] = { 257.85986328125,171.90625,2081.419921875,-11189.0029296875,1823.56005859375,-11017.0966796875 },
			[3] = { 345.1494140625,230.099609375,2132.57470703125,-11066.2998046875,1787.42529296875,-10836.2001953125 },
			[4] = { 520.048828125,346.69921875,2190.0244140625,-11119.599609375,1669.9755859375,-10772.900390625 },
			[5] = { 234.14990234375,156.099609375,1932.5799560546875,-10969.2998046875,1698.4300537109375,-10813.2001953125 },
			[6] = { 581.548828125,387.69921875,2205.7744140625,-11190.599609375,1624.2255859375,-10802.900390625 },
			[7] = { 191.548828125,127.69921875,2066.7744140625,-11115.599609375,1875.2255859375,-10987.900390625 },
			[8] = { 139.3505859375,92.900390625,2037.6802978515625,-11105.2001953125,1898.3297119140625,-11012.2998046875 },
			[9] = { 760.048828125,506.69921875,2270.0244140625,-11459.599609375,1509.9755859375,-10952.900390625 },
			[10] = { 450.25,300.166015625,2040.1300048828125,-11386.3330078125,1589.8800048828125,-11086.1669921875 },
			[11] = { 271.050048828125,180.69921875,1825.530029296875,-11285.099609375,1554.47998046875,-11104.400390625 },
			[12] = { 595.048828125,396.69921875,2182.5244140625,-11444.599609375,1587.4755859375,-11047.900390625 },
			[13] = { 529.048828125,352.69921875,1963.0244140625,-11339.099609375,1433.9755859375,-10986.400390625 },
			[14] = { 245.25,163.5,2032.6300048828125,-11143.0,1787.3800048828125,-10979.5 },
			[15] = { 211.14990234375,140.765625,2025.0799560546875,-11113.6328125,1813.9300537109375,-10972.8671875 },
			[16] = { 101.25,67.5,2020.1300048828125,-11097.0,1918.8800048828125,-11029.5 },
			[17] = { 341.25,227.5,2155.1298828125,-11102.0,1813.8798828125,-10874.5 },
		}
		mapData[800] = { 
			['floors'] = 3, ['name'] = "Firelands", ['rzti'] = 720, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {1587.4999389648438,1058.3332824707031,-718.75,424.9999694824219,868.7499389648438,-633.3333129882812},
			[2] = { 375.0,250.0,-302.08331298828125,343.75,-677.0833129882812,593.75 },
			[3] = { 1440.0,960.0,770.0,265.0,-670.0,1225.0 },
		}
		mapData[803] = { 
			['floors'] = 1, ['name'] = "TheNexusLegendary", ['rzti'] = 951, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1101.2841796875,734.189697265625,-6656.60791015625,3626.820068359375,-7757.89208984375,4361.009765625 },
		}
		mapData[806] = { 
			['floors'] = 0, ['name'] = "TheJadeForest", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {6983.3330078125,4654.1669921875,-1452.0830078125,3652.0830078125,5531.25,-1002.083984375},
		}
		mapData[807] = { 
			['floors'] = 0, ['name'] = "ValleyoftheFourWinds", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {3925.0009765625,2616.6669921875,-2679.1669921875,1095.8330078125,1245.833984375,-1520.833984375},
		}
		mapData[808] = { 
			['floors'] = 0, ['name'] = "TheWanderingIsle", ['rzti'] = 860, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {2670.8330078125,1779.1669921875,-4979.166015625,1785.4169921875,-2308.3330078125,6.25},
		}
		mapData[809] = { 
			['floors'] = 0, ['name'] = "KunLaiSummit", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {6258.3330078125,4172.9169921875,-4839.5830078125,5618.75,1418.75,1445.8330078125},
		}
		mapData[810] = { 
			['floors'] = 0, ['name'] = "TownlongWastes", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {5743.7490234375,3829.166015625,-7079.166015625,4558.3330078125,-1335.4169921875,729.1669921875},
		}
		mapData[811] = { 
			['floors'] = 0, ['name'] = "ValeofEternalBlossoms", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {2533.333984375,1687.5009765625,-2481.25,1947.9169921875,52.083984375,260.416015625},
		}
		mapData[813] = { 
			['floors'] = 0, ['name'] = "NetherstormArena", ['rzti'] = 968, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {2270.8331909179688,1514.5833740234375,-2660.41650390625,2918.75,-389.58331298828125,1404.1666259765625},
		}
		mapData[816] = { 
			['floors'] = 0, ['name'] = "WellofEternity", ['rzti'] = 939, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = {1252.0830078125,833.333251953125,4650.0,3766.66650390625,5902.0830078125,2933.333251953125},
		}
		mapData[819] = { 
			['floors'] = 2, ['name'] = "HourofTwilight", ['rzti'] = 940, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 3043.7498779296875,2029.16650390625,-1791.6666259765625,5327.0830078125,1252.083251953125,3297.91650390625 },
			[2] = { 375.0,250.0,-75.0,3425.0,-450.0,3675.0 },
		}
		mapData[820] = { 
			['floors'] = 5, ['name'] = "EndTime", ['rzti'] = 938, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 562.5,375.0,-231.25,2918.75,-793.75,3293.75 },
			[2] = { 865.6205444335938,577.080322265625,-534.8982543945312,3499.999755859375,-1400.518798828125,4077.080078125 },
			[3] = { 475.0,316.66650390625,-1181.25,4229.1650390625,-1656.25,4545.83154296875 },
			[4] = { 696.884765625,464.58984375,290.109375,2570.830078125,-406.775390625,3035.419921875 },
			[5] = { 453.135009765625,302.08984375,646.3590087890625,3970.830078125,193.2239990234375,4272.919921875 },
		}
		mapData[823] = { 
			['floors'] = 0, ['name'] = "DarkmoonFaireIsland", ['rzti'] = 974, ['map_type'] = 0, ['continent'] = 0, ['transform'] = 0,
			[1] = {1858.3330078125,1239.58349609375,-7268.74951171875,-3322.91650390625,-5410.41650390625,-4562.5},
		}
		mapData[824] = { 
			['floors'] = 7, ['name'] = "DragonSoul", ['rzti'] = 967, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 3106.70849609375,2063.065185546875,833.5927734375,-565.0927734375,3940.30126953125,-2628.157958984375 },
			[2] = { 397.5,265.0,2113.75,-1890.0,1716.25,-1625.0 },
			[3] = { 427.5,285.0,3262.0,-1910.0,2834.5,-1625.0 },
			[4] = { 185.19921875,123.466796875,-13523.900390625,13528.2666015625,-13709.099609375,13651.7333984375 },
			[5] = { 1.5,1.0,0.25,0.0,-1.25,1.0 },
			[6] = { 1.5,1.0,0.25,0.0,-1.25,1.0 },
			[7] = { 1108.3515625,738.900390625,-11427.07421875,-12254.900390625,-12535.42578125,-11516.0 },
		}
		mapData[851] = { 
			['floors'] = 0, ['name'] = "DustwallowMarshScenario", ['rzti'] = 999, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {1058.333984375,706.25,3979.166015625,-3468.75,5037.5,-4175.0},
		}
		mapData[856] = { 
			['floors'] = 0, ['name'] = "TempleofKotmogu", ['rzti'] = 998, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = {839.5830078125,560.416015625,-1743.75,2083.3330078125,-904.1669921875,1522.9169921875},
		}
		mapData[857] = { 
			['floors'] = 0, ['name'] = "Krasarang", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {4687.5009765625,3124.9999923706055,-2947.9169921875,-110.41602325439453,1739.583984375,-3235.416015625},
		}
		mapData[858] = { 
			['floors'] = 0, ['name'] = "DreadWastes", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {5352.0830078125,3568.7509765625,-6139.5830078125,1416.6669921875,-787.5,-2152.083984375},
		}
		mapData[860] = { 
			['floors'] = 1, ['name'] = "STVDiamondMineBG", ['rzti'] = 727, ['map_type'] = 3, ['continent'] = 0, ['transform'] = 0,
			[1] = { 915.5059967041016,610.3373107910156,200.2530059814453,425.5828552246094,-715.2529907226562,1035.920166015625 },
		}
		mapData[862] = { 
			['floors'] = 0, ['name'] = "Pandaria", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {15515.30029296875,10343.5400390625,-8752.8603515625,6679.16015625,6762.43994140625,-3664.3798828125},
		}
		mapData[864] = { 
			['floors'] = 0, ['name'] = "Northshire", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {968.75,645.833984375,-187.5,-8570.83203125,781.25,-9216.666015625},
		}
		mapData[866] = { 
			['floors'] = 0, ['name'] = "ColdridgeValley", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {964.5830078125,643.75,-979.1669921875,-5962.5,-14.583984375,-6606.25},
		}
		mapData[867] = { 
			['floors'] = 2, ['name'] = "EastTemple", ['rzti'] = 960, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 550.0,366.66668701171875,2865.0,751.6636352539062,2315.0,1118.330322265625 },
			[2] = { 198.0,132.0,2576.5,788.5,2378.5,920.5 },
		}
		mapData[871] = { 
			['floors'] = 2, ['name'] = "ScarletHalls", ['rzti'] = 1001, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 465.0,310.0,-302.5,790.0,-767.5,1100.0 },
			[2] = { 468.0,312.0,-265.0,1035.5,-733.0,1347.5 },
		}
		mapData[873] = { 
			['floors'] = 0, ['name'] = "TheHiddenPass", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {1793.75,1195.8330078125,-812.5,1689.5830078125,981.25,493.75},
		}
		mapData[874] = { 
			['floors'] = 2, ['name'] = "ScarletCathedral", ['rzti'] = 1004, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 343.02001953125,228.67999267578125,-428.989990234375,1000.6599731445312,-772.010009765625,1229.3399658203125 },
			[2] = { 600.0,400.0,-300.5,660.0,-900.5,1060.0 },
		}
		mapData[875] = { 
			['floors'] = 2, ['name'] = "TheGreatWall", ['rzti'] = 962, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 1300.0,866.6666870117188,-1605.0,616.6636352539062,-2905.0,1483.330322265625 },
			[2] = { 222.52001953125,148.3466796875,-2191.239990234375,1123.32666015625,-2413.760009765625,1271.67333984375 },
		}
		mapData[876] = { 
			['floors'] = 4, ['name'] = "StormstoutBrewery", ['rzti'] = 961, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 260.0009765625,173.333984375,-1212.49951171875,-836.6669921875,-1472.50048828125,-663.3330078125 },
			[2] = { 260.0009765625,173.333984375,-1212.49951171875,-836.6669921875,-1472.50048828125,-663.3330078125 },
			[3] = { 340.0,226.6666259765625,-1047.5,-818.3333129882812,-1387.5,-591.6666870117188 },
			[4] = { 230.0009765625,153.333984375,-1044.99951171875,-776.6669921875,-1275.00048828125,-623.3330078125 },
		}
		mapData[877] = { 
			['floors'] = 3, ['name'] = "ShadowpanHideout", ['rzti'] = 959, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 310.0,206.66650390625,-2505.0,3566.666748046875,-2815.0,3773.333251953125 },
			[2] = { 210.0,140.0,-2932.5,3610.0,-3142.5,3750.0 },
			[3] = { 390.0,260.0,-2700.0,3895.0,-3090.0,4155.0 },
		}
		mapData[878] = { 
			['floors'] = 0, ['name'] = "BrewmasterScenario01", ['rzti'] = 1005, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {468.75,312.5,875.0,2389.5830078125,1343.75,2077.0830078125},
		}
		mapData[879] = { 
			['floors'] = 0, ['name'] = "KunLaiSummitScenario", ['rzti'] = 1014, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {729.166015625,485.4169921875,-2102.0830078125,4168.75,-1372.9169921875,3683.3330078125},
		}
		mapData[880] = { 
			['floors'] = 0, ['name'] = "TheJadeForestScenario", ['rzti'] = 1024, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {925.0,616.6669921875,1397.916015625,2372.9169921875,2322.916015625,1756.25},
		}
		mapData[881] = { 
			['floors'] = 0, ['name'] = "ValleyOfPowerScenario", ['rzti'] = 1035, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {839.5830078125,560.416015625,-1743.75,2083.3330078125,-904.1669921875,1522.9169921875},
		}
		mapData[882] = { 
			['floors'] = 0, ['name'] = "BrewmasterScenario03", ['rzti'] = 1048, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {906.2490234375,604.166015625,-1220.8330078125,-2564.583984375,-314.583984375,-3168.75},
		}
		mapData[883] = { 
			['floors'] = 0, ['name'] = "Tyrivess", ['rzti'] = 1050, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {2683.3330078125,1789.58203125,-5616.666015625,-252.083984375,-2933.3330078125,-2041.666015625},
		}
		mapData[884] = { 
			['floors'] = 0, ['name'] = "KunLaiPassScenario", ['rzti'] = 1051, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {970.8330078125,647.9169921875,-747.9169921875,2216.6669921875,222.916015625,1568.75},
		}
		mapData[885] = { 
			['floors'] = 3, ['name'] = "MogushanPalace", ['rzti'] = 994, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 735.0,490.0,3052.5,-4360.0,2317.5,-3870.0 },
			[2] = { 540.0,360.0,2905.0,-4485.0,2365.0,-4125.0 },
			[3] = { 747.509765625,498.33984375,3058.7548828125,-4776.669921875,2311.2451171875,-4278.330078125 },
		}
		mapData[886] = { 
			['floors'] = 0, ['name'] = "TerraceOfEndlessSpring", ['rzti'] = 996, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = {702.083984375,468.75,2497.916015625,-789.583984375,3200.0,-1258.333984375},
		}
		mapData[887] = { 
			['floors'] = 2, ['name'] = "SiegeofNiuzaoTemple", ['rzti'] = 1011, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 290.009765625,193.340087890625,-5009.9951171875,1438.3299560546875,-5300.0048828125,1631.6700439453125 },
			[2] = { 290.009765625,193.340087890625,-5009.9951171875,1438.3299560546875,-5300.0048828125,1631.6700439453125 },
		}
		mapData[888] = { 
			['floors'] = 0, ['name'] = "ShadowglenStart", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1450.0009765625,966.6669921875,-1491.6669921875,11033.3330078125,-41.666015625,10066.666015625},
		}
		mapData[889] = { 
			['floors'] = 0, ['name'] = "ValleyofTrialsStart", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1350.0,900.0,3641.666015625,0.0,4991.666015625,-900.0},
		}
		mapData[890] = { 
			['floors'] = 0, ['name'] = "CampNaracheStart", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1766.66796875,1177.08203125,-233.333984375,-2577.083984375,1533.333984375,-3754.166015625},
		}
		mapData[891] = { 
			['floors'] = 0, ['name'] = "EchoIslesStart", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {1806.25,1204.166015625,4491.666015625,-525.0,6297.916015625,-1729.166015625},
		}
		mapData[892] = { 
			['floors'] = 0, ['name'] = "DeathknellStart", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {1089.583984375,727.0830078125,-2147.9169921875,2270.8330078125,-1058.3330078125,1543.75},
		}
		mapData[893] = { 
			['floors'] = 0, ['name'] = "SunstriderIsleStart", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {1600.0,1066.6669921875,5383.333984375,10833.3330078125,6983.333984375,9766.666015625},
		}
		mapData[894] = { 
			['floors'] = 0, ['name'] = "AmmenValeStart", ['rzti'] = 530, ['map_type'] = 0, ['continent'] = 3, ['transform'] = 1,
			[1] = {1818.75,1212.5,12814.58203125,-3604.166015625,14633.33203125,-4816.666015625},
		}
		mapData[895] = { 
			['floors'] = 0, ['name'] = "NewTinkertownStart", ['rzti'] = 0, ['map_type'] = 0, ['continent'] = 1, ['transform'] = 0,
			[1] = {1850.0,1233.33203125,-1206.25,-4727.083984375,643.75,-5960.416015625},
		}
		mapData[896] = { 
			['floors'] = 3, ['name'] = "MogushanVaults", ['rzti'] = 1008, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 687.509765625,458.33984375,-874.9906005859375,3735.830078125,-1562.5003662109375,4194.169921875 },
			[2] = { 432.509765625,288.33984375,-1244.9951171875,4088.330078125,-1677.5048828125,4376.669921875 },
			[3] = { 750.0,500.0,-1315.0,3780.0,-2065.0,4280.0 },
		}
		mapData[897] = { 
			['floors'] = 2, ['name'] = "HeartofFear", ['rzti'] = 1009, ['map_type'] = 2, ['continent'] = 0, ['transform'] = 0,
			[1] = { 700.0,466.666748046875,-0.0,-2433.33349609375,-700.0,-1966.666748046875 },
			[2] = { 1440.0043802261353,960.0029296875,9.994370460510254,-2730.00146484375,-1430.010009765625,-1769.99853515625 },
		}
		mapData[898] = { 
			['floors'] = 4, ['name'] = "Scholomance", ['rzti'] = 1007, ['map_type'] = 1, ['continent'] = 0, ['transform'] = 0,
			[1] = { 250.00200653076172,166.6680145263672,79.5009994506836,134.6649932861328,-170.50100708007812,301.3330078125 },
			[2] = { 445.0003662109375,296.66690826416016,130.00018310546875,43.666099548339844,-315.00018310546875,340.3330078125 },
			[3] = { 262.5,175.0,73.75,-87.5,-188.75,87.5 },
			[4] = { 262.5,175.0,73.75,-87.5,-188.75,87.5 },
		}
		mapData[899] = { 
			['floors'] = 1, ['name'] = "ProvingGrounds", ['rzti'] = 1031, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = { 212.490234375,141.66015625,-418.7548828125,3726.669921875,-631.2451171875,3868.330078125 },
		}
		mapData[900] = { 
			['floors'] = 2, ['name'] = "AncientMoguCrypt", ['rzti'] = 1030, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = { 645.0,430.0,-2122.5,540.0,-2767.5,970.0 },
			[2] = { 335.50048828125,223.6669921875,-2182.249755859375,606.3330078125,-2517.750244140625,830.0 },
		}
		mapData[903] = { 
			['floors'] = 0, ['name'] = "ShrineofTwoMoons", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {0.0,0.0,-0.0,0.0,-0.0,0.0},
		}
		mapData[905] = { 
			['floors'] = 0, ['name'] = "ShrineofSevenStars", ['rzti'] = 870, ['map_type'] = 0, ['continent'] = 6, ['transform'] = 0,
			[1] = {0.0,0.0,-0.0,0.0,-0.0,0.0},
		}
		mapData[906] = { 
			['floors'] = 0, ['name'] = "DustwallowMarshScenarioAlliance", ['rzti'] = 1000, ['map_type'] = 5, ['continent'] = 0, ['transform'] = 0,
			[1] = {1058.333984375,706.25,3979.166015625,-3468.75,5037.5,-4175.0},
		}
		mapData[907] = { 
			['floors'] = 0, ['name'] = "Dustwallow_terrain1", ['rzti'] = 1, ['map_type'] = 0, ['continent'] = 2, ['transform'] = 0,
			[1] = {5250.0,3500.0,975.0,-2033.333984375,6225.0,-5533.333984375},
		}
	-- Dustwallow Transition patch for client that havent been patched
	SetMapByID(141)
	local dwMap = GetMapInfo()
	if dwMap == "DustwallowMarsh" then
		mapData[141].name = "Dustwallow"
	end
	-- Create Reverse map
	for k,v in pairs(mapData) do
		idToMap[v['name']] = k
	end
	
	-- Phasing Hacks
	for k,v in pairs(idToMap) do
		local m,e = string.find(k,"_terrain%d")
		if m then
			rmap = k:sub(1,m-1)
			idToMap[k] = idToMap[rmap]
		end
	end
	-- non terrain style remap for battle of gilneas
	idToMap["BattleforGilneas"] = idToMap["GilneasCity"]
	
	-- Build the localized name list.
	local continentList = {GetMapContinents()}
	for cID = 1, #continentList do
		SetMapZoom(cID, 0)
		local mapfile = GetMapInfo()
		local cname = continentList[cID]
		mapToLocal[mapfile] = cname
		localToMap[cname] = mapfile
		mapData[idToMap[mapfile]].continent = cID
		for zID, zname in ipairs({GetMapZones(cID)}) do
			SetMapZoom(cID, zID)
			local mapfile = GetMapInfo()
			-- L: X1, T: Y1, R: X2, B: Y2 New GetCurrentMapZone
			mapToLocal[mapfile] = zname
			localToMap[zname] = mapfile
			mapData[idToMap[mapfile]].continent = cID
			-- Phasing Hacks
			local mstart,e = string.find(mapfile,"_terrain%d")
			if mstart then
				local rmap = mapfile:sub(1,mstart-1)
				mapToLocal[rmap] = zname
				mapData[idToMap[rmap]].continent = cID
			end
		end
	end

	for k,v in pairs(mapData) do
		local rName = rawget(mapToLocal,v.name)
		if rName == nil and v.rzti then
			mapToLocal[v.name] = GetRealZoneText(v.rzti)
		end
		SetMapByID(k)
		local _,l,t,r,b = GetCurrentMapZone()
		local floors = GetNumDungeonMapLevels();
		local width, height = 0,0
		width = math.abs((-l) - (-r))
		height = math.abs(t - b)
		if l and l ~= 0 and t and t~= 0 and r and r ~= 0 and b and b ~= 0 and v.floors == 0 then
			if v[1][1] ~= width then
				v[1][1] = width
			end
			if v[1][2] ~= height then
				v[1][2] = height
			end
			v[1][3] = -l
			v[1][4] = t
			v[1][5] = -r
			v[1][6] = b
		end
		-- update floor data if we can
		if v.floors > 0 and floors > 0 then
			for f = 1, floors do
				SetDungeonMapLevel(f)
				local _, l, t, r, b = GetCurrentMapDungeonLevel()
				if l and l ~= 0 and t and t~= 0 and r and r ~= 0 and b and b ~= 0 then
					if v[f] == nil then
						v[f] = {}
					end
					local width, height = 0,0
					width = math.abs((-l) - (-r))
					height = math.abs(t - b)
					if v[f][3] ~= -l  and v[f][4] ~= t and v[f][5] ~= -r and v[f][6] ~= b then
						v[f][1] = width
						v[f][2] = height
						v[f][3] = -l
						v[f][4] = t
						v[f][5] = -r
						v[f][6] = b
					end
				end
			end
		end
	end
end

--- API to encode a location in game
-- @param x
-- @param y
-- @param mapLevel
-- @return encoded location number
function lib:EncodeLoc(x,y,level)
	local level = level or 0
	if x > 0.9999 then
		x = 0.9999
	end
	if y > 0.9999 then
		y = 0.9999
	end
	return floor( x * 10000 + 0.5 ) * 1000000 + floor( y * 10000  + 0.5 ) * 100 + level
end

--- API to decode a location num
-- @param location id
-- @return x,y,level
function lib:DecodeLoc(id)
	return floor(id/1000000)/10000, floor(id % 1000000 / 100)/10000, id % 100
end

--- API to list all zones
-- @param (optional) table to store results in
-- @return a table of zones
function lib:GetAllMapIDs(storage)
	local t = storage or {}
	local i = 1
	for k,v in pairs(mapData) do
		t[i] = k
		i= i + 1
	end
	return t
end

--- API to list raids
-- @param (optional) table to store results in
-- @return a table containing the raid area ids
function lib:GetRaids(storage)
	local t = storage or {}
	local i = 1
	for k,v in pairs(mapData) do
		if v.map_type == 2 then
			t[i] = k
			i = i + 1
		end
	end
	return t
end

--- API to list dungeons
-- @param (optional) table to store results in
-- @return a table containing the dungeon area ids
function lib:GetDungeons(storage)
	local t = storage or {}
	local i = 1
	for k,v in pairs(mapData) do
		if v.map_type == 1 then
			t[i] = k
			i = i + 1
		end
	end
	return t
end


--- API to get the continent for a given map
-- @param the map file or id to check
-- @return the in-game continent index
function lib:GetContinentFromMap(mapfile)
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return -1 end
	return mapData[mapfile].continent
end

--- API to list zones by continent
-- @param Continent index
-- @param (optional) table to store results in
-- @return a table containing the zone area ids
function lib:GetZonesForContinent(continent, storage)
	local t = storage or {}
	if continent < 1 then
		return t
	end
	local i = 1
	for k,v in pairs(mapData) do
		if v.continent == continent then
			t[i] = k
			i = i + 1
		end
	end
	return t
end
--- API to determine is a map is a continent
-- @param mapfile or area id to check
-- @return true if a continent
function lib:IsContinentMap(mapfile)
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return true end
	if mapfile == 466 or mapfile == 485 or mapfile == 13 or mapfile == 14 or mapfile == 751 then
		return true
	end
	return false
end

--[[
	The upper lft, lower right coords are the position within the continent map
	so to figure out location on a given continent, we need to upscale the x,y to the continent
--]]

--- API to get distance and direction to a target in the same map
-- @param mapfile to use
-- @param targetX coords
-- @param targetY coords
-- @return distance,angle where distance is yards and angle is radians
function lib:DistanceAndDirection(mapfile,floor,targetX, targetY)
	local srcX,srcY = GetPlayerMapPosition("player")
	local distance,xd,yd = self:Distance(mapfile,floor,srcX,srcY,targetX,targetY)
	local radians =  atan2(xd,-yd)
	if radians > 0 then
		radians = PI2 - radians
	else
		radians = -radians
	end
	return distance,radians
end

--- API to calc the distance between 2 locations within the same mapfile
-- @param mapfile or area_id
-- @param floor to use
-- @param srcX starting x
-- @param srcY starting y
-- @param dstX destination x
-- @param dstY destination y
-- @return distance, xdelta, ydelta where distance is the total distance, xdelta is the delta of the x values and ydelta is the detla of y values all in yards
function lib:Distance(mapfile,floor, srcX,srcY,dstX,dstY)
	assert(floor == nil or (type(floor) == "number" and floor))
	local width = 0
	local height = 0
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0,0,0 end
	local data = mapData[mapfile]
	local fl = data[floor]
	if floor and floor <= data['floors'] and floor > 0 then
		width, height  = fl[1],fl[2] 
	else
		fl = data[1]
		width,height = fl[1], fl[2]
	end
	local x = (dstX - srcX) * width
	local y = (dstY - srcY) * height
	return (x*x + y*y)^0.5,x,y
end

--- API to convert an x,y (yards) in a given zone up to the world map
-- @param mapfile
-- @param x in yards
-- @param y in yards
-- @return the x,y point in world map yards
function lib:ConvertToWorldPoint(mapfile,x,y)
   	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0 end
	local fl = mapData[mapfile]
	-- Convert to continet data
	local x1,y1 = self:ConvertToContinent(mapfile,0,x,y)
	return x1 + contOffsets[fl.continent][1], y1 + contOffsets[fl.continent][2]
end

--- API to convert from the world poistion in yars to the world map scale
-- @param x the world map x point in yards
-- @param y in the world map yard point
-- @return x,y in world map frame scale
function lib:ConvertFromWorldPoint(x,y)
	return x/worldMapWidth, y/worldMapHeight
end

-- API to convert from continent x,y (in yards) to zone x,y
-- @param map the map to use
-- @param floor the floor to use
-- @param x in yards
-- @param y in yards
-- @return x,y in zone scale
function lib:ConvertFromContinent(map,floor,x,y)
	if type(map) == "string" then
		map = idToMap[map]
	end
	if map == WORLDMAP_COSMIC_ID then return 0,0 end
	local zx1,zy1 = self:GetMapUpperLeft(map,floor)
	local zx2,zy2 = self:GetMapLowerRight(map,floor)
	local x,y = (x-zx1)/(zx1-zx2), (y-zy1)/(zy2-zy1)
	if mapData[map].transform == 1 then
		x = x - transforms_x[mapData[map].continent]
		y = y - transforms_y[mapData[map].continent]
	end
	return x,y
end

-- API to convert to continent x,y (in yards) from zone x,y
-- @param map the map to use
-- @param floor the floor to use
-- @param x in yards
-- @param y in yards
-- @return x,y in continent scale
function lib:ConvertToContinent(map,floor, x,y)
	if type(map) == "string" then
		map = idToMap[map]
	end
	if map == WORLDMAP_COSMIC_ID then return 0,0 end
	local zx1,zy1 = self:GetMapUpperLeft(map,floor)
	local zx2,zy2 = self:GetMapLowerRight(map,floor)
	local x,y =  zx1 + (zx2-zx1)*x,zy1 + (zy2-zy1)*y
	if mapData[map].transform == 1 then
		x = x + transforms_x[mapData[map].continent]
		y = y + transforms_y[mapData[map].continent]
	end
	return x,-y
end

--- API to calc the distance between 2 locations across map files
-- @param srcMap or area_id
-- @param srcFloor to use
-- @param srcX starting x
-- @param srcY starting y
-- @param dstMap destination map file
-- @param dstFloor destination floor
-- @param dstX destination x
-- @param dstY destination y
-- @return distance, xdelta, ydelta where distance is the total distance, xdelta is the delta of the x values and ydelta is the detla of y values all in yards
function lib:DistanceWithinContinent(srcMap,srcFloor, srcX, srcY, dstMap, dstFloor, dstX, dstY)
	assert(srcFloor == nil or (type(srcFloor) == "number" and srcFloor))
	assert(dstFloor == nil or (type(dstFloor) == "number" and dstFloor))
	if type(dstMap) == "string" then
		dstMap = idToMap[dstMap]
	end
	if type(srcMap) == "string" then
		srcMap = idToMap[srcMap]
	end
	
	if srcMap == WORLDMAP_COSMIC_ID or dstMap == WORLDMAP_COSMIC_ID then
		return 0,0,0
	end
	
	if mapData[srcMap].continent ~= mapData[dstMap].continent then
		return 0,0,0
	end
	local startX, startY = self:ConvertToContinent(srcMap,srcFloor, srcX, srcY)
	local endX, endY = self:ConvertToContinent(dstMap,dstFloor, dstX, dstY)
	local x = (endX - startX)
	local y = (endY - startY)
	return (x*x+y*y)^0.5,x,y
end

--- API to convert coords to yards
-- @param mapfile or area_id
-- @param floor
-- @param x coord
-- @param y coord
-- @return x,y as yards
function lib:PointToYards(mapfile,floor, x, y)
	assert(floor == nil or (type(floor) == "number" and floor))
	local width = 0
	local height = 0
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0,0 end
	local data = mapData[mapfile]
	local fl = data[floor]
	if floor and floor <= data['floors'] and floor > 0 then
		width, height  = fl[1],fl[2] 
	else
		fl = data[1]
		width,height = fl[1], fl[2]
	end
	return x * width, y * height
end

--- API to convert from yards to a point
-- @param mapfile or area_id
-- @param floor
-- @param x coord in yards
-- @param y coord in yards
-- @return x,y as a fractional point
function lib:YardsToPoint(mapfile,floor,x,y)
	assert(floor == nil or (type(floor) == "number" and floor))
	local width = 0
	local height = 0
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0,0 end
	local data = mapData[mapfile]
	local fl = data[floor]
	if floor and floor <= data['floors'] and floor > 0 then
		width, height  = fl[1],fl[2] 
	else
		local fl = data[1]
		width,height = fl[1], fl[2]
	end
	return x/width, y/height
end


--- API to get the number of floors of a given map
-- @param mapfile the mapfile you wish to check or area id from GetCurrentMapAreaID()
-- @return number of floors or 0 if no floors exist
-- @usage floors = lib:MapFloors(GetMapInfo())
function lib:MapFloors(mapfile)
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0 end
	local fl = mapData[mapfile]['floors']
	if fl == 1 then
		fl = 0
	end
	return fl
end

--- API to get area id for a given map file
-- @param mapfile to check
-- @return area_id or 0 if the map doesnt exist
-- @usage aid = lib:MapAreaId(GetMapInfo())
function lib:MapAreaId(mapfile)
	assert(mapfile and type(mapfile) == "string")
	return idToMap[mapfile]
end

--- API to get localized name of a given map file
-- @param mapfile or area id to check, note area id is more accurate 
-- @return the localized map name or nil
-- @usage lname = lib:MapLocalized(GetMapInfo())
function lib:MapLocalize(mapfile)
	if type(mapfile) == "number" then
		mapfile = mapData[mapfile]['name']
	end
	if mapfile == WORLDMAP_COSMIC_ID then return WORLD_MAP end
	return mapToLocal[mapfile]
end

--- API to get the width,height of a given map
-- @param mapfile you wish to interrogate or area id from GetCurrentMapAreaID()
-- @param floor optional floor you wish to examine
-- @return width,height in yards or 0,0 if no data exists. Will add a message to the DEFAULT_CHAT_FRAME
-- @usage local w,h = lib:MapArea(GetMapInfo(),GetCurrentMapDungeonLevel())
function lib:MapArea(mapfile,floor)
	assert(floor == nil or (type(floor) == "number" and floor))
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0,0 end
	local data = mapData[mapfile]
	local fl = data[floor]
	if floor and floor <= data['floors'] and floor > 0 then
		return fl[1],fl[2] 
	else
		if floor and floor > 0 then
			return 0,0
		end
		fl = data[1]
		return fl[1], fl[2]
	end
end


--- API to get the upper left x,y of a given map
-- @param mapfile you wish to interrogate or area id from GetCurrentMapAreaID()
-- @param floor optional floor you wish to examine
-- @return x,y or the upper left corner or 0,0 if no data exists. Will add a message to the DEFAULT_CHAT_FRAME
-- @usage local x,y = lib:MapUpperLeft(GetMapInfo(),GetCurrentMapDungeonLevel())
function lib:GetMapUpperLeft(mapfile, floor)
	assert(floor == nil or (floor and floor >= 0))
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0,0 end
	local data = mapData[mapfile]
	local fl = data[floor + 1]
	if floor and floor <= data['floors'] then
		return fl[3],fl[4]
	else
		if floor and floor > 0 then
			return 0,0
		end
		fl = data[1]
		return fl[3],fl[4]
	end
end

--- API to get the lower right x,y of a given map
-- @param mapfile you wish to interrogate or area id from GetCurrentMapAreaID()
-- @param floor optional floor you wish to examine
-- @return x,y or the lower right corner or 0,0 if no data exists. Will add a message to the DEFAULT_CHAT_FRAME
-- @usage local x,y = lib:MapLowerRight(GetMapInfo(),GetCurrentMapDungeonLevel())
function lib:GetMapLowerRight(mapfile, floor)
	assert(floor == nil or (floor and floor >= 0))
	if type(mapfile) == "string" then
		mapfile = idToMap[mapfile]
	end
	if mapfile == WORLDMAP_COSMIC_ID then return 0,0 end
	local data = mapData[mapfile]
	local fl = data[floor + 1]
	if floor and floor <= data['floors'] then
		return fl[5],fl[6]
	else
		if floor and floor > 0 then
			return 0,0
		end
		fl = data[1]
		return fl[5],fl[6]
	end
end

--- API to force a zone change check
-- calling this method will fire a callback
-- @param force, optional if you want to force a check even if data hasnt changed
-- @return void
function lib:ZoneChanged(force)
	if WorldMapFrame:IsVisible() then return end
	SetMapToCurrentZone()
	local x,y = GetPlayerMapPosition("player")
	-- if the player is in an instance without a map then dont fire anything
	if x == 0 and y == 0 then
		return
	end
	local map = GetMapInfo()
	if map == nil then
		return
	end
	local floor = GetCurrentMapDungeonLevel()
	if map ~= lastMap or floor ~= lastFloor or force then
		local w,h = self:MapArea(map,floor)
		self.callbacks:Fire("MapChanged",map,floor,w,h)
		lastMap = map
		lastFloor = floor
	end
end

-- Turn on events on someone registers for them
function lib.callbacks:OnUsed()
	watchFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	watchFrame:RegisterEvent("ZONE_CHANGED")
	watchFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	watchFrame:RegisterEvent("ZONE_CHANGED_INDOORS")
	lib:ZoneChanged(true)
end

-- turn off events once we no longer have listeners
function lib.callbacks:OnUnused()
	watchFrame:UnregisterAllEvents()	
end
watchFrame:SetScript("OnEvent", function(frame,event,...) 
	lib:ZoneChanged(false) 
end)

--@alpha@
function lib:Test()
	-- Validate map files are all present.
	for continent in pairs({GetMapContinents()}) do
		local zones = { GetMapZones(continent) }
		print("Continent "..continent)
		for zone, name in pairs(zones) do
			SetMapZoom(continent, zone)
			local mapFile = GetMapInfo()
			local area_id = GetCurrentMapAreaID()
			local w,h = self:MapArea(mapFile)
			local aid = self:MapAreaId(mapFile)
			if w == 0 and h == 0 then
				error("Failed to find map "..mapFile)
			end
			if area_id ~= aid then
				error(mapFile.." area id mismatch")
			end
		end
	end
	print("All Tests passed")
end