local _, ns = ...

local orig1, orig2 = {}, {}
local GameTooltip = GameTooltip

local linktypes = {item = true, enchant = true, spell = true, quest = true, unit = true, talent = true, achievement = true, glyph = true, instancelock = true}


local function OnHyperlinkEnter(frame, link, ...)
    if(ns.db.hover_compare) then
        local linktype = link:match("^([^:]+)")
        if linktype and linktypes[linktype] then
            GameTooltip:SetOwner(frame, "ANCHOR_TOPLEFT")
            GameTooltip:SetHyperlink(link)
            GameTooltip:Show()
        end
    end

	if orig1[frame] then return orig1[frame](frame, link, ...) end
end

local function OnHyperlinkLeave(frame, ...)
    if(ns.db.hover_compare) then
        GameTooltip:Hide()
    end
	if orig2[frame] then return orig2[frame](frame, ...) end
end


local _G = getfenv(0)
for i=1, NUM_CHAT_WINDOWS do
	local frame = _G["ChatFrame"..i]
	orig1[frame] = frame:GetScript("OnHyperlinkEnter")
	frame:SetScript("OnHyperlinkEnter", OnHyperlinkEnter)

	orig2[frame] = frame:GetScript("OnHyperlinkLeave")
	frame:SetScript("OnHyperlinkLeave", OnHyperlinkLeave)
end
