--[[****************************************************************************
  * _NPCScan by Saiket                                                         *
  * Locales/Locale-itIT.lua - Localized string constants (it-IT).              *
  ****************************************************************************]]


if ( GetLocale() ~= "itIT" ) then
	return;
end


-- See http://wow.curseforge.com/addons/npcscan/localization/itIT/
local _NPCScan = select( 2, ... );
_NPCScan.L = setmetatable( {
	NPCs = setmetatable( {
		[ 18684 ] = "Bro'Gaz il Senzaclan",
		[ 32491 ] = "Proto Draco Preistorico",
		[ 33776 ] = "Gondria",
		[ 35189 ] = "Skoll",
		[ 38453 ] = "Arcturis",
		[ 49822 ] = "Grinfiagiada",
		[ 49913 ] = "Dama Ga-Ga",
		[ 50005 ] = "Poseidus",
		[ 50009 ] = "Mobus",
		[ 50050 ] = "Shok'sharak",
		[ 50051 ] = "Strisciaombre",
		[ 50052 ] = "Burgy Cuorenero",
		[ 50053 ] = "Thattuk l'Esiliato",
		[ 50056 ] = "Garr",
		[ 50057 ] = "Alafiamma",
		[ 50058 ] = "Tartafuoco",
		[ 50059 ] = "Golgarok",
		[ 50060 ] = "Terborus",
		[ 50061 ] = "Xariona",
		[ 50062 ] = "Aeonaxx",
		[ 50063 ] = "Akma'hat",
		[ 50064 ] = "Cyrus il Nero",
		[ 50065 ] = "Armagedillo",
		[ 50085 ] = "Supremo Fendifuria",
		[ 50086 ] = "Tarvus il Vile",
		[ 50089 ] = "Julak",
		[ 50138 ] = "Karoma",
		[ 50154 ] = "Madexx (Marrone)",
		[ 50159 ] = "Sambas",
		[ 50409 ] = "Statuetta di Dromedario Misteriosa",
		[ 50410 ] = "Statuetta di Dromedario Misteriosa",
		[ 50815 ] = "Skarr",
		[ 50959 ] = "Karkin",
		[ 51071 ] = "Capitano Florence",
		[ 51079 ] = "Capitano Ventosudicio",
		[ 51401 ] = "Madexx (Rosso)",
		[ 51402 ] = "Madexx (Verde)",
		[ 51403 ] = "Madexx (Nero)",
		[ 51404 ] = "Madexx (Blu)",
		[ 54318 ] = "Ankha",
		[ 54319 ] = "Magria",
		[ 54320 ] = "Ban'thalos",
		[ 54321 ] = "Solix",
		[ 54322 ] = "Deth'tilac",
		[ 54323 ] = "Kirix",
		[ 54324 ] = "Balzafiamme",
		[ 54338 ] = "Anthriss",
	}, { __index = _NPCScan.L.NPCs; } );

	BUTTON_FOUND = "NPC trovato!",
	CACHED_FORMAT = "La/le seguente/i unità sono già nella cache: %s.",
	CACHED_LONG_FORMAT = "La/le seguente/i unità sono già nella cache. Considera l'opportunità di rimuoverle usando |cff808080“/npcscan”|r's menu o resettando la cache: %s.",
	CACHED_PET_RESTING_FORMAT = "I seguenti famigli sono stati trovati e messi nella cache mentre stavi riposando: %s.",
	CACHED_STABLED_FORMAT = "Le seguenti unità non possono essere ricercate mentre si stanno addomesticando: %s.",
	CACHED_WORLD_FORMAT = "La/le seguente/i unità %2$s sono già nella cache: %1$s.",
	CACHELIST_ENTRY_FORMAT = "|cff808080“%s”|r",
	CACHELIST_SEPARATOR = ",",
	CMD_ADD = "AGGIUNGI",
	CMD_CACHE = "CACHE",
	CMD_CACHE_EMPTY = "Nessuno dei mostri cercati è nella cache.",
	CMD_HELP = "I comandi sono |cff808080“/npcscan add <NpcID> <Nome>”|r, |cff808080“/npcscan remove <NpcID o Nome>”|r, |cff808080“/npcscan cache”|r per mettere in lista i mob nella cache, e semplicemente |cff808080“/npcscan”|r per il menu delle opzioni.",
	CMD_REMOVE = "RIMUOVI",
	CMD_REMOVENOTFOUND_FORMAT = "NPC |cff808080“%s”|r non trovato.",
	CONFIG_ALERT = "Opzioni d'allarme",
	CONFIG_ALERT_SOUND = "File sonoro di allarme",
	CONFIG_ALERT_SOUND_DEFAULT = "|cffffd200Default|r",
	CONFIG_ALERT_SOUND_DESC = "Scegli il suono di allarme da riprodurre quando un NPC viene trovato. Altri suoni possono essere aggiunti tramite l'addon |cff808080“SharedMedia”|r.",
	CONFIG_ALERT_UNMUTE = "Attiva per il suono d'allarme",
	CONFIG_ALERT_UNMUTE_DESC = "Abilita il suono del gioco quando il bottone obiettivo viene mostrato così puoi sentire gli allarmi anche quando mutato.",
	CONFIG_CACHEWARNINGS = "Stampa promemoria della cache al login ed ai cambiamenti di mondo",
	CONFIG_CACHEWARNINGS_DESC = "Se un NPC è già nella cache quando logghi o cambi mondo, questa opzione stampa un promemoria di quali mob nella cache non possono essere cercati.", -- Needs review
	CONFIG_DESC = "Queste opzioni ti lasciano configurare il modo in cui _NPCScan ti avvisa quando trova NPC rari.",
	CONFIG_PRINTTIME = "Aggiungi l'ora nel frame della chat",
	CONFIG_PRINTTIME_DESC = "Aggiungi l'ora corrente a tutti i messaggi. Utile per ricordare quando si sono visti gli NPC.",
	CONFIG_TEST = "Prova Allarme Trovato",
	CONFIG_TEST_DESC = "Simula un allarme |cff808080“NPC trovato”|r per farti sapere a cosa devi stare attento.",
	CONFIG_TEST_HELP_FORMAT = "Clicca il bottone target o usa il keybind fornito per selezionare il mob trovato. Tieni premuto |cffffffff<%s>|r e sposta per muovere il bottone del target. Nota che se un NPC viene trovato finchè sei in combat, il bottone comparirà solo dopo l'uscita dal combat.",
	CONFIG_TEST_NAME = "Tu! (Test)",
	CONFIG_TITLE = "_|cffCCCC88NPCScan|r",
	FOUND_FORMAT = "Trovato |cff808080“%s”|r!",
	FOUND_TAMABLE_FORMAT = "Trovato |cff808080“%s”|r!  |cffff2020(Nota: mob catturabile, potrebbe essere solo un famiglio)|r",
	FOUND_TAMABLE_WRONGZONE_FORMAT = "|cffff2020Falso allarme:|r Trovato mob catturabil |cff808080“%s”|r in %s invece che %s (ID %d); Senzaltro un pet.",
	PRINT_FORMAT = "%s_|cffCCCC88NPCScan|r: %s",
	SEARCH_ACHIEVEMENTADDFOUND = "Ricerca NPC completati dell'impresa",
	SEARCH_ACHIEVEMENTADDFOUND_DESC = "Continua a cercare gli NPC dell'impresa, anche se non sono più necessari.",
	SEARCH_ACHIEVEMENT_DISABLED = "Disabilitato",
	SEARCH_ADD = "+",
	SEARCH_ADD_DESC = "Aggiungi nuovo NPC o salva i cambiamenti a quello esistente.",
	SEARCH_ADD_TAMABLE_FORMAT = "Nota: |cff808080“%s”|r è addomesticabile, se lo vedi come famiglio addomesticato di un cacciatore procurerà un falso positivo.",
	SEARCH_CACHED = "Nella cache",
	SEARCH_COMPLETED = "Fatto",
	SEARCH_DESC = "Questa tabella ti permette di aggiungere o rimuovere NPC e Imprese da ricercare.",
	SEARCH_ID = "NPC ID:",
	SEARCH_ID_DESC = "l'ID dell'NPC da cercare. Si può trovare questo valore su siti come Wowhead.com o similari.",
	SEARCH_MAP = "Zona:",
	SEARCH_NAME = "Nome:",
	SEARCH_NAME_DESC = "Un nome per l'NPC. Può anche non essere il vero nome dell'NPC.",
	SEARCH_NPCS = "NPC personalizzati",
	SEARCH_NPCS_DESC = "Aggiungi qualsiasi NPC da cercare, anche se non c'é un'impresa su di loro.",
	SEARCH_REMOVE = "-",
	SEARCH_TITLE = "Ricerca",
	SEARCH_WORLD = "Mondo:",
	SEARCH_WORLD_DESC = "Nome opzionale del mondo in cui effettuare la ricerca. Può essere il nome di un continente oppure |cffff7f3finstance name|r (case-sensitive)",
	SEARCH_WORLD_FORMAT = "(%s)",
	TIME_FORMAT = "cff808080[%H:%M:%S]|r ",
	TOOLS_TITLE = "|cff808080Tools|r",
}, { __index = _NPCScan.L; } );


_G[ "BINDING_NAME_CLICK _NPCScanButton:LeftButton" ] = [=[Targetta l'ultimo NPC trovato
|cff808080(Usato da _NPCScan per avvisarti)|r]=];