--[[****************************************************************************
  * _NPCScan by Saiket                                                         *
  * Locales/Locale-ruRU.lua - Localized string constants (ru-RU).              *
  ****************************************************************************]]


if ( GetLocale() ~= "ruRU" ) then
	return;
end


-- See http://wow.curseforge.com/addons/npcscan/localization/ruRU/
local _NPCScan = select( 2, ... );
_NPCScan.L = setmetatable( {
	NPCs = setmetatable( {
		[ 18684 ] = "Бро'Газ Без Клана",
		[ 32491 ] = "Затерянный во времени протодракон",
		[ 33776 ] = "Гондрия",
		[ 35189 ] = "Сколл",
		[ 38453 ] = "Арктур",
		[ 49822 ] = "Яшмовый Клык",
		[ 49913 ] = "Леди Лала",
		[ 50005 ] = "Посейдус",
		[ 50009 ] = "Мобус",
		[ 50050 ] = "Шок'шарак",
		[ 50051 ] = "Призрачный краб",
		[ 50052 ] = "Углик Черносерд",
		[ 50053 ] = "Тартук Изгой",
		[ 50056 ] = "Гарр",
		[ 50057 ] = "Жарокрыл",
		[ 50058 ] = "Калентий",
		[ 50059 ] = "Голгарок",
		[ 50060 ] = "Тербурий",
		[ 50061 ] = "Зариона",
		[ 50062 ] = "Эонакс",
		[ 50063 ] = "Акма'хат",
		[ 50064 ] = "Сирус Блек",
		[ 50065 ] = "Армагедилло",
		[ 50085 ] = "Властитель Губительная Ярость",
		[ 50086 ] = "Тарвий Злобный",
		[ 50089 ] = "Джулак-Рок",
		[ 50138 ] = "Карома",
		[ 50154 ] = "Мадекс (коричневый)",
		[ 50159 ] = "Самбас",
		[ 50409 ] = "Странная фигурка верблюда",
		[ 50410 ] = "Странная фигурка верблюда",
		[ 50815 ] = "Скарр",
		[ 50959 ] = "Каркин",
		[ 51071 ] = "Капитан Флоренс",
		[ 51079 ] = "Капитан Злозюйд",
		[ 51401 ] = "Мадекс (красный)",
		[ 51402 ] = "Мадекс (зеленый)",
		[ 51403 ] = "Мадекс (черный)",
		[ 51404 ] = "Мадекс (синий)",
		[ 54318 ] = "Анха",
		[ 54319 ] = "Магрия",
		[ 54320 ] = "Бан'талос",
		[ 54321 ] = "Соликс",
		[ 54322 ] = "Мер'тилак",
		[ 54323 ] = "Кирикс",
		[ 54324 ] = "Жарисс",
		[ 54338 ] = "Антрисс",
		[ 62346 ] = "Галеон",
	}, { __index = _NPCScan.L.NPCs; } );

	BUTTON_FOUND = "Найден НИП!",
	CACHED_FORMAT = "Следующие существа уже находятся в кэше: %s.", -- Needs review
	CACHED_LONG_FORMAT = "Следующие существа уже находятся в кэше. Попробуйте удалить их с помощью команды |cff808080“/npcscan”|r или сбросить их очистив ваш кэш: %s.", -- Needs review
	CACHED_PET_RESTING_FORMAT = "Следующие питомцы попали в кэш пока вы отдыхали: %s.", -- Needs review
	CACHED_STABLED_FORMAT = "Следующие существа не могут быть найдены, потому что они приручены: %s",
	CACHED_WORLD_FORMAT = "Следующие %2$s существа уже находятся в кэше: %1$s.", -- Needs review
	CACHELIST_ENTRY_FORMAT = "|cff808080“%s”|r",
	CACHELIST_SEPARATOR = ", ",
	CMD_ADD = "ADD",
	CMD_CACHE = "CACHE",
	CMD_CACHE_EMPTY = "Ни одно существо не найдено в вашем кэше.", -- Needs review
	CMD_HELP = "Команды |cff808080“/npcscan add <IDНИПа> <Название>”|r, |cff808080“/npcscan remove <IDНИПа или название>”|r, |cff808080“/npcscan cache”|r выводит список существ из кэша, и просто |cff808080“/npcscan”|r открывает меню настроек.", -- Needs review
	CMD_REMOVE = "REMOVE",
	CMD_REMOVENOTFOUND_FORMAT = "НИП |cff808080“%s”|r не найден.",
	CONFIG_ALERT = "Настройки сигнала",
	CONFIG_ALERT_SOUND = "Звуковой файл сигнала",
	CONFIG_ALERT_SOUND_DEFAULT = "|cffffd200По умолчанию|r",
	CONFIG_ALERT_SOUND_DESC = "Выберите звуковой файл, который будет проигрываться при обнаружении НИПа. Дополнительные звуки могут быть добавлены через модификацию |cff808080“SharedMedia”|r.",
	CONFIG_ALERT_UNMUTE = "Включить звук для звукового сигнала",
	CONFIG_ALERT_UNMUTE_DESC = "Временно включить звуки игры при показе кнопки _NPCScan, чтобы вы могли услышать сигнал обнаружения.",
	CONFIG_CACHEWARNINGS = "Выводить напоминания о кэше при входе/изменении мира", -- Needs review
	CONFIG_CACHEWARNINGS_DESC = "Если НИП уже находиться в кэше, когда вы войдете\\смените мир, будет выведено напоминание о существах которых невозможно найти.", -- Needs review
	CONFIG_DESC = "Эти параметры позволяют настроить для вас способ оповещения _NPCScan, при обнаружении им редкого НИПа.",
	CONFIG_PRINTTIME = "Показ временных меток в окне чата",
	CONFIG_PRINTTIME_DESC = "Добавляет текущее время ко всем выводимым сообщениям. Полезно при записи, когда НПЦ был найден.",
	CONFIG_TEST = "Тест сигнала", -- Needs review
	CONFIG_TEST_DESC = "Имитирует оповещение |cff808080“Найден НИП!|r, которое информирует вас о том, кого именно надо искать.", -- Needs review
	CONFIG_TEST_HELP_FORMAT = "Нажмите на кнопку цели или используйте комбинацию клавиш для взятия в цель найденного существа.  Держите |cffffffff<%s>|r и перемещайте мышь, для перемещения кнопки цели.  Если Вы находитесь в бою когда НИП был найден, предупреждение появиться только после выхода из боя.", -- Needs review
	CONFIG_TEST_NAME = "Вы! (Тест)",
	CONFIG_TITLE = "_|cffCCCC88NPCScan|r",
	FOUND_FORMAT = "Найдено: |cff808080“%s”|r!",
	FOUND_TAMABLE_FORMAT = "Найдено: |cff808080“%s”|r!  |cffff2020(Заметка: приручаемое существо, может оказаться питомцем.)|r", -- Needs review
	FOUND_TAMABLE_WRONGZONE_FORMAT = "|cffff2020False alarm:|r Найдено приручаемое существо |cff808080“%s”|r в %s вместо %s (ID %d); Определенно питомец.", -- Needs review
	PRINT_FORMAT = "%s_|cffCCCC88NPCScan|r: %s",
	SEARCH_ACHIEVEMENTADDFOUND = "Поиск по завершенным НИПам для достижений",
	SEARCH_ACHIEVEMENTADDFOUND_DESC = "Продолжать поиск всех НИПов для достижений, даже если они больше не нужны.",
	SEARCH_ACHIEVEMENT_DISABLED = "Отключено",
	SEARCH_ADD = "+",
	SEARCH_ADD_DESC = "Добавить нового НИПа или сохранить изменения в уже существующего.",
	SEARCH_ADD_TAMABLE_FORMAT = "Заметка: |cff808080“%s”|r - приручаемое существо, при его обнаружении в качестве питомца охотника - будет ложная тревога.", -- Needs review
	SEARCH_CACHED = "В кэше", -- Needs review
	SEARCH_COMPLETED = "Готово",
	SEARCH_DESC = "Эта таблица позволяет добавить или удалить из поиска НИПов и достижения.",
	SEARCH_ID = "ID НИПа:",
	SEARCH_ID_DESC = "ID НИПа для поиска.  Данное значение можно найти на таких сайтах как Wowhead.com.",
	SEARCH_MAP = "Зона: ",
	SEARCH_NAME = "Название:",
	SEARCH_NAME_DESC = "Ярлык НИПа. Он не обязан совпадать с реальным названием НИПа.", -- Needs review
	SEARCH_NPCS = "Свои НИПы",
	SEARCH_NPCS_DESC = "Добавить к отслеживанию любого НИПа, даже если он не относится к достижениям.",
	SEARCH_REMOVE = "-",
	SEARCH_TITLE = "Поиск",
	SEARCH_WORLD = "Мир:",
	SEARCH_WORLD_DESC = "Опция ограничения поиска в мире.  Может быть континентом или |cffff7f3fзоной|r (с учетом регистра).",
	SEARCH_WORLD_FORMAT = "(%s)",
	TIME_FORMAT = "|cff808080[%H:%M:%S]|r ",
	TOOLS_TITLE = "|cff808080Инструменты|r", -- Needs review
}, { __index = _NPCScan.L; } );


_G[ "BINDING_NAME_CLICK _NPCScanButton:LeftButton" ] = [=[Выбрать последнее из найденных существ
|cff808080(Используйте когда _NPCScan известит Вас)|r]=];