// XAnalogClockTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "XAnalogClockTest.h"
#include "XAnalogClockTestDlg.h"
#include "about.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXAnalogClockTestDlg dialog

BEGIN_MESSAGE_MAP(CXAnalogClockTestDlg, CDialog)
	//{{AFX_MSG_MAP(CXAnalogClockTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RUN, OnRun)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CXAnalogClockTestDlg::CXAnalogClockTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CXAnalogClockTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXAnalogClockTestDlg)
	m_bShowDate = TRUE;
	m_bShowSecondHand = TRUE;
	m_nSkin = 0;
	m_nSystemTime = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CXAnalogClockTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXAnalogClockTestDlg)
	DDX_Control(pDX, IDC_FRAME, m_Clock);
	DDX_Check(pDX, IDC_DATE, m_bShowDate);
	DDX_Check(pDX, IDC_SECOND_HAND, m_bShowSecondHand);
	DDX_Radio(pDX, IDC_SKIN_BLUE, m_nSkin);
	DDX_Radio(pDX, IDC_TIME_SYSTEM, m_nSystemTime);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CXAnalogClockTestDlg message handlers

BOOL CXAnalogClockTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	///////////////////////////////////////////////////////////////////////////

	// set resource IDs
	m_Clock.SetBitmaps(IDB_BLUE_CLOCK_FACE, IDB_BLUE_DATE);

	// set control size
	CSize size = m_Clock.GetWindowSize();

	CRect rect;
	m_Clock.GetWindowRect(&rect);
	ScreenToClient(&rect);
	rect.right = rect.left + size.cx;
	rect.bottom = rect.top + size.cy;
	m_Clock.MoveWindow(&rect);

	// start the clock
	m_Clock.Run();

	GetDlgItem(IDC_RUN)->EnableWindow(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CXAnalogClockTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CXAnalogClockTestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CXAnalogClockTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CXAnalogClockTestDlg::OnRun()
{
	GetDlgItem(IDC_RUN)->EnableWindow(FALSE);
	GetDlgItem(IDC_STOP)->EnableWindow(TRUE);

	UpdateData(TRUE);
	m_Clock.ShowDate(m_bShowDate);
	m_Clock.ShowSecondHand(m_bShowSecondHand);

	if (m_nSkin == 0)
		m_Clock.SetBitmaps(IDB_BLUE_CLOCK_FACE, IDB_BLUE_DATE);
	else
		m_Clock.SetBitmaps(IDB_SILVER_CLOCK_FACE, IDB_SILVER_DATE);

	if (m_nSystemTime == 0)
	{
		m_Clock.UseSystemTime(TRUE);
	}
	else
	{
		CTime t(2006, 1, 1, 8, 40, 0);
		m_Clock.SetTime(t);
		m_Clock.UseSystemTime(FALSE);
	}

	//m_Clock.SetMinuteHandColor(RGB(0,255,0));
	//m_Clock.SetHourHandColor(RGB(0,0,255));
	//m_Clock.SetSecondHandColor(RGB(0,255,255));

	// start clock
	m_Clock.Run();

	//m_Clock.Invalidate();
}

void CXAnalogClockTestDlg::OnStop()
{
	GetDlgItem(IDC_RUN)->EnableWindow(TRUE);
	GetDlgItem(IDC_STOP)->EnableWindow(FALSE);

	m_Clock.Stop();

	CTime t = m_Clock.GetTime();
	TRACE(_T("clock stopped at %02d:%02d:%02d\n"),
		t.GetHour(), t.GetMinute(), t.GetSecond());
}
