/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet {
    private boolean mReadable;
    private boolean mWritable;
    private int mLen;
    private int mChannel;
    private byte[] mData;
    private ByteArrayOutputStream mBuff;
    private DataOutputStream mBuffOS;
    private DataOutputStream mOS;
    private DataInputStream mBuffIS;
    private DataInputStream mIS;
    private boolean mSent;

    public Packet(int channel, DataInputStream is, DataOutputStream os) {
        this.mReadable = false;
        this.mWritable = true;
        this.mChannel = channel;
        this.mBuff = new ByteArrayOutputStream();
        this.mBuffOS = new DataOutputStream(this.mBuff);
        this.mIS = is;
        this.mOS = os;
    }

    Packet(DataInputStream is, DataOutputStream os) throws IOException {
        this.mReadable = true;
        this.mWritable = false;
        this.mLen = is.readInt();
        this.mChannel = is.readInt();
        this.mData = new byte[this.mLen];
        is.readFully(this.mData);
        this.mBuffIS = new DataInputStream(new ByteArrayInputStream(this.mData));
        this.mOS = os;
    }

    void send(DataOutputStream os) throws IOException {
        if (this.mSent) {
            throw new RuntimeException("Packet already sent, refusing to send again!");
        }
        if (!this.mWritable) {
            throw new RuntimeException("Cannot send a read-only packet");
        }
        byte[] data = this.mBuff.toByteArray();
        os.writeInt(data.length);
        os.writeInt(this.mChannel);
        os.write(data);
        os.flush();
        this.mSent = true;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public Packet createReply() {
        return new Packet(this.mChannel, null, this.mOS);
    }

    private Packet getReply() throws IOException {
        return new Packet(this.mIS, this.mOS);
    }

    public void send() throws IOException {
        this.send(this.mOS);
    }

    public Packet sendAndReceive(String cmd) throws IOException {
        this.mOS.writeUTF(cmd);
        this.send(this.mOS);
        return this.getReply();
    }

    public int readInt() throws IOException {
        if (!this.mReadable) {
            throw new RuntimeException("Cannot read from a write-only packet");
        }
        return this.mBuffIS.readInt();
    }

    public float readFloat() throws IOException {
        if (!this.mReadable) {
            throw new RuntimeException("Cannot read from a write-only packet");
        }
        return this.mBuffIS.readFloat();
    }

    public boolean readBoolean() throws IOException {
        if (!this.mReadable) {
            throw new RuntimeException("Cannot read from a write-only packet");
        }
        return this.mBuffIS.readBoolean();
    }

    public String readUTF() throws IOException {
        if (!this.mReadable) {
            throw new RuntimeException("Cannot read from a write-only packet");
        }
        return this.mBuffIS.readUTF();
    }

    public void writeInt(int value) throws IOException {
        if (!this.mWritable) {
            throw new RuntimeException("Cannot send a read-only packet");
        }
        this.mBuffOS.writeInt(value);
    }

    public void writeFloat(float value) throws IOException {
        if (!this.mWritable) {
            throw new RuntimeException("Cannot send a read-only packet");
        }
        this.mBuffOS.writeFloat(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        if (!this.mWritable) {
            throw new RuntimeException("Cannot send a read-only packet");
        }
        this.mBuffOS.writeBoolean(value);
    }

    public void writeUTF(String value) throws IOException {
        if (!this.mWritable) {
            throw new RuntimeException("Cannot send a read-only packet");
        }
        this.mBuffOS.writeUTF(value);
    }
}

