/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.XAppDbgCommand;
import com.sonymobile.tools.xappdbg.XAppDbgModule;
import com.sonymobile.tools.xappdbg.XAppDbgServerClientThread;
import com.sonymobile.tools.xappdbg.XAppDbgWidget;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class XAppDbgServer {
    private static final int PROTOCOL_VERSION = 1;
    private int mPort = 55011;
    private DebugServerThread mThread;
    private Vector<XAppDbgModule> mModules = new Vector();
    private HashMap<String, XAppDbgCommand> mCommands = new HashMap();
    private Vector<XAppDbgWidget> mWidgets = new Vector();
    private int mNextChannel = 1;
    private Object connectedSync = new Object();
    private boolean connected = false;

    public void addModule(XAppDbgModule mod) {
        int channel = this.mNextChannel++;
        mod.setChannel(channel);
        this.mModules.add(mod);
        Object[] objectArray = mod.getCommands();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            XAppDbgCommand cmd = objectArray[n2];
            this.mCommands.put(cmd.getID(), cmd);
            ++n2;
        }
        objectArray = mod.getWidgets();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object w = objectArray[n2];
            this.mWidgets.add((XAppDbgWidget)w);
            ++n2;
        }
    }

    public XAppDbgCommand getCommand(String cmdId, int channel) {
        XAppDbgModule mod = this.findModuleByChannel(channel);
        if (mod == null) {
            return null;
        }
        return mod.findCommand(cmdId);
    }

    private XAppDbgModule findModuleByChannel(int channel) {
        for (XAppDbgModule mod : this.mModules) {
            if (mod.getChannel() != channel) continue;
            return mod;
        }
        return null;
    }

    protected boolean handleCommand(String cmdId, Packet packet) throws IOException {
        long t0 = System.currentTimeMillis();
        XAppDbgCommand cmd = this.getCommand(cmdId, packet.getChannel());
        if (cmd == null) {
            System.out.println("PANIC: Unknown command '" + cmdId + "'");
            return true;
        }
        Packet reply = packet.createReply();
        cmd.exec(packet, reply);
        reply.send();
        long t1 = System.currentTimeMillis();
        System.out.println("Executed command '" + cmdId + "' in " + (t1 - t0) + "ms");
        return false;
    }

    public void listWidgets(DataOutputStream os) throws IOException {
        System.out.println("# Sending widget list");
        os.writeInt(this.mWidgets.size());
        for (XAppDbgWidget w : this.mWidgets) {
            w.writeToClient(os);
        }
    }

    public void listCommands(DataOutputStream os) throws IOException {
        System.out.println("# Sending command list");
        Collection<XAppDbgCommand> cmds = this.mCommands.values();
        os.writeInt(cmds.size());
        for (XAppDbgCommand cmd : cmds) {
            os.writeUTF(cmd.getID());
        }
    }

    public void start() {
        this.mThread = new DebugServerThread();
        this.mThread.setName("XAppDbgServer");
        this.mThread.start();
    }

    public void stop() {
        this.mThread.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnection() throws InterruptedException {
        Object object = this.connectedSync;
        synchronized (object) {
            if (!this.connected) {
                this.connectedSync.wait();
            }
        }
    }

    class DebugServerThread
    extends Thread {
        private ServerSocket ss;

        DebugServerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int tries = 0;
            while (tries < 10) {
                try {
                    this.ss = new ServerSocket(XAppDbgServer.this.mPort);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error creating server socket: " + e.getMessage() + ", try#" + tries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    ++tries;
                }
            }
            if (this.ss == null) {
                System.out.println("Error creating server socket, giving up!");
                return;
            }
            System.out.println("Network interfaces:");
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                        System.out.println("  - " + inetAddress);
                    }
                }
            }
            catch (SocketException en) {}
            while (true) {
                try {
                    if (XAppDbgServer.this.mThread == null) return;
                    System.out.println("Waiting for connection...");
                    Socket sock = this.ss.accept();
                    System.out.println("Client connected!");
                    new XAppDbgServerClientThread(sock, 1, XAppDbgServer.this);
                    Object object = XAppDbgServer.this.connectedSync;
                    synchronized (object) {
                        XAppDbgServer.this.connected = true;
                        XAppDbgServer.this.connectedSync.notify();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.ss != null) {
                        try {
                            this.ss.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    this.ss = null;
                    return;
                }
                continue;
                break;
            }
            finally {
                if (this.ss != null) {
                    try {
                        this.ss.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.ss = null;
            }
        }

        public void stopThread() {
            XAppDbgServer.this.mThread = null;
            if (this.ss != null) {
                try {
                    this.ss.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

