/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.XAppDbgServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

public class XAppDbgServerClientThread
extends Thread {
    private DataInputStream mIS;
    private DataOutputStream mOS;
    private XAppDbgServer mServer;

    public XAppDbgServerClientThread(Socket sock, int version, XAppDbgServer debugServer) throws IOException {
        this.mServer = debugServer;
        this.setName("XAppDbgClient");
        this.mOS = new DataOutputStream(sock.getOutputStream());
        this.mIS = new DataInputStream(sock.getInputStream());
        this.mOS.writeInt(version);
        this.mOS.flush();
        int clientVersion = this.mIS.readInt();
        if (clientVersion != version) {
            System.err.println("[DebugServer] Connection refused due to version mismatch, server: " + Integer.toHexString(version) + " client: " + Integer.toHexString(clientVersion));
            sock.close();
            return;
        }
        this.start();
    }

    @Override
    public void run() {
        try {
            Packet packet;
            String cmd;
            this.mServer.listWidgets(this.mOS);
            this.mServer.listCommands(this.mOS);
            System.out.println("# Starting IO loop");
            do {
                cmd = this.mIS.readUTF();
                packet = new Packet(this.mIS, this.mOS);
                if (cmd != null) continue;
                System.out.println("Connection lost");
                break;
            } while (!this.mServer.handleCommand(cmd, packet));
        }
        catch (EOFException eof) {
            System.out.println("Connection lost");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

