/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg;

import com.sonymobile.tools.xappdbg.XAppDbgModule;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class XAppDbgWidget {
    private String mName;
    private String mParam;
    private boolean mInline;
    private XAppDbgModule mModule;
    private int mId;
    private int mChannel;
    private static int lastId = 1;

    public XAppDbgWidget(String name, String param, boolean inline, XAppDbgModule mod) {
        this.mName = name;
        this.mParam = param;
        this.mInline = inline;
        this.mModule = mod;
        this.mId = lastId++;
    }

    public void writeToClient(DataOutputStream os) throws IOException {
        os.writeUTF(this.mName);
        os.writeUTF(this.mParam);
        os.writeBoolean(this.mInline);
        os.writeInt(this.mId);
        os.writeInt(this.getChannel());
    }

    public static XAppDbgWidget readFromServer(DataInputStream is) throws IOException {
        String name = is.readUTF();
        String param = is.readUTF();
        boolean inline = is.readBoolean();
        XAppDbgWidget ret = new XAppDbgWidget(name, param, inline, null);
        ret.mId = is.readInt();
        ret.mChannel = is.readInt();
        return ret;
    }

    public boolean isInline() {
        return this.mInline;
    }

    public String getName() {
        return this.mName;
    }

    public String getParams() {
        return this.mParam;
    }

    public int getId() {
        return this.mId;
    }

    public int getChannel() {
        return this.mModule == null ? this.mChannel : this.mModule.getChannel();
    }
}

