/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.properties.CommandItem;
import com.sonymobile.tools.xappdbg.properties.FieldItem;
import com.sonymobile.tools.xappdbg.properties.Item;
import com.sonymobile.tools.xappdbg.properties.PropertyItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;

public class ClassItems {
    private Vector<Item> mItems = new Vector();
    private Comparator<? super Item> mCmp = new Comparator<Item>(){

        @Override
        public int compare(Item item1, Item item2) {
            return item1.getName().compareToIgnoreCase(item2.getName());
        }
    };

    public ClassItems(String fullClassName) {
    }

    public static ClassItems scanClass(Class<?> clazz) {
        Item item;
        long t0 = System.currentTimeMillis();
        ClassItems ret = new ClassItems(clazz.getName());
        long t1 = System.currentTimeMillis();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            FieldItem item2 = FieldItem.scan(f, clazz);
            if (item2 != null) {
                ret.mItems.add(item2);
            }
            ++n2;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("all.methods.size=" + clazz.getMethods().length);
        HashMap<String, Method> methods = new HashMap<String, Method>();
        Method[] methodArray = clazz.getMethods();
        int n3 = methodArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Method m = methodArray[n4];
            if (ClassItems.isCandidate(m)) {
                methods.put(m.getName(), m);
            }
            ++n4;
        }
        long t3 = System.currentTimeMillis();
        System.out.println("methods.size=" + methods.size());
        Method[] methodArray2 = clazz.getMethods();
        int n5 = methodArray2.length;
        int n6 = 0;
        while (n6 < n5) {
            Method m = methodArray2[n6];
            item = PropertyItem.scan(m, methods);
            if (item != null) {
                ret.mItems.add(item);
            }
            ++n6;
        }
        long t4 = System.currentTimeMillis();
        for (Method m : methods.values()) {
            if (m == null || (item = CommandItem.scan(m)) == null) continue;
            ret.mItems.add(item);
        }
        long t5 = System.currentTimeMillis();
        ret.sort();
        long t6 = System.currentTimeMillis();
        System.out.println("Class scan times t1=" + (t1 - t0) + "ms t2=" + (t2 - t0) + "ms t3=" + (t3 - t0) + "ms t4=" + (t4 - t0) + "ms t5=" + (t5 - t0) + "ms t6=" + (t6 - t0) + "ms");
        return ret;
    }

    private static boolean isCandidate(Method m) {
        int mod = m.getModifiers();
        if ((mod & 1) == 0) {
            return false;
        }
        Class<?>[] params = m.getParameterTypes();
        return params.length <= 1;
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public Item getItem(int idx) {
        return this.mItems.get(idx);
    }

    public void addItem(Item item) {
        this.mItems.add(item);
    }

    public void sort() {
        Collections.sort(this.mItems, this.mCmp);
    }
}

