/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.properties.Item;
import com.sonymobile.tools.xappdbg.properties.Util;
import com.sonymobile.tools.xappdbg.properties.XAppDbgPropDescr;
import java.io.IOException;
import java.lang.reflect.Method;

public class CommandItem
extends Item {
    private static final String mIgnoreList = ",equals,getClass,hashCode,notify,notifyAll,wait,toString,";
    private Method mSetter;

    public CommandItem(Method m, String name, int type, boolean proxy) {
        super(name, 3, type, proxy);
        this.mSetter = m;
        this.setWritable();
        if (m != null) {
            this.readDescription(m);
        }
    }

    public static CommandItem scan(Method m) {
        Class<?> javaType;
        CommandItem ret = null;
        int mod = m.getModifiers();
        String name = m.getName();
        Class<?>[] params = m.getParameterTypes();
        int type = 0;
        if ((mod & 1) == 0) {
            return null;
        }
        if (params.length > 1) {
            return null;
        }
        if (params.length == 1 && (type = Util.javaTypeToType(javaType = params[0])) == 0) {
            return null;
        }
        if (mIgnoreList.indexOf("," + name + ",") >= 0) {
            return null;
        }
        ret = new CommandItem(m, name, type, false);
        return ret;
    }

    private void readDescription(Method m) {
        XAppDbgPropDescr ann = m.getAnnotation(XAppDbgPropDescr.class);
        if (ann != null) {
            this.setDescription(ann.value());
        }
    }

    @Override
    public boolean getBoolValue(Object obj) {
        throw new IllegalArgumentException();
    }

    @Override
    public float getFloatValue(Object obj) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getIntValue(Object obj) {
        throw new IllegalArgumentException();
    }

    @Override
    public String getStringValue(Object obj) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean setVoidValue(Object obj) {
        if (this.getType() != 0 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, new Object[0]);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setBoolValue(Object obj, boolean value) {
        if (this.getType() != 1 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setFloatValue(Object obj, float value) {
        if (this.getType() != 21 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, Float.valueOf(value));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setIntValue(Object obj, int value) {
        if (this.getType() != 17 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setStringValue(Object obj, String value) {
        if (this.getType() != 33 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void sendToClient(Packet out) throws IOException {
        super.sendToClient(out);
    }

    public static CommandItem readFromServer(Packet in, String name, int type) throws IOException {
        CommandItem ret = new CommandItem(null, name, type, true);
        return ret;
    }
}

