/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.properties.Item;
import com.sonymobile.tools.xappdbg.properties.Util;
import com.sonymobile.tools.xappdbg.properties.XAppDbgPropDescr;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class FieldItem
extends Item {
    private Field mField;

    public FieldItem(Field field, String name, int type, boolean proxy) {
        super(name, 1, type, proxy);
        this.mField = field;
        this.setReadable();
        this.setWritable();
        if (this.mField != null) {
            Annotation[] annotationArray = this.mField.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann instanceof XAppDbgPropDescr) {
                    XAppDbgPropDescr descr = this.mField.getAnnotation(XAppDbgPropDescr.class);
                    this.setDescription(descr.value());
                }
                ++n2;
            }
        }
    }

    public static FieldItem scan(Field f, Class<?> clazz) {
        FieldItem ret = null;
        int mod = f.getModifiers();
        String name = f.getName();
        int type = 0;
        Class<?> javaType = f.getType();
        if ((mod & 1) != 0 && (mod & 0x10) == 0) {
            type = Util.javaTypeToType(javaType);
        }
        if (type != 0) {
            ret = new FieldItem(f, name, type, false);
        }
        return ret;
    }

    @Override
    public boolean getBoolValue(Object obj) {
        if (this.getType() != 1) {
            throw new IllegalArgumentException();
        }
        try {
            return this.mField.getBoolean(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public float getFloatValue(Object obj) {
        if (this.getType() != 21) {
            throw new IllegalArgumentException();
        }
        try {
            return this.mField.getFloat(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getIntValue(Object obj) {
        if (this.getType() != 17) {
            throw new IllegalArgumentException();
        }
        try {
            return this.mField.getInt(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getStringValue(Object obj) {
        if (this.getType() != 33) {
            throw new IllegalArgumentException();
        }
        try {
            Object ret = this.mField.get(obj);
            return ret == null ? null : ret.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setBoolValue(Object obj, boolean value) {
        if (this.getType() != 1) {
            throw new IllegalArgumentException();
        }
        try {
            this.mField.setBoolean(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setFloatValue(Object obj, float value) {
        if (this.getType() != 21) {
            throw new IllegalArgumentException();
        }
        try {
            this.mField.setFloat(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setIntValue(Object obj, int value) {
        if (this.getType() != 17) {
            throw new IllegalArgumentException();
        }
        try {
            this.mField.setInt(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setStringValue(Object obj, String value) {
        if (this.getType() != 33) {
            throw new IllegalArgumentException();
        }
        try {
            this.mField.set(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setVoidValue(Object obj) {
        throw new IllegalArgumentException();
    }

    @Override
    public void sendToClient(Packet out) throws IOException {
        super.sendToClient(out);
    }

    public static FieldItem readFromServer(Packet in, String name, int type) {
        FieldItem ret = new FieldItem(null, name, type, true);
        return ret;
    }
}

