/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.properties.CommandItem;
import com.sonymobile.tools.xappdbg.properties.FieldItem;
import com.sonymobile.tools.xappdbg.properties.PropertyItem;
import com.sonymobile.tools.xappdbg.properties.Util;
import java.io.IOException;

public abstract class Item {
    public static final int ITEM_FIELD = 1;
    public static final int ITEM_PROPERTY = 2;
    public static final int ITEM_COMMAND = 3;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_INT = 17;
    public static final int TYPE_FLOAT = 21;
    public static final int TYPE_STRING = 33;
    private String mName;
    private int mItemType;
    private int mType;
    private String mDescr;
    private Runnable mCB;
    private boolean mProxy;
    private int mRW;

    public Item(String name, int itemType, int type, boolean proxy) {
        this.mName = name;
        this.mItemType = itemType;
        this.mType = type;
        this.mProxy = proxy;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public int getItemType() {
        return this.mItemType;
    }

    public int getType() {
        return this.mType;
    }

    public String getDescription() {
        return this.mDescr;
    }

    public void setDescription(String descr) {
        this.mDescr = descr;
    }

    public void setCallback(Runnable cb) {
        this.mCB = cb;
    }

    protected void runCB() {
        if (this.mProxy) {
            return;
        }
        if (this.mCB == null) {
            return;
        }
        this.mCB.run();
    }

    protected void setReadable() {
        this.mRW |= 1;
    }

    public boolean isReadable() {
        return (this.mRW & 1) != 0;
    }

    protected void setWritable() {
        this.mRW |= 2;
    }

    public boolean isWritable() {
        return (this.mRW & 2) != 0;
    }

    public abstract int getIntValue(Object var1);

    public abstract boolean getBoolValue(Object var1);

    public abstract float getFloatValue(Object var1);

    public abstract String getStringValue(Object var1);

    public abstract boolean setIntValue(Object var1, int var2);

    public abstract boolean setBoolValue(Object var1, boolean var2);

    public abstract boolean setFloatValue(Object var1, float var2);

    public abstract boolean setStringValue(Object var1, String var2);

    public abstract boolean setVoidValue(Object var1);

    public void sendToClient(Packet out) throws IOException {
        if (this.mProxy) {
            throw new RuntimeException("This must be called by the server only!");
        }
        out.writeInt(this.mItemType);
        out.writeUTF(this.mName);
        Util.writeString(out, this.mDescr);
        out.writeInt(this.mType);
        out.writeInt(this.mRW);
    }

    public static Item readFromServer(Packet in) throws IOException {
        int itemType = in.readInt();
        String name = in.readUTF();
        String descr = Util.readString(in);
        int type = in.readInt();
        int rw = in.readInt();
        Item ret = null;
        switch (itemType) {
            case 1: {
                ret = FieldItem.readFromServer(in, name, type);
                break;
            }
            case 2: {
                ret = PropertyItem.readFromServer(in, name, type);
                break;
            }
            case 3: {
                ret = CommandItem.readFromServer(in, name, type);
                break;
            }
            default: {
                throw new RuntimeException("Unknown item type: " + itemType);
            }
        }
        ret.setDescription(descr);
        ret.mRW = rw;
        return ret;
    }

    public void sendValueToClient(Packet out, Object obj) throws IOException {
        switch (this.getType()) {
            case 1: {
                out.writeBoolean(this.getBoolValue(obj));
                break;
            }
            case 17: {
                out.writeInt(this.getIntValue(obj));
                break;
            }
            case 21: {
                out.writeFloat(this.getFloatValue(obj));
                break;
            }
            case 33: {
                Util.writeString(out, this.getStringValue(obj));
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void readValueFromClient(Packet is, Object obj) throws IOException {
        switch (this.getType()) {
            case 1: {
                this.setBoolValue(obj, is.readBoolean());
                break;
            }
            case 17: {
                this.setIntValue(obj, is.readInt());
                break;
            }
            case 21: {
                this.setFloatValue(obj, is.readFloat());
                break;
            }
            case 33: {
                this.setStringValue(obj, Util.readString(is));
                break;
            }
            case 0: {
                this.setVoidValue(obj);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.runCB();
    }

    public int readIntValue(Packet out) throws IOException {
        Packet in = this.sendReadReq(out);
        return in.readInt();
    }

    public float readFloatValue(Packet out) throws IOException {
        Packet in = this.sendReadReq(out);
        return in.readFloat();
    }

    public boolean readBoolValue(Packet out) throws IOException {
        Packet in = this.sendReadReq(out);
        return in.readBoolean();
    }

    public String readStringValue(Packet out) throws IOException {
        Packet in = this.sendReadReq(out);
        return Util.readString(in);
    }

    protected Packet sendReadReq(Packet out) throws IOException {
        out.writeUTF(this.mName);
        Packet in = out.sendAndReceive("XAppDbg.C.ReadProp");
        int found = in.readInt();
        if (found == 0) {
            throw new RuntimeException("Property " + this.mName + " not found on server!");
        }
        return in;
    }

    public void sendIntValueToServer(int value, Packet out) throws IOException {
        out.writeUTF(this.mName);
        out.writeInt(value);
        out.sendAndReceive("XAppDbg.C.WriteProp");
    }

    public void sendFloatValueToServer(float value, Packet out) throws IOException {
        out.writeUTF(this.mName);
        out.writeFloat(value);
        out.sendAndReceive("XAppDbg.C.WriteProp");
    }

    public void sendBoolValueToServer(boolean value, Packet out) throws IOException {
        out.writeUTF(this.mName);
        out.writeBoolean(value);
        out.sendAndReceive("XAppDbg.C.WriteProp");
    }

    public void sendStringValueToServer(String value, Packet out) throws IOException {
        out.writeUTF(this.mName);
        Util.writeString(out, value);
        out.sendAndReceive("XAppDbg.C.WriteProp");
    }

    public void sendVoidValueToServer(Packet out) throws IOException {
        out.writeUTF(this.mName);
        out.sendAndReceive("XAppDbg.C.WriteProp");
    }
}

