/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.properties.Item;
import com.sonymobile.tools.xappdbg.properties.Util;
import com.sonymobile.tools.xappdbg.properties.XAppDbgPropDescr;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class PropertyItem
extends Item {
    private Method mGetter;
    private Method mSetter;

    public PropertyItem(String name, int type, boolean proxy) {
        super(name, 2, type, proxy);
    }

    public static PropertyItem scan(Method m, HashMap<String, Method> methods) {
        String name1;
        PropertyItem ret = null;
        int mod = m.getModifiers();
        String name = m.getName();
        Class<?> javaType = m.getReturnType();
        int type = Util.javaTypeToType(javaType);
        Class<?>[] params = m.getParameterTypes();
        if (type != 0 && (mod & 1) != 0 && ((name1 = Util.getFirstToken(name)).equals("is") || name1.equals("get")) && params.length == 0) {
            String propName = name.substring(name1.length(), name.length());
            ret = new PropertyItem(propName, type, false);
            ret.addGetter(m);
            methods.put(m.getName(), null);
            Method setter = PropertyItem.findSetter(methods, propName, javaType);
            if (setter != null) {
                ret.addSetter(setter);
                methods.put(setter.getName(), null);
            }
        }
        return ret;
    }

    private static Method findSetter(HashMap<String, Method> methods, String propName, Class<?> javaType) {
        String name = "set" + propName;
        Method m = methods.get(name);
        if (m != null) {
            Class<?> type2 = m.getReturnType();
            Class<?>[] params2 = m.getParameterTypes();
            if (type2 == Void.TYPE && params2.length == 1 && params2[0] == javaType) {
                return m;
            }
        }
        return null;
    }

    public void addGetter(Method m) {
        this.mGetter = m;
        this.setReadable();
        this.readDescription(m);
    }

    public void addSetter(Method m) {
        this.mSetter = m;
        this.setWritable();
        this.readDescription(m);
    }

    private void readDescription(Method m) {
        XAppDbgPropDescr ann = m.getAnnotation(XAppDbgPropDescr.class);
        if (ann != null) {
            this.setDescription(ann.value());
        }
    }

    @Override
    public boolean getBoolValue(Object obj) {
        if (this.getType() != 1 || this.mGetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            return (Boolean)this.mGetter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public float getFloatValue(Object obj) {
        if (this.getType() != 21 || this.mGetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            return ((Float)this.mGetter.invoke(obj, new Object[0])).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getIntValue(Object obj) {
        if (this.getType() != 17 || this.mGetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            return (Integer)this.mGetter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getStringValue(Object obj) {
        if (this.getType() != 33 || this.mGetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            return (String)this.mGetter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setBoolValue(Object obj, boolean value) {
        if (this.getType() != 1 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setFloatValue(Object obj, float value) {
        if (this.getType() != 21 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, Float.valueOf(value));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setIntValue(Object obj, int value) {
        if (this.getType() != 17 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setStringValue(Object obj, String value) {
        if (this.getType() != 33 || this.mSetter == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mSetter.invoke(obj, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setVoidValue(Object obj) {
        throw new IllegalArgumentException();
    }

    @Override
    public void sendToClient(Packet out) throws IOException {
        super.sendToClient(out);
    }

    public static PropertyItem readFromServer(Packet in, String name, int type) throws IOException {
        PropertyItem ret = new PropertyItem(name, type, true);
        return ret;
    }
}

