/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.XAppDbgCommand;
import com.sonymobile.tools.xappdbg.XAppDbgModule;
import com.sonymobile.tools.xappdbg.XAppDbgWidget;
import com.sonymobile.tools.xappdbg.properties.ClassItems;
import com.sonymobile.tools.xappdbg.properties.FieldItem;
import com.sonymobile.tools.xappdbg.properties.Item;
import com.sonymobile.tools.xappdbg.properties.Util;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdListProp;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdReadProp;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdWriteProp;
import java.io.IOException;
import java.lang.reflect.Field;

public class XAppDbgPropertiesModule
extends XAppDbgModule {
    private XAppDbgCommand[] mCmds = new XAppDbgCommand[]{new XAppDbgCmdListProp(this), new XAppDbgCmdWriteProp(this), new XAppDbgCmdReadProp(this)};
    private XAppDbgWidget[] mWidget = new XAppDbgWidget[]{new XAppDbgWidget("XAppDbg.W.ObjPropList", "", true, this)};
    private Object mObj;
    private ClassItems mItems;

    public XAppDbgPropertiesModule(Object obj) {
        this.mObj = obj;
        this.mItems = this.mObj == null ? new ClassItems(null) : ClassItems.scanClass(this.mObj.getClass());
    }

    public XAppDbgPropertiesModule(Class<?> cls) {
        this.mObj = null;
        this.mItems = ClassItems.scanClass(cls);
    }

    public void addFieldItem(Class<?> cls, String name, String fieldName, String descr, Runnable cb) {
        Field field;
        if (fieldName == null) {
            fieldName = name;
        }
        try {
            field = cls.getField(fieldName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (field == null) {
            System.out.println("Cannot find field " + fieldName + " in class " + cls);
            return;
        }
        int type = Util.javaTypeToType(field.getType());
        if (type == 0) {
            System.out.println("Cannot handle field(" + fieldName + ") type " + field.getType());
            return;
        }
        FieldItem item = new FieldItem(field, fieldName, type, false);
        item.setDescription(descr);
        item.setCallback(cb);
        this.mItems.addItem(item);
    }

    @Override
    public XAppDbgCommand[] getCommands() {
        return this.mCmds;
    }

    public boolean cmdListProp(Packet in, Packet out) throws IOException {
        int cnt = this.mItems.getItemCount();
        out.writeInt(cnt);
        int i = 0;
        while (i < cnt) {
            Item item = this.mItems.getItem(i);
            item.sendToClient(out);
            if (item.isReadable()) {
                item.sendValueToClient(out, this.mObj);
            }
            ++i;
        }
        return true;
    }

    public boolean cmdReadProp(Packet in, Packet out) throws IOException {
        String name = in.readUTF();
        Item item = this.find(name);
        if (item == null) {
            out.writeInt(0);
            return false;
        }
        out.writeInt(1);
        item.sendValueToClient(out, this.mObj);
        return true;
    }

    public boolean cmdWriteProp(Packet in, Packet out) throws IOException {
        String name = in.readUTF();
        Item item = this.find(name);
        item.readValueFromClient(in, this.mObj);
        return true;
    }

    private Item find(String name) {
        int cnt = this.mItems.getItemCount();
        int i = 0;
        while (i < cnt) {
            Item item = this.mItems.getItem(i);
            if (item.getName().equals(name)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    @Override
    public XAppDbgWidget[] getWidgets() {
        return this.mWidget;
    }
}

