/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.xappdbg.properties;

import com.sonymobile.tools.xappdbg.Packet;
import com.sonymobile.tools.xappdbg.XAppDbgCommand;
import com.sonymobile.tools.xappdbg.XAppDbgModule;
import com.sonymobile.tools.xappdbg.XAppDbgWidget;
import com.sonymobile.tools.xappdbg.properties.ClassItems;
import com.sonymobile.tools.xappdbg.properties.Item;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdTree;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdTreeDo;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdTreeList;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdTreeRead;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdTreeSelect;
import com.sonymobile.tools.xappdbg.properties.XAppDbgCmdTreeWrite;
import com.sonymobile.tools.xappdbg.properties.XAppDbgTreeParser;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class XAppDbgTreeModule
extends XAppDbgModule {
    private XAppDbgCommand[] mCommands = new XAppDbgCommand[]{new XAppDbgCmdTree(this), new XAppDbgCmdTreeSelect(this), new XAppDbgCmdTreeList(this), new XAppDbgCmdTreeRead(this), new XAppDbgCmdTreeWrite(this), new XAppDbgCmdTreeDo(this)};
    private String mParams = "";
    private Object mTree;
    private XAppDbgTreeParser mTreeParser;
    private Object mSelectedObj;
    private ClassItems mSelectedItems;
    private HashMap<Integer, WeakReference<Object>> mCache = new HashMap();
    private HashMap<String, Runnable> mCBs = new HashMap();

    public XAppDbgTreeModule(Object tree, XAppDbgTreeParser treeParser) {
        this.mTree = tree;
        this.mTreeParser = treeParser;
    }

    public void addCommand(String label, Runnable cb) {
        this.mCBs.put(label, cb);
        this.mParams = String.valueOf(this.mParams) + label + "|";
    }

    @Override
    public XAppDbgCommand[] getCommands() {
        return this.mCommands;
    }

    @Override
    public XAppDbgWidget[] getWidgets() {
        return new XAppDbgWidget[]{new XAppDbgWidget("XAppDbg.W.ObjTree", this.mParams, true, this)};
    }

    public boolean cmdTree(Packet in, Packet out) throws IOException {
        this.mCache.clear();
        this.dumpNode(this.mTree, out);
        return true;
    }

    private void dumpNode(Object node, Packet out) throws IOException {
        int cnt = this.mTreeParser.getChildCount(node);
        int hashCode = node.hashCode();
        this.mCache.put(hashCode, new WeakReference<Object>(node));
        out.writeInt(hashCode);
        out.writeUTF(this.mTreeParser.getText(node));
        out.writeInt(cnt);
        int i = 0;
        while (i < cnt) {
            Object child = this.mTreeParser.getChild(node, i);
            this.dumpNode(child, out);
            ++i;
        }
    }

    public boolean cmdTreeList(Packet in, Packet out) throws IOException {
        if (this.mSelectedItems == null) {
            out.writeInt(0);
            return false;
        }
        int cnt = this.mSelectedItems.getItemCount();
        out.writeInt(cnt);
        int i = 0;
        while (i < cnt) {
            Item item = this.mSelectedItems.getItem(i);
            item.sendToClient(out);
            if (item.isReadable()) {
                item.sendValueToClient(out, this.mSelectedObj);
            }
            ++i;
        }
        return true;
    }

    public boolean cmdTreeSelect(Packet in, Packet out) throws IOException {
        int hashCode = in.readInt();
        this.mSelectedItems = null;
        WeakReference<Object> ref = this.mCache.get(hashCode);
        if (ref != null) {
            this.mSelectedObj = ref.get();
            if (this.mSelectedObj != null) {
                this.mSelectedItems = this.getPropertiesOf(this.mSelectedObj);
            }
        }
        return false;
    }

    protected ClassItems getPropertiesOf(Object obj) {
        return ClassItems.scanClass(obj.getClass());
    }

    public boolean cmdTreeRead(Packet in, Packet out) throws IOException {
        String name = in.readUTF();
        Item item = this.find(name);
        if (item == null || this.mSelectedObj == null) {
            out.writeInt(0);
            return false;
        }
        out.writeInt(1);
        item.sendValueToClient(out, this.mSelectedObj);
        return true;
    }

    public boolean cmdTreeWrite(Packet in, Packet out) throws IOException {
        String name = in.readUTF();
        Item item = this.find(name);
        item.readValueFromClient(in, this.mSelectedObj);
        return true;
    }

    private Item find(String name) {
        int cnt = this.mSelectedItems.getItemCount();
        int i = 0;
        while (i < cnt) {
            Item item = this.mSelectedItems.getItem(i);
            if (item.getName().equals(name)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public boolean cmdDo(Packet in, Packet out) throws IOException {
        String cmd = in.readUTF();
        Runnable cb = this.mCBs.get(cmd);
        cb.run();
        return true;
    }

    public Object getSelectedNode() {
        return this.mSelectedObj;
    }
}

