/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jpos.CashDrawer;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class CashDrawerPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = 4066023079410077425L;
    protected MainButtonPanel mainButtonPanel;
    private CashDrawer cashDrawer = new CashDrawer();
    private String defaultLogicalName = "defaultCashDrawer";
    private JButton openCashDrawerButton;
    private JButton getDrawerOpenedButton;
    private JButton waitForDrawerCloseButton;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JTextArea statusTextArea;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;

    public CashDrawerPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        this.openCashDrawerButton = new JButton("Open Cash Drawer");
        this.openCashDrawerButton.setActionCommand("openCashDrawer");
        this.openCashDrawerButton.addActionListener(this);
        this.openCashDrawerButton.setEnabled(false);
        buttonPanel.add(this.openCashDrawerButton);
        this.getDrawerOpenedButton = new JButton("Get Drawer Opened");
        this.getDrawerOpenedButton.setActionCommand("getDrawerOpened");
        this.getDrawerOpenedButton.addActionListener(this);
        this.getDrawerOpenedButton.setEnabled(false);
        buttonPanel.add(this.getDrawerOpenedButton);
        this.waitForDrawerCloseButton = new JButton("Wait For Drawer Close");
        this.waitForDrawerCloseButton.setActionCommand("waitForDrawerClose");
        this.waitForDrawerCloseButton.addActionListener(this);
        this.waitForDrawerCloseButton.setEnabled(false);
        buttonPanel.add(this.waitForDrawerCloseButton);
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        JLabel label = new JLabel("Action log: ");
        label.setAlignmentX(0.5f);
        statusPanel.add(label);
        this.statusTextArea = new JTextArea(10, 10);
        JScrollPane scrollPane = new JScrollPane(this.statusTextArea);
        statusPanel.add(scrollPane);
        subPanel.add(statusPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        String msg = "Status Update Event: ";
        switch (sue.getStatus()) {
            case 0: {
                msg = String.valueOf(msg) + "Drawer Closed\n";
                break;
            }
            case 1: {
                msg = String.valueOf(msg) + "Drawer Opened\n";
                break;
            }
            default: {
                msg = String.valueOf(msg) + "Unknown Status: " + Integer.toString(sue.getStatus()) + "\n";
            }
        }
        this.statusTextArea.append(msg);
    }

    public void actionPerformed(ActionEvent ae) {
        block55: {
            this.mainButtonPanel.action(ae);
            String logicalName = this.mainButtonPanel.getLogicalName();
            if (ae.getActionCommand().equals("open")) {
                try {
                    if (logicalName.equals("")) {
                        logicalName = this.defaultLogicalName;
                    }
                    this.cashDrawer.addStatusUpdateListener((StatusUpdateListener)this);
                    this.cashDrawer.open(logicalName);
                    this.deviceEnabledCB.setEnabled(false);
                    this.freezeEventsCB.setEnabled(true);
                    int version = this.cashDrawer.getDeviceServiceVersion();
                    if (version >= 1009000) {
                        this.ver_19_complient = true;
                        this.ver_18_complient = true;
                    }
                    if (version >= 1008000) {
                        this.ver_18_complient = true;
                    }
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("claim")) {
                try {
                    this.cashDrawer.claim(0);
                    this.openCashDrawerButton.setEnabled(true);
                    this.getDrawerOpenedButton.setEnabled(true);
                    this.waitForDrawerCloseButton.setEnabled(true);
                    this.deviceEnabledCB.setEnabled(true);
                    this.freezeEventsCB.setEnabled(true);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("release")) {
                try {
                    this.cashDrawer.release();
                    this.openCashDrawerButton.setEnabled(false);
                    this.getDrawerOpenedButton.setEnabled(false);
                    this.waitForDrawerCloseButton.setEnabled(false);
                    this.deviceEnabledCB.setEnabled(false);
                    this.freezeEventsCB.setEnabled(true);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("close")) {
                try {
                    this.cashDrawer.close();
                    this.deviceEnabledCB.setEnabled(false);
                    this.freezeEventsCB.setEnabled(false);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("openCashDrawer")) {
                this.statusTextArea.append("Open cash drawer.\n");
                try {
                    this.cashDrawer.openDrawer();
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in openDrawer: " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("getDrawerOpened")) {
                try {
                    if (this.cashDrawer.getDrawerOpened()) {
                        this.statusTextArea.append("Cash drawer is open.\n");
                        break block55;
                    }
                    this.statusTextArea.append("Cash drawer is closed.\n");
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in getDrawerOpened: " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("waitForDrawerClose")) {
                try {
                    this.cashDrawer.waitForDrawerClose(100, 500, 100, 200);
                    this.statusTextArea.append("Cash drawer closed.\n");
                }
                catch (JposException e) {
                    this.statusTextArea.append("Jpos exception " + (Object)((Object)e) + "\n");
                    JOptionPane.showMessageDialog(null, "Exception in waitForDrawerClose: " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("info")) {
                try {
                    String ver = new Integer(this.cashDrawer.getDeviceServiceVersion()).toString();
                    String msg = "Service Description: " + this.cashDrawer.getDeviceServiceDescription();
                    msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                    ver = new Integer(this.cashDrawer.getDeviceControlVersion()).toString();
                    msg = String.valueOf(msg) + "\n\nControl Description: " + this.cashDrawer.getDeviceControlDescription();
                    msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                    msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.cashDrawer.getPhysicalDeviceName();
                    msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.cashDrawer.getPhysicalDeviceDescription();
                    msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                    msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.cashDrawer.getCapPowerReporting() == 2 ? "Advanced" : (this.cashDrawer.getCapPowerReporting() == 1 ? "Standard" : "None"));
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.cashDrawer.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.cashDrawer.getCapUpdateStatistics();
                    msg = String.valueOf(msg) + "\nCapStatus: " + this.cashDrawer.getCapStatus();
                    msg = String.valueOf(msg) + "\nCapStatusMultiDrawerDetect: " + this.cashDrawer.getCapStatusMultiDrawerDetect();
                    if (this.ver_18_complient) {
                        msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.cashDrawer.getCapStatisticsReporting();
                        msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.cashDrawer.getCapUpdateStatistics();
                    } else {
                        msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                        msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                    }
                    if (this.ver_19_complient) {
                        msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.cashDrawer.getCapCompareFirmwareVersion();
                        msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.cashDrawer.getCapUpdateFirmware();
                    } else {
                        msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                        msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                    }
                    JOptionPane.showMessageDialog(null, msg, "Info", 1);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("oce")) {
                try {
                    if (logicalName.equals("")) {
                        logicalName = this.defaultLogicalName;
                    }
                    this.cashDrawer.addStatusUpdateListener((StatusUpdateListener)this);
                    this.cashDrawer.open(logicalName);
                    this.cashDrawer.claim(0);
                    this.deviceEnabledCB.setEnabled(true);
                    this.freezeEventsCB.setEnabled(true);
                    this.cashDrawer.setDeviceEnabled(true);
                    this.openCashDrawerButton.setEnabled(true);
                    this.getDrawerOpenedButton.setEnabled(true);
                    this.waitForDrawerCloseButton.setEnabled(true);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            } else if (ae.getActionCommand().equals("stats")) {
                try {
                    StatisticsDialog dlg = new StatisticsDialog(this.cashDrawer);
                    dlg.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("firmware")) {
                try {
                    FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.cashDrawer);
                    dlg.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            }
        }
        try {
            if (this.cashDrawer.getState() != 1) {
                this.deviceEnabledCB.setSelected(this.cashDrawer.getDeviceEnabled());
                this.freezeEventsCB.setSelected(this.cashDrawer.getFreezeEvents());
            }
        }
        catch (JposException je) {
            System.err.println("POSPrinterPanel: MethodListener: JposException");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == CashDrawerPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        CashDrawerPanel.this.cashDrawer.setDeviceEnabled(false);
                    } else {
                        CashDrawerPanel.this.cashDrawer.setDeviceEnabled(true);
                    }
                } else if (source == CashDrawerPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        CashDrawerPanel.this.cashDrawer.setFreezeEvents(false);
                    } else {
                        CashDrawerPanel.this.cashDrawer.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("CashDrawerPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (CashDrawerPanel.this.cashDrawer != null) {
                CashDrawerPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(CashDrawerPanel.this.cashDrawer.getState()));
            }
        }
    }
}

