/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.CheckScanner;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class CheckScannerPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = 1618429583773178897L;
    protected MainButtonPanel mainButtonPanel;
    private CheckScanner checkScanner = new CheckScanner();
    private String defaultLogicalName = "defaultCheckScanner";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JButton beginInsertionButton;
    private JButton endInsertionButton;
    private JButton beginRemovalButton;
    private JButton endRemovalButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public CheckScannerPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        this.beginInsertionButton = new JButton("Begin Insertion");
        this.beginInsertionButton.setActionCommand("beginInsertion");
        this.beginInsertionButton.addActionListener(this);
        this.beginInsertionButton.setEnabled(false);
        buttonPanel.add(this.beginInsertionButton);
        this.endInsertionButton = new JButton("End Insertion");
        this.endInsertionButton.setActionCommand("endInsertion");
        this.endInsertionButton.addActionListener(this);
        this.endInsertionButton.setEnabled(false);
        buttonPanel.add(this.endInsertionButton);
        this.beginRemovalButton = new JButton("Begin Removal");
        this.beginRemovalButton.setActionCommand("beginRemoval");
        this.beginRemovalButton.addActionListener(this);
        this.beginRemovalButton.setEnabled(false);
        buttonPanel.add(this.beginRemovalButton);
        this.endRemovalButton = new JButton("End Removal");
        this.endRemovalButton.setActionCommand("endRemoval");
        this.endRemovalButton.addActionListener(this);
        this.endRemovalButton.setEnabled(false);
        buttonPanel.add(this.endRemovalButton);
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        JLabel label = new JLabel("Not yet implemented.");
        label.setAlignmentX(0.5f);
        statusPanel.add(label);
        statusPanel.add(Box.createHorizontalGlue());
        subPanel.add(statusPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("CheckScanner received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.checkScanner.addStatusUpdateListener((StatusUpdateListener)this);
                this.checkScanner.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.checkScanner.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.checkScanner.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.beginInsertionButton.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.checkScanner.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.checkScanner.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.checkScanner.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.checkScanner.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.checkScanner.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.checkScanner.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.checkScanner.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.checkScanner.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.checkScanner.getCapPowerReporting() == 2 ? "Advanced" : (this.checkScanner.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.checkScanner.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.checkScanner.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.checkScanner.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.checkScanner.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapAutoGenerateFileID: " + this.checkScanner.getCapAutoGenerateFileID();
                msg = String.valueOf(msg) + "\nCapAutoGenerateImageTagData: " + this.checkScanner.getCapAutoGenerateImageTagData();
                msg = String.valueOf(msg) + "\nCapAutoSize: " + this.checkScanner.getCapAutoSize();
                msg = String.valueOf(msg) + "\nCapColor: ";
                int color = this.checkScanner.getCapColor();
                if ((color & 1) > 0) {
                    msg = String.valueOf(msg) + "CHK_CCL_MONO | ";
                }
                if ((color & 2) > 0) {
                    msg = String.valueOf(msg) + "CHK_CCL_GRAYSCALE | ";
                }
                if ((color & 4) > 0) {
                    msg = String.valueOf(msg) + "CHK_CCL_16 | ";
                }
                if ((color & 8) > 0) {
                    msg = String.valueOf(msg) + "CHK_CCL_256 | ";
                }
                if ((color & 0x10) > 0) {
                    msg = String.valueOf(msg) + "CHK_CCL_FULL";
                }
                msg = String.valueOf(msg) + "\nCapConcurrentMICR: " + this.checkScanner.getCapConcurrentMICR();
                msg = String.valueOf(msg) + "\nCapDefineCropArea: " + this.checkScanner.getCapDefineCropArea();
                msg = String.valueOf(msg) + "\nCapImageFormat: ";
                int format = this.checkScanner.getCapImageFormat();
                if ((format & 1) > 0) {
                    msg = String.valueOf(msg) + "Bi-CHK_CIF_NATIVE | ";
                }
                if ((format & 2) > 0) {
                    msg = String.valueOf(msg) + "Bi-CHK_CIF_TIFF | ";
                }
                if ((format & 4) > 0) {
                    msg = String.valueOf(msg) + "Bi-CHK_CIF_BMP | ";
                }
                if ((format & 8) > 0) {
                    msg = String.valueOf(msg) + "Bi-CHK_CIF_JPEG | ";
                }
                if ((format & 0x10) > 0) {
                    msg = String.valueOf(msg) + "Bi-CHK_CIF_GIF";
                }
                msg = String.valueOf(msg) + "\nCapImageTagData: " + this.checkScanner.getCapImageTagData();
                msg = String.valueOf(msg) + "\nCapMICRDevice: " + this.checkScanner.getCapMICRDevice();
                msg = String.valueOf(msg) + "\nCapStoreImageFiles: " + this.checkScanner.getCapStoreImageFiles();
                msg = String.valueOf(msg) + "\nCapValidationDevice: " + this.checkScanner.getCapValidationDevice();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("beginInsertion")) {
            try {
                this.checkScanner.beginInsertion(-1);
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(true);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in beginInsertion: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("endInsertion")) {
            try {
                this.checkScanner.endInsertion();
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(true);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in endInsertion: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("beginRemoval")) {
            try {
                this.checkScanner.beginRemoval(-1);
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in beginRemoval: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("endRemoval")) {
            try {
                this.checkScanner.endRemoval();
                this.beginInsertionButton.setEnabled(true);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in endRemoval: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.checkScanner);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.checkScanner);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            if (this.checkScanner.getState() != 1) {
                if (this.checkScanner.getClaimed()) {
                    this.deviceEnabledCB.setSelected(this.checkScanner.getDeviceEnabled());
                }
                this.freezeEventsCB.setSelected(this.checkScanner.getFreezeEvents());
            }
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "Exception in Method Panel:\n " + je.getMessage(), "Exception", 0);
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == CheckScannerPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        CheckScannerPanel.this.checkScanner.setDeviceEnabled(false);
                    } else {
                        CheckScannerPanel.this.checkScanner.setDeviceEnabled(true);
                    }
                } else if (source == CheckScannerPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        CheckScannerPanel.this.checkScanner.setFreezeEvents(false);
                    } else {
                        CheckScannerPanel.this.checkScanner.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("CheckScannerPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (CheckScannerPanel.this.checkScanner != null) {
                CheckScannerPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(CheckScannerPanel.this.checkScanner.getState()));
            }
        }
    }
}

