/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jpos.FiscalPrinter;
import jpos.JposException;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class FiscalPrinterPanel
extends Component
implements StatusUpdateListener,
OutputCompleteListener,
ErrorListener {
    private static final long serialVersionUID = -1141207648205875965L;
    protected MainButtonPanel mainButtonPanel;
    private FiscalPrinter fiscalPrinter;
    private String defaultLogicalName = "fiscalprinter";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JCheckBox doubleWidthCB;
    private JCheckBox duplicateReceiptCB;
    private JCheckBox asyncModeCB;
    private JCheckBox checkTotalCB;
    private JCheckBox flagWhenIdleCB;
    private JCheckBox clearOutputForErrorCB;
    private JList itemList;
    private DefaultListModel itemListModel;
    private JList propList;
    private DefaultListModel propListModel;
    private JComboBox paymantFormCombo;
    private JComboBox vatIdCombo;
    private JComboBox vatIdCombo_2;
    private JComboBox adjustmentTypeCombo;
    private JComboBox reportTypeCombo;
    private JComboBox totalTypeCombo;
    private JRadioButton firmwareRB;
    private JRadioButton printerIDRB;
    private JRadioButton currentTotalRB;
    private JRadioButton grandTotalRB;
    private JRadioButton mitVoidRB;
    private JRadioButton fiscalRecRB;
    private JRadioButton receiptNumberRB;
    private JRadioButton refundRB;
    private JRadioButton fiscalRecVoidRB;
    private JRadioButton nonFiscalRecRB;
    private JRadioButton descriptionLengthRB;
    private JRadioButton zReportRB;
    private JRadioButton dayTotalizerRB;
    private JRadioButton grandTotalizerRB;
    private JRadioButton currentRecTotalRB;
    MethodListener methodListener = new MethodListener();
    private JButton beginFiscalReceiptButton;
    private JButton beginNonFiscalButton;
    private JButton endNonFiscalButton;
    private JButton printNormalButton;
    private JButton printRecItemButton;
    private JButton printRecItemAdjButton;
    private JButton printRecRefundButton;
    private JButton printRecSubTotalButton;
    private JButton printRecTotalButton;
    private JButton printDuplicateRecButton;
    private JButton printRecVoidButton;
    private JButton printRecRefundVoidButton;
    private JButton printRecVoidItemButton;
    private JButton endFiscalReceiptButton;
    private JButton printReportButton;
    private JButton printXReportButton;
    private JButton printZReportButton;
    private JButton setPrinterProp;
    private JButton getDataButton;
    private JButton getTotalizerButton;
    private JButton getDateButton;
    private JButton printPeriodicTotalReportButton;
    private JButton printerStatusButton;
    private JButton dayOpenedButton;
    private JButton remainingFiscalMemoryButton;
    private JButton showPropertyButton;
    private JButton beginTrainingButton;
    private JButton endTrainingButton;
    private JButton clearOutPutButton;
    private JButton getErrorLevelButton;
    private JButton getPropListButton;
    private JButton directIoButton;
    private JButton getAdditionalHeaderButton;
    private JButton getAdditionalTrailerButton;
    private JButton resetPrinterButton;
    private JButton clearFieldsButton;
    private JButton getTrainingStateButton;
    private JButton getCheckHealthButton;
    private JButton getOutPutIdButton;
    private JButton setVatTableButton;
    private JButton clearOutButton;
    private JButton clearErrorButton;
    private JButton printRecMessageButton;
    private JButton recSubTotalDiscountButton;
    private JButton recSubTotalDiscountVoidButton;
    private JTextField itemDescription;
    private JTextField itemPrice;
    private JTextField itemQuantity;
    private JTextField itemUnitPrice;
    private JTextField itemVatInfo;
    private JTextField unitName;
    private JTextField reportFrom;
    private JTextField reportTo;
    private JTextField additionalHeaderTxt;
    private JTextField additionalTrailerTxt;
    private JTextField dateTxt;
    private JTextField headerTxt;
    private JTextField trailerTxt;
    private JTextField vatIdTxt;
    private JTextField vatValueTxt;
    private JTextField headerLineNumberTxt;
    private JTextField itemAmountPercAdjTxt;
    private JTextField directIoCommand;
    private JTextField directIoData;
    private JTextField directIoObject;
    private JTextField checkHealthTxt;
    private JTextField preLineTxt;
    private JTextField postLineTxt;
    private JTextField recMessageTxt;
    private JTextArea nonFiscalTxt;
    private JLabel label;
    private long TOTAL = 0L;
    private long amountFactorDecimal = 1L;
    private int quantityFactorDecimal = 1;
    private int getDataType = 10;
    private int adjustmentType = 1;
    private int reportType = 1;
    private String[] adjType = new String[]{"Amount Discount", "Amount Surcharge", "Perc. Discount", "Perc. Surcharge"};
    private int numAdjType = 4;
    private int[] valuesGetData = new int[1];
    private String[] strGetData = new String[]{""};
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;

    public FiscalPrinterPanel() {
        this.fiscalPrinter = new FiscalPrinter();
        this.fiscalPrinter.addStatusUpdateListener((StatusUpdateListener)this);
        this.fiscalPrinter.addErrorListener((ErrorListener)this);
        this.fiscalPrinter.addOutputCompleteListener((OutputCompleteListener)this);
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this.methodListener, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        this.duplicateReceiptCB = new JCheckBox("Duplicate Receipt");
        propPanel.add(this.duplicateReceiptCB);
        this.asyncModeCB = new JCheckBox("Async Mode");
        propPanel.add(this.asyncModeCB);
        this.checkTotalCB = new JCheckBox("Check Total");
        propPanel.add(this.checkTotalCB);
        this.flagWhenIdleCB = new JCheckBox("Flag When Idle");
        propPanel.add(this.flagWhenIdleCB);
        this.beginTrainingButton = new JButton("Begin Training");
        this.beginTrainingButton.setMaximumSize(new Dimension(160, 17));
        this.beginTrainingButton.setPreferredSize(new Dimension(160, 17));
        this.beginTrainingButton.setActionCommand("beginTraining");
        this.beginTrainingButton.addActionListener(this.methodListener);
        this.beginTrainingButton.setAlignmentX(0.0f);
        this.beginTrainingButton.setEnabled(false);
        propPanel.add(this.beginTrainingButton);
        this.endTrainingButton = new JButton("End Training");
        this.endTrainingButton.setMaximumSize(new Dimension(160, 17));
        this.endTrainingButton.setPreferredSize(new Dimension(160, 17));
        this.endTrainingButton.setActionCommand("endTraining");
        this.endTrainingButton.addActionListener(this.methodListener);
        this.endTrainingButton.setAlignmentX(0.0f);
        this.endTrainingButton.setEnabled(false);
        propPanel.add(this.endTrainingButton);
        this.clearOutButton = new JButton("Clear OutPut");
        this.clearOutButton.setMaximumSize(new Dimension(160, 17));
        this.clearOutButton.setPreferredSize(new Dimension(160, 17));
        this.clearOutButton.setActionCommand("clearOut");
        this.clearOutButton.addActionListener(this.methodListener);
        this.clearOutButton.setAlignmentX(0.0f);
        this.clearOutButton.setEnabled(false);
        propPanel.add(this.clearOutButton);
        this.clearErrorButton = new JButton("Clear Error");
        this.clearErrorButton.setMaximumSize(new Dimension(160, 17));
        this.clearErrorButton.setPreferredSize(new Dimension(160, 17));
        this.clearErrorButton.setActionCommand("clearError");
        this.clearErrorButton.addActionListener(this.methodListener);
        this.clearErrorButton.setAlignmentX(0.0f);
        this.clearErrorButton.setEnabled(false);
        propPanel.add(this.clearErrorButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        this.duplicateReceiptCB.setEnabled(false);
        this.asyncModeCB.setEnabled(false);
        this.checkTotalCB.setEnabled(false);
        this.flagWhenIdleCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        this.duplicateReceiptCB.addItemListener(cbListener);
        this.asyncModeCB.addItemListener(cbListener);
        this.checkTotalCB.addItemListener(cbListener);
        this.flagWhenIdleCB.addItemListener(cbListener);
        JTabbedPane tabbedPane = new JTabbedPane();
        FiscalPrinterSettingPanel fpt = new FiscalPrinterSettingPanel();
        tabbedPane.addTab("Printer Setting", null, fpt.make(), "PrinterSetting");
        FiscalReceiptPanel frp = new FiscalReceiptPanel();
        tabbedPane.addTab("Fiscal Receipt", null, frp.make(), "FiscalReceipt");
        NonFiscalPanel nfp = new NonFiscalPanel();
        tabbedPane.addTab("Non Fiscal Printing", null, nfp.make(), "NonFiscalPriting");
        FiscalPrinterFscReportPanel ffr = new FiscalPrinterFscReportPanel();
        tabbedPane.addTab("Fiscal Report", null, ffr.make(), "FiscalReport");
        FiscalPrinterStatusPanel fps = new FiscalPrinterStatusPanel();
        tabbedPane.addTab("Fiscal Printer Status", null, fps.make(), "PrinterStatus");
        DirectIOPanel dct = new DirectIOPanel();
        tabbedPane.addTab("Direct IO", null, dct.make(), "directIO");
        subPanel.add(tabbedPane);
        subPanel.setAlignmentY(0.0f);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    private void setEnableButtonTo(boolean param) {
        this.deviceEnabledCB.setEnabled(param);
        this.freezeEventsCB.setEnabled(param);
        this.duplicateReceiptCB.setEnabled(param);
        this.asyncModeCB.setEnabled(param);
        this.checkTotalCB.setEnabled(param);
        this.flagWhenIdleCB.setEnabled(param);
        this.beginFiscalReceiptButton.setEnabled(param);
        this.printRecItemButton.setEnabled(param);
        this.printRecItemAdjButton.setEnabled(param);
        this.endFiscalReceiptButton.setEnabled(param);
        this.printRecRefundButton.setEnabled(param);
        this.printRecSubTotalButton.setEnabled(param);
        this.printRecTotalButton.setEnabled(param);
        this.printRecVoidButton.setEnabled(param);
        this.printRecRefundVoidButton.setEnabled(param);
        this.printRecVoidItemButton.setEnabled(param);
        this.printReportButton.setEnabled(param);
        this.printXReportButton.setEnabled(param);
        this.printZReportButton.setEnabled(param);
        this.printDuplicateRecButton.setEnabled(param);
        this.beginNonFiscalButton.setEnabled(param);
        this.endNonFiscalButton.setEnabled(param);
        this.printNormalButton.setEnabled(param);
        this.setPrinterProp.setEnabled(param);
        this.paymantFormCombo.setEnabled(param);
        this.vatIdCombo.setEnabled(param);
        this.vatIdCombo_2.setEnabled(param);
        this.getDataButton.setEnabled(param);
        this.getDateButton.setEnabled(param);
        this.getTotalizerButton.setEnabled(param);
        this.showPropertyButton.setEnabled(param);
        this.printPeriodicTotalReportButton.setEnabled(param);
        this.printerStatusButton.setEnabled(param);
        this.dayOpenedButton.setEnabled(param);
        this.getErrorLevelButton.setEnabled(param);
        this.getOutPutIdButton.setEnabled(param);
        this.remainingFiscalMemoryButton.setEnabled(param);
        this.getPropListButton.setEnabled(param);
        this.directIoButton.setEnabled(param);
        this.getAdditionalHeaderButton.setEnabled(param);
        this.getAdditionalTrailerButton.setEnabled(param);
        this.resetPrinterButton.setEnabled(param);
        this.getTrainingStateButton.setEnabled(param);
        this.getCheckHealthButton.setEnabled(param);
        this.setVatTableButton.setEnabled(param);
        this.clearOutButton.setEnabled(param);
        this.clearErrorButton.setEnabled(param);
        this.printRecMessageButton.setEnabled(param);
        this.recSubTotalDiscountButton.setEnabled(param);
        this.recSubTotalDiscountVoidButton.setEnabled(param);
    }

    public void errorOccurred(ErrorEvent errorEvent) {
        String errorCodestr = String.valueOf(errorEvent.getErrorCode());
        String errorExtstr = String.valueOf(errorEvent.getErrorCodeExtended());
        String msg = "Occurred Error : (" + errorCodestr + "," + errorExtstr + ")";
        this.itemListModel.addElement(msg);
        if (this.clearOutputForErrorCB.isSelected()) {
            errorEvent.setErrorResponse(12);
        }
    }

    public void outputCompleteOccurred(OutputCompleteEvent outputCompleteEvent) {
        String msg = "Completed Async Output N. : " + String.valueOf(outputCompleteEvent.getOutputID());
        this.itemListModel.addElement(msg);
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        String msg = "Status Update Event: ";
        switch (sue.getStatus()) {
            case 12: {
                msg = String.valueOf(msg) + "Cover is OK\n";
                break;
            }
            case 11: {
                msg = String.valueOf(msg) + "Cover is Open\n";
                break;
            }
            case 21: {
                msg = String.valueOf(msg) + "Jrn is Empty\n";
                break;
            }
            case 22: {
                msg = String.valueOf(msg) + "Jrn is NearEmpty\n";
                break;
            }
            case 23: {
                msg = String.valueOf(msg) + "Jrn is OK\n";
                break;
            }
            case 24: {
                msg = String.valueOf(msg) + "Rec is Empty\n";
                break;
            }
            case 25: {
                msg = String.valueOf(msg) + "Rec is NearEmpty\n";
                break;
            }
            case 26: {
                msg = String.valueOf(msg) + "Rec is OK\n";
                break;
            }
            case 2: {
                msg = String.valueOf(msg) + "printer is IDLE";
                this.flagWhenIdleCB.setSelected(false);
            }
        }
        this.itemListModel.addElement(msg);
    }

    private String decodeErrorStation(int errStat) {
        String errStatSTR = "UNKNOWN";
        switch (errStat) {
            case 1: {
                errStatSTR = "JOURNAL";
                break;
            }
            case 3: {
                errStatSTR = "JOURNAL RECEIPT";
                break;
            }
            case 2: {
                errStatSTR = "RECEIPT";
                break;
            }
            case 4: {
                errStatSTR = "SLIP";
            }
        }
        return errStatSTR;
    }

    private String decodeErrorLevel(int errLev) {
        String errLevSTR = "UNKNOWN";
        switch (errLev) {
            case 1: {
                errLevSTR = "NONE";
                break;
            }
            case 3: {
                errLevSTR = "FATAL";
                break;
            }
            case 2: {
                errLevSTR = "RECOVERABLE";
                break;
            }
            case 4: {
                errLevSTR = "BLOCKED";
            }
        }
        return errLevSTR;
    }

    private String decodeDeviceState(int state) {
        String stateSTR = "UNKNOWN";
        switch (state) {
            case 3: {
                stateSTR = "BUSY";
                break;
            }
            case 2: {
                stateSTR = "IDLE";
                break;
            }
            case 1: {
                stateSTR = "CLOSED";
                break;
            }
            case 4: {
                stateSTR = "ERROR";
            }
        }
        return stateSTR;
    }

    private String decodeState(int state) {
        String stateSTR = "UNKNOWN";
        switch (state) {
            case 2: {
                stateSTR = "FISCAL RECEIPT";
                break;
            }
            case 1: {
                stateSTR = "MONITOR";
                break;
            }
            case 10: {
                stateSTR = "REPORT";
                break;
            }
            case 4: {
                stateSTR = "FISCAL RECEIPT ENDING";
                break;
            }
            case 3: {
                stateSTR = "FISCAL RECEIPT TOTAL";
                break;
            }
            case 8: {
                stateSTR = "LOCKED";
                break;
            }
            case 9: {
                stateSTR = "NON FISCAL";
            }
        }
        return stateSTR;
    }

    private String decodeCountryCode(int cc) {
        String countrySTR = "Unknown";
        switch (cc) {
            case 1: {
                countrySTR = "BRAZIL";
                break;
            }
            case 128: {
                countrySTR = "BULGARIA";
                break;
            }
            case 2: {
                countrySTR = "GREECE";
                break;
            }
            case 4: {
                countrySTR = "HUNGARY";
                break;
            }
            case 8: {
                countrySTR = "ITALY";
                break;
            }
            case 16: {
                countrySTR = "POLAND";
                break;
            }
            case 256: {
                countrySTR = "ROMANIA";
                break;
            }
            case 64: {
                countrySTR = "RUSSIA";
                break;
            }
            case 32: {
                countrySTR = "TURKEY";
            }
        }
        countrySTR = "Country : " + countrySTR;
        return countrySTR;
    }

    private String decodeTypeMessage(int cc) {
        String typeMsg = "Unknown";
        switch (cc) {
            case 24: {
                typeMsg = "FREE TEXT";
                break;
            }
            case 23: {
                typeMsg = "EMPTY LINE";
            }
        }
        typeMsg = "Type Message : " + typeMsg;
        return typeMsg;
    }

    private int getTotalizerType(String[] strLab) {
        int totzType = 5;
        int index = this.totalTypeCombo.getSelectedIndex();
        String str = "";
        switch (index) {
            case 0: {
                totzType = 5;
                str = "Item Totalizer: ";
                break;
            }
            case 1: {
                totzType = 8;
                str = "Refund Totalizer : ";
                break;
            }
            case 2: {
                totzType = 6;
                str = "Voided Item Totalizer : ";
                break;
            }
            case 3: {
                totzType = 3;
                str = "Discount Totalizer : ";
                break;
            }
            case 4: {
                totzType = 1;
                str = "Gross Totalizer : ";
            }
        }
        strLab[0] = str;
        return totzType;
    }

    private void executeGetData() throws JposException {
        String lblStr = "Firmware Rel. : ";
        this.valuesGetData[0] = 0;
        this.strGetData[0] = "";
        try {
            this.getDataType = 10;
            if (this.printerIDRB.isSelected()) {
                this.getDataType = 9;
                lblStr = "Printer ID : ";
            } else if (this.currentTotalRB.isSelected()) {
                this.getDataType = 2;
                lblStr = "Daily Total : ";
            } else if (this.grandTotalRB.isSelected()) {
                this.getDataType = 8;
                lblStr = "Grand Total : ";
            } else if (this.mitVoidRB.isSelected()) {
                this.getDataType = 6;
                lblStr = "N. of Voided Rec. : ";
            } else if (this.fiscalRecRB.isSelected()) {
                this.getDataType = 20;
                lblStr = "N. of Daily Fiscal Rec. : ";
            } else if (this.receiptNumberRB.isSelected()) {
                this.getDataType = 3;
                lblStr = "N. of Fiscal Rec. Printed : ";
            } else if (this.refundRB.isSelected()) {
                this.getDataType = 4;
                lblStr = "Current Tot. of Refunds : ";
            } else if (this.fiscalRecVoidRB.isSelected()) {
                this.getDataType = 21;
                lblStr = "N. of Daily Voided Fiscal Rec. : ";
            } else if (this.nonFiscalRecRB.isSelected()) {
                this.getDataType = 24;
                lblStr = "N. of Daily Non Fiscal Rec. : ";
            } else if (this.descriptionLengthRB.isSelected()) {
                this.getDataType = 28;
                lblStr = "Description Length : ";
            } else if (this.zReportRB.isSelected()) {
                this.getDataType = 7;
                lblStr = "Z Report : ";
            } else if (this.currentRecTotalRB.isSelected()) {
                this.getDataType = 1;
                lblStr = "Current Rec. Total : ";
            }
            this.fiscalPrinter.getData(this.getDataType, this.valuesGetData, this.strGetData);
            this.itemListModel.addElement(new String(String.valueOf(lblStr) + this.strGetData[0]));
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "JPosException calling getData", "Failed", 0);
        }
    }

    private void clearFields() {
        this.itemQuantity.setText("");
        this.itemPrice.setText("");
        this.itemDescription.setText("");
        this.itemUnitPrice.setText("");
        this.itemVatInfo.setText("");
        this.unitName.setText("");
        this.reportFrom.setText("");
        this.reportTo.setText("");
        this.additionalHeaderTxt.setText("");
        this.additionalTrailerTxt.setText("");
        this.dateTxt.setText("");
        this.headerTxt.setText("");
        this.headerLineNumberTxt.setText("");
        this.nonFiscalTxt.setText("");
        this.itemAmountPercAdjTxt.setText("");
        this.directIoCommand.setText("0");
        this.directIoData.setText("");
        this.directIoObject.setText("");
        this.trailerTxt.setText("");
        this.vatIdTxt.setText("");
        this.vatValueTxt.setText("");
        this.preLineTxt.setText("");
        this.postLineTxt.setText("");
        this.recMessageTxt.setText("");
        if (this.vatIdCombo_2.isEnabled()) {
            this.vatValueTxt.setText((String)this.vatIdCombo_2.getSelectedItem());
        }
        this.checkHealthTxt.setText("");
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == FiscalPrinterPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        FiscalPrinterPanel.this.fiscalPrinter.setDeviceEnabled(false);
                        FiscalPrinterPanel.this.endTrainingButton.setEnabled(false);
                        FiscalPrinterPanel.this.beginTrainingButton.setEnabled(false);
                    } else {
                        int i;
                        FiscalPrinterPanel.this.fiscalPrinter.setDeviceEnabled(true);
                        FiscalPrinterPanel.this.amountFactorDecimal = 1L;
                        FiscalPrinterPanel.this.quantityFactorDecimal = 1;
                        int temp = FiscalPrinterPanel.this.fiscalPrinter.getAmountDecimalPlace();
                        if (temp > 0) {
                            i = 1;
                            while (i <= temp) {
                                FiscalPrinterPanel fiscalPrinterPanel = FiscalPrinterPanel.this;
                                fiscalPrinterPanel.amountFactorDecimal = fiscalPrinterPanel.amountFactorDecimal * 10L;
                                ++i;
                            }
                        }
                        if ((temp = FiscalPrinterPanel.this.fiscalPrinter.getQuantityDecimalPlaces()) > 0) {
                            i = 1;
                            while (i <= temp) {
                                FiscalPrinterPanel fiscalPrinterPanel = FiscalPrinterPanel.this;
                                fiscalPrinterPanel.quantityFactorDecimal = fiscalPrinterPanel.quantityFactorDecimal * 10;
                                ++i;
                            }
                        }
                        FiscalPrinterPanel.this.endTrainingButton.setEnabled(true);
                        FiscalPrinterPanel.this.beginTrainingButton.setEnabled(true);
                        FiscalPrinterPanel.this.paymantFormCombo.removeAllItems();
                        if (FiscalPrinterPanel.this.fiscalPrinter.getCapPredefinedPaymentLines()) {
                            String S = FiscalPrinterPanel.this.fiscalPrinter.getPredefinedPaymentLines();
                            int i2 = 0;
                            while (i2 < S.length()) {
                                String str = S.substring(i2, i2 + 1);
                                if (!str.equals(",")) {
                                    FiscalPrinterPanel.this.paymantFormCombo.addItem(str);
                                }
                                ++i2;
                            }
                        } else {
                            FiscalPrinterPanel.this.paymantFormCombo.addItem("CASH");
                        }
                        FiscalPrinterPanel.this.vatIdCombo.removeAllItems();
                        FiscalPrinterPanel.this.vatIdCombo_2.removeAllItems();
                        if (FiscalPrinterPanel.this.fiscalPrinter.getCapHasVatTable()) {
                            int nv = FiscalPrinterPanel.this.fiscalPrinter.getNumVatRates();
                            int i3 = 1;
                            while (i3 <= nv) {
                                FiscalPrinterPanel.this.vatIdCombo.addItem(String.valueOf(i3));
                                FiscalPrinterPanel.this.vatIdCombo_2.addItem(String.valueOf(i3));
                                ++i3;
                            }
                        } else {
                            FiscalPrinterPanel.this.vatIdCombo.addItem("0");
                            FiscalPrinterPanel.this.vatIdCombo_2.addItem("0");
                        }
                    }
                } else if (source == FiscalPrinterPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        FiscalPrinterPanel.this.fiscalPrinter.setFreezeEvents(false);
                    } else {
                        FiscalPrinterPanel.this.fiscalPrinter.setFreezeEvents(true);
                    }
                } else if (source == FiscalPrinterPanel.this.duplicateReceiptCB) {
                    if (e.getStateChange() == 2) {
                        FiscalPrinterPanel.this.fiscalPrinter.setDuplicateReceipt(false);
                    } else {
                        FiscalPrinterPanel.this.fiscalPrinter.setDuplicateReceipt(true);
                    }
                } else if (source == FiscalPrinterPanel.this.asyncModeCB) {
                    if (e.getStateChange() == 2) {
                        FiscalPrinterPanel.this.fiscalPrinter.setAsyncMode(false);
                    } else {
                        FiscalPrinterPanel.this.fiscalPrinter.setAsyncMode(true);
                    }
                } else if (source == FiscalPrinterPanel.this.checkTotalCB) {
                    if (e.getStateChange() == 2) {
                        FiscalPrinterPanel.this.fiscalPrinter.setCheckTotal(false);
                    } else {
                        FiscalPrinterPanel.this.fiscalPrinter.setCheckTotal(true);
                    }
                } else if (source == FiscalPrinterPanel.this.flagWhenIdleCB) {
                    if (e.getStateChange() == 2) {
                        FiscalPrinterPanel.this.fiscalPrinter.setFlagWhenIdle(false);
                    } else {
                        FiscalPrinterPanel.this.fiscalPrinter.setFlagWhenIdle(true);
                    }
                }
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "Exception in GetPrinter State\nException: " + je.getErrorCode() + "-" + je.getErrorCodeExtended(), "Exception", 0);
                System.err.println("FiscalPrinterPanel: CheckBoxListener: Jpos Exception" + je.getErrorCode() + "-" + je.getErrorCodeExtended());
            }
        }
    }

    class MethodListener
    implements ActionListener {
        MethodListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            block277: {
                FiscalPrinterPanel.this.mainButtonPanel.action(ae);
                String logicalName = FiscalPrinterPanel.this.mainButtonPanel.getLogicalName();
                if (ae.getActionCommand().equals("open")) {
                    try {
                        int version;
                        if (logicalName.equals("")) {
                            logicalName = FiscalPrinterPanel.this.defaultLogicalName;
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.open(logicalName);
                        FiscalPrinterPanel.this.deviceEnabledCB.setEnabled(false);
                        FiscalPrinterPanel.this.freezeEventsCB.setEnabled(true);
                        FiscalPrinterPanel.this.duplicateReceiptCB.setEnabled(true);
                        FiscalPrinterPanel.this.asyncModeCB.setEnabled(true);
                        FiscalPrinterPanel.this.checkTotalCB.setEnabled(true);
                        FiscalPrinterPanel.this.flagWhenIdleCB.setEnabled(true);
                        boolean dupRec = FiscalPrinterPanel.this.fiscalPrinter.getDuplicateReceipt();
                        if (dupRec) {
                            FiscalPrinterPanel.this.duplicateReceiptCB.doClick();
                        }
                        if ((version = FiscalPrinterPanel.this.fiscalPrinter.getDeviceServiceVersion()) >= 1009000) {
                            FiscalPrinterPanel.this.ver_19_complient = true;
                            FiscalPrinterPanel.this.ver_18_complient = true;
                        }
                        if (version >= 1008000) {
                            FiscalPrinterPanel.this.ver_18_complient = true;
                        }
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("claim")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.claim(0);
                        FiscalPrinterPanel.this.paymantFormCombo.removeAllItems();
                        FiscalPrinterPanel.this.vatIdCombo.removeAllItems();
                        FiscalPrinterPanel.this.vatIdCombo_2.removeAllItems();
                        FiscalPrinterPanel.this.setEnableButtonTo(true);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("release")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.release();
                        FiscalPrinterPanel.this.setEnableButtonTo(false);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("close")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.close();
                        FiscalPrinterPanel.this.setEnableButtonTo(false);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("clearOutPut")) {
                    FiscalPrinterPanel.this.itemListModel.clear();
                } else if (ae.getActionCommand().equals("info")) {
                    try {
                        String ver = new Integer(FiscalPrinterPanel.this.fiscalPrinter.getDeviceServiceVersion()).toString();
                        String msg = "Service Description: " + FiscalPrinterPanel.this.fiscalPrinter.getDeviceServiceDescription();
                        msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                        ver = new Integer(FiscalPrinterPanel.this.fiscalPrinter.getDeviceControlVersion()).toString();
                        msg = String.valueOf(msg) + "\n\nControl Description: " + FiscalPrinterPanel.this.fiscalPrinter.getDeviceControlDescription();
                        msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                        msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + FiscalPrinterPanel.this.fiscalPrinter.getPhysicalDeviceName();
                        msg = String.valueOf(msg) + "\nPhysical Device Description: " + FiscalPrinterPanel.this.fiscalPrinter.getPhysicalDeviceDescription();
                        msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                        if (FiscalPrinterPanel.this.ver_18_complient) {
                            msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + FiscalPrinterPanel.this.fiscalPrinter.getCapStatisticsReporting();
                            msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + FiscalPrinterPanel.this.fiscalPrinter.getCapUpdateStatistics();
                        } else {
                            msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                            msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                        }
                        if (FiscalPrinterPanel.this.ver_19_complient) {
                            msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + FiscalPrinterPanel.this.fiscalPrinter.getCapCompareFirmwareVersion();
                            msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + FiscalPrinterPanel.this.fiscalPrinter.getCapUpdateFirmware();
                        } else {
                            msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                            msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                        }
                        msg = String.valueOf(msg) + "\nCapPowerReporting: " + (FiscalPrinterPanel.this.fiscalPrinter.getCapPowerReporting() == 2 ? "Advanced" : (FiscalPrinterPanel.this.fiscalPrinter.getCapPowerReporting() == 1 ? "Standard" : "None"));
                        JOptionPane.showMessageDialog(null, msg, "Info", 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("stats")) {
                    try {
                        StatisticsDialog dlg = new StatisticsDialog(FiscalPrinterPanel.this.fiscalPrinter);
                        dlg.setVisible(true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                    }
                } else if (ae.getActionCommand().equals("firmware")) {
                    try {
                        FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(FiscalPrinterPanel.this.fiscalPrinter);
                        dlg.setVisible(true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                    }
                } else if (ae.getActionCommand().equals("paymantFormCombo")) {
                    try {
                        FiscalPrinterPanel.this.itemDescription.setText((String)FiscalPrinterPanel.this.paymantFormCombo.getSelectedItem());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception in Payamant Form\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Exception " + e);
                    }
                } else if (ae.getActionCommand().equals("vatIdCombo")) {
                    try {
                        FiscalPrinterPanel.this.itemVatInfo.setText((String)FiscalPrinterPanel.this.vatIdCombo.getSelectedItem());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception in Vat info\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Exception " + e);
                    }
                } else if (ae.getActionCommand().equals("adjustmentTypeCombo")) {
                    try {
                        String S = (String)FiscalPrinterPanel.this.adjustmentTypeCombo.getSelectedItem();
                        FiscalPrinterPanel.this.adjustmentType = 1;
                        if (S.equals(FiscalPrinterPanel.this.adjType[1])) {
                            FiscalPrinterPanel.this.adjustmentType = 2;
                        } else if (S.equals(FiscalPrinterPanel.this.adjType[2])) {
                            FiscalPrinterPanel.this.adjustmentType = 3;
                        } else if (S.equals(FiscalPrinterPanel.this.adjType[3])) {
                            FiscalPrinterPanel.this.adjustmentType = 4;
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception in adjustmentCombo\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Exception " + e);
                    }
                } else if (ae.getActionCommand().equals("reportTypeCombo")) {
                    try {
                        String S = (String)FiscalPrinterPanel.this.reportTypeCombo.getSelectedItem();
                        FiscalPrinterPanel.this.reportType = 1;
                        if (S.equals("DATE")) {
                            FiscalPrinterPanel.this.reportType = 2;
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception in Reporttype\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Exception " + e);
                    }
                } else if (ae.getActionCommand().equals("beginFiscalReceipt")) {
                    try {
                        FiscalPrinterPanel.this.TOTAL = 0L;
                        FiscalPrinterPanel.this.fiscalPrinter.beginFiscalReceipt(true);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Begin Fiscal Receipt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecItem")) {
                    try {
                        String postL;
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        String itPrice = FiscalPrinterPanel.this.itemPrice.getText();
                        String itQuantity = FiscalPrinterPanel.this.itemQuantity.getText();
                        String itUnitPrice = FiscalPrinterPanel.this.itemUnitPrice.getText();
                        String itVatInfo = FiscalPrinterPanel.this.itemVatInfo.getText();
                        String itUnitName = FiscalPrinterPanel.this.unitName.getText();
                        double dprice = Double.parseDouble(itPrice);
                        long price = (long)(dprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        double dUnitPrice = Double.parseDouble(itUnitPrice);
                        long unitPrice = (long)(dUnitPrice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        int vatInfo = 0;
                        if (itVatInfo.length() > 0) {
                            vatInfo = Integer.parseInt(itVatInfo);
                        }
                        FiscalPrinterPanel fiscalPrinterPanel = FiscalPrinterPanel.this;
                        fiscalPrinterPanel.TOTAL = fiscalPrinterPanel.TOTAL + price;
                        double dquantity = Double.parseDouble(itQuantity);
                        int quantity = (int)(dquantity * (double)FiscalPrinterPanel.this.quantityFactorDecimal);
                        String preL = FiscalPrinterPanel.this.preLineTxt.getText();
                        if (preL.length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPreLine(preL);
                        }
                        if ((postL = FiscalPrinterPanel.this.postLineTxt.getText()).length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPostLine(postL);
                        }
                        FiscalPrinterPanel.this.clearFields();
                        FiscalPrinterPanel.this.fiscalPrinter.printRecItem(itDesc, price, quantity, vatInfo, unitPrice, itUnitName);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in printRecItem \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getData")) {
                    try {
                        FiscalPrinterPanel.this.executeGetData();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetData\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("endFiscalReceipt")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.endFiscalReceipt(false);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in End Fiscal Receipt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecItemAdj")) {
                    try {
                        String preL;
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        String itPrice = FiscalPrinterPanel.this.itemAmountPercAdjTxt.getText();
                        String itVatInfo = FiscalPrinterPanel.this.itemVatInfo.getText();
                        double dprice = Double.parseDouble(itPrice);
                        double kFactor = FiscalPrinterPanel.this.amountFactorDecimal;
                        if (FiscalPrinterPanel.this.adjustmentType == 3 || FiscalPrinterPanel.this.adjustmentType == 4) {
                            kFactor = 1.0;
                        }
                        long price = (long)(dprice * kFactor);
                        int vatInfo = 0;
                        if (itVatInfo.length() > 0) {
                            vatInfo = Integer.parseInt(itVatInfo);
                        }
                        if ((preL = FiscalPrinterPanel.this.preLineTxt.getText()).length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPreLine(preL);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecItemAdjustment(FiscalPrinterPanel.this.adjustmentType, itDesc, price, vatInfo);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Begin Fiscal Receipt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecRefund")) {
                    try {
                        String preL;
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        String itPrice = FiscalPrinterPanel.this.itemPrice.getText();
                        String itVatInfo = FiscalPrinterPanel.this.itemVatInfo.getText();
                        double dprice = Double.parseDouble(itPrice);
                        long price = (long)(dprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        int vatInfo = 0;
                        if (itVatInfo.length() > 0) {
                            vatInfo = Integer.parseInt(itVatInfo);
                        }
                        if ((preL = FiscalPrinterPanel.this.preLineTxt.getText()).length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPreLine(preL);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecRefund(itDesc, price, vatInfo);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRecRefund\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecSubTotal")) {
                    try {
                        String itPrice = FiscalPrinterPanel.this.itemPrice.getText();
                        double dprice = Double.parseDouble(itPrice);
                        long price = (long)(dprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        String postL = FiscalPrinterPanel.this.postLineTxt.getText();
                        if (postL.length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPostLine(postL);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecSubtotal(price);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Begin Fiscal Receipt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecTotal")) {
                    try {
                        String itAmountPerc;
                        String postL;
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        String itPrice = FiscalPrinterPanel.this.itemPrice.getText();
                        double dprice = Double.parseDouble(itPrice);
                        long price = (long)(dprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        long __Total = FiscalPrinterPanel.this.TOTAL;
                        if (price < FiscalPrinterPanel.this.TOTAL) {
                            FiscalPrinterPanel fiscalPrinterPanel = FiscalPrinterPanel.this;
                            fiscalPrinterPanel.TOTAL = fiscalPrinterPanel.TOTAL - price;
                        }
                        if ((postL = FiscalPrinterPanel.this.postLineTxt.getText()).length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPostLine(postL);
                        }
                        if ((itAmountPerc = FiscalPrinterPanel.this.itemAmountPercAdjTxt.getText()).length() > 0) {
                            long erratedTotale;
                            double ddprice = Double.parseDouble(itAmountPerc);
                            __Total = erratedTotale = (long)(ddprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecTotal(__Total, price, itDesc);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Print Receipt Total\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecVoid")) {
                    try {
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        FiscalPrinterPanel.this.fiscalPrinter.printRecVoid(itDesc);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRecVoid \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecRefundVoid")) {
                    try {
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        String itPrice = FiscalPrinterPanel.this.itemPrice.getText();
                        String itVatInfo = FiscalPrinterPanel.this.itemVatInfo.getText();
                        double dprice = Double.parseDouble(itPrice);
                        long price = (long)(dprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        int vatInfo = 0;
                        if (itVatInfo.length() > 0) {
                            vatInfo = Integer.parseInt(itVatInfo);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecRefundVoid(itDesc, price, vatInfo);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRefundVoid\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecMessage")) {
                    try {
                        String itMsg = FiscalPrinterPanel.this.recMessageTxt.getText();
                        FiscalPrinterPanel.this.fiscalPrinter.printRecMessage(itMsg);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRecMessage \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("recSubTotalDiscount")) {
                    try {
                        String itAmountPerc = FiscalPrinterPanel.this.itemAmountPercAdjTxt.getText();
                        double dprice = Double.parseDouble(itAmountPerc);
                        double kFactor = FiscalPrinterPanel.this.amountFactorDecimal;
                        if (FiscalPrinterPanel.this.adjustmentType == 3 || FiscalPrinterPanel.this.adjustmentType == 4) {
                            kFactor = 1.0;
                        }
                        long price = (long)(dprice * kFactor);
                        String preL = FiscalPrinterPanel.this.preLineTxt.getText();
                        if (preL.length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPreLine(preL);
                        }
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        FiscalPrinterPanel.this.fiscalPrinter.printRecSubtotalAdjustment(FiscalPrinterPanel.this.adjustmentType, itDesc, price);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRecSubTotalDiscount \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("recSubTotalDiscountVoid")) {
                    try {
                        String itAmountPerc = FiscalPrinterPanel.this.itemAmountPercAdjTxt.getText();
                        double dprice = Double.parseDouble(itAmountPerc);
                        double kFactor = FiscalPrinterPanel.this.amountFactorDecimal;
                        if (FiscalPrinterPanel.this.adjustmentType == 3 || FiscalPrinterPanel.this.adjustmentType == 4) {
                            kFactor = 1.0;
                        }
                        long price = (long)(dprice * kFactor);
                        String preL = FiscalPrinterPanel.this.preLineTxt.getText();
                        if (preL.length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setPreLine(preL);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecSubtotalAdjustVoid(FiscalPrinterPanel.this.adjustmentType, price);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRecSubTotalDiscount \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printRecVoidItem")) {
                    try {
                        String itDesc = FiscalPrinterPanel.this.itemDescription.getText();
                        String itPrice = FiscalPrinterPanel.this.itemPrice.getText();
                        String itQuantity = FiscalPrinterPanel.this.itemQuantity.getText();
                        String itVatInfo = FiscalPrinterPanel.this.itemVatInfo.getText();
                        String amountAdjTxt = FiscalPrinterPanel.this.itemAmountPercAdjTxt.getText();
                        double dprice = Double.parseDouble(itPrice);
                        long price = (long)(dprice * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        double damount = Double.parseDouble(amountAdjTxt);
                        long amount = (long)(damount * (double)FiscalPrinterPanel.this.amountFactorDecimal);
                        double dquantity = Double.parseDouble(itQuantity);
                        int quantity = (int)(dquantity * (double)FiscalPrinterPanel.this.quantityFactorDecimal);
                        int vatInfo = 0;
                        if (itVatInfo.length() > 0) {
                            vatInfo = Integer.parseInt(itVatInfo);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.printRecVoidItem(itDesc, price, quantity, FiscalPrinterPanel.this.adjustmentType, amount, vatInfo);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintRecVoiItem\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printReport")) {
                    try {
                        String repFrom = FiscalPrinterPanel.this.reportFrom.getText();
                        String repTo = FiscalPrinterPanel.this.reportTo.getText();
                        FiscalPrinterPanel.this.fiscalPrinter.printReport(FiscalPrinterPanel.this.reportType, repFrom, repTo);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Print Report\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printXReport")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.printXReport();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintXReport\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printZReport")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.printZReport();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PrintZReport\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printDuplicateRec")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.printDuplicateReceipt();
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Print Duplicate Receipt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("setVatTable")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.setVatTable();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in SetVatTable\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("setPrinterProp")) {
                    try {
                        String sckh;
                        int lineNumber;
                        String s1;
                        String S = FiscalPrinterPanel.this.additionalHeaderTxt.getText();
                        if (S.length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setAdditionalHeader(S);
                        }
                        if ((S = FiscalPrinterPanel.this.additionalTrailerTxt.getText()).length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setAdditionalTrailer(S);
                        }
                        if ((S = FiscalPrinterPanel.this.dateTxt.getText()).length() > 0) {
                            FiscalPrinterPanel.this.fiscalPrinter.setDate(S);
                        }
                        String SST = FiscalPrinterPanel.this.trailerTxt.getText();
                        String SS = FiscalPrinterPanel.this.headerTxt.getText();
                        if (SS.length() > 0) {
                            s1 = FiscalPrinterPanel.this.headerLineNumberTxt.getText();
                            lineNumber = -1;
                            if (s1.length() > 0) {
                                lineNumber = Integer.parseInt(s1);
                            }
                            if (lineNumber > 0) {
                                FiscalPrinterPanel.this.fiscalPrinter.setHeaderLine(lineNumber, SS, FiscalPrinterPanel.this.doubleWidthCB.isSelected());
                            } else {
                                JOptionPane.showMessageDialog(null, "Illegal Line Number", "Exception", 0);
                            }
                        }
                        if (SST.length() > 0) {
                            s1 = FiscalPrinterPanel.this.headerLineNumberTxt.getText();
                            lineNumber = -1;
                            if (s1.length() > 0) {
                                lineNumber = Integer.parseInt(s1);
                            }
                            if (lineNumber > 0) {
                                FiscalPrinterPanel.this.fiscalPrinter.setTrailerLine(lineNumber, SST, FiscalPrinterPanel.this.doubleWidthCB.isSelected());
                            } else {
                                JOptionPane.showMessageDialog(null, "Illegal Line Number", "Exception", 0);
                            }
                        }
                        String SvatId = FiscalPrinterPanel.this.vatIdTxt.getText();
                        String SvatValue = FiscalPrinterPanel.this.vatValueTxt.getText();
                        if (SvatId.length() > 0) {
                            int vatId = Integer.parseInt(SvatId);
                            FiscalPrinterPanel.this.fiscalPrinter.setVatValue(vatId, SvatValue);
                        }
                        if ((sckh = FiscalPrinterPanel.this.checkHealthTxt.getText()).length() > 0) {
                            int chk = Integer.parseInt(sckh);
                            FiscalPrinterPanel.this.fiscalPrinter.checkHealth(chk);
                        }
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Set Property\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("beginNonFiscal")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.beginNonFiscal();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Begin Non Fiscal\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("endNonFiscal")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.endNonFiscal();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in End Non Fiscal\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printNormal")) {
                    try {
                        int station = 2;
                        String txt = FiscalPrinterPanel.this.nonFiscalTxt.getText();
                        FiscalPrinterPanel.this.fiscalPrinter.printNormal(station, txt);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Print Normalt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printPeriodicReport")) {
                    try {
                        String repFrom = FiscalPrinterPanel.this.reportFrom.getText();
                        String repTo = FiscalPrinterPanel.this.reportTo.getText();
                        FiscalPrinterPanel.this.fiscalPrinter.printPeriodicTotalsReport(repFrom, repTo);
                        FiscalPrinterPanel.this.clearFields();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in PeriodicReport\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getDate")) {
                    try {
                        String[] txt = new String[]{""};
                        FiscalPrinterPanel.this.fiscalPrinter.getDate(txt);
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("DATE : " + txt[0]));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetDate\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getErrorLevel")) {
                    try {
                        int errState = FiscalPrinterPanel.this.fiscalPrinter.getErrorState();
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("ERROR STATE : " + String.valueOf(errState)));
                        int errLev = FiscalPrinterPanel.this.fiscalPrinter.getErrorLevel();
                        String str = FiscalPrinterPanel.this.decodeErrorLevel(errLev);
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("ERROR LEVEL : " + str));
                        int errId = FiscalPrinterPanel.this.fiscalPrinter.getErrorOutID();
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("ERROR OUT ID : " + String.valueOf(errId)));
                        int errStat = FiscalPrinterPanel.this.fiscalPrinter.getErrorStation();
                        str = FiscalPrinterPanel.this.decodeErrorStation(errStat);
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("ERROR STATION : " + str));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetPrinter Error Info\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getOutPutId")) {
                    try {
                        int outId = FiscalPrinterPanel.this.fiscalPrinter.getOutputID();
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("OUTPUT ID : " + String.valueOf(outId)));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Get OutputID Level\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getTrainingState")) {
                    try {
                        boolean traiMode = FiscalPrinterPanel.this.fiscalPrinter.getTrainingModeActive();
                        String str = "FALSE";
                        if (traiMode) {
                            str = "TRUE";
                        }
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("TRAINING MODE ACTIVE : " + str));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetTraining State\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("printerStatus")) {
                    try {
                        int tempstate = FiscalPrinterPanel.this.fiscalPrinter.getPrinterState();
                        String str = FiscalPrinterPanel.this.decodeState(tempstate);
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("STATE : " + str));
                        tempstate = FiscalPrinterPanel.this.fiscalPrinter.getState();
                        str = FiscalPrinterPanel.this.decodeDeviceState(tempstate);
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("DEVICE STATE : " + str));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetPrinter State\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("dayOpened")) {
                    try {
                        boolean dayOpened = FiscalPrinterPanel.this.fiscalPrinter.getDayOpened();
                        String str = dayOpened ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("DAY OPENED : " + str));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetPrinter State\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("remainingFiscalMemory")) {
                    try {
                        int remFiscMem = FiscalPrinterPanel.this.fiscalPrinter.getRemainingFiscalMemory();
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("Rem. Fisc. Memory : " + String.valueOf(remFiscMem)));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in GetPrinter State\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("clearOut")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.clearOutput();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Clear Output\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("clearError")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.clearError();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Clear Error\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("showProperty")) {
                    try {
                        boolean jrnEmpty = FiscalPrinterPanel.this.fiscalPrinter.getJrnEmpty();
                        String str = jrnEmpty ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("JrnEMPTY : " + str));
                        boolean jrnNearEnd = FiscalPrinterPanel.this.fiscalPrinter.getJrnNearEnd();
                        str = jrnNearEnd ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("JrnNEAREND : " + str));
                        boolean recEmpty = FiscalPrinterPanel.this.fiscalPrinter.getRecEmpty();
                        str = recEmpty ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("recEMPTY : " + str));
                        boolean recNearEnd = FiscalPrinterPanel.this.fiscalPrinter.getRecNearEnd();
                        str = recNearEnd ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.itemListModel.addElement(new String("recNEAREND : " + str));
                        if (FiscalPrinterPanel.this.fiscalPrinter.getCapHasVatTable()) {
                            int nv = FiscalPrinterPanel.this.fiscalPrinter.getNumVatRates();
                            int[] v = new int[1];
                            int i = 1;
                            while (i <= nv) {
                                FiscalPrinterPanel.this.fiscalPrinter.getVatEntry(i, 0, v);
                                FiscalPrinterPanel.this.itemListModel.addElement(new String("Vat ID: " + String.valueOf(i) + " - Value : " + String.valueOf(v[0])));
                                ++i;
                            }
                        }
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in ShowProperty\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getTotalizer")) {
                    try {
                        String labStr;
                        String[] str = new String[]{""};
                        String[] valStr = new String[]{""};
                        if (FiscalPrinterPanel.this.grandTotalizerRB.isSelected()) {
                            FiscalPrinterPanel.this.fiscalPrinter.setTotalizerType(4);
                            labStr = "GRAND TOTAL - ";
                        } else {
                            FiscalPrinterPanel.this.fiscalPrinter.setTotalizerType(2);
                            labStr = "DAY TOTAL - ";
                        }
                        int totalizerType = FiscalPrinterPanel.this.getTotalizerType(str);
                        String tempVatid = (String)FiscalPrinterPanel.this.vatIdCombo_2.getSelectedItem();
                        int vatid = Integer.parseInt(tempVatid);
                        FiscalPrinterPanel.this.fiscalPrinter.getTotalizer(vatid, totalizerType, valStr);
                        FiscalPrinterPanel.this.itemListModel.addElement(new String(String.valueOf(labStr) + str[0] + valStr[0]));
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Get Totalizer\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("beginTraining")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.beginTraining();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in BeginTraning\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("endTraining")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.endTraining();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Endtraning\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getPropList")) {
                    try {
                        String s;
                        FiscalPrinterPanel.this.propListModel.clear();
                        int cc = FiscalPrinterPanel.this.fiscalPrinter.getCountryCode();
                        FiscalPrinterPanel.this.propListModel.addElement(FiscalPrinterPanel.this.decodeCountryCode(cc));
                        cc = FiscalPrinterPanel.this.fiscalPrinter.getDescriptionLength();
                        FiscalPrinterPanel.this.propListModel.addElement("Description Length : " + String.valueOf(cc));
                        cc = FiscalPrinterPanel.this.fiscalPrinter.getMessageLength();
                        FiscalPrinterPanel.this.propListModel.addElement("Message Length : " + String.valueOf(cc));
                        cc = FiscalPrinterPanel.this.fiscalPrinter.getNumHeaderLines();
                        FiscalPrinterPanel.this.propListModel.addElement("Num. Header Lines : " + String.valueOf(cc));
                        if (FiscalPrinterPanel.this.fiscalPrinter.getCapPredefinedPaymentLines()) {
                            s = FiscalPrinterPanel.this.fiscalPrinter.getPredefinedPaymentLines();
                            FiscalPrinterPanel.this.propListModel.addElement("Pred. Payment Lines : " + s);
                        } else {
                            FiscalPrinterPanel.this.propListModel.addElement("Pred. Payment Lines : NOT Supported");
                        }
                        cc = FiscalPrinterPanel.this.fiscalPrinter.getQuantityDecimalPlaces();
                        FiscalPrinterPanel.this.propListModel.addElement("Quantity Dec. Places : " + String.valueOf(cc));
                        cc = FiscalPrinterPanel.this.fiscalPrinter.getQuantityLength();
                        FiscalPrinterPanel.this.propListModel.addElement("Quantity Length : " + String.valueOf(cc));
                        s = FiscalPrinterPanel.this.fiscalPrinter.getReservedWord();
                        FiscalPrinterPanel.this.propListModel.addElement("Reserved Word : " + s);
                        FiscalPrinterPanel.this.propListModel.addElement("********** Capability **********");
                        boolean b = FiscalPrinterPanel.this.fiscalPrinter.getCapAdditionalLines();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapAdditionalLines : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapAmountAdjustment();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapAmountAdjustment : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapAmountNotPaid();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapAmountNotPaid : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapChangeDue();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapChangeDue : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapCheckTotal();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapCheckTotal : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapJrnEmptySensor();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapJrnEmptySensor : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapJrnNearEndSensor();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapJrnNearEndSensor : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapPredefinedPaymentLines();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapPredefinedPaymentLines : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapRecEmptySensor();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapRecEmptySensor : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapRecPresent();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapRecPresent : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapReservedWord();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapReservedWord : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapRemainingFiscalMemory();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapRemainingFiscalMemory : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSetHeader();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSetHeader : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSetPOSID();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSetPOSID : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSetTrailer();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSetTrailer : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSetVatTable();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSetVatTable : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSubAmountAdjustment();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSubAmountAdjustment : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSubPercentAdjustment();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSubPercentAdjustment : " + s));
                        b = FiscalPrinterPanel.this.fiscalPrinter.getCapSubtotal();
                        s = b ? "TRUE" : "FALSE";
                        FiscalPrinterPanel.this.propListModel.addElement(new String("CapSubtotal : " + s));
                        FiscalPrinterPanel.this.propListModel.addElement("--------------------------------");
                        if (FiscalPrinterPanel.this.fiscalPrinter.getDeviceEnabled()) {
                            cc = FiscalPrinterPanel.this.fiscalPrinter.getMessageType();
                            FiscalPrinterPanel.this.propListModel.addElement("Message Type :" + FiscalPrinterPanel.this.decodeTypeMessage(cc));
                            cc = FiscalPrinterPanel.this.fiscalPrinter.getAmountDecimalPlace();
                            FiscalPrinterPanel.this.propListModel.addElement("Amount Dec. Places : " + String.valueOf(cc));
                            break block277;
                        }
                        FiscalPrinterPanel.this.propListModel.addElement("For others properties enable device");
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Get Property \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("directIoButton")) {
                    try {
                        String s1 = FiscalPrinterPanel.this.directIoCommand.getText();
                        String s2 = FiscalPrinterPanel.this.directIoData.getText();
                        String s3 = FiscalPrinterPanel.this.directIoObject.getText();
                        StringBuffer sb = new StringBuffer(s3);
                        int dC = 0;
                        int[] dD = new int[1];
                        try {
                            dC = Integer.parseInt(s1);
                            dD[0] = Integer.parseInt(s2);
                            FiscalPrinterPanel.this.clearFields();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, "Dati Errati \nException: " + e.getMessage(), "Exception", 0);
                        }
                        FiscalPrinterPanel.this.fiscalPrinter.directIO(dC, dD, (Object)sb);
                        FiscalPrinterPanel.this.directIoData.setText(String.valueOf(dD[0]));
                        FiscalPrinterPanel.this.directIoObject.setText(sb.toString());
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in DirectIO \nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getAdditionalHeader")) {
                    try {
                        String s = FiscalPrinterPanel.this.fiscalPrinter.getAdditionalHeader();
                        FiscalPrinterPanel.this.propListModel.addElement("Additional Header : " + s);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in getAdditionalHeader\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("getAdditionalTrailer")) {
                    try {
                        String s = FiscalPrinterPanel.this.fiscalPrinter.getAdditionalTrailer();
                        FiscalPrinterPanel.this.propListModel.addElement("Additional Trailer : " + s);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in getAdditionalTrailer\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("resetPrinter")) {
                    try {
                        FiscalPrinterPanel.this.fiscalPrinter.resetPrinter();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in resetPrinter\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("clearFieldsButton")) {
                    FiscalPrinterPanel.this.clearFields();
                } else if (ae.getActionCommand().equals("getCheckHealth")) {
                    try {
                        String s = FiscalPrinterPanel.this.fiscalPrinter.getCheckHealthText();
                        FiscalPrinterPanel.this.propListModel.addElement("CheckHealthText : " + s);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in getCheckHealth\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                }
            }
            try {
                if (FiscalPrinterPanel.this.deviceEnabledCB.isSelected()) {
                    FiscalPrinterPanel.this.deviceEnabledCB.setSelected(FiscalPrinterPanel.this.fiscalPrinter.getDeviceEnabled());
                    FiscalPrinterPanel.this.freezeEventsCB.setSelected(FiscalPrinterPanel.this.fiscalPrinter.getFreezeEvents());
                }
            }
            catch (JposException je) {
                System.err.println("FiscalPrinterPanel: MethodListener: JposException");
            }
        }
    }

    class DirectIOPanel
    extends Component {
        private static final long serialVersionUID = 9108485289446253369L;

        DirectIOPanel() {
        }

        public Component make() {
            JPanel labelPanel = new JPanel();
            labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            FiscalPrinterPanel.this.label = new JLabel("Number");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(80, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(80, 17));
            labelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Data");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(80, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(80, 17));
            labelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("String");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(80, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(80, 17));
            labelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel(" ");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(80, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(80, 17));
            labelPanel.add(FiscalPrinterPanel.this.label);
            JPanel dataPanel = new JPanel();
            dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            dataPanel.setLayout(new BoxLayout(dataPanel, 1));
            FiscalPrinterPanel.this.directIoCommand = new JTextField();
            FiscalPrinterPanel.this.directIoCommand.setMaximumSize(new Dimension(80, 18));
            FiscalPrinterPanel.this.directIoCommand.setPreferredSize(new Dimension(80, 18));
            FiscalPrinterPanel.this.directIoCommand.setMinimumSize(new Dimension(80, 18));
            FiscalPrinterPanel.this.directIoCommand.setText("0");
            FiscalPrinterPanel.this.directIoCommand.setAlignmentX(0.0f);
            dataPanel.add(FiscalPrinterPanel.this.directIoCommand);
            FiscalPrinterPanel.this.directIoData = new JTextField();
            FiscalPrinterPanel.this.directIoData.setMaximumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.directIoData.setPreferredSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.directIoData.setMinimumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.directIoData.setAlignmentX(0.0f);
            dataPanel.add(FiscalPrinterPanel.this.directIoData);
            FiscalPrinterPanel.this.directIoObject = new JTextField();
            FiscalPrinterPanel.this.directIoObject.setMaximumSize(new Dimension(500, 18));
            FiscalPrinterPanel.this.directIoObject.setPreferredSize(new Dimension(500, 18));
            FiscalPrinterPanel.this.directIoObject.setMinimumSize(new Dimension(450, 18));
            FiscalPrinterPanel.this.directIoObject.setAlignmentX(0.0f);
            dataPanel.add(FiscalPrinterPanel.this.directIoObject);
            FiscalPrinterPanel.this.directIoButton = new JButton("Direct IO");
            FiscalPrinterPanel.this.directIoButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.directIoButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.directIoButton.setActionCommand("directIoButton");
            FiscalPrinterPanel.this.directIoButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.directIoButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.directIoButton.setEnabled(false);
            dataPanel.add(FiscalPrinterPanel.this.directIoButton);
            FiscalPrinterPanel.this.clearFieldsButton = new JButton("Clear Fields");
            FiscalPrinterPanel.this.clearFieldsButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.clearFieldsButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.clearFieldsButton.setActionCommand("clearFieldsButton");
            FiscalPrinterPanel.this.clearFieldsButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.clearFieldsButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.clearFieldsButton.setEnabled(true);
            dataPanel.add(FiscalPrinterPanel.this.clearFieldsButton);
            JPanel directIOPanel = new JPanel();
            directIOPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            directIOPanel.setLayout(new BoxLayout(directIOPanel, 0));
            directIOPanel.add(labelPanel);
            directIOPanel.add(dataPanel);
            return directIOPanel;
        }
    }

    class NonFiscalPanel
    extends Component {
        private static final long serialVersionUID = -8116838958814524668L;

        NonFiscalPanel() {
        }

        public Component make() {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            FiscalPrinterPanel.this.beginNonFiscalButton = new JButton("Begin Non Fiscal");
            FiscalPrinterPanel.this.beginNonFiscalButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.beginNonFiscalButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.beginNonFiscalButton.setActionCommand("beginNonFiscal");
            FiscalPrinterPanel.this.beginNonFiscalButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.beginNonFiscalButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.beginNonFiscalButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.beginNonFiscalButton);
            FiscalPrinterPanel.this.printNormalButton = new JButton("Print   Normal");
            FiscalPrinterPanel.this.printNormalButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printNormalButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printNormalButton.setActionCommand("printNormal");
            FiscalPrinterPanel.this.printNormalButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printNormalButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printNormalButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printNormalButton);
            FiscalPrinterPanel.this.endNonFiscalButton = new JButton("End Non Fiscal");
            FiscalPrinterPanel.this.endNonFiscalButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.endNonFiscalButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.endNonFiscalButton.setActionCommand("endNonFiscal");
            FiscalPrinterPanel.this.endNonFiscalButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.endNonFiscalButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.endNonFiscalButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.endNonFiscalButton);
            JPanel itemLabelPanel = new JPanel();
            itemLabelPanel.setLayout(new BoxLayout(itemLabelPanel, 1));
            itemLabelPanel.setAlignmentX(1.0f);
            itemLabelPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Text");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            JPanel itemFieldPanel = new JPanel();
            itemFieldPanel.setLayout(new BoxLayout(itemFieldPanel, 1));
            itemFieldPanel.setAlignmentX(0.0f);
            itemFieldPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.nonFiscalTxt = new JTextArea(50, 40);
            FiscalPrinterPanel.this.nonFiscalTxt.setMaximumSize(new Dimension(300, 200));
            FiscalPrinterPanel.this.nonFiscalTxt.setPreferredSize(new Dimension(300, 200));
            FiscalPrinterPanel.this.nonFiscalTxt.setMinimumSize(new Dimension(300, 200));
            itemFieldPanel.add((Component)new JScrollPane(FiscalPrinterPanel.this.nonFiscalTxt), "Center");
            JPanel nonFiscalControlPanel = new JPanel();
            nonFiscalControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            nonFiscalControlPanel.setLayout(new BoxLayout(nonFiscalControlPanel, 0));
            nonFiscalControlPanel.add(buttonPanel);
            nonFiscalControlPanel.add(itemLabelPanel);
            nonFiscalControlPanel.add(itemFieldPanel);
            return nonFiscalControlPanel;
        }
    }

    class FiscalPrinterSettingPanel
    extends Component {
        private static final long serialVersionUID = 699060709578537513L;

        FiscalPrinterSettingPanel() {
        }

        public Component make() {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            FiscalPrinterPanel.this.label = new JLabel("Additional Trailer");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Additional Header");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Date");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Header");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Trailer");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Line Number");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Vat ID");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Vat Value (% * 100)");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Check Health");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            buttonPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.setPrinterProp = new JButton("Set Printer");
            FiscalPrinterPanel.this.setPrinterProp.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.setPrinterProp.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.setPrinterProp.setActionCommand("setPrinterProp");
            FiscalPrinterPanel.this.setPrinterProp.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.setPrinterProp.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.setPrinterProp.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.setPrinterProp);
            FiscalPrinterPanel.this.setVatTableButton = new JButton("Set VatTable");
            FiscalPrinterPanel.this.setVatTableButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.setVatTableButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.setVatTableButton.setActionCommand("setVatTable");
            FiscalPrinterPanel.this.setVatTableButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.setVatTableButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.setVatTableButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.setVatTableButton);
            JPanel itemFieldPanel = new JPanel();
            itemFieldPanel.setLayout(new BoxLayout(itemFieldPanel, 1));
            itemFieldPanel.setAlignmentX(0.0f);
            itemFieldPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.additionalTrailerTxt = new JTextField();
            FiscalPrinterPanel.this.additionalTrailerTxt.setMaximumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.additionalTrailerTxt.setPreferredSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.additionalTrailerTxt.setMinimumSize(new Dimension(160, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.additionalTrailerTxt);
            FiscalPrinterPanel.this.additionalHeaderTxt = new JTextField();
            FiscalPrinterPanel.this.additionalHeaderTxt.setMaximumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.additionalHeaderTxt.setPreferredSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.additionalHeaderTxt.setMinimumSize(new Dimension(160, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.additionalHeaderTxt);
            FiscalPrinterPanel.this.dateTxt = new JTextField();
            FiscalPrinterPanel.this.dateTxt.setMaximumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.dateTxt.setPreferredSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.dateTxt.setMinimumSize(new Dimension(160, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.dateTxt);
            FiscalPrinterPanel.this.headerTxt = new JTextField();
            FiscalPrinterPanel.this.headerTxt.setMaximumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.headerTxt.setPreferredSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.headerTxt.setMinimumSize(new Dimension(160, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.headerTxt);
            FiscalPrinterPanel.this.trailerTxt = new JTextField();
            FiscalPrinterPanel.this.trailerTxt.setMaximumSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.trailerTxt.setPreferredSize(new Dimension(160, 18));
            FiscalPrinterPanel.this.trailerTxt.setMinimumSize(new Dimension(160, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.trailerTxt);
            FiscalPrinterPanel.this.headerLineNumberTxt = new JTextField();
            FiscalPrinterPanel.this.headerLineNumberTxt.setMaximumSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.headerLineNumberTxt.setPreferredSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.headerLineNumberTxt.setMinimumSize(new Dimension(50, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.headerLineNumberTxt);
            FiscalPrinterPanel.this.vatIdTxt = new JTextField();
            FiscalPrinterPanel.this.vatIdTxt.setMaximumSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.vatIdTxt.setPreferredSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.vatIdTxt.setMinimumSize(new Dimension(50, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.vatIdTxt);
            FiscalPrinterPanel.this.vatValueTxt = new JTextField();
            FiscalPrinterPanel.this.vatValueTxt.setMaximumSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.vatValueTxt.setPreferredSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.vatValueTxt.setMinimumSize(new Dimension(50, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.vatValueTxt);
            FiscalPrinterPanel.this.checkHealthTxt = new JTextField();
            FiscalPrinterPanel.this.checkHealthTxt.setMaximumSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.checkHealthTxt.setPreferredSize(new Dimension(50, 18));
            FiscalPrinterPanel.this.checkHealthTxt.setMinimumSize(new Dimension(50, 18));
            itemFieldPanel.add(FiscalPrinterPanel.this.checkHealthTxt);
            FiscalPrinterPanel.this.label = new JLabel("");
            FiscalPrinterPanel.this.label.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.doubleWidthCB = new JCheckBox("Set Double Width");
            FiscalPrinterPanel.this.doubleWidthCB.setMaximumSize(new Dimension(160, 14));
            FiscalPrinterPanel.this.doubleWidthCB.setPreferredSize(new Dimension(160, 14));
            FiscalPrinterPanel.this.doubleWidthCB.setMinimumSize(new Dimension(160, 14));
            FiscalPrinterPanel.this.doubleWidthCB.setAlignmentX(0.5f);
            itemFieldPanel.add(FiscalPrinterPanel.this.doubleWidthCB);
            JPanel propListPanel = new JPanel();
            propListPanel.setLayout(new BoxLayout(propListPanel, 1));
            propListPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Property : ");
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.propListModel = new DefaultListModel();
            FiscalPrinterPanel.this.propList = new JList(FiscalPrinterPanel.this.propListModel);
            FiscalPrinterPanel.this.propList.setSelectionMode(1);
            FiscalPrinterPanel.this.propList.setLayoutOrientation(0);
            FiscalPrinterPanel.this.propList.setVisibleRowCount(7);
            JScrollPane windowScrollPane = new JScrollPane(FiscalPrinterPanel.this.propList);
            windowScrollPane.setMinimumSize(new Dimension(200, 250));
            windowScrollPane.setPreferredSize(new Dimension(350, 300));
            windowScrollPane.setMaximumSize(new Dimension(350, 300));
            propListPanel.add(FiscalPrinterPanel.this.label);
            propListPanel.add(windowScrollPane);
            FiscalPrinterPanel.this.getPropListButton = new JButton("Get Property");
            FiscalPrinterPanel.this.getPropListButton.setMaximumSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getPropListButton.setPreferredSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getPropListButton.setActionCommand("getPropList");
            FiscalPrinterPanel.this.getPropListButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getPropListButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getPropListButton.setEnabled(false);
            propListPanel.add(FiscalPrinterPanel.this.getPropListButton);
            FiscalPrinterPanel.this.getAdditionalHeaderButton = new JButton("Get Additional Header");
            FiscalPrinterPanel.this.getAdditionalHeaderButton.setMaximumSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getAdditionalHeaderButton.setPreferredSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getAdditionalHeaderButton.setActionCommand("getAdditionalHeader");
            FiscalPrinterPanel.this.getAdditionalHeaderButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getAdditionalHeaderButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getAdditionalHeaderButton.setEnabled(false);
            propListPanel.add(FiscalPrinterPanel.this.getAdditionalHeaderButton);
            FiscalPrinterPanel.this.getAdditionalTrailerButton = new JButton("Get Additional Trailer");
            FiscalPrinterPanel.this.getAdditionalTrailerButton.setMaximumSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getAdditionalTrailerButton.setPreferredSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getAdditionalTrailerButton.setActionCommand("getAdditionalTrailer");
            FiscalPrinterPanel.this.getAdditionalTrailerButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getAdditionalTrailerButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getAdditionalTrailerButton.setEnabled(false);
            propListPanel.add(FiscalPrinterPanel.this.getAdditionalTrailerButton);
            FiscalPrinterPanel.this.getCheckHealthButton = new JButton("Get CheckHealth");
            FiscalPrinterPanel.this.getCheckHealthButton.setMaximumSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getCheckHealthButton.setPreferredSize(new Dimension(200, 17));
            FiscalPrinterPanel.this.getCheckHealthButton.setActionCommand("getCheckHealth");
            FiscalPrinterPanel.this.getCheckHealthButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getCheckHealthButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getCheckHealthButton.setEnabled(false);
            propListPanel.add(FiscalPrinterPanel.this.getCheckHealthButton);
            JPanel fiscalPtrSettingControlPanel = new JPanel();
            fiscalPtrSettingControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            fiscalPtrSettingControlPanel.setLayout(new BoxLayout(fiscalPtrSettingControlPanel, 0));
            fiscalPtrSettingControlPanel.add(buttonPanel);
            fiscalPtrSettingControlPanel.add(itemFieldPanel);
            fiscalPtrSettingControlPanel.add(propListPanel);
            return fiscalPtrSettingControlPanel;
        }
    }

    class FiscalReceiptPanel
    extends Component {
        private static final long serialVersionUID = 1191991536139213593L;

        FiscalReceiptPanel() {
        }

        public Component make() {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            FiscalPrinterPanel.this.beginFiscalReceiptButton = new JButton("Begin Fiscal Receipt");
            FiscalPrinterPanel.this.beginFiscalReceiptButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.beginFiscalReceiptButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.beginFiscalReceiptButton.setActionCommand("beginFiscalReceipt");
            FiscalPrinterPanel.this.beginFiscalReceiptButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.beginFiscalReceiptButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.beginFiscalReceiptButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.beginFiscalReceiptButton);
            FiscalPrinterPanel.this.printRecItemButton = new JButton("Print   Receipt   Item");
            FiscalPrinterPanel.this.printRecItemButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecItemButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecItemButton.setActionCommand("printRecItem");
            FiscalPrinterPanel.this.printRecItemButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecItemButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecItemButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecItemButton);
            FiscalPrinterPanel.this.printRecItemAdjButton = new JButton("Print Rec Adj  Item");
            FiscalPrinterPanel.this.printRecItemAdjButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecItemAdjButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecItemAdjButton.setActionCommand("printRecItemAdj");
            FiscalPrinterPanel.this.printRecItemAdjButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecItemAdjButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecItemAdjButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecItemAdjButton);
            FiscalPrinterPanel.this.printRecRefundButton = new JButton("Print Receipt Refund");
            FiscalPrinterPanel.this.printRecRefundButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecRefundButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecRefundButton.setActionCommand("printRecRefund");
            FiscalPrinterPanel.this.printRecRefundButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecRefundButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecRefundButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecRefundButton);
            FiscalPrinterPanel.this.printRecRefundVoidButton = new JButton("Print RecRef. Void");
            FiscalPrinterPanel.this.printRecRefundVoidButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecRefundVoidButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecRefundVoidButton.setActionCommand("printRecRefundVoid");
            FiscalPrinterPanel.this.printRecRefundVoidButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecRefundVoidButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecRefundVoidButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecRefundVoidButton);
            FiscalPrinterPanel.this.printRecTotalButton = new JButton("Print Receipt Total");
            FiscalPrinterPanel.this.printRecTotalButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecTotalButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecTotalButton.setActionCommand("printRecTotal");
            FiscalPrinterPanel.this.printRecTotalButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecTotalButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecTotalButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecTotalButton);
            FiscalPrinterPanel.this.printRecSubTotalButton = new JButton("Print Receipt SubT.");
            FiscalPrinterPanel.this.printRecSubTotalButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecSubTotalButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecSubTotalButton.setActionCommand("printRecSubTotal");
            FiscalPrinterPanel.this.printRecSubTotalButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecSubTotalButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecSubTotalButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecSubTotalButton);
            FiscalPrinterPanel.this.printRecVoidButton = new JButton("Print Receipt Void");
            FiscalPrinterPanel.this.printRecVoidButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecVoidButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecVoidButton.setActionCommand("printRecVoid");
            FiscalPrinterPanel.this.printRecVoidButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecVoidButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecVoidButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecVoidButton);
            FiscalPrinterPanel.this.printRecVoidItemButton = new JButton("Print Rec. Void Item");
            FiscalPrinterPanel.this.printRecVoidItemButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecVoidItemButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecVoidItemButton.setActionCommand("printRecVoidItem");
            FiscalPrinterPanel.this.printRecVoidItemButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecVoidItemButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecVoidItemButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecVoidItemButton);
            FiscalPrinterPanel.this.recSubTotalDiscountButton = new JButton("Rec. SubTotal Adj.");
            FiscalPrinterPanel.this.recSubTotalDiscountButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.recSubTotalDiscountButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.recSubTotalDiscountButton.setActionCommand("recSubTotalDiscount");
            FiscalPrinterPanel.this.recSubTotalDiscountButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.recSubTotalDiscountButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.recSubTotalDiscountButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.recSubTotalDiscountButton);
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton = new JButton("Rec. SubT. Adj. Void");
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton.setActionCommand("recSubTotalDiscountVoid");
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.recSubTotalDiscountVoidButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.recSubTotalDiscountVoidButton);
            FiscalPrinterPanel.this.printRecMessageButton = new JButton("Print Rec. Message");
            FiscalPrinterPanel.this.printRecMessageButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecMessageButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printRecMessageButton.setActionCommand("printRecMessage");
            FiscalPrinterPanel.this.printRecMessageButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printRecMessageButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printRecMessageButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printRecMessageButton);
            FiscalPrinterPanel.this.printDuplicateRecButton = new JButton("Duplicate Receipt");
            FiscalPrinterPanel.this.printDuplicateRecButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printDuplicateRecButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printDuplicateRecButton.setActionCommand("printDuplicateRec");
            FiscalPrinterPanel.this.printDuplicateRecButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printDuplicateRecButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printDuplicateRecButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printDuplicateRecButton);
            FiscalPrinterPanel.this.endFiscalReceiptButton = new JButton("End  Fiscal   Receipt");
            FiscalPrinterPanel.this.endFiscalReceiptButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.endFiscalReceiptButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.endFiscalReceiptButton.setActionCommand("endFiscalReceipt");
            FiscalPrinterPanel.this.endFiscalReceiptButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.endFiscalReceiptButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.endFiscalReceiptButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.endFiscalReceiptButton);
            JPanel itemLabelPanel = new JPanel();
            itemLabelPanel.setLayout(new BoxLayout(itemLabelPanel, 1));
            itemLabelPanel.setAlignmentX(1.0f);
            itemLabelPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Receipt Message");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("PreLine Text");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("PostLine Text");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Description");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Price-Amount");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Quantity");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Unit Price");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Vat Info");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Unit Name");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Amount - Adj.");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            JPanel itemFieldPanel = new JPanel();
            itemFieldPanel.setLayout(new BoxLayout(itemFieldPanel, 1));
            itemFieldPanel.setAlignmentX(0.0f);
            itemFieldPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.recMessageTxt = new JTextField();
            FiscalPrinterPanel.this.recMessageTxt.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.recMessageTxt.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.recMessageTxt.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.recMessageTxt);
            FiscalPrinterPanel.this.preLineTxt = new JTextField();
            FiscalPrinterPanel.this.preLineTxt.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.preLineTxt.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.preLineTxt.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.preLineTxt);
            FiscalPrinterPanel.this.postLineTxt = new JTextField();
            FiscalPrinterPanel.this.postLineTxt.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.postLineTxt.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.postLineTxt.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.postLineTxt);
            FiscalPrinterPanel.this.itemDescription = new JTextField();
            FiscalPrinterPanel.this.itemDescription.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemDescription.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemDescription.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.itemDescription);
            FiscalPrinterPanel.this.itemPrice = new JTextField();
            FiscalPrinterPanel.this.itemPrice.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemPrice.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemPrice.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.itemPrice);
            FiscalPrinterPanel.this.itemQuantity = new JTextField();
            FiscalPrinterPanel.this.itemQuantity.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemQuantity.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemQuantity.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.itemQuantity);
            FiscalPrinterPanel.this.itemUnitPrice = new JTextField();
            FiscalPrinterPanel.this.itemUnitPrice.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemUnitPrice.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemUnitPrice.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.itemUnitPrice);
            FiscalPrinterPanel.this.itemVatInfo = new JTextField();
            FiscalPrinterPanel.this.itemVatInfo.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemVatInfo.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemVatInfo.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.itemVatInfo);
            FiscalPrinterPanel.this.unitName = new JTextField();
            FiscalPrinterPanel.this.unitName.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.unitName.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.unitName.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.unitName);
            FiscalPrinterPanel.this.itemAmountPercAdjTxt = new JTextField();
            FiscalPrinterPanel.this.itemAmountPercAdjTxt.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemAmountPercAdjTxt.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.itemAmountPercAdjTxt.setMinimumSize(new Dimension(160, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.itemAmountPercAdjTxt);
            JPanel comboPanel = new JPanel();
            comboPanel.setLayout(new BoxLayout(comboPanel, 1));
            comboPanel.setAlignmentX(0.0f);
            comboPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Payament Forms :");
            FiscalPrinterPanel.this.label.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(130, 22));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(130, 22));
            comboPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.paymantFormCombo = new JComboBox();
            FiscalPrinterPanel.this.paymantFormCombo.setMaximumSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.paymantFormCombo.setPreferredSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.paymantFormCombo.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.paymantFormCombo.setActionCommand("paymantFormCombo");
            FiscalPrinterPanel.this.paymantFormCombo.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.paymantFormCombo.setEnabled(false);
            comboPanel.add(FiscalPrinterPanel.this.paymantFormCombo);
            FiscalPrinterPanel.this.label = new JLabel("Vat ID :");
            FiscalPrinterPanel.this.label.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(130, 22));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(130, 22));
            comboPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.vatIdCombo = new JComboBox();
            FiscalPrinterPanel.this.vatIdCombo.setMaximumSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.vatIdCombo.setPreferredSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.vatIdCombo.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.vatIdCombo.setActionCommand("vatIdCombo");
            FiscalPrinterPanel.this.vatIdCombo.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.vatIdCombo.setEnabled(false);
            comboPanel.add(FiscalPrinterPanel.this.vatIdCombo);
            FiscalPrinterPanel.this.label = new JLabel("Adjustment Type :");
            FiscalPrinterPanel.this.label.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(130, 22));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(130, 22));
            comboPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.adjustmentTypeCombo = new JComboBox();
            FiscalPrinterPanel.this.adjustmentTypeCombo.setMaximumSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.adjustmentTypeCombo.setPreferredSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.adjustmentTypeCombo.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.adjustmentTypeCombo.setActionCommand("adjustmentTypeCombo");
            FiscalPrinterPanel.this.adjustmentTypeCombo.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.adjustmentTypeCombo.setEnabled(true);
            int i = 0;
            while (i < FiscalPrinterPanel.this.numAdjType) {
                FiscalPrinterPanel.this.adjustmentTypeCombo.addItem(FiscalPrinterPanel.this.adjType[i]);
                ++i;
            }
            comboPanel.add(FiscalPrinterPanel.this.adjustmentTypeCombo);
            JPanel fiscalReceiptControlPanel = new JPanel();
            fiscalReceiptControlPanel.setAlignmentX(0.5f);
            fiscalReceiptControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            fiscalReceiptControlPanel.setLayout(new BoxLayout(fiscalReceiptControlPanel, 0));
            fiscalReceiptControlPanel.add(buttonPanel);
            fiscalReceiptControlPanel.add(itemLabelPanel);
            fiscalReceiptControlPanel.add(itemFieldPanel);
            fiscalReceiptControlPanel.add(comboPanel);
            return fiscalReceiptControlPanel;
        }
    }

    class FiscalPrinterFscReportPanel
    extends Component {
        private static final long serialVersionUID = 8226960362715736598L;

        FiscalPrinterFscReportPanel() {
        }

        public Component make() {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            FiscalPrinterPanel.this.printReportButton = new JButton("Print Report");
            FiscalPrinterPanel.this.printReportButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printReportButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printReportButton.setActionCommand("printReport");
            FiscalPrinterPanel.this.printReportButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printReportButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printReportButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printReportButton);
            FiscalPrinterPanel.this.printXReportButton = new JButton("Print X Report");
            FiscalPrinterPanel.this.printXReportButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printXReportButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printXReportButton.setActionCommand("printXReport");
            FiscalPrinterPanel.this.printXReportButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printXReportButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printXReportButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printXReportButton);
            FiscalPrinterPanel.this.printZReportButton = new JButton("Print Z Report");
            FiscalPrinterPanel.this.printZReportButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printZReportButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printZReportButton.setActionCommand("printZReport");
            FiscalPrinterPanel.this.printZReportButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printZReportButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printZReportButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printZReportButton);
            FiscalPrinterPanel.this.printPeriodicTotalReportButton = new JButton("Print Periodic Report");
            FiscalPrinterPanel.this.printPeriodicTotalReportButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printPeriodicTotalReportButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printPeriodicTotalReportButton.setActionCommand("printPeriodicReport");
            FiscalPrinterPanel.this.printPeriodicTotalReportButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printPeriodicTotalReportButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.printPeriodicTotalReportButton.setEnabled(false);
            buttonPanel.add(FiscalPrinterPanel.this.printPeriodicTotalReportButton);
            JPanel itemLabelPanel = new JPanel();
            itemLabelPanel.setLayout(new BoxLayout(itemLabelPanel, 1));
            itemLabelPanel.setAlignmentX(1.0f);
            itemLabelPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Report From :");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.label = new JLabel("Report To :");
            FiscalPrinterPanel.this.label.setAlignmentX(1.0f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 17));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 17));
            itemLabelPanel.add(FiscalPrinterPanel.this.label);
            JPanel itemFieldPanel = new JPanel();
            itemFieldPanel.setLayout(new BoxLayout(itemFieldPanel, 1));
            itemFieldPanel.setAlignmentX(0.0f);
            itemFieldPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.reportFrom = new JTextField();
            FiscalPrinterPanel.this.reportFrom.setMaximumSize(new Dimension(130, 17));
            FiscalPrinterPanel.this.reportFrom.setPreferredSize(new Dimension(130, 17));
            FiscalPrinterPanel.this.reportFrom.setMinimumSize(new Dimension(130, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.reportFrom);
            FiscalPrinterPanel.this.reportTo = new JTextField();
            FiscalPrinterPanel.this.reportTo.setMaximumSize(new Dimension(130, 17));
            FiscalPrinterPanel.this.reportTo.setPreferredSize(new Dimension(130, 17));
            FiscalPrinterPanel.this.reportTo.setMinimumSize(new Dimension(130, 17));
            itemFieldPanel.add(FiscalPrinterPanel.this.reportTo);
            JPanel comboPanel = new JPanel();
            comboPanel.setLayout(new BoxLayout(comboPanel, 1));
            comboPanel.setAlignmentX(0.0f);
            comboPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Report Type :");
            FiscalPrinterPanel.this.label.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(110, 22));
            FiscalPrinterPanel.this.label.setPreferredSize(new Dimension(110, 22));
            comboPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.reportTypeCombo = new JComboBox();
            FiscalPrinterPanel.this.reportTypeCombo.setMaximumSize(new Dimension(110, 22));
            FiscalPrinterPanel.this.reportTypeCombo.setPreferredSize(new Dimension(110, 22));
            FiscalPrinterPanel.this.reportTypeCombo.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.reportTypeCombo.setActionCommand("reportTypeCombo");
            FiscalPrinterPanel.this.reportTypeCombo.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.reportTypeCombo.setFont(new Font(null, 0, 10));
            FiscalPrinterPanel.this.reportTypeCombo.setEnabled(true);
            FiscalPrinterPanel.this.reportTypeCombo.addItem("ORDINAL");
            FiscalPrinterPanel.this.reportTypeCombo.addItem("DATE");
            comboPanel.add(FiscalPrinterPanel.this.reportTypeCombo);
            JPanel fiscalPtrFscReportControlPanel = new JPanel();
            fiscalPtrFscReportControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            fiscalPtrFscReportControlPanel.setLayout(new BoxLayout(fiscalPtrFscReportControlPanel, 0));
            fiscalPtrFscReportControlPanel.add(buttonPanel);
            fiscalPtrFscReportControlPanel.add(itemLabelPanel);
            fiscalPtrFscReportControlPanel.add(itemFieldPanel);
            fiscalPtrFscReportControlPanel.add(FiscalPrinterPanel.this.reportTypeCombo);
            return fiscalPtrFscReportControlPanel;
        }
    }

    class FiscalPrinterStatusPanel
    extends Component {
        private static final long serialVersionUID = 8878274840702299074L;

        FiscalPrinterStatusPanel() {
        }

        public Component make() {
            JPanel itemListPanel = new JPanel();
            itemListPanel.setLayout(new BoxLayout(itemListPanel, 1));
            itemListPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            FiscalPrinterPanel.this.label = new JLabel("Text Output: ");
            FiscalPrinterPanel.this.label.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.label.setAlignmentX(0.5f);
            itemListPanel.add(FiscalPrinterPanel.this.label);
            FiscalPrinterPanel.this.itemListModel = new DefaultListModel();
            FiscalPrinterPanel.this.itemList = new JList(FiscalPrinterPanel.this.itemListModel);
            FiscalPrinterPanel.this.itemList.setSelectionMode(1);
            FiscalPrinterPanel.this.itemList.setLayoutOrientation(0);
            FiscalPrinterPanel.this.itemList.setVisibleRowCount(7);
            JScrollPane windowScrollPane = new JScrollPane(FiscalPrinterPanel.this.itemList);
            windowScrollPane.setMinimumSize(new Dimension(200, 250));
            windowScrollPane.setPreferredSize(new Dimension(350, 300));
            windowScrollPane.setMaximumSize(new Dimension(350, 300));
            itemListPanel.add(windowScrollPane);
            FiscalPrinterPanel.this.clearOutPutButton = new JButton("Clear Text Output");
            FiscalPrinterPanel.this.clearOutPutButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.clearOutPutButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.clearOutPutButton.setActionCommand("clearOutPut");
            FiscalPrinterPanel.this.clearOutPutButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.clearOutPutButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.clearOutPutButton.setEnabled(true);
            itemListPanel.add(FiscalPrinterPanel.this.clearOutPutButton);
            FiscalPrinterPanel.this.resetPrinterButton = new JButton("Reset Printer");
            FiscalPrinterPanel.this.resetPrinterButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.resetPrinterButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.resetPrinterButton.setActionCommand("resetPrinter");
            FiscalPrinterPanel.this.resetPrinterButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.resetPrinterButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.resetPrinterButton.setEnabled(false);
            itemListPanel.add(FiscalPrinterPanel.this.resetPrinterButton);
            FiscalPrinterPanel.this.clearOutputForErrorCB = new JCheckBox("Clear output for Error Event");
            FiscalPrinterPanel.this.clearOutputForErrorCB.setAlignmentX(0.5f);
            itemListPanel.add(FiscalPrinterPanel.this.clearOutputForErrorCB);
            JPanel dataPanel = new JPanel();
            dataPanel.setLayout(new BoxLayout(dataPanel, 1));
            dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            ButtonGroup bg = new ButtonGroup();
            FiscalPrinterPanel.this.firmwareRB = new JRadioButton("Firmware Release Number");
            bg.add(FiscalPrinterPanel.this.firmwareRB);
            dataPanel.add(FiscalPrinterPanel.this.firmwareRB);
            FiscalPrinterPanel.this.firmwareRB.doClick();
            FiscalPrinterPanel.this.printerIDRB = new JRadioButton("Printer's Fiscal ID");
            bg.add(FiscalPrinterPanel.this.printerIDRB);
            dataPanel.add(FiscalPrinterPanel.this.printerIDRB);
            FiscalPrinterPanel.this.currentRecTotalRB = new JRadioButton("Current Receipt Total");
            bg.add(FiscalPrinterPanel.this.currentRecTotalRB);
            dataPanel.add(FiscalPrinterPanel.this.currentRecTotalRB);
            FiscalPrinterPanel.this.currentTotalRB = new JRadioButton("Daily Total");
            bg.add(FiscalPrinterPanel.this.currentTotalRB);
            dataPanel.add(FiscalPrinterPanel.this.currentTotalRB);
            FiscalPrinterPanel.this.grandTotalRB = new JRadioButton("Fiscal Printer's Grand Total");
            bg.add(FiscalPrinterPanel.this.grandTotalRB);
            dataPanel.add(FiscalPrinterPanel.this.grandTotalRB);
            FiscalPrinterPanel.this.mitVoidRB = new JRadioButton("Total Number of Voided Receipts");
            bg.add(FiscalPrinterPanel.this.mitVoidRB);
            dataPanel.add(FiscalPrinterPanel.this.mitVoidRB);
            FiscalPrinterPanel.this.fiscalRecRB = new JRadioButton("N. of Daily Fiscal Sales Receipts");
            bg.add(FiscalPrinterPanel.this.fiscalRecRB);
            dataPanel.add(FiscalPrinterPanel.this.fiscalRecRB);
            FiscalPrinterPanel.this.receiptNumberRB = new JRadioButton("N. of Fiscal Receipts Printed");
            bg.add(FiscalPrinterPanel.this.receiptNumberRB);
            dataPanel.add(FiscalPrinterPanel.this.receiptNumberRB);
            FiscalPrinterPanel.this.refundRB = new JRadioButton("Current Total of Refunds");
            bg.add(FiscalPrinterPanel.this.refundRB);
            dataPanel.add(FiscalPrinterPanel.this.refundRB);
            FiscalPrinterPanel.this.fiscalRecVoidRB = new JRadioButton("N. of Daily Voided Fiscal Sales Receipt");
            bg.add(FiscalPrinterPanel.this.fiscalRecVoidRB);
            dataPanel.add(FiscalPrinterPanel.this.fiscalRecVoidRB);
            FiscalPrinterPanel.this.nonFiscalRecRB = new JRadioButton("N. of Daily Non Fiscal Sales Receipts");
            bg.add(FiscalPrinterPanel.this.nonFiscalRecRB);
            dataPanel.add(FiscalPrinterPanel.this.nonFiscalRecRB);
            FiscalPrinterPanel.this.descriptionLengthRB = new JRadioButton("Description Length");
            bg.add(FiscalPrinterPanel.this.descriptionLengthRB);
            dataPanel.add(FiscalPrinterPanel.this.descriptionLengthRB);
            FiscalPrinterPanel.this.zReportRB = new JRadioButton("Z Report");
            bg.add(FiscalPrinterPanel.this.zReportRB);
            dataPanel.add(FiscalPrinterPanel.this.zReportRB);
            FiscalPrinterPanel.this.getDataButton = new JButton("GetData");
            FiscalPrinterPanel.this.getDataButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getDataButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getDataButton.setActionCommand("getData");
            FiscalPrinterPanel.this.getDataButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getDataButton.setAlignmentX(0.0f);
            FiscalPrinterPanel.this.getDataButton.setEnabled(false);
            dataPanel.add(FiscalPrinterPanel.this.getDataButton);
            JPanel dataPanelBis = new JPanel();
            dataPanelBis.setLayout(new BoxLayout(dataPanelBis, 1));
            dataPanelBis.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            ButtonGroup bgbis = new ButtonGroup();
            FiscalPrinterPanel.this.dayTotalizerRB = new JRadioButton("Daily Totalizer");
            FiscalPrinterPanel.this.dayTotalizerRB.setAlignmentX(0.5f);
            bgbis.add(FiscalPrinterPanel.this.dayTotalizerRB);
            dataPanelBis.add(FiscalPrinterPanel.this.dayTotalizerRB);
            FiscalPrinterPanel.this.dayTotalizerRB.doClick();
            FiscalPrinterPanel.this.grandTotalizerRB = new JRadioButton("Grand Totalizer");
            FiscalPrinterPanel.this.grandTotalizerRB.setAlignmentX(0.5f);
            bgbis.add(FiscalPrinterPanel.this.grandTotalizerRB);
            dataPanelBis.add(FiscalPrinterPanel.this.grandTotalizerRB);
            FiscalPrinterPanel.this.totalTypeCombo = new JComboBox();
            FiscalPrinterPanel.this.totalTypeCombo.setMaximumSize(new Dimension(160, 22));
            FiscalPrinterPanel.this.totalTypeCombo.setPreferredSize(new Dimension(160, 22));
            FiscalPrinterPanel.this.totalTypeCombo.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.totalTypeCombo.setActionCommand("totalTypeCombo");
            FiscalPrinterPanel.this.totalTypeCombo.setEnabled(true);
            FiscalPrinterPanel.this.totalTypeCombo.addItem("Item Totalizer");
            FiscalPrinterPanel.this.totalTypeCombo.addItem("Refund Totalizer");
            FiscalPrinterPanel.this.totalTypeCombo.addItem("Voided Item Totalizer");
            FiscalPrinterPanel.this.totalTypeCombo.addItem("Discount Totalizer");
            FiscalPrinterPanel.this.totalTypeCombo.addItem("Gross Totalizer");
            dataPanelBis.add(FiscalPrinterPanel.this.totalTypeCombo);
            FiscalPrinterPanel.this.vatIdCombo_2 = new JComboBox();
            FiscalPrinterPanel.this.vatIdCombo_2.setMaximumSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.vatIdCombo_2.setPreferredSize(new Dimension(150, 22));
            FiscalPrinterPanel.this.vatIdCombo_2.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.vatIdCombo_2.setActionCommand("vatIdCombo_2");
            FiscalPrinterPanel.this.vatIdCombo_2.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.vatIdCombo_2.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.vatIdCombo_2);
            dataPanelBis.add(Box.createVerticalStrut(17));
            FiscalPrinterPanel.this.getTotalizerButton = new JButton("GetTotalizer");
            FiscalPrinterPanel.this.getTotalizerButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getTotalizerButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getTotalizerButton.setActionCommand("getTotalizer");
            FiscalPrinterPanel.this.getTotalizerButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getTotalizerButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getTotalizerButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.getTotalizerButton);
            FiscalPrinterPanel.this.getDateButton = new JButton("Get Date");
            FiscalPrinterPanel.this.getDateButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getDateButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getDateButton.setActionCommand("getDate");
            FiscalPrinterPanel.this.getDateButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getDateButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getDateButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.getDateButton);
            FiscalPrinterPanel.this.getTrainingStateButton = new JButton("Get Training Mode");
            FiscalPrinterPanel.this.getTrainingStateButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getTrainingStateButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getTrainingStateButton.setActionCommand("getTrainingState");
            FiscalPrinterPanel.this.getTrainingStateButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getTrainingStateButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getTrainingStateButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.getTrainingStateButton);
            FiscalPrinterPanel.this.getErrorLevelButton = new JButton("Get Error Info");
            FiscalPrinterPanel.this.getErrorLevelButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getErrorLevelButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getErrorLevelButton.setActionCommand("getErrorLevel");
            FiscalPrinterPanel.this.getErrorLevelButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getErrorLevelButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getErrorLevelButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.getErrorLevelButton);
            FiscalPrinterPanel.this.getOutPutIdButton = new JButton("Get Output ID");
            FiscalPrinterPanel.this.getOutPutIdButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getOutPutIdButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.getOutPutIdButton.setActionCommand("getOutPutId");
            FiscalPrinterPanel.this.getOutPutIdButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.getOutPutIdButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.getOutPutIdButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.getOutPutIdButton);
            FiscalPrinterPanel.this.printerStatusButton = new JButton("Get Printer Status");
            FiscalPrinterPanel.this.printerStatusButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printerStatusButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.printerStatusButton.setActionCommand("printerStatus");
            FiscalPrinterPanel.this.printerStatusButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.printerStatusButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.printerStatusButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.printerStatusButton);
            FiscalPrinterPanel.this.dayOpenedButton = new JButton("Get Day Opened");
            FiscalPrinterPanel.this.dayOpenedButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.dayOpenedButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.dayOpenedButton.setActionCommand("dayOpened");
            FiscalPrinterPanel.this.dayOpenedButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.dayOpenedButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.dayOpenedButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.dayOpenedButton);
            FiscalPrinterPanel.this.remainingFiscalMemoryButton = new JButton("Get Rem. Fiscal Memory");
            FiscalPrinterPanel.this.remainingFiscalMemoryButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.remainingFiscalMemoryButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.remainingFiscalMemoryButton.setActionCommand("remainingFiscalMemory");
            FiscalPrinterPanel.this.remainingFiscalMemoryButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.remainingFiscalMemoryButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.remainingFiscalMemoryButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.remainingFiscalMemoryButton);
            FiscalPrinterPanel.this.showPropertyButton = new JButton("Show Other Property");
            FiscalPrinterPanel.this.showPropertyButton.setMaximumSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.showPropertyButton.setPreferredSize(new Dimension(160, 17));
            FiscalPrinterPanel.this.showPropertyButton.setActionCommand("showProperty");
            FiscalPrinterPanel.this.showPropertyButton.addActionListener(FiscalPrinterPanel.this.methodListener);
            FiscalPrinterPanel.this.showPropertyButton.setAlignmentX(0.5f);
            FiscalPrinterPanel.this.showPropertyButton.setEnabled(false);
            dataPanelBis.add(FiscalPrinterPanel.this.showPropertyButton);
            JPanel fiscalPtrStatusControlPanel = new JPanel();
            fiscalPtrStatusControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            fiscalPtrStatusControlPanel.setLayout(new BoxLayout(fiscalPtrStatusControlPanel, 0));
            fiscalPtrStatusControlPanel.add(itemListPanel);
            fiscalPtrStatusControlPanel.add(dataPanel);
            fiscalPtrStatusControlPanel.add(dataPanelBis);
            return fiscalPtrStatusControlPanel;
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (FiscalPrinterPanel.this.fiscalPrinter != null) {
                FiscalPrinterPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(FiscalPrinterPanel.this.fiscalPrinter.getState()));
            }
        }
    }
}

