/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.ErrorPromptDlg;
import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpos.JposException;
import jpos.MSR;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;

public class MSRPanel
extends Component
implements DataListener,
ActionListener {
    private static final long serialVersionUID = -1934362106766686694L;
    protected MSR msr;
    protected MainButtonPanel mainButtonPanel;
    private String defaultLogicalName = "defaultMSR";
    byte[] track1Data = new byte[0];
    byte[] track2Data = new byte[0];
    byte[] track3Data = new byte[0];
    byte[] track4Data = new byte[0];
    String accountNumber = new String("");
    String expirationDate = new String("");
    String title = new String("");
    String firstName = new String("");
    String middleInitial = new String("");
    String surname = new String("");
    String suffix = new String("");
    String serviceCode = new String("");
    byte[] t1DiscData = new byte[0];
    byte[] t2DiscData = new byte[0];
    private boolean ver_110_complient = false;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    boolean autoDisable;
    boolean dataEventEnabled;
    boolean deviceEnabled;
    boolean freezeEvents;
    boolean decodeData;
    boolean parseDecodeData;
    boolean updateDevice = true;
    private JTextField track1DataTextField;
    private JTextField track2DataTextField;
    private JTextField track3DataTextField;
    private JTextField track4DataTextField;
    private JTextField t1LengthTF;
    private JTextField t2LengthTF;
    private JTextField t3LengthTF;
    private JTextField t4LengthTF;
    private int t1Length;
    private int t2Length;
    private int t3Length;
    private int t4Length;
    private JTextField accountNumberTextField;
    private JTextField expirationDateTextField;
    private JTextField titleTextField;
    private JTextField firstNameTextField;
    private JTextField middleInitialTextField;
    private JTextField surnameTextField;
    private JTextField suffixTextField;
    private JTextField serviceCodeTextField;
    private JTextField t1DiscDataTextField;
    private JTextField t2DiscDataTextField;
    private JCheckBox autoDisableCB;
    private JCheckBox dataEventEnabledCB;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JCheckBox decodeDataCB;
    private JCheckBox parseDecodeDataCB;
    private JCheckBox transmitSentinels;
    private JCheckBox perTrackErrorReporting;
    private JCheckBox track1Enabled;
    private JCheckBox track2Enabled;
    private JCheckBox track3Enabled;
    private JCheckBox track4Enabled;
    private JLabel dataCountLabel;
    private JButton clearFieldsButton;
    private JButton refreshFieldsButton;
    private JButton clearInputButton;
    private JButton clearInputPropertiesButton;
    private Timer updateDatacountTimer;
    DataCountTimerUpdateTask updateDataCountTask;
    Runnable doUpdateGUI;
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;
    private JCheckBox write1CB;
    private JCheckBox write2CB;
    private JCheckBox write3CB;
    private JCheckBox write4CB;
    private JLabel encodingMaxLengthLabel;
    private JButton updateTracksToWriteButton;
    private JTextField dataToWriteTextField;
    private JTextField writeTracksTimeoutTextField;
    private JButton writeTracksButton;

    public MSRPanel() {
        this.msr = new MSR();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public MSR getMSR() {
        return this.msr;
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.autoDisableCB = new JCheckBox("Auto disable");
        Font f = this.autoDisableCB.getFont();
        Font newf = new Font(f.getName(), 0, f.getSize());
        this.autoDisableCB.setFont(newf);
        propPanel.add(this.autoDisableCB);
        this.dataEventEnabledCB = new JCheckBox("Data event enabled");
        this.dataEventEnabledCB.setFont(newf);
        propPanel.add(this.dataEventEnabledCB);
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        this.deviceEnabledCB.setFont(newf);
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        this.freezeEventsCB.setFont(newf);
        propPanel.add(this.freezeEventsCB);
        this.decodeDataCB = new JCheckBox("Decode data");
        this.decodeDataCB.setFont(newf);
        propPanel.add(this.decodeDataCB);
        this.parseDecodeDataCB = new JCheckBox("Parse decode data");
        this.parseDecodeDataCB.setFont(newf);
        propPanel.add(this.parseDecodeDataCB);
        this.transmitSentinels = new JCheckBox("Transmit sentinels");
        this.transmitSentinels.setFont(newf);
        propPanel.add(this.transmitSentinels);
        this.perTrackErrorReporting = new JCheckBox("Per-track error reporting");
        this.perTrackErrorReporting.setFont(newf);
        propPanel.add(this.perTrackErrorReporting);
        this.track1Enabled = new JCheckBox("Track 1 enabled");
        this.track1Enabled.setFont(newf);
        propPanel.add(this.track1Enabled);
        this.track2Enabled = new JCheckBox("Track 2 enabled");
        this.track2Enabled.setFont(newf);
        propPanel.add(this.track2Enabled);
        this.track3Enabled = new JCheckBox("Track 3 enabled");
        this.track3Enabled.setFont(newf);
        propPanel.add(this.track3Enabled);
        this.track4Enabled = new JCheckBox("Track 4 enabled");
        this.track4Enabled.setFont(newf);
        propPanel.add(this.track4Enabled);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        this.clearInputPropertiesButton = new JButton("Clear Input Properties");
        this.clearInputPropertiesButton.setActionCommand("clearInputProperties");
        this.clearInputPropertiesButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(this.clearInputPropertiesButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.enableCheckBoxes(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.autoDisableCB.addItemListener(cbListener);
        this.dataEventEnabledCB.addItemListener(cbListener);
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        this.decodeDataCB.addItemListener(cbListener);
        this.parseDecodeDataCB.addItemListener(cbListener);
        this.transmitSentinels.addItemListener(cbListener);
        this.perTrackErrorReporting.addItemListener(cbListener);
        this.track1Enabled.addItemListener(cbListener);
        this.track2Enabled.addItemListener(cbListener);
        this.track3Enabled.addItemListener(cbListener);
        this.track4Enabled.addItemListener(cbListener);
        this.clearFieldsButton = new JButton("Clear Fields");
        this.clearFieldsButton.setActionCommand("clearFields");
        this.clearFieldsButton.addActionListener(this);
        this.refreshFieldsButton = new JButton("Refresh Fields");
        this.refreshFieldsButton.setActionCommand("refreshFields");
        this.refreshFieldsButton.addActionListener(this);
        this.updateTracksToWriteButton = new JButton("Set tracks to write");
        this.updateTracksToWriteButton.setActionCommand("setTracksToWrite");
        this.updateTracksToWriteButton.addActionListener(this);
        this.writeTracksButton = new JButton("Write Tracks!");
        this.writeTracksButton.setActionCommand("writeTracks");
        this.writeTracksButton.addActionListener(this);
        JTabbedPane tabbedPane = new JTabbedPane();
        subPanel.add(tabbedPane);
        MSRReadPanel readPanel = new MSRReadPanel();
        tabbedPane.addTab("MSR Reading", null, readPanel.make(), "MSR Reading");
        MSRWritePanel writePanel = new MSRWritePanel();
        tabbedPane.addTab("MSR Writing", null, writePanel.make(), "MSR Writing");
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        this.doUpdateGUI = new Runnable(){

            public void run() {
                MSRPanel.this.updateGUI();
            }
        };
        return mainPanel;
    }

    private void enableCheckBoxes(boolean enable) {
        this.autoDisableCB.setEnabled(enable);
        this.dataEventEnabledCB.setEnabled(enable);
        this.deviceEnabledCB.setEnabled(enable);
        this.freezeEventsCB.setEnabled(enable);
        this.decodeDataCB.setEnabled(enable);
        this.parseDecodeDataCB.setEnabled(enable);
        this.transmitSentinels.setEnabled(enable);
        this.perTrackErrorReporting.setEnabled(enable);
        this.track1Enabled.setEnabled(enable);
        this.track2Enabled.setEnabled(enable);
        this.track3Enabled.setEnabled(enable);
        this.track4Enabled.setEnabled(enable);
    }

    public void doOpen() throws JposException {
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (logicalName.equals("")) {
            logicalName = this.defaultLogicalName;
        }
        this.msr.open(logicalName);
        this.msr.addDataListener((DataListener)this);
        this.msr.addErrorListener(new ErrorListener(){

            public void errorOccurred(ErrorEvent e) {
                String msg = new String("MSR Error Event Occured\n");
                msg = String.valueOf(msg) + "Error Code = " + MainButtonPanel.getErrorName(e.getErrorCode()) + "\n";
                if (e.getErrorCode() == 114) {
                    int error = e.getErrorCodeExtended();
                    msg = String.valueOf(msg) + "Extended Error Code:\n";
                    msg = String.valueOf(msg) + "  Track 1 = " + MainButtonPanel.getErrorName(error & 0xFF) + "\n";
                    msg = String.valueOf(msg) + "  Track 2 = " + MainButtonPanel.getErrorName((error & 0xFF00) >> 8) + "\n";
                    msg = String.valueOf(msg) + "  Track 3 = " + MainButtonPanel.getErrorName((error & 0xFF0000) >> 16) + "\n";
                    msg = String.valueOf(msg) + "  Track 4 = " + MainButtonPanel.getErrorName((error & 0xFF000000) >> 32) + "\n";
                }
                try {
                    ErrorPromptDlg dlg = new ErrorPromptDlg(e, msg);
                    dlg.setVisible(true);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Exception: " + ex.getMessage(), "Failed", 0);
                }
                MSRPanel.this.updateGUI();
            }
        });
        this.updateDatacountTimer = new Timer(true);
        this.updateDataCountTask = new DataCountTimerUpdateTask();
        this.updateDatacountTimer.schedule((TimerTask)this.updateDataCountTask, 200L, 200L);
        int version = this.msr.getDeviceServiceVersion();
        if (version >= 1010000) {
            this.ver_110_complient = true;
            this.ver_19_complient = true;
            this.ver_18_complient = true;
        }
        if (version >= 1009000) {
            this.ver_19_complient = true;
            this.ver_18_complient = true;
        }
        if (version >= 1008000) {
            this.ver_18_complient = true;
        }
    }

    public void doClaim() throws JposException {
        this.msr.claim(1000);
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                this.doOpen();
                this.enableCheckBoxes(true);
                this.updateGUI();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.doClaim();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.msr.release();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                if (this.updateDatacountTimer != null) {
                    this.updateDatacountTimer.cancel();
                    this.updateDatacountTimer = null;
                    this.updateDataCountTask = null;
                }
                this.msr.close();
                this.enableCheckBoxes(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.msr.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.msr.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.msr.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.msr.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.msr.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.msr.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.msr.getCapPowerReporting() == 2 ? "Advanced" : (this.msr.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.msr.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.msr.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.msr.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.msr.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = this.ver_110_complient ? String.valueOf(msg) + "\nCapWritableTracks: " + this.getCapWritableTracksString(this.msr.getCapWritableTracks()) : String.valueOf(msg) + "\nCapWritableTracks: Service Object is not 1.10 complient";
                msg = String.valueOf(msg) + "\nCapISO: " + this.msr.getCapISO();
                msg = String.valueOf(msg) + "\nCapJISOne: " + this.msr.getCapJISOne();
                msg = String.valueOf(msg) + "\nCapJISTwo: " + this.msr.getCapJISTwo();
                msg = String.valueOf(msg) + "\nCapTransmitSentinels: " + this.msr.getCapTransmitSentinels();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            if (logicalName.equals("")) {
                logicalName = this.defaultLogicalName;
            }
            try {
                this.doOpen();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
                return;
            }
            this.enableCheckBoxes(true);
            this.updateGUI();
            try {
                this.doClaim();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
                return;
            }
            this.updateGUI();
            this.deviceEnabledCB.doClick();
            this.updateGUI();
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.msr);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.msr);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("clearFields")) {
            try {
                this.track1Data = new byte[0];
                this.track2Data = new byte[0];
                this.track3Data = new byte[0];
                this.track4Data = new byte[0];
                this.accountNumber = "";
                this.expirationDate = "";
                this.title = "";
                this.firstName = "";
                this.middleInitial = "";
                this.surname = "";
                this.suffix = "";
                this.serviceCode = "";
                this.t1Length = 0;
                this.t2Length = 0;
                this.t3Length = 0;
                this.t4Length = 0;
                this.t1DiscData = new byte[0];
                this.t2DiscData = new byte[0];
                this.track1DataTextField.setText(new String(this.track1Data));
                this.track2DataTextField.setText(new String(this.track2Data));
                this.track3DataTextField.setText(new String(this.track3Data));
                this.track4DataTextField.setText(new String(this.track4Data));
                this.t1LengthTF.setText(Integer.toString(this.t1Length));
                this.t2LengthTF.setText(Integer.toString(this.t2Length));
                this.t3LengthTF.setText(Integer.toString(this.t3Length));
                this.t4LengthTF.setText(Integer.toString(this.t4Length));
                this.accountNumberTextField.setText(new String(this.accountNumber));
                this.expirationDateTextField.setText(new String(this.expirationDate));
                this.titleTextField.setText(new String(this.title));
                this.firstNameTextField.setText(new String(this.firstName));
                this.middleInitialTextField.setText(new String(this.middleInitial));
                this.surnameTextField.setText(new String(this.surname));
                this.suffixTextField.setText(new String(this.suffix));
                this.serviceCodeTextField.setText(new String(this.serviceCode));
                this.t1DiscDataTextField.setText(new String(this.t1DiscData));
                this.t2DiscDataTextField.setText(new String(this.t2DiscData));
                try {
                    this.autoDisableCB.setSelected(this.msr.getAutoDisable());
                    this.dataEventEnabledCB.setSelected(this.msr.getDataEventEnabled());
                    this.deviceEnabledCB.setSelected(this.msr.getDeviceEnabled());
                    this.freezeEventsCB.setSelected(this.msr.getFreezeEvents());
                    this.decodeDataCB.setSelected(this.msr.getDecodeData());
                    this.parseDecodeDataCB.setSelected(this.msr.getParseDecodeData());
                    this.transmitSentinels.setSelected(this.msr.getTransmitSentinels());
                    this.perTrackErrorReporting.setSelected(this.msr.getErrorReportingType() == 1);
                    int tracks = this.msr.getTracksToRead();
                    this.track1Enabled.setSelected((tracks & 1) > 0);
                    this.track2Enabled.setSelected((tracks & 2) > 0);
                    this.track3Enabled.setSelected((tracks & 4) > 0);
                    this.track4Enabled.setSelected((tracks & 8) > 0);
                }
                catch (JposException je) {
                    JOptionPane.showMessageDialog(null, "UpdateGUI method received JposException: " + je.getMessage(), "Exception", 0);
                }
            }
            catch (Exception je) {}
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.msr.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("clearInputProperties")) {
            try {
                this.msr.clearInputProperties();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInputProperties threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("refreshFields")) {
            try {
                this.getMSRFieldData();
                this.updateGUI();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "JposException caught while refreshing fields: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("setTracksToWrite")) {
            try {
                int tracks = 0;
                if (this.write1CB.isSelected()) {
                    tracks |= 1;
                }
                if (this.write2CB.isSelected()) {
                    tracks |= 2;
                }
                if (this.write3CB.isSelected()) {
                    tracks |= 4;
                }
                if (this.write4CB.isSelected()) {
                    tracks |= 8;
                }
                this.msr.setTracksToWrite(tracks);
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "JposException caught in setTracksToWrite(): " + je.getMessage(), "Exception", 0);
            }
            this.updateGUI();
        } else if (ae.getActionCommand().equals("writeTracks")) {
            try {
                this.msr.writeTracks(this.dataToWriteTextField.getText(), Integer.parseInt(this.writeTracksTimeoutTextField.getText()));
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "JposException caught in writeTracks(): " + je.getMessage(), "Exception", 0);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "JposException caught: " + ex.getMessage(), "Exception", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        try {
            if (this.msr.getState() != 1) {
                this.updateDevice = false;
                this.autoDisableCB.setSelected(this.msr.getAutoDisable());
                this.dataEventEnabledCB.setSelected(this.msr.getDataEventEnabled());
                this.deviceEnabledCB.setSelected(this.msr.getDeviceEnabled());
                this.freezeEventsCB.setSelected(this.msr.getFreezeEvents());
                this.decodeDataCB.setSelected(this.msr.getDecodeData());
                this.parseDecodeDataCB.setSelected(this.msr.getParseDecodeData());
                this.perTrackErrorReporting.setSelected(this.msr.getErrorReportingType() == 1);
                this.updateDevice = true;
            }
        }
        catch (JposException je) {
            System.err.println("MSRPanel: JposException" + (Object)((Object)je));
        }
    }

    String getCapWritableTracksString(int cap) {
        String retVal = "";
        if (cap == 0) {
            return "The MSR does not support writing track data.";
        }
        if ((cap & 1) > 0) {
            return "Track 1, ";
        }
        if ((cap & 2) > 0) {
            return "Track 2, ";
        }
        if ((cap & 4) > 0) {
            return "Track 3, ";
        }
        if ((cap & 8) > 0) {
            return "Track 4, ";
        }
        return retVal;
    }

    public void dataOccurred(DataEvent de) {
        try {
            this.getMSRFieldData();
            this.t1Length = de.getStatus() & 0xFF;
            this.t2Length = (de.getStatus() & 0xFF00) >> 8;
            this.t3Length = (de.getStatus() & 0xFF0000) >> 16;
            this.t4Length = (de.getStatus() & 0xFF000000) >> 32;
            this.autoDisable = this.msr.getAutoDisable();
            this.dataEventEnabled = this.msr.getDataEventEnabled();
            this.deviceEnabled = this.msr.getDeviceEnabled();
            this.freezeEvents = this.msr.getFreezeEvents();
            this.decodeData = this.msr.getDecodeData();
            this.parseDecodeData = this.msr.getParseDecodeData();
        }
        catch (JposException je) {
            System.err.println("MSR: Jpos Exception");
        }
        this.updateDevice = false;
        try {
            SwingUtilities.invokeLater(this.doUpdateGUI);
        }
        catch (Exception e) {
            System.err.println("InvokeLater exception.");
        }
        this.updateDevice = true;
    }

    public void getMSRFieldData() throws JposException {
        this.track1Data = this.msr.getTrack1Data();
        this.track2Data = this.msr.getTrack2Data();
        this.track3Data = this.msr.getTrack3Data();
        this.track4Data = this.msr.getTrack4Data();
        this.accountNumber = this.msr.getAccountNumber();
        this.expirationDate = this.msr.getExpirationDate();
        this.title = this.msr.getTitle();
        this.firstName = this.msr.getFirstName();
        this.middleInitial = this.msr.getMiddleInitial();
        this.surname = this.msr.getSurname();
        this.suffix = this.msr.getSuffix();
        this.serviceCode = this.msr.getServiceCode();
        this.t1DiscData = this.msr.getTrack1DiscretionaryData();
        this.t2DiscData = this.msr.getTrack2DiscretionaryData();
    }

    public void updateGUI() {
        this.track1DataTextField.setText(new String(this.track1Data));
        this.track2DataTextField.setText(new String(this.track2Data));
        this.track3DataTextField.setText(new String(this.track3Data));
        this.track4DataTextField.setText(new String(this.track4Data));
        this.t1LengthTF.setText(Integer.toString(this.t1Length));
        this.t2LengthTF.setText(Integer.toString(this.t2Length));
        this.t3LengthTF.setText(Integer.toString(this.t3Length));
        this.t4LengthTF.setText(Integer.toString(this.t4Length));
        this.accountNumberTextField.setText(new String(this.accountNumber));
        this.expirationDateTextField.setText(new String(this.expirationDate));
        this.titleTextField.setText(new String(this.title));
        this.firstNameTextField.setText(new String(this.firstName));
        this.middleInitialTextField.setText(new String(this.middleInitial));
        this.surnameTextField.setText(new String(this.surname));
        this.suffixTextField.setText(new String(this.suffix));
        this.serviceCodeTextField.setText(new String(this.serviceCode));
        this.t1DiscDataTextField.setText(new String(this.t1DiscData));
        this.t2DiscDataTextField.setText(new String(this.t2DiscData));
        try {
            this.autoDisableCB.setSelected(this.msr.getAutoDisable());
            this.dataEventEnabledCB.setSelected(this.msr.getDataEventEnabled());
            this.deviceEnabledCB.setSelected(this.msr.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.msr.getFreezeEvents());
            this.decodeDataCB.setSelected(this.msr.getDecodeData());
            this.parseDecodeDataCB.setSelected(this.msr.getParseDecodeData());
            this.transmitSentinels.setSelected(this.msr.getTransmitSentinels());
            this.perTrackErrorReporting.setSelected(this.msr.getErrorReportingType() == 1);
            int tracks = this.msr.getTracksToRead();
            this.track1Enabled.setSelected((tracks & 1) > 0);
            this.track2Enabled.setSelected((tracks & 2) > 0);
            this.track3Enabled.setSelected((tracks & 4) > 0);
            this.track4Enabled.setSelected((tracks & 8) > 0);
            if (this.ver_110_complient) {
                int writeTracks = this.msr.getTracksToWrite();
                this.write1CB.setSelected((writeTracks & 1) > 0);
                this.write2CB.setSelected((writeTracks & 2) > 0);
                this.write3CB.setSelected((writeTracks & 4) > 0);
                this.write4CB.setSelected((writeTracks & 8) > 0);
                this.encodingMaxLengthLabel.setText("Encoding Max Length: " + String.valueOf(this.msr.getEncodingMaxLength()));
            }
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "UpdateGUI method received JposException: " + je.getMessage(), "Exception", 0);
            System.err.println("MSRPanel: UpdateGUI method received JposException: " + (Object)((Object)je));
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (MSRPanel.this.updateDevice) {
                block61: {
                    ItemSelectable source = e.getItemSelectable();
                    if (source == MSRPanel.this.autoDisableCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setAutoDisable(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setAutoDisable(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setAutoDisable(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setAutoDisable(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.dataEventEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setDataEventEnabled(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setDataEventEnabled(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setDataEventEnabled(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setDataEventEnabled(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.deviceEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setDeviceEnabled(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setDeviceEnabled(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setDeviceEnabled(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setDeviceEnabled(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.freezeEventsCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setFreezeEvents(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setFreezeEvents(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setFreezeEvents(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setFreezeEvents(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.decodeDataCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setDecodeData(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setDecodeData(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setDecodeData(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setDecodeData(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.parseDecodeDataCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setParseDecodeData(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setParseDecodeData(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setParseDecodeData(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setParseDecodeData(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.transmitSentinels) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setTransmitSentinels(false);
                                break block61;
                            }
                            MSRPanel.this.msr.setTransmitSentinels(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setTransmitSentinels(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setTransmitSentinels(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.perTrackErrorReporting) {
                        try {
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setErrorReportingType(0);
                                break block61;
                            }
                            MSRPanel.this.msr.setErrorReportingType(1);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setTransmitSentinels(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setTransmitSentinels(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.track1Enabled) {
                        try {
                            int tracks = MSRPanel.this.msr.getTracksToRead();
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setTracksToRead(tracks &= 0xFFFFFFFE);
                                break block61;
                            }
                            MSRPanel.this.msr.setTracksToRead(tracks |= 1);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setTracksToRead(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setTracksToRead(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.track2Enabled) {
                        try {
                            int tracks = MSRPanel.this.msr.getTracksToRead();
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setTracksToRead(tracks &= 0xFFFFFFFD);
                                break block61;
                            }
                            MSRPanel.this.msr.setTracksToRead(tracks |= 2);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setTracksToRead(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setTracksToRead(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.track3Enabled) {
                        try {
                            int tracks = MSRPanel.this.msr.getTracksToRead();
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setTracksToRead(tracks &= 0xFFFFFFFB);
                                break block61;
                            }
                            MSRPanel.this.msr.setTracksToRead(tracks |= 4);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setTracksToRead(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setTracksToRead(): " + (Object)((Object)je));
                        }
                    } else if (source == MSRPanel.this.track4Enabled) {
                        try {
                            int tracks = MSRPanel.this.msr.getTracksToRead();
                            if (e.getStateChange() == 2) {
                                MSRPanel.this.msr.setTracksToRead(tracks &= 0xFFFFFFF7);
                            } else {
                                MSRPanel.this.msr.setTracksToRead(tracks |= 8);
                            }
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "exception in setTracksToRead(): " + je.getMessage(), "Exception", 0);
                            System.err.println("MSRPanel: exception in setTracksToRead(): " + (Object)((Object)je));
                        }
                    }
                }
                MSRPanel.this.updateGUI();
            }
        }
    }

    private class DataCountTimerUpdateTask
    extends TimerTask {
        DataCountTimerUpdateTask() {
        }

        public void run() {
            try {
                MSRPanel.this.dataCountLabel.setText("Data Count: " + Integer.toString(MSRPanel.this.msr.getDataCount()));
            }
            catch (JposException e) {
                System.out.println("Failed to retrieve the data count:\n" + e.getMessage());
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (MSRPanel.this.msr != null) {
                MSRPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(MSRPanel.this.msr.getState()));
            }
        }
    }

    class MSRReadPanel
    extends Component {
        private static final long serialVersionUID = 5550374415910334154L;

        MSRReadPanel() {
        }

        public Component make() {
            JPanel mainBox = new JPanel();
            mainBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            mainBox.setLayout(new BoxLayout(mainBox, 0));
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            JLabel dataLabel = new JLabel("Track 1 Data: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Track 2 Data: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Track 3 Data: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Track 4 Data: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Account number: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Expiration date: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Title: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("First name: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Middle initial: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Surname: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Suffix: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Service Code: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Track 1 discretionary data: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            dataLabel = new JLabel("Track 2 discretionary data: ");
            dataLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(dataLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            MSRPanel.this.dataCountLabel = new JLabel("Data Count: ");
            MSRPanel.this.dataCountLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            labelPanel.add(MSRPanel.this.dataCountLabel);
            labelPanel.add(Box.createVerticalGlue());
            mainBox.add(labelPanel);
            JPanel countPanel = new JPanel();
            countPanel.setLayout(new BoxLayout(countPanel, 1));
            MSRPanel.this.t1LengthTF = new JTextField(4);
            MSRPanel.this.t1LengthTF.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            countPanel.add(MSRPanel.this.t1LengthTF);
            MSRPanel.this.t2LengthTF = new JTextField(4);
            MSRPanel.this.t2LengthTF.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            countPanel.add(MSRPanel.this.t2LengthTF);
            MSRPanel.this.t3LengthTF = new JTextField(4);
            MSRPanel.this.t3LengthTF.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            countPanel.add(MSRPanel.this.t3LengthTF);
            MSRPanel.this.t4LengthTF = new JTextField(4);
            MSRPanel.this.t4LengthTF.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            countPanel.add(MSRPanel.this.t4LengthTF);
            countPanel.add(Box.createVerticalGlue());
            JPanel tfPanel = new JPanel();
            tfPanel.setLayout(new BoxLayout(tfPanel, 1));
            MSRPanel.this.track1DataTextField = new JTextField(50);
            MSRPanel.this.track1DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.track1DataTextField);
            MSRPanel.this.track2DataTextField = new JTextField(50);
            MSRPanel.this.track2DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.track2DataTextField);
            MSRPanel.this.track3DataTextField = new JTextField(50);
            MSRPanel.this.track3DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.track3DataTextField);
            MSRPanel.this.track4DataTextField = new JTextField(50);
            MSRPanel.this.track4DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.track4DataTextField);
            MSRPanel.this.accountNumberTextField = new JTextField(50);
            MSRPanel.this.accountNumberTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.accountNumberTextField);
            MSRPanel.this.expirationDateTextField = new JTextField(50);
            MSRPanel.this.expirationDateTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.expirationDateTextField);
            MSRPanel.this.titleTextField = new JTextField(50);
            MSRPanel.this.titleTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.titleTextField);
            MSRPanel.this.firstNameTextField = new JTextField(50);
            MSRPanel.this.firstNameTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.firstNameTextField);
            MSRPanel.this.middleInitialTextField = new JTextField(50);
            MSRPanel.this.middleInitialTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.middleInitialTextField);
            MSRPanel.this.surnameTextField = new JTextField(50);
            MSRPanel.this.surnameTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.surnameTextField);
            MSRPanel.this.suffixTextField = new JTextField(50);
            MSRPanel.this.suffixTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.suffixTextField);
            MSRPanel.this.serviceCodeTextField = new JTextField(50);
            MSRPanel.this.serviceCodeTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.serviceCodeTextField);
            MSRPanel.this.t1DiscDataTextField = new JTextField(50);
            MSRPanel.this.t1DiscDataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.t1DiscDataTextField);
            MSRPanel.this.t2DiscDataTextField = new JTextField(50);
            MSRPanel.this.t2DiscDataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            tfPanel.add(MSRPanel.this.t2DiscDataTextField);
            tfPanel.add(Box.createRigidArea(new Dimension(0, 25)));
            JPanel bottomButtonPanel = new JPanel();
            bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
            bottomButtonPanel.add(MSRPanel.this.clearFieldsButton);
            bottomButtonPanel.add(MSRPanel.this.refreshFieldsButton);
            tfPanel.add(bottomButtonPanel);
            tfPanel.add(Box.createVerticalGlue());
            mainBox.add(countPanel);
            mainBox.add(tfPanel);
            return mainBox;
        }
    }

    class MSRWritePanel
    extends Component {
        private static final long serialVersionUID = -7813746193583966760L;

        MSRWritePanel() {
        }

        public Component make() {
            JPanel mainBox = new JPanel();
            mainBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            mainBox.setLayout(new BoxLayout(mainBox, 0));
            JPanel tracksToWriteBox = new JPanel();
            tracksToWriteBox.setBorder(BorderFactory.createEtchedBorder());
            tracksToWriteBox.setLayout(new BoxLayout(tracksToWriteBox, 1));
            MSRPanel.this.write1CB = new JCheckBox("Track 1");
            MSRPanel.this.write2CB = new JCheckBox("Track 2");
            MSRPanel.this.write3CB = new JCheckBox("Track 3");
            MSRPanel.this.write4CB = new JCheckBox("Track 4");
            MSRPanel.this.encodingMaxLengthLabel = new JLabel();
            JLabel label = new JLabel("Tracks to Write:");
            tracksToWriteBox.add(label);
            tracksToWriteBox.add(MSRPanel.this.write1CB);
            tracksToWriteBox.add(MSRPanel.this.write2CB);
            tracksToWriteBox.add(MSRPanel.this.write3CB);
            tracksToWriteBox.add(MSRPanel.this.write4CB);
            tracksToWriteBox.add(MSRPanel.this.updateTracksToWriteButton);
            mainBox.add(tracksToWriteBox);
            JPanel writeBox = new JPanel();
            writeBox.setBorder(BorderFactory.createEtchedBorder());
            writeBox.setLayout(new BoxLayout(writeBox, 1));
            MSRPanel.this.encodingMaxLengthLabel = new JLabel("Encoding Max Length: ");
            MSRPanel.this.dataToWriteTextField = new JTextField();
            MSRPanel.this.dataToWriteTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
            MSRPanel.this.writeTracksTimeoutTextField = new JTextField("-1");
            MSRPanel.this.writeTracksTimeoutTextField.setMaximumSize(new Dimension(100, 25));
            writeBox.add(MSRPanel.this.encodingMaxLengthLabel);
            writeBox.add(new JLabel("Data To Write:"));
            writeBox.add(MSRPanel.this.dataToWriteTextField);
            writeBox.add(new JLabel("\nTimeout (ms):"));
            writeBox.add(MSRPanel.this.writeTracksTimeoutTextField);
            writeBox.add(MSRPanel.this.writeTracksButton);
            mainBox.add(writeBox);
            return mainBox;
        }
    }
}

