/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jpos.JposException;
import jpos.MotionSensor;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class MotionSensorPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -4446838855128096416L;
    protected MainButtonPanel mainButtonPanel;
    private MotionSensor motionSensor;
    private String defaultLogicalName = "defaultMotionSensor";
    private String logicalName = "";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JLabel motionLabel = new JLabel("Current Motion Property: (Enable Service First)");
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    boolean motionOpened = false;
    private JButton waitForMotionButton = new JButton("Start");
    private JButton motionTimeoutButton = new JButton("Set Timeout");
    private JLabel motionTimeWaitLabel = new JLabel("Timeout (ms):");
    private JTextField motionTimeWaitField = new JTextField("0", 5);
    private JTextField motionTimeoutField = new JTextField("0", 5);
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;

    public MotionSensorPanel() {
        this.motionSensor = new MotionSensor();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        propPanel.add(this.motionLabel);
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        this.deviceEnabledCB.setActionCommand("deviceEnabled");
        this.deviceEnabledCB.addActionListener(this);
        this.freezeEventsCB.setActionCommand("freezeEvents");
        this.freezeEventsCB.addActionListener(this);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        JPanel motionPanel = new JPanel();
        JPanel motionMethodsPanel = new JPanel();
        motionMethodsPanel.setBorder(new TitledBorder("Wait For Motion"));
        motionMethodsPanel.add(this.motionTimeWaitLabel);
        motionMethodsPanel.add(this.motionTimeWaitField);
        motionMethodsPanel.add(this.waitForMotionButton);
        this.motionTimeWaitField.setToolTipText("Enter milliseconds");
        this.waitForMotionButton.setToolTipText("start button");
        JPanel motionTimeoutPanel = new JPanel();
        motionTimeoutPanel.setBorder(new TitledBorder("Motion Timeout"));
        motionTimeoutPanel.add(new JLabel("Timeout Value (ms)"));
        motionTimeoutPanel.add(this.motionTimeoutField);
        motionTimeoutPanel.add(this.motionTimeoutButton);
        this.motionTimeoutButton.setActionCommand("setTimeout");
        this.motionTimeoutButton.addActionListener(this);
        motionPanel.add(motionMethodsPanel);
        motionPanel.add(motionTimeoutPanel);
        mainPanel.add(motionPanel);
        this.waitForMotionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int timeout = Integer.parseInt(MotionSensorPanel.this.motionTimeWaitField.getText());
                    MotionSensorPanel.this.motionSensor.waitForMotion(timeout);
                    System.out.println("pressed wait for motion button!!!");
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + MotionSensorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            }
        });
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        if (sue.getStatus() == 2) {
            this.motionLabel.setText("Current Motion Property: MOTION_M_ABSENT");
        } else if (sue.getStatus() == 1) {
            this.motionLabel.setText("Current Motion Property: MOTION_M_PRESENT");
        } else {
            this.motionLabel.setText("Current Motion Property: Service sent an invalid status");
        }
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.motionSensor.open(logicalName);
                this.motionSensor.addStatusUpdateListener((StatusUpdateListener)this);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.motionSensor.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.motionSensor.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.motionSensor.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.motionSensor.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.motionSensor.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.motionSensor.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.motionSensor.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.motionSensor.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.motionSensor.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.motionSensor.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.motionSensor.getCapPowerReporting() == 2 ? "Advanced" : (this.motionSensor.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.motionSensor.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.motionSensor.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.motionSensor.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.motionSensor.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.motionSensor.addStatusUpdateListener((StatusUpdateListener)this);
                this.motionSensor.open(logicalName);
                this.motionSensor.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.motionSensor.setDeviceEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.motionSensor);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.motionSensor);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("deviceEnabled")) {
            if (!this.deviceEnabledCB.isSelected()) {
                try {
                    this.motionSensor.setDeviceEnabled(false);
                    this.motionLabel.setText("Current Motion Property: (Enable First)");
                }
                catch (JposException je) {
                    JOptionPane.showMessageDialog(null, "Failed to disable \"" + logicalName + "\"\nException: " + je.getMessage(), "Failed", 0);
                }
            } else {
                try {
                    this.motionSensor.setDeviceEnabled(true);
                    this.motionLabel.setText("Current Motion Property: " + (this.motionSensor.getMotion() ? "MOTION_M_PRESENT" : "MOTION_M_ABSENT"));
                }
                catch (JposException je) {
                    JOptionPane.showMessageDialog(null, "Failed to enable \"" + logicalName + "\"\nException: " + je.getMessage(), "Failed", 0);
                }
            }
        } else if (ae.getActionCommand().equals("freezeEvents")) {
            if (!this.freezeEventsCB.isSelected()) {
                try {
                    this.motionSensor.setFreezeEvents(false);
                }
                catch (JposException je) {
                    JOptionPane.showMessageDialog(null, "Failed to un-freeze events on \"" + logicalName + "\"\nException: " + je.getMessage(), "Failed", 0);
                }
            } else {
                try {
                    this.motionSensor.setFreezeEvents(true);
                }
                catch (JposException je) {
                    JOptionPane.showMessageDialog(null, "Failed to freeze events on \"" + logicalName + "\"\nException: " + je.getMessage(), "Failed", 0);
                }
            }
        } else if (ae.getActionCommand().equals("setTimeout")) {
            try {
                this.motionSensor.setTimeout(Integer.parseInt(this.motionTimeoutField.getText()));
            }
            catch (Exception je) {
                JOptionPane.showMessageDialog(null, "Failed to update timeout value on \"" + logicalName + "\"\nException: " + je.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.motionSensor.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.motionSensor.getFreezeEvents());
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "MotionSensorPanel: MethodListener:\nException: " + je.getMessage(), "Failed", 0);
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (MotionSensorPanel.this.motionSensor != null) {
                MotionSensorPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(MotionSensorPanel.this.motionSensor.getState()));
            }
        }
    }
}

