/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpos.JposException;
import jpos.PINPad;
import jpos.events.DataEvent;
import jpos.events.DataListener;

public class PINPadPanel
extends Component
implements DataListener,
ActionListener {
    private static final long serialVersionUID = -5872374527899063970L;
    protected MainButtonPanel mainButtonPanel;
    private PINPad pinpad = new PINPad();
    private String defaultLogicalName = "defaultPINPad";
    protected JTextField accountNumberTextField;
    protected JTextField amountTextField;
    protected JTextField merchantIDTextField;
    protected JTextField terminalIDTextField;
    protected JTextField track1DataTextField;
    protected JTextField track2DataTextField;
    protected JTextField track3DataTextField;
    protected JTextField track4DataTextField;
    protected JTextField transactionTypeTextField;
    protected JTextField pinPadSystemTextField;
    protected JTextField transactionHostTextField;
    protected JTextField completionCodeTextField;
    protected JTextField keyNumTextField;
    protected JTextField keyTextField;
    protected JTextField encryptedPINTextField;
    private JCheckBox dataEventEnabledCB;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JButton beginEFTTransactionButton;
    private JButton endEFTTransactionButton;
    private JButton updateKeyButton;
    private JButton clearInputButton;
    private JButton clearInputPropertiesButton;
    private JButton clearFieldsButton;
    private JButton refreshFieldsButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    Runnable doDataUpdate;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public PINPadPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        this.beginEFTTransactionButton = new JButton("Begin EFT Transaction");
        this.beginEFTTransactionButton.setActionCommand("beginEFTTransaction");
        this.beginEFTTransactionButton.addActionListener(this);
        this.beginEFTTransactionButton.setEnabled(false);
        buttonPanel.add(this.beginEFTTransactionButton);
        this.endEFTTransactionButton = new JButton("End EFT Transaction");
        this.endEFTTransactionButton.setActionCommand("endEFTTransaction");
        this.endEFTTransactionButton.addActionListener(this);
        this.endEFTTransactionButton.setEnabled(false);
        buttonPanel.add(this.endEFTTransactionButton);
        this.updateKeyButton = new JButton("Update Key");
        this.updateKeyButton.setActionCommand("updateKey");
        this.updateKeyButton.addActionListener(this);
        this.updateKeyButton.setEnabled(false);
        buttonPanel.add(this.updateKeyButton);
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.dataEventEnabledCB = new JCheckBox("Data event enabled");
        Font f = this.dataEventEnabledCB.getFont();
        Font newf = new Font(f.getName(), 0, f.getSize());
        this.dataEventEnabledCB.setFont(newf);
        propPanel.add(this.dataEventEnabledCB);
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        this.deviceEnabledCB.setFont(newf);
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        this.freezeEventsCB.setFont(newf);
        propPanel.add(this.freezeEventsCB);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        this.clearInputPropertiesButton = new JButton("Clear Input Properties");
        this.clearInputPropertiesButton.setActionCommand("clearInputProperties");
        this.clearInputPropertiesButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(this.clearInputPropertiesButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.dataEventEnabledCB.setEnabled(false);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.dataEventEnabledCB.addItemListener(cbListener);
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        int dim = 4;
        JLabel label = new JLabel("Account number:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Amount:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Merchant ID:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("TerminalID:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Track 1 Data:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Track 2 Data:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Track 3 Data:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Track 4 Data:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Transaction Type:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("PINPad System:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Transaction host:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Completion code:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Key number:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Key:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        label = new JLabel("Encrypted PIN:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, dim)));
        labelPanel.add(Box.createVerticalGlue());
        subPanel.add(labelPanel);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        this.accountNumberTextField = new JTextField(50);
        this.accountNumberTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.accountNumberTextField);
        this.amountTextField = new JTextField(50);
        this.amountTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.amountTextField);
        this.merchantIDTextField = new JTextField(50);
        this.merchantIDTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.merchantIDTextField);
        this.terminalIDTextField = new JTextField(50);
        this.terminalIDTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.terminalIDTextField);
        this.track1DataTextField = new JTextField(50);
        this.track1DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.track1DataTextField);
        this.track2DataTextField = new JTextField(50);
        this.track2DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.track2DataTextField);
        this.track3DataTextField = new JTextField(50);
        this.track3DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.track3DataTextField);
        this.track4DataTextField = new JTextField(50);
        this.track4DataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.track4DataTextField);
        this.transactionTypeTextField = new JTextField(50);
        this.transactionTypeTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.transactionTypeTextField);
        this.pinPadSystemTextField = new JTextField(50);
        this.pinPadSystemTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.pinPadSystemTextField);
        this.transactionHostTextField = new JTextField(50);
        this.transactionHostTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.transactionHostTextField);
        this.completionCodeTextField = new JTextField(50);
        this.completionCodeTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.completionCodeTextField);
        this.keyNumTextField = new JTextField(50);
        this.keyNumTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.keyNumTextField);
        this.keyTextField = new JTextField(50);
        this.keyTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.keyTextField);
        this.encryptedPINTextField = new JTextField(50);
        this.encryptedPINTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        fieldPanel.add(this.encryptedPINTextField);
        JPanel bottomButtonPanel = new JPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        this.clearFieldsButton = new JButton("Clear Fields");
        this.clearFieldsButton.setToolTipText("clears input fields");
        this.clearFieldsButton.setActionCommand("clearFields");
        this.clearFieldsButton.addActionListener(this);
        this.clearFieldsButton.setEnabled(true);
        this.refreshFieldsButton = new JButton("Refresh Fields");
        this.refreshFieldsButton.setToolTipText("Refresh input fields");
        this.refreshFieldsButton.setActionCommand("refreshFields");
        this.refreshFieldsButton.addActionListener(this);
        this.refreshFieldsButton.setEnabled(true);
        bottomButtonPanel.add(this.clearFieldsButton);
        bottomButtonPanel.add(this.refreshFieldsButton);
        fieldPanel.add(bottomButtonPanel);
        fieldPanel.add(Box.createVerticalGlue());
        subPanel.add(fieldPanel);
        subPanel.add(Box.createHorizontalGlue());
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        this.doDataUpdate = new Runnable(){

            public void run() {
                PINPadPanel.this.updateData();
            }
        };
        return mainPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.pinpad.addDataListener((DataListener)this);
                this.pinpad.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.pinpad.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.pinpad.claim(0);
                this.beginEFTTransactionButton.setEnabled(true);
                this.dataEventEnabledCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.pinpad.release();
                this.beginEFTTransactionButton.setEnabled(false);
                this.endEFTTransactionButton.setEnabled(false);
                this.updateKeyButton.setEnabled(false);
                this.dataEventEnabledCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.pinpad.close();
                this.dataEventEnabledCB.setEnabled(false);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("beginEFTTransaction")) {
            try {
                this.pinpad.setAccountNumber(this.accountNumberTextField.getText());
                this.pinpad.setAmount(Long.parseLong(this.amountTextField.getText()));
                this.pinpad.setMerchantID(this.merchantIDTextField.getText());
                this.pinpad.setTerminalID(this.terminalIDTextField.getText());
                this.pinpad.setTrack1Data(this.track1DataTextField.getText().getBytes());
                this.pinpad.setTrack2Data(this.track2DataTextField.getText().getBytes());
                this.pinpad.setTrack3Data(this.track3DataTextField.getText().getBytes());
                this.pinpad.setTransactionType(Integer.parseInt(this.transactionTypeTextField.getText()));
                this.pinpad.beginEFTTransaction(this.pinPadSystemTextField.getText(), Integer.parseInt(this.transactionHostTextField.getText()));
            }
            catch (JposException e) {
                System.err.println("beginEFTTransaction: Jpos exception " + (Object)((Object)e));
            }
            this.beginEFTTransactionButton.setEnabled(false);
            this.endEFTTransactionButton.setEnabled(true);
        } else if (ae.getActionCommand().equals("endEFTTransaction")) {
            try {
                this.pinpad.endEFTTransaction(Integer.parseInt(this.completionCodeTextField.getText()));
            }
            catch (JposException e) {
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
            this.beginEFTTransactionButton.setEnabled(true);
            this.endEFTTransactionButton.setEnabled(false);
        } else if (ae.getActionCommand().equals("updateKey")) {
            try {
                this.pinpad.updateKey(Integer.parseInt(this.keyNumTextField.getText()), this.keyTextField.getText());
            }
            catch (JposException e) {
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.pinpad.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.pinpad.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.pinpad.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.pinpad.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.pinpad.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.pinpad.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.pinpad.getCapPowerReporting() == 2 ? "Advanced" : (this.pinpad.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.pinpad.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.pinpad.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.pinpad.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.pinpad.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapDisplay: ";
                int disp = this.pinpad.getCapDisplay();
                switch (disp) {
                    case 1: {
                        msg = String.valueOf(msg) + "PPAD_DISP_UNRESTRICTED";
                        break;
                    }
                    case 2: {
                        msg = String.valueOf(msg) + "PPAD_DISP_PINRESTRICTED";
                        break;
                    }
                    case 3: {
                        msg = String.valueOf(msg) + "PPAD_DISP_RESTRICTED_LIST";
                        break;
                    }
                    case 4: {
                        msg = String.valueOf(msg) + "PPAD_DISP_RESTRICTED_ORDER";
                        break;
                    }
                    case 5: {
                        msg = String.valueOf(msg) + "PPAD_DISP_NONE";
                    }
                }
                msg = String.valueOf(msg) + "\nCapKeyboard: " + this.pinpad.getCapKeyboard();
                msg = String.valueOf(msg) + "\nCapLanguage: ";
                int lang = this.pinpad.getCapLanguage();
                switch (lang) {
                    case 1: {
                        msg = String.valueOf(msg) + "PPAD_LANG_NONE";
                        break;
                    }
                    case 2: {
                        msg = String.valueOf(msg) + "PPAD_LANG_ONE";
                        break;
                    }
                    case 3: {
                        msg = String.valueOf(msg) + "PPAD_LANG_PINRESTRICTED";
                        break;
                    }
                    case 4: {
                        msg = String.valueOf(msg) + "PPAD_LANG_UNRESTRICTED / RESTRICTED_ORDER";
                    }
                }
                msg = String.valueOf(msg) + "\nCapMACCalulation: " + this.pinpad.getCapMACCalculation();
                msg = String.valueOf(msg) + "\nCapTone: " + this.pinpad.getCapTone();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.pinpad.addDataListener((DataListener)this);
                this.pinpad.open(logicalName);
                this.pinpad.claim(0);
                this.beginEFTTransactionButton.setEnabled(true);
                this.dataEventEnabledCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.pinpad.setDeviceEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.pinpad);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.pinpad);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.pinpad.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("clearInputProperties")) {
            try {
                this.pinpad.clearInputProperties();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInputProperties threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("refreshFields")) {
            try {
                this.accountNumberTextField.setText(this.pinpad.getAccountNumber());
                this.amountTextField.setText(String.valueOf(this.pinpad.getAmount()));
                this.merchantIDTextField.setText(this.pinpad.getMerchantID());
                this.terminalIDTextField.setText(this.pinpad.getTerminalID());
                this.track1DataTextField.setText(this.pinpad.getTrack1Data().toString());
                this.track2DataTextField.setText(this.pinpad.getTrack2Data().toString());
                this.track3DataTextField.setText(this.pinpad.getTrack3Data().toString());
                this.track4DataTextField.setText(this.pinpad.getTrack4Data().toString());
                this.transactionTypeTextField.setText(String.valueOf(this.pinpad.getTransactionType()));
                this.encryptedPINTextField.setText(this.pinpad.getEncryptedPIN());
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInputProperties threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        try {
            this.dataEventEnabledCB.setSelected(this.pinpad.getDataEventEnabled());
            this.deviceEnabledCB.setSelected(this.pinpad.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.pinpad.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("PINPadPanel: MethodListener: JposException");
        }
    }

    public void updateData() {
        try {
            this.encryptedPINTextField.setText(new String(this.pinpad.getEncryptedPIN()));
            this.pinpad.setDataEventEnabled(true);
        }
        catch (JposException je) {
            System.err.println("PINPadPanel: dataOccurred 1: Jpos Exception");
        }
        try {
            this.dataEventEnabledCB.setSelected(this.pinpad.getDataEventEnabled());
            this.deviceEnabledCB.setSelected(this.pinpad.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.pinpad.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("PINPadPanel: dataOccurred 2: JposException");
        }
    }

    public void dataOccurred(DataEvent dataEvent) {
        try {
            SwingUtilities.invokeLater(this.doDataUpdate);
        }
        catch (Exception e) {
            System.err.println("InvokeLater exception.");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == PINPadPanel.this.dataEventEnabledCB) {
                    if (e.getStateChange() == 2) {
                        PINPadPanel.this.pinpad.setDataEventEnabled(false);
                    } else {
                        PINPadPanel.this.pinpad.setDataEventEnabled(true);
                    }
                } else if (source == PINPadPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        PINPadPanel.this.pinpad.setDeviceEnabled(false);
                    } else {
                        PINPadPanel.this.pinpad.setDeviceEnabled(true);
                    }
                } else if (source == PINPadPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        PINPadPanel.this.pinpad.setFreezeEvents(false);
                    } else {
                        PINPadPanel.this.pinpad.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("PINPadPanel: CheckBoxListener: Jpos Exception" + source);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (PINPadPanel.this.pinpad != null) {
                PINPadPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(PINPadPanel.this.pinpad.getState()));
            }
        }
    }
}

