/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.DrawPanel;
import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpos.JposException;
import jpos.SignatureCapture;
import jpos.events.DataEvent;
import jpos.events.DataListener;

public class SigpadPanel
extends Component
implements DataListener,
ActionListener {
    private static final long serialVersionUID = -5375294458678884018L;
    protected MainButtonPanel mainButtonPanel;
    private SignatureCapture sigpad = new SignatureCapture();
    private String defaultLogicalName = "defaultSigcap";
    private JCheckBox autoDisableCB;
    private JCheckBox dataEventEnabledCB;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JButton beginCaptureButton;
    private JButton endCaptureButton;
    private DrawPanel drawPanel;
    private JTextField formNameTextField;
    private JButton clearInputButton;
    private JButton clearInputPropertiesButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    Runnable doDataUpdate;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public SigpadPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        this.beginCaptureButton = new JButton("Begin Capture");
        this.beginCaptureButton.setActionCommand("beginCapture");
        this.beginCaptureButton.addActionListener(this);
        this.beginCaptureButton.setEnabled(false);
        buttonPanel.add(this.beginCaptureButton);
        this.formNameTextField = new JTextField(12);
        buttonPanel.add(this.formNameTextField);
        this.endCaptureButton = new JButton("End Capture");
        this.endCaptureButton.setActionCommand("endCapture");
        this.endCaptureButton.addActionListener(this);
        this.endCaptureButton.setEnabled(false);
        buttonPanel.add(this.endCaptureButton);
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.autoDisableCB = new JCheckBox("Auto disable");
        Font f = this.autoDisableCB.getFont();
        Font newf = new Font(f.getName(), 0, f.getSize());
        this.autoDisableCB.setFont(newf);
        propPanel.add(this.autoDisableCB);
        this.dataEventEnabledCB = new JCheckBox("Data event enabled");
        this.dataEventEnabledCB.setFont(newf);
        propPanel.add(this.dataEventEnabledCB);
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        this.deviceEnabledCB.setFont(newf);
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        this.freezeEventsCB.setFont(newf);
        propPanel.add(this.freezeEventsCB);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        this.clearInputPropertiesButton = new JButton("Clear Input Properties");
        this.clearInputPropertiesButton.setActionCommand("clearInputProperties");
        this.clearInputPropertiesButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(this.clearInputPropertiesButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.autoDisableCB.setEnabled(false);
        this.dataEventEnabledCB.setEnabled(false);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.autoDisableCB.addItemListener(cbListener);
        this.dataEventEnabledCB.addItemListener(cbListener);
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel dataPanel = new JPanel();
        this.drawPanel = new DrawPanel();
        dataPanel.add(this.drawPanel);
        subPanel.add(dataPanel);
        subPanel.add(Box.createHorizontalGlue());
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        this.doDataUpdate = new Runnable(){

            public void run() {
                SigpadPanel.this.updateData();
            }
        };
        return mainPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.sigpad.addDataListener((DataListener)this);
                this.sigpad.open(logicalName);
                this.autoDisableCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.sigpad.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.sigpad.claim(0);
                this.beginCaptureButton.setEnabled(true);
                this.autoDisableCB.setEnabled(true);
                this.dataEventEnabledCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.sigpad.release();
                this.beginCaptureButton.setEnabled(false);
                this.endCaptureButton.setEnabled(false);
                this.autoDisableCB.setEnabled(true);
                this.dataEventEnabledCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.sigpad.close();
                this.autoDisableCB.setEnabled(false);
                this.dataEventEnabledCB.setEnabled(false);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("beginCapture")) {
            try {
                this.sigpad.beginCapture(this.formNameTextField.getText());
            }
            catch (JposException e) {
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
            this.beginCaptureButton.setEnabled(false);
            this.endCaptureButton.setEnabled(true);
        } else if (ae.getActionCommand().equals("endCapture")) {
            try {
                this.sigpad.endCapture();
                this.updateData();
            }
            catch (JposException e) {
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
            this.beginCaptureButton.setEnabled(true);
            this.endCaptureButton.setEnabled(false);
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.sigpad.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.sigpad.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.sigpad.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.sigpad.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.sigpad.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.sigpad.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.sigpad.getCapPowerReporting() == 2 ? "Advanced" : (this.sigpad.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.sigpad.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.sigpad.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.sigpad.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.sigpad.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapDisplay: " + this.sigpad.getCapDisplay();
                msg = String.valueOf(msg) + "\nCapRealTimeData: " + this.sigpad.getCapRealTimeData();
                msg = String.valueOf(msg) + "\nCapUserTerminated: " + this.sigpad.getCapUserTerminated();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.sigpad.addDataListener((DataListener)this);
                this.sigpad.open(logicalName);
                this.sigpad.claim(0);
                this.beginCaptureButton.setEnabled(true);
                this.autoDisableCB.setEnabled(true);
                this.dataEventEnabledCB.setEnabled(true);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.sigpad.setDeviceEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.sigpad);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.sigpad);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.sigpad.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("clearInputProperties")) {
            try {
                this.sigpad.clearInputProperties();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInputProperties threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        try {
            this.autoDisableCB.setSelected(this.sigpad.getAutoDisable());
            this.dataEventEnabledCB.setSelected(this.sigpad.getDataEventEnabled());
            this.deviceEnabledCB.setSelected(this.sigpad.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.sigpad.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("SigpadPanel: MethodListener: JposException");
        }
    }

    public void updateData() {
        try {
            Point[] p = this.sigpad.getPointArray();
            this.drawPanel.setPoints(p);
            this.drawPanel.repaint();
            this.sigpad.setDataEventEnabled(true);
        }
        catch (JposException je) {
            System.err.println("SigpadPanel: dataOccurred 1: Jpos Exception");
        }
        try {
            this.autoDisableCB.setSelected(this.sigpad.getAutoDisable());
            this.dataEventEnabledCB.setSelected(this.sigpad.getDataEventEnabled());
            this.deviceEnabledCB.setSelected(this.sigpad.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.sigpad.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("SigpadPanel: dataOccurred 2: JposException");
        }
    }

    public void dataOccurred(DataEvent dataEvent) {
        try {
            SwingUtilities.invokeLater(this.doDataUpdate);
        }
        catch (Exception e) {
            System.err.println("InvokeLater exception.");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == SigpadPanel.this.autoDisableCB) {
                    if (e.getStateChange() == 2) {
                        SigpadPanel.this.sigpad.setAutoDisable(false);
                    } else {
                        SigpadPanel.this.sigpad.setAutoDisable(true);
                    }
                } else if (source == SigpadPanel.this.dataEventEnabledCB) {
                    if (e.getStateChange() == 2) {
                        SigpadPanel.this.sigpad.setDataEventEnabled(false);
                    } else {
                        SigpadPanel.this.sigpad.setDataEventEnabled(true);
                    }
                } else if (source == SigpadPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        SigpadPanel.this.sigpad.setDeviceEnabled(false);
                    } else {
                        SigpadPanel.this.sigpad.setDeviceEnabled(true);
                    }
                } else if (source == SigpadPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        SigpadPanel.this.sigpad.setFreezeEvents(false);
                    } else {
                        SigpadPanel.this.sigpad.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("SigpadPanel: CheckBoxListener: Jpos Exception" + source);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (SigpadPanel.this.sigpad != null) {
                SigpadPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(SigpadPanel.this.sigpad.getState()));
            }
        }
    }
}

