/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jpos.JposException;
import jpos.ToneIndicator;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class ToneIndicatorPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -385357392108807346L;
    protected MainButtonPanel mainButtonPanel;
    private ToneIndicator toneIndicator;
    private String defaultLogicalName = "defaultToneIndicator";
    private String logicalName = "";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    boolean toneOpened = false;
    private JButton toneSoundButton = new JButton("Sound");
    private JButton toneSoundImmediateButton = new JButton("Sound Immediate");
    private JLabel toneNumberOfCyclesLabel = new JLabel("Number of Cycles");
    private JTextField toneNumberOfCyclesField = new JTextField("1", 5);
    private JLabel toneInterSoundWaitLabel = new JLabel("InterSound Wait");
    private JTextField toneInterSoundWaitField = new JTextField("0", 5);
    private JCheckBox toneCapPitchBox = new JCheckBox("CapPitch");
    private JCheckBox toneCapVolumeBox = new JCheckBox("CapVolume");
    private JCheckBox toneAsyncModeBox = new JCheckBox("AsyncMode");
    private JLabel toneInterToneWaitLabel = new JLabel("InterTone Wait");
    private JTextField toneInterToneWaitField = new JTextField("0", 5);
    private JLabel toneTone1DurationLabel = new JLabel("Duration");
    private JTextField toneTone1DurationField = new JTextField("100", 5);
    private JLabel toneTone1PitchLabel = new JLabel("Pitch");
    private JTextField toneTone1PitchField = new JTextField("100", 5);
    private JLabel toneTone1VolumeLabel = new JLabel("Volume");
    private JTextField toneTone1VolumeField = new JTextField("1", 5);
    private JLabel toneTone2DurationLabel = new JLabel("Duration");
    private JTextField toneTone2DurationField = new JTextField("100", 5);
    private JLabel toneTone2PitchLabel = new JLabel("Pitch");
    private JTextField toneTone2PitchField = new JTextField("100", 5);
    private JLabel toneTone2VolumeLabel = new JLabel("Volume");
    private JTextField toneTone2VolumeField = new JTextField("1", 5);
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;

    public ToneIndicatorPanel() {
        this.toneIndicator = new ToneIndicator();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        JPanel tonePanel = new JPanel();
        GridBagLayout toneLayout = new GridBagLayout();
        GridBagConstraints toneConstraints = new GridBagConstraints();
        toneConstraints.gridy = 0;
        toneConstraints.gridwidth = 1;
        toneConstraints.gridheight = 1;
        toneConstraints.insets = new Insets(0, 10, 0, 10);
        toneConstraints.fill = 0;
        toneConstraints.anchor = 10;
        tonePanel.setLayout(toneLayout);
        JPanel toneCommandsPanel = new JPanel();
        toneCommandsPanel.setBorder(new TitledBorder("*** Commands ***"));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        toneCommandsPanel.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.fill = 0;
        constraints.anchor = 10;
        layout.setConstraints(this.toneSoundButton, constraints);
        this.toneSoundButton.setToolTipText("use cycles");
        toneCommandsPanel.add(this.toneSoundButton);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        layout.setConstraints(this.toneSoundButton, constraints);
        this.toneSoundImmediateButton.setToolTipText("no cycles");
        toneCommandsPanel.add(this.toneSoundImmediateButton);
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.gridy = 2;
        layout.setConstraints(this.toneNumberOfCyclesLabel, constraints);
        toneCommandsPanel.add(this.toneNumberOfCyclesLabel);
        constraints.gridx = 1;
        constraints.gridy = 2;
        layout.setConstraints(this.toneNumberOfCyclesField, constraints);
        toneCommandsPanel.add(this.toneNumberOfCyclesField);
        this.toneNumberOfCyclesField.setToolTipText("enter integer");
        constraints.gridx = 0;
        constraints.gridy = 3;
        layout.setConstraints(this.toneInterSoundWaitLabel, constraints);
        toneCommandsPanel.add(this.toneInterSoundWaitLabel);
        constraints.gridx = 1;
        constraints.gridy = 3;
        layout.setConstraints(this.toneInterSoundWaitField, constraints);
        toneCommandsPanel.add(this.toneInterSoundWaitField);
        this.toneInterSoundWaitField.setToolTipText("in milliseconds");
        toneConstraints.gridx = 0;
        toneConstraints.gridheight = 2;
        toneLayout.setConstraints(toneCommandsPanel, toneConstraints);
        mainPanel.add(toneCommandsPanel);
        this.toneSoundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone1Duration(Integer.parseInt(ToneIndicatorPanel.this.toneTone1DurationField.getText()));
                    ToneIndicatorPanel.this.toneIndicator.setTone1Pitch(Integer.parseInt(ToneIndicatorPanel.this.toneTone1PitchField.getText()));
                    ToneIndicatorPanel.this.toneIndicator.setTone1Volume(Integer.parseInt(ToneIndicatorPanel.this.toneTone1VolumeField.getText()));
                    ToneIndicatorPanel.this.toneIndicator.setTone2Duration(Integer.parseInt(ToneIndicatorPanel.this.toneTone2DurationField.getText()));
                    ToneIndicatorPanel.this.toneIndicator.setTone2Pitch(Integer.parseInt(ToneIndicatorPanel.this.toneTone2PitchField.getText()));
                    ToneIndicatorPanel.this.toneIndicator.setTone2Volume(Integer.parseInt(ToneIndicatorPanel.this.toneTone2VolumeField.getText()));
                    ToneIndicatorPanel.this.toneIndicator.setInterToneWait(Integer.parseInt(ToneIndicatorPanel.this.toneInterToneWaitField.getText()));
                    int cycles = Integer.parseInt(ToneIndicatorPanel.this.toneNumberOfCyclesField.getText());
                    int wait = Integer.parseInt(ToneIndicatorPanel.this.toneInterSoundWaitField.getText());
                    ToneIndicatorPanel.this.toneIndicator.sound(cycles, wait);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
                catch (NumberFormatException e) {
                    System.err.println("Sound parameter not a number\n" + e);
                }
            }
        });
        this.toneSoundImmediateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.soundImmediate();
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            }
        });
        JPanel tonePropertiesPanel = new JPanel();
        tonePropertiesPanel.setLayout(new FlowLayout());
        JPanel tone1Panel = new JPanel();
        tone1Panel.setBorder(new TitledBorder("Tone 1 Properties"));
        tone1Panel.setLayout(new GridLayout(3, 2));
        this.toneTone1DurationField.setToolTipText("in milliseconds");
        this.toneTone1PitchField.setToolTipText("in hertz");
        this.toneTone1VolumeField.setToolTipText("range is 0 (silent) to 100");
        tone1Panel.add(this.toneTone1DurationLabel);
        tone1Panel.add(this.toneTone1DurationField);
        tone1Panel.add(this.toneTone1PitchLabel);
        tone1Panel.add(this.toneTone1PitchField);
        tone1Panel.add(this.toneTone1VolumeLabel);
        tone1Panel.add(this.toneTone1VolumeField);
        toneConstraints.gridx = 1;
        toneConstraints.gridheight = 1;
        toneLayout.setConstraints(tone1Panel, toneConstraints);
        mainPanel.add(tone1Panel);
        JPanel tone2Panel = new JPanel();
        tone2Panel.setBorder(new TitledBorder("Tone 2 Properties"));
        tone2Panel.setLayout(new GridLayout(3, 2));
        this.toneTone2DurationField.setToolTipText("in milliseconds");
        this.toneTone2PitchField.setToolTipText("in hertz");
        this.toneTone2VolumeField.setToolTipText("range is 0 (silent) to 100");
        tone2Panel.add(this.toneTone2DurationLabel);
        tone2Panel.add(this.toneTone2DurationField);
        tone2Panel.add(this.toneTone2PitchLabel);
        tone2Panel.add(this.toneTone2PitchField);
        tone2Panel.add(this.toneTone2VolumeLabel);
        tone2Panel.add(this.toneTone2VolumeField);
        toneConstraints.gridx = 2;
        toneConstraints.gridheight = 1;
        toneLayout.setConstraints(tone2Panel, toneConstraints);
        mainPanel.add(tone2Panel);
        JPanel toneWaitPanel = new JPanel();
        toneWaitPanel.setLayout(new GridLayout(1, 2));
        toneWaitPanel.add(this.toneInterToneWaitLabel);
        toneWaitPanel.add(this.toneInterToneWaitField);
        toneConstraints.gridx = 1;
        toneConstraints.gridy = 1;
        toneConstraints.gridwidth = 2;
        toneLayout.setConstraints(toneWaitPanel, toneConstraints);
        mainPanel.add(toneWaitPanel);
        JPanel toneMiscPanel = new JPanel();
        layout = new GridBagLayout();
        toneMiscPanel.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        layout.setConstraints(this.toneCapPitchBox, constraints);
        toneMiscPanel.add(this.toneCapPitchBox);
        constraints.gridy = 1;
        layout.setConstraints(this.toneCapVolumeBox, constraints);
        toneMiscPanel.add(this.toneCapVolumeBox);
        this.toneCapPitchBox.setEnabled(false);
        this.toneCapVolumeBox.setEnabled(false);
        constraints.gridy = 2;
        layout.setConstraints(this.toneAsyncModeBox, constraints);
        toneMiscPanel.add(this.toneAsyncModeBox);
        toneConstraints.gridx = 3;
        toneConstraints.gridy = 0;
        toneConstraints.gridwidth = 1;
        toneConstraints.gridheight = 2;
        toneLayout.setConstraints(toneMiscPanel, toneConstraints);
        mainPanel.add(toneMiscPanel);
        JScrollPane toneScroll = new JScrollPane();
        toneScroll.setViewportView(mainPanel);
        this.toneAsyncModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                boolean state = ToneIndicatorPanel.this.toneAsyncModeBox.isSelected();
                try {
                    ToneIndicatorPanel.this.toneIndicator.setAsyncMode(state);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                    ToneIndicatorPanel.this.toneAsyncModeBox.setSelected(!state);
                }
            }
        });
        this.toneTone1DurationField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone1Duration(Integer.parseInt(ToneIndicatorPanel.this.toneTone1DurationField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
                catch (NumberFormatException e) {
                    System.err.println("Tone1Duration: not a number\n" + e);
                }
            }
        });
        this.toneTone1PitchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone1Pitch(Integer.parseInt(ToneIndicatorPanel.this.toneTone1PitchField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
                catch (NumberFormatException e) {
                    System.err.println("Tone1Pitch: not a number\n" + e);
                }
            }
        });
        this.toneTone1VolumeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone1Volume(Integer.parseInt(ToneIndicatorPanel.this.toneTone1VolumeField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
                catch (NumberFormatException e) {
                    System.err.println("Tone1Volume: not a number\n" + e);
                }
            }
        });
        this.toneTone2DurationField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone2Duration(Integer.parseInt(ToneIndicatorPanel.this.toneTone2DurationField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
                catch (NumberFormatException e) {
                    System.err.println("Tone2Duration: not a number\n" + e);
                }
            }
        });
        this.toneTone2PitchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone2Pitch(Integer.parseInt(ToneIndicatorPanel.this.toneTone2PitchField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
                catch (NumberFormatException e) {
                    System.err.println("Tone2Pitch: not a number\n" + e);
                }
            }
        });
        this.toneTone2VolumeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setTone2Volume(Integer.parseInt(ToneIndicatorPanel.this.toneTone2VolumeField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
                catch (NumberFormatException e) {
                    System.err.println("Tone2Volume: not a number\n" + e);
                }
            }
        });
        this.toneInterToneWaitField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ToneIndicatorPanel.this.toneIndicator.setInterToneWait(Integer.parseInt(ToneIndicatorPanel.this.toneInterToneWaitField.getText()));
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ToneIndicatorPanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                }
                catch (NumberFormatException e) {
                    System.err.println("InterToneWait: not a number\n" + e);
                }
            }
        });
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("ToneIndicator received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.toneIndicator.addStatusUpdateListener((StatusUpdateListener)this);
                this.toneIndicator.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.toneIndicator.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.toneIndicator.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.toneIndicator.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.toneIndicator.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.toneIndicator.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.toneIndicator.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.toneIndicator.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.toneIndicator.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.toneIndicator.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.toneIndicator.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.toneIndicator.getCapPowerReporting() == 2 ? "Advanced" : (this.toneIndicator.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.toneIndicator.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.toneIndicator.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.toneIndicator.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.toneIndicator.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapPitch: " + this.toneIndicator.getCapPitch();
                msg = String.valueOf(msg) + "\nCapVolume: " + this.toneIndicator.getCapVolume();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.toneIndicator.addStatusUpdateListener((StatusUpdateListener)this);
                this.toneIndicator.open(logicalName);
                this.toneIndicator.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.toneIndicator.setDeviceEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.toneIndicator);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.toneIndicator);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.toneIndicator.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.toneIndicator.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("ToneIndicatorPanel: MethodListener: JposException");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == ToneIndicatorPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        ToneIndicatorPanel.this.toneIndicator.setDeviceEnabled(false);
                    } else {
                        ToneIndicatorPanel.this.toneIndicator.setDeviceEnabled(true);
                    }
                } else if (source == ToneIndicatorPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        ToneIndicatorPanel.this.toneIndicator.setFreezeEvents(false);
                    } else {
                        ToneIndicatorPanel.this.toneIndicator.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("ToneIndicatorPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (ToneIndicatorPanel.this.toneIndicator != null) {
                ToneIndicatorPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(ToneIndicatorPanel.this.toneIndicator.getState()));
            }
        }
    }
}

