/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.scanner;

import com.jpos.scanner.ScanEventQueue;
import com.jpos.scanner.ScanEventQueueElem;
import com.jpos.scanner.ScannerConf;
import com.jpos.scanner.ScannerDvc;
import com.jpos.scanner.ScannerJni;
import jpos.events.DataEvent;
import jpos.events.JposEvent;

public class ScannerImpl
implements ScannerDvc {
    int PIDX_NUMBER = 0;
    int PIDX_STRING = 1000000;
    int PIDX_SCAN = 10000;
    int PIDXScan_DecodeData = 1 + this.PIDX_SCAN + this.PIDX_NUMBER;
    int PIDXScan_ScanDataType = 2 + this.PIDX_SCAN + this.PIDX_NUMBER;
    int PIDX_DeviceEnabled = 3 + this.PIDX_NUMBER;
    int PIDXScan_ScanData = 1 + this.PIDX_SCAN + this.PIDX_STRING;
    int PIDXScan_ScanDataLabel = 2 + this.PIDX_SCAN + this.PIDX_STRING;
    private ScannerEventThread thdScannerEvt;
    private ScannerJni scannerjni;
    private ScanEventQueue seq;
    private Object evtSrc;
    private boolean bClose;
    private boolean bEnabled;
    private boolean bRunning;
    private boolean bOpened;
    private ScannerConf scanconf;

    protected ScannerImpl(ScannerConf scancfg, ScanEventQueue scanEQ, Object sObj) {
        this.seq = scanEQ;
        this.evtSrc = sObj;
        this.bOpened = false;
        this.bClose = true;
        this.bEnabled = false;
        this.scannerjni = new ScannerJni(this);
        this.scanconf = scancfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() {
        boolean bRet = false;
        ScannerImpl scannerImpl = this;
        synchronized (scannerImpl) {
            block8: {
                if (!this.bOpened) break block8;
                return true;
            }
            try {
                boolean bl = this.bOpened = this.scannerjni.Open(this.scanconf.iScannerType, this.scanconf.icommtype, this.scanconf.iportNo, 1) == 0;
                if (this.bOpened) {
                    this.scannerjni.LoadAddOn(this.scanconf.strAddonInfo, this.scanconf.strAddonFunc, this.scanconf.ibMask, this.scanconf.ibLatch, this.scanconf.iCallAfterRead, this.scanconf.iSleepTime, this.scanconf.iSuffix);
                    this.scannerjni.ClaimDevice(100);
                    this.setEnabled(false);
                    this.bClose = false;
                    this.bRunning = true;
                    this.thdScannerEvt = new ScannerEventThread(this);
                    this.thdScannerEvt.start();
                    bRet = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bRet) {
                this.close();
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ScannerImpl scannerImpl = this;
        synchronized (scannerImpl) {
            this.bClose = true;
            if (this.bOpened) {
                this.scannerjni.Close();
                this.bOpened = false;
            }
        }
        int i = 0;
        while (i < 10 && this.bRunning) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        ScannerImpl scannerImpl2 = this;
        synchronized (scannerImpl2) {
            this.bEnabled = false;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.bEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean enabled) {
        ScannerImpl scannerImpl = this;
        synchronized (scannerImpl) {
            if (enabled != this.bEnabled) {
                this.bEnabled = enabled;
                if (this.bOpened) {
                    this.scannerjni.SetPropertyNumber(this.PIDX_DeviceEnabled, enabled ? 1 : 0);
                }
            }
        }
    }

    @Override
    public void decodeData(boolean enabled) {
        if (this.bOpened) {
            this.scannerjni.SetPropertyNumber(this.PIDXScan_DecodeData, enabled ? 1 : 0);
        }
    }

    @Override
    public void ClearInput() {
        this.scannerjni.ClearInput();
    }

    class ScannerEventThread
    extends Thread {
        private ScannerImpl scannerimpl;

        protected ScannerEventThread(ScannerImpl newScanner) {
            this.scannerimpl = newScanner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.scannerimpl.bClose) {
                    if (this.scannerimpl.bClose) break;
                    ScannerImpl scannerImpl = this.scannerimpl;
                    synchronized (scannerImpl) {
                        if (this.scannerimpl.bClose) {
                            break;
                        }
                        if (this.scannerimpl.scannerjni.GetPropertyNumber(12) > 0) {
                            this.scannerimpl.scannerjni.SetPropertyNumber(2, 1);
                            DataEvent localDataEvent = new DataEvent(ScannerImpl.this.evtSrc, 0);
                            ScanEventQueueElem tmpseqElem = new ScanEventQueueElem((JposEvent)localDataEvent, 0);
                            tmpseqElem.abScanData = this.scannerimpl.scannerjni.GetPropertyString(ScannerImpl.this.PIDXScan_ScanData);
                            tmpseqElem.iScanType = this.scannerimpl.scannerjni.GetPropertyNumber(ScannerImpl.this.PIDXScan_ScanDataType);
                            tmpseqElem.iDataLength = tmpseqElem.abScanData.length;
                            tmpseqElem.iTypeLength = 1;
                            tmpseqElem.bIsBCD = false;
                            this.scannerimpl.seq.addTail(tmpseqElem);
                            this.scannerimpl.scannerjni.SetPropertyNumber(2, 0);
                        }
                        Thread.sleep(100L);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scannerimpl.bRunning = false;
            this.scannerimpl.setEnabled(false);
        }
    }
}

