/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.scanner;

import com.jpos.scanner.ScanEventPool;
import com.jpos.scanner.ScanEventQueue;
import com.jpos.scanner.ScanEventQueueElem;
import com.jpos.scanner.ScannerConf;
import com.jpos.scanner.ScannerDvc;
import com.jpos.scanner.ScannerImpl;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.ScannerService110;

public class ScannerSvc110
implements ScannerService110,
JposConst,
ScanEventPool {
    protected static final int iServiceVer = 1010000;
    protected static boolean bClaimed = false;
    protected boolean bAutoDisable = false;
    protected boolean bCapCompareFWVer = false;
    protected boolean bCapStatsReporting = false;
    protected boolean bCapUpdateFW = false;
    protected boolean bCapUpdateStats = false;
    protected boolean bDecodeData = false;
    protected boolean bDeviceOwner = false;
    protected boolean bOpened = false;
    protected String strHealthText = "";
    protected String strPhysicalDesc = null;
    protected String strPhysicalName = null;
    protected String strServiceDesc = "Serial/USB Scanner Service Driver, (C) 2011 NEWLAND COMPUTER, Inc.";
    protected byte[] abScanData = new byte[0];
    protected byte[] abScanDataLabel = new byte[0];
    protected int iState = 1;
    protected int iCapPowerReporting = 0;
    protected int iPowerNotify = 0;
    protected int iPowerState = 2000;
    protected int iScanDataType = 0;
    protected ScanEventQueue seqEvents = new ScanEventQueue(this);
    protected JposEntry jpe = null;
    protected EventCallbacks ecbs = null;
    protected ScannerDvc scnDvc = null;
    protected ScannerConf scnCfg = new ScannerConf("COM", 1);

    public boolean getAutoDisable() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.bAutoDisable;
    }

    public void setAutoDisable(boolean autoDisable) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        this.bAutoDisable = autoDisable;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.bCapCompareFWVer;
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.iCapPowerReporting;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.bCapStatsReporting;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.bCapUpdateFW;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.bCapUpdateStats;
    }

    public String getCheckHealthText() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.strHealthText;
    }

    public boolean getClaimed() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return bClaimed;
    }

    public int getDataCount() throws JposException {
        if (!this.bOpened) {
            return 0;
        }
        return this.seqEvents.iDataEvents;
    }

    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.seqEvents.bDataEventEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            if (dataEventEnabled != this.seqEvents.bDataEventEnabled) {
                this.seqEvents.bDataEventEnabled = dataEventEnabled;
                if (dataEventEnabled && !this.seqEvents.bFreezeEvents && this.seqEvents.iDataEvents > 0) {
                    this.seqEvents.notify();
                }
            }
        }
    }

    public boolean getDecodeData() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.bDecodeData;
    }

    public void setDecodeData(boolean decodeData) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        this.bDecodeData = decodeData;
        this.scnDvc.decodeData(decodeData);
    }

    public boolean getDeviceEnabled() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.seqEvents.bEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        if (!this.bDeviceOwner) {
            if (!bClaimed) {
                throw new JposException(103, "Device is not claimed");
            }
            throw new JposException(102, "Device is already claimed by another control instance");
        }
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            if (deviceEnabled != this.seqEvents.bEnabled) {
                this.seqEvents.bEnabled = deviceEnabled;
                if (this.scnDvc != null) {
                    this.scnDvc.setEnabled(deviceEnabled);
                }
            }
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.strServiceDesc;
    }

    public int getDeviceServiceVersion() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return 1010000;
    }

    public boolean getFreezeEvents() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.seqEvents.bFreezeEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            if (freezeEvents != this.seqEvents.bFreezeEvents) {
                this.seqEvents.bFreezeEvents = freezeEvents;
                this.seqEvents.notify();
            }
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.strPhysicalDesc;
    }

    public String getPhysicalDeviceName() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.strPhysicalName;
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.iPowerNotify;
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        if (this.seqEvents.bEnabled) {
            throw new JposException(106, "Device is already enabled");
        }
        if (this.iCapPowerReporting == 0 && powerNotify != 0) {
            throw new JposException(106, "Service does not support power notifications");
        }
        this.iPowerNotify = powerNotify;
    }

    public int getPowerState() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.iPowerState;
    }

    public byte[] getScanData() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.abScanData;
    }

    public byte[] getScanDataLabel() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.abScanDataLabel;
    }

    public int getScanDataType() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        return this.iScanDataType;
    }

    public int getState() throws JposException {
        return this.iState;
    }

    public void checkHealth(int health) throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        if (!this.bDeviceOwner) {
            if (!bClaimed) {
                throw new JposException(103, "Device is not claimed");
            }
            throw new JposException(102, "Device is already claimed by another control instance");
        }
        if (!this.seqEvents.bEnabled) {
            throw new JposException(105, "Device is not enabled");
        }
        if (health != 1) {
            throw new JposException(106, "Device only supports internal health checks");
        }
        this.strHealthText = "Successful";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claim(int timeout) throws JposException {
        if (timeout < -1) {
            throw new JposException(106, "Invalid timeout value");
        }
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            if (!this.bOpened) {
                throw new JposException(101, "Service is not open");
            }
            long l = System.currentTimeMillis();
            while (!this.bDeviceOwner) {
                ScannerImpl localScannerImpl = new ScannerImpl(this.scnCfg, this.seqEvents, this.ecbs.getEventSource());
                if (localScannerImpl != null && localScannerImpl.open()) {
                    this.scnDvc = localScannerImpl;
                    bClaimed = true;
                    this.bDeviceOwner = true;
                    break;
                }
                localScannerImpl = null;
                if (timeout >= 0 && System.currentTimeMillis() - l > (long)timeout) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.bDeviceOwner) {
            throw new JposException(112, "Device is in use or does not exist");
        }
    }

    public void clearInput() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        this.seqEvents.Clear();
        this.scnDvc.ClearInput();
    }

    public void clearInputProperties() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        this.abScanData = new byte[0];
        this.abScanDataLabel = new byte[0];
        this.iScanDataType = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            this.seqEvents.bStopThread = true;
            this.seqEvents.notify();
            try {
                if (this.seqEvents.bEnabled) {
                    this.setDeviceEnabled(false);
                }
                if (this.bDeviceOwner) {
                    this.release();
                }
            }
            catch (JposException jposException) {
                // empty catch block
            }
            this.seqEvents.Clear();
            this.bOpened = false;
            this.iState = 1;
        }
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        throw new JposException(106, "Method is not supported by this service");
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        throw new JposException(106, "Method is not supported by this service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String logicalName, EventCallbacks cb) throws JposException {
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            if (this.bOpened) {
                throw new JposException(106, "Service is already open");
            }
            this.jpe = JposServiceLoader.getManager().getEntryRegistry().getJposEntry(logicalName);
            if (this.jpe == null) {
                throw new JposException(109, "Logical device could not be found");
            }
            this.ecbs = cb;
            this.seqEvents.bEnabled = false;
            this.seqEvents.bDataEventEnabled = false;
            this.seqEvents.bFreezeEvents = false;
            this.bAutoDisable = false;
            this.bCapCompareFWVer = false;
            this.bCapStatsReporting = false;
            this.bCapUpdateFW = false;
            this.bCapUpdateStats = false;
            this.bDecodeData = false;
            this.bDeviceOwner = false;
            this.strHealthText = "";
            this.abScanData = new byte[0];
            this.abScanDataLabel = new byte[0];
            this.iCapPowerReporting = 0;
            this.iPowerNotify = 0;
            this.iPowerState = 2000;
            this.iScanDataType = 0;
            this.strPhysicalDesc = "";
            JposEntry.Prop localProp = this.jpe.getProp("productDescription");
            if (localProp != null) {
                this.strPhysicalDesc = localProp.getValueAsString();
            }
            if (this.strPhysicalDesc == "") {
                this.strPhysicalDesc = "Newland auto Serial/USB Scanner";
            }
            this.strPhysicalName = "";
            localProp = this.jpe.getProp("productName");
            if (localProp != null) {
                this.strPhysicalName = localProp.getValueAsString();
            }
            if (this.strPhysicalName == "") {
                this.strPhysicalName = "Newland auto Scanner";
            }
            if ((localProp = this.jpe.getProp("AddonInfo")) != null) {
                this.scnCfg.strAddonInfo = localProp.getValueAsString();
            }
            if ((localProp = this.jpe.getProp("AddonFunc")) != null) {
                this.scnCfg.strAddonFunc = localProp.getValueAsString();
            }
            this.scnCfg.iSuffix = this.getIntProp("Suffix", 0);
            this.scnCfg.ibMask = this.getIntProp("bMask", 0);
            this.scnCfg.ibLatch = this.getIntProp("bLatch", 0);
            this.scnCfg.iCallAfterRead = this.getIntProp("CallAfterRead", 0);
            this.scnCfg.iSleepTime = this.getIntProp("SleepTime", 0);
            this.scnCfg.strPortName = "";
            localProp = this.jpe.getProp("port");
            if (localProp != null) {
                this.scnCfg.strPortName = localProp.getValueAsString();
            }
            if (this.scnCfg.strPortName.compareTo("") == 0 || this.scnCfg.strPortName.compareTo("COM") == 0) {
                this.scnCfg.strPortName = "COM";
                this.scnCfg.icommtype = 1;
                this.scnCfg.iportNo = this.getIntProp("portno", 1);
            } else if (this.scnCfg.strPortName.compareTo("USB") == 0) {
                this.scnCfg.icommtype = 2;
            } else if (this.scnCfg.strPortName.compareTo("HID") == 0) {
                this.scnCfg.icommtype = 3;
            } else if (this.scnCfg.strPortName.compareTo("HID-POS") == 0) {
                this.scnCfg.icommtype = 3;
            }
            this.scnCfg.iScannerType = this.getIntProp("ScannerType", 0);
            this.seqEvents.bStopThread = false;
            this.seqEvents.start();
            this.bOpened = true;
            this.iState = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws JposException {
        if (!this.bOpened) {
            throw new JposException(101, "Service is not open");
        }
        if (!this.bDeviceOwner) {
            if (!bClaimed) {
                throw new JposException(103, "Device is not claimed");
            }
            throw new JposException(102, "Device is already claimed by another control instance");
        }
        ScanEventQueue scanEventQueue = this.seqEvents;
        synchronized (scanEventQueue) {
            try {
                ScannerImpl localObject1;
                if (this.seqEvents.bEnabled) {
                    this.setDeviceEnabled(false);
                }
                if ((localObject1 = (ScannerImpl)this.scnDvc) != null) {
                    localObject1.close();
                }
            }
            catch (JposException jposException) {
                // empty catch block
            }
            this.bDeviceOwner = false;
            bClaimed = false;
        }
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        throw new JposException(106, "Method is not supported by this service");
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        throw new JposException(106, "Method is not supported by this service");
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        throw new JposException(106, "Method is not supported by this service");
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        throw new JposException(106, "Method is not supported by this service");
    }

    public void deleteInstance() throws JposException {
    }

    @Override
    public void receiveScanData() {
        if (this.bAutoDisable) {
            try {
                this.setDeviceEnabled(false);
            }
            catch (JposException jposException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleScanEvent(ScanEventQueueElem seqElem) {
        EventCallbacks localEventCallbacks = this.ecbs;
        if (localEventCallbacks != null) {
            switch (seqElem.iEventType) {
                case 0: {
                    int i;
                    int k;
                    if (this.bDecodeData) {
                        this.iScanDataType = seqElem.iScanType;
                        k = seqElem.iDataLength;
                        i = 0;
                        this.abScanData = new byte[0];
                        int j = seqElem.iTypeLength <= 0 ? -seqElem.iTypeLength : 0;
                        if (this.iScanDataType == 104 && k == 10) {
                            this.abScanDataLabel = new byte[k += 3];
                            this.abScanDataLabel[0] = 57;
                            this.abScanDataLabel[1] = 55;
                            this.abScanDataLabel[2] = 56;
                            i = 3;
                        } else {
                            this.abScanDataLabel = new byte[k];
                            i = 0;
                        }
                        while (i < k) {
                            this.abScanDataLabel[i] = seqElem.abScanData[j];
                            if (seqElem.bIsBCD && this.abScanDataLabel[i] < 32) {
                                byte[] tmp = this.abScanDataLabel;
                                tmp[i] = (byte)(tmp[i] + 48);
                            }
                            ++i;
                            ++j;
                        }
                    }
                    k = seqElem.abScanData.length;
                    this.abScanData = new byte[k];
                    i = 0;
                    while (i < k) {
                        this.abScanData[i] = seqElem.abScanData[i];
                        ++i;
                    }
                    localEventCallbacks.fireDataEvent((DataEvent)seqElem.jpe);
                    break;
                }
                case 1: {
                    localEventCallbacks.fireDirectIOEvent((DirectIOEvent)seqElem.jpe);
                    break;
                }
                case 2: {
                    localEventCallbacks.fireErrorEvent((ErrorEvent)seqElem.jpe);
                    break;
                }
                case 3: {
                    localEventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)seqElem.jpe);
                }
            }
        }
    }

    private int getIntProp(String propName, int defValue) {
        int i = defValue;
        JposEntry.Prop localProp = this.jpe.getProp(propName);
        if (localProp != null) {
            try {
                i = Integer.parseInt(localProp.getValueAsString());
            }
            catch (Exception localException) {
                i = defValue;
            }
        }
        return i;
    }
}

